/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfCommon;
import org.apache.juneau.jena.RdfParserBuilder;
import org.apache.juneau.jena.RdfParserSession;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.xml.Namespace;

@ConfigurableContext(prefixes={"RdfCommon", "RdfParser"})
public class RdfParser
extends ReaderParser
implements RdfCommon {
    private static final Namespace DEFAULT_JUNEAU_NS = Namespace.create((String)"j", (String)"http://www.apache.org/juneau/");
    private static final Namespace DEFAULT_JUNEAUBP_NS = Namespace.create((String)"jp", (String)"http://www.apache.org/juneaubp/");
    static final String PREFIX = "RdfParser";
    public static final String RDF_trimWhitespace = "RdfParser.trimWhitespace.b";
    private final boolean trimWhitespace = this.getBooleanProperty("RdfParser.trimWhitespace.b", false);
    private final boolean looseCollections = this.getBooleanProperty("RdfCommon.looseCollections.b", false);
    private final String rdfLanguage = this.getStringProperty("RdfCommon.language.s", "RDF/XML-ABBREV");
    private final Namespace juneauNs = (Namespace)this.getInstanceProperty("RdfCommon.juneauNs.s", Namespace.class, DEFAULT_JUNEAU_NS);
    private final Namespace juneauBpNs = (Namespace)this.getInstanceProperty("RdfCommon.juneauBpNs.s", Namespace.class, DEFAULT_JUNEAUBP_NS);
    private final RdfCollectionFormat collectionFormat = (RdfCollectionFormat)((Object)this.getProperty("RdfCommon.collectionFormat.s", RdfCollectionFormat.class, (Object)RdfCollectionFormat.DEFAULT));
    final Map<String, Object> jenaProperties;

    public RdfParser(PropertyStore ps, String ... consumes) {
        super(ps, consumes);
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        for (String k : this.getPropertyKeys("RdfCommon")) {
            if (!k.startsWith("jena.")) continue;
            m.put(k.substring(5), this.getProperty("RdfCommon." + k));
        }
        this.jenaProperties = CollectionUtils.unmodifiableMap(m);
    }

    public RdfParser(PropertyStore ps) {
        this(ps, "text/xml+rdf");
    }

    public RdfParserBuilder builder() {
        return new RdfParserBuilder(this.getPropertyStore());
    }

    public static RdfParserBuilder create() {
        return new RdfParserBuilder();
    }

    public RdfParserSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    public RdfParserSession createSession(ParserSessionArgs args) {
        return new RdfParserSession(this, args);
    }

    protected final RdfCollectionFormat getCollectionFormat() {
        return this.collectionFormat;
    }

    protected final Namespace getJuneauBpNs() {
        return this.juneauBpNs;
    }

    protected final Namespace getJuneauNs() {
        return this.juneauNs;
    }

    protected final String getLanguage() {
        return this.rdfLanguage;
    }

    protected final boolean isLooseCollections() {
        return this.looseCollections;
    }

    protected final Map<String, Object> getJenaProperties() {
        return this.jenaProperties;
    }

    protected final boolean isTrimWhitespace() {
        return this.trimWhitespace;
    }

    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, (Object)new DefaultFilteringObjectMap().append("trimWhitespace", (Object)this.trimWhitespace).append("looseCollections", (Object)this.looseCollections).append("rdfLanguage", (Object)this.rdfLanguage).append("juneauNs", (Object)this.juneauNs).append("juneauBpNs", (Object)this.juneauBpNs).append("collectionFormat", (Object)this.collectionFormat));
    }
}

