/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.util.List;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyMetaExtended;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfUtils;
import org.apache.juneau.jena.annotation.Rdf;
import org.apache.juneau.jena.annotation.RdfSchema;
import org.apache.juneau.xml.Namespace;

public class RdfBeanPropertyMeta
extends BeanPropertyMetaExtended {
    public static final RdfBeanPropertyMeta DEFAULT = new RdfBeanPropertyMeta();
    private RdfCollectionFormat collectionFormat = RdfCollectionFormat.DEFAULT;
    private Namespace namespace = null;
    private boolean isBeanUri;

    public RdfBeanPropertyMeta(BeanPropertyMeta bpm) {
        super(bpm);
        List rdfs = bpm.findAnnotations(Rdf.class);
        List schemas = bpm.findAnnotations(RdfSchema.class);
        for (Rdf rdf : rdfs) {
            if (this.collectionFormat == RdfCollectionFormat.DEFAULT) {
                this.collectionFormat = rdf.collectionFormat();
            }
            if (!rdf.beanUri()) continue;
            this.isBeanUri = true;
        }
        this.namespace = RdfUtils.findNamespace(rdfs, schemas);
    }

    private RdfBeanPropertyMeta() {
        super(null);
    }

    protected RdfCollectionFormat getCollectionFormat() {
        return this.collectionFormat;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public boolean isBeanUri() {
        return this.isBeanUri;
    }
}

