/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.helper;

import org.apache.juneau.annotation.Bean;
import org.apache.juneau.html.annotation.Html;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.jsonschema.annotation.Schema;

@Bean(properties="name,description", fluentSetters=true)
@Response(schema=@Schema(ignore=true))
public final class ResourceDescription
implements Comparable<ResourceDescription> {
    private String name;
    private String description;

    public ResourceDescription(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public ResourceDescription() {
    }

    @Html(link="servlet:/{name}")
    public String getName() {
        return this.name;
    }

    public ResourceDescription name(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public ResourceDescription description(String description) {
        this.description = description;
        return this;
    }

    @Override
    public int compareTo(ResourceDescription o) {
        return this.getName().toString().compareTo(o.getName().toString());
    }

    public boolean equals(Object o) {
        return o instanceof ResourceDescription && ((ResourceDescription)o).getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

