/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.util.Map;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;

public class StaticFileMapping {
    final Class<?> resourceClass;
    final String path;
    final String location;
    final Map<String, Object> responseHeaders;

    public StaticFileMapping(Class<?> resourceClass, String path, String location, Map<String, Object> responseHeaders) {
        this.resourceClass = resourceClass;
        this.path = StringUtils.trimSlashes((String)path);
        this.location = StringUtils.trimSlashes((String)location);
        this.responseHeaders = CollectionUtils.immutableMap(responseHeaders);
    }

    public StaticFileMapping(Class<?> resourceClass, String mappingString) {
        this.resourceClass = resourceClass;
        String[] parts = StringUtils.split((String)mappingString, (char)':', (int)3);
        if (parts == null || parts.length <= 1) {
            throw new FormattedRuntimeException("Invalid mapping string format: ''{0}'' on resource class ''{1}''", new Object[]{mappingString, resourceClass.getName()});
        }
        this.path = StringUtils.trimSlashes((String)parts[0]);
        this.location = StringUtils.trimSlashes((String)parts[1]);
        if (parts.length == 3) {
            try {
                this.responseHeaders = CollectionUtils.unmodifiableMap((Map)new ObjectMap((CharSequence)parts[2]));
            }
            catch (ParseException e) {
                throw new FormattedRuntimeException((Throwable)e, "Invalid mapping string format: ''{0}'' on resource class ''{1}''", new Object[]{mappingString, resourceClass.getName()});
            }
        } else {
            this.responseHeaders = null;
        }
    }
}

