/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.http.StreamResource;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.rest.Enablement;
import org.apache.juneau.rest.OverrideableHttpServletRequest;
import org.apache.juneau.rest.RequestPath;
import org.apache.juneau.rest.ResponseHandler;
import org.apache.juneau.rest.RestCallHandler;
import org.apache.juneau.rest.RestCallLogger;
import org.apache.juneau.rest.RestCallLoggerConfig;
import org.apache.juneau.rest.RestCallRouter;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.exception.MethodNotAllowed;
import org.apache.juneau.rest.exception.NotFound;
import org.apache.juneau.rest.exception.NotImplemented;
import org.apache.juneau.rest.exception.PreconditionFailed;
import org.apache.juneau.rest.exception.Unauthorized;
import org.apache.juneau.rest.util.CachingHttpServletRequest;
import org.apache.juneau.rest.util.CachingHttpServletResponse;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.rest.util.UrlPathInfo;
import org.apache.juneau.rest.util.UrlPathPattern;
import org.apache.juneau.rest.util.UrlPathPatternMatch;

public class BasicRestCallHandler
implements RestCallHandler {
    private final RestContext context;
    private final Map<String, RestCallRouter> restCallRouters;

    public BasicRestCallHandler(RestContext context) {
        this.context = context;
        this.restCallRouters = context.getCallRouters();
    }

    @Override
    public RestRequest createRequest(HttpServletRequest req) throws ServletException {
        return new RestRequest(this.context, req);
    }

    @Override
    public RestResponse createResponse(RestRequest req, HttpServletResponse res) throws ServletException {
        return new RestResponse(this.context, req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void service(HttpServletRequest r1, HttpServletResponse r2) throws ServletException, IOException {
        long startTime = System.currentTimeMillis();
        RestRequest req = null;
        RestResponse res = null;
        RestCallLogger logger = this.context.getCallLogger();
        RestCallLoggerConfig loggerConfig = this.context.getCallLoggerConfig();
        try {
            this.context.checkForInitException();
            String pathInfo = RestUtils.getPathInfoUndecoded(r1);
            UrlPathInfo upi = new UrlPathInfo(pathInfo);
            if (this.context.pathPattern.hasVars() && this.context.getParentContext() == null) {
                String sp = r1.getServletPath();
                UrlPathInfo upi2 = new UrlPathInfo((String)(pathInfo == null ? sp : (String)sp + pathInfo));
                UrlPathPatternMatch uppm = this.context.pathPattern.match(upi2);
                if (uppm != null && !uppm.hasEmptyVars()) {
                    RequestPath.addPathVars(r1, uppm.getVars());
                    r1 = new OverrideableHttpServletRequest((HttpServletRequest)r1).pathInfo(StringUtils.nullIfEmpty((String)StringUtils.urlDecode((String)uppm.getSuffix()))).servletPath(uppm.getPrefix());
                    pathInfo = RestUtils.getPathInfoUndecoded(r1);
                    upi = new UrlPathInfo(pathInfo);
                } else {
                    if (this.isDebug((HttpServletRequest)r1)) {
                        r1 = CachingHttpServletRequest.wrap(r1);
                        r1.setAttribute("Debug", (Object)true);
                    }
                    r2.setStatus(404);
                    return;
                }
            }
            if (this.context.hasChildResources() && pathInfo != null && !pathInfo.equals("/")) {
                for (RestContext rc : this.context.getChildResources().values()) {
                    UrlPathPattern upp = rc.pathPattern;
                    UrlPathPatternMatch uppm = upp.match(upi);
                    if (uppm == null) continue;
                    if (!uppm.hasEmptyVars()) {
                        RequestPath.addPathVars(r1, uppm.getVars());
                        OverrideableHttpServletRequest childRequest = new OverrideableHttpServletRequest((HttpServletRequest)r1).pathInfo(StringUtils.nullIfEmpty((String)StringUtils.urlDecode((String)uppm.getSuffix()))).servletPath(r1.getServletPath() + uppm.getPrefix());
                        rc.getCallHandler().service((HttpServletRequest)childRequest, (HttpServletResponse)r2);
                    } else {
                        if (this.isDebug((HttpServletRequest)r1)) {
                            r1 = CachingHttpServletRequest.wrap(r1);
                            r1.setAttribute("Debug", (Object)true);
                        }
                        r2.setStatus(404);
                    }
                    return;
                }
            }
            if (this.isDebug((HttpServletRequest)r1)) {
                r1 = CachingHttpServletRequest.wrap(r1);
                r2 = CachingHttpServletResponse.wrap(r2);
                r1.setAttribute("Debug", (Object)true);
            }
            this.context.startCall((HttpServletRequest)r1, (HttpServletResponse)r2);
            req = this.createRequest((HttpServletRequest)r1);
            res = this.createResponse(req, (HttpServletResponse)r2);
            req.setResponse(res);
            this.context.setRequest(req);
            this.context.setResponse(res);
            String method = req.getMethod();
            String methodUC = method.toUpperCase(Locale.ENGLISH);
            StreamResource r = null;
            if (pathInfo != null) {
                String p = pathInfo.substring(1);
                if (this.context.isStaticFile(p)) {
                    RestContext.StaticFile sf = this.context.resolveStaticFile(p);
                    r = sf.resource;
                    res.setResponseMeta(sf.meta);
                } else if (p.equals("favicon.ico")) {
                    res.setOutput(null);
                }
            }
            if (r != null) {
                res.setStatus(200);
                res.setOutput(r);
            } else {
                int rc = 0;
                if (this.restCallRouters.containsKey(methodUC)) {
                    rc = this.restCallRouters.get(methodUC).invoke(upi, req, res);
                } else if (this.restCallRouters.containsKey("*")) {
                    rc = this.restCallRouters.get("*").invoke(upi, req, res);
                }
                if (rc == 0) {
                    for (RestCallRouter rcc : this.restCallRouters.values()) {
                        if (!rcc.matches(upi)) continue;
                        rc = 405;
                    }
                }
                if (rc == 0) {
                    rc = 404;
                }
                if (rc != 200) {
                    this.handleNotFound(rc, req, res);
                }
                if (res.getStatus() == 0) {
                    res.setStatus(rc);
                }
            }
            if (res.hasOutput()) {
                this.handleResponse(req, res);
            }
            res.flushBuffer();
            req.close();
            r1 = req.getInner();
            r2 = res.getInner();
            loggerConfig = req.getCallLoggerConfig();
            r1.setAttribute("ExecTime", (Object)(System.currentTimeMillis() - startTime));
        }
        catch (Throwable e) {
            e = this.convertThrowable(e);
            if (req != null) {
                r1 = req.getInner();
                loggerConfig = req.getCallLoggerConfig();
            }
            if (res != null) {
                r2 = res.getInner();
            }
            r1.setAttribute("Exception", (Object)e);
            r1.setAttribute("ExecTime", (Object)(System.currentTimeMillis() - startTime));
            this.handleError((HttpServletRequest)r1, (HttpServletResponse)r2, e);
        }
        finally {
            this.context.clearState();
        }
        logger.log(loggerConfig, (HttpServletRequest)r1, (HttpServletResponse)r2);
        this.context.finishCall((HttpServletRequest)r1, (HttpServletResponse)r2);
    }

    private boolean isDebug(HttpServletRequest req) {
        Enablement e = this.context.getDebug();
        if (e == Enablement.TRUE) {
            return true;
        }
        if (e == Enablement.FALSE) {
            return false;
        }
        return "true".equalsIgnoreCase(req.getHeader("X-Debug"));
    }

    @Override
    public void handleResponse(RestRequest req, RestResponse res) throws IOException, RestException, NotImplemented {
        for (ResponseHandler h : this.context.getResponseHandlers()) {
            if (!h.handle(req, res)) continue;
            return;
        }
        Object output = res.getOutput();
        throw new NotImplemented("No response handlers found to process output of type '" + (output == null ? null : output.getClass().getName()) + "'");
    }

    @Override
    public Throwable convertThrowable(Throwable t) {
        if (t instanceof RestException) {
            return t;
        }
        String n = t.getClass().getName();
        if (n.contains("AccessDenied")) {
            return new Unauthorized(t);
        }
        if (n.contains("Empty") || n.contains("NotFound")) {
            return new NotFound(t);
        }
        return t;
    }

    @Override
    public void handleNotFound(int rc, RestRequest req, RestResponse res) throws Exception {
        String onPath;
        String pathInfo = req.getPathInfo();
        String methodUC = req.getMethod();
        String string = onPath = pathInfo == null ? " on no pathInfo" : String.format(" on path '%s'", pathInfo);
        if (rc == 404) {
            throw new NotFound("Method ''{0}'' not found on resource with matching pattern{1}.", methodUC, onPath);
        }
        if (rc == 412) {
            throw new PreconditionFailed("Method ''{0}'' not found on resource{1} with matching matcher.", methodUC, onPath);
        }
        if (rc == 405) {
            throw new MethodNotAllowed("Method ''{0}'' not found on resource.", methodUC);
        }
        throw new ServletException("Invalid method response: " + rc);
    }

    @Override
    public synchronized void handleError(HttpServletRequest req, HttpServletResponse res, Throwable e) throws IOException {
        int occurrence;
        RestException e2 = (e instanceof RestException ? (RestException)e : new RestException(e, 500)).setOccurrence(occurrence = this.context == null ? 0 : this.context.getStackTraceOccurrence(e));
        Throwable t = e2.getRootCause();
        if (t != null) {
            res.setHeader("Exception-Name", t.getClass().getName());
            res.setHeader("Exception-Message", t.getMessage());
        }
        try {
            res.setContentType("text/plain");
            res.setHeader("Content-Encoding", "identity");
            res.setStatus(e2.getStatus());
            PrintWriter w = null;
            try {
                w = res.getWriter();
            }
            catch (IllegalStateException x) {
                w = new PrintWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), IOUtils.UTF8));
            }
            try (PrintWriter w2 = w;){
                String httpMessage = RestUtils.getHttpResponseText(e2.getStatus());
                if (httpMessage != null) {
                    w2.append("HTTP ").append(String.valueOf(e2.getStatus())).append(": ").append(httpMessage).append("\n\n");
                }
                if (this.context != null && this.context.isRenderResponseStackTraces()) {
                    e.printStackTrace(w2);
                } else {
                    w2.append(e2.getFullStackMessage(true));
                }
            }
        }
        catch (Exception e1) {
            req.setAttribute("Exception", (Object)e1);
        }
    }

    @Override
    public Map<String, Object> getSessionObjects(RestRequest req, RestResponse res) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("req", (Object)req);
        m.put("res", (Object)res);
        return m;
    }
}

