/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client;

import java.lang.reflect.Method;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.BackoffManager;
import org.apache.http.client.ConnectionBackoffStrategy;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.InputStreamFactory;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.ssl.SSLContexts;
import org.apache.juneau.BeanContextBuilder;
import org.apache.juneau.BinaryFormat;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.Visibility;
import org.apache.juneau.html.HtmlParser;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.marshall.Marshall;
import org.apache.juneau.msgpack.MsgPackParser;
import org.apache.juneau.msgpack.MsgPackSerializer;
import org.apache.juneau.oapi.OpenApiParser;
import org.apache.juneau.oapi.OpenApiSerializer;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.plaintext.PlainTextParser;
import org.apache.juneau.plaintext.PlainTextSerializer;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.rest.client.AllowAllRedirects;
import org.apache.juneau.rest.client.RestCallInterceptor;
import org.apache.juneau.rest.client.RestCallLogger;
import org.apache.juneau.rest.client.RestClient;
import org.apache.juneau.rest.client.RetryOn;
import org.apache.juneau.rest.client.SimpleX509TrustManager;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerListener;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.uon.UonParser;
import org.apache.juneau.uon.UonSerializer;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;
import org.apache.juneau.xml.XmlParser;
import org.apache.juneau.xml.XmlSerializer;

public class RestClientBuilder
extends BeanContextBuilder {
    private HttpClientConnectionManager httpClientConnectionManager;
    private HttpClientBuilder httpClientBuilder;
    private CloseableHttpClient httpClient;
    private boolean enableSsl = false;
    private HostnameVerifier hostnameVerifier;
    private KeyManager[] keyManagers;
    private TrustManager[] trustManagers;
    private SecureRandom secureRandom;
    private String[] sslProtocols;
    private String[] cipherSuites;
    private boolean pooled;

    protected RestClientBuilder(PropertyStore ps, HttpClientBuilder httpClientBuilder) {
        super(ps);
        this.httpClientBuilder = httpClientBuilder != null ? httpClientBuilder : this.createHttpClientBuilder();
    }

    public RestClient build() {
        try {
            CloseableHttpClient c = this.httpClient != null ? this.httpClient : this.createHttpClient();
            PropertyStore ps = this.psb.build();
            return new RestClient(ps, this.httpClientBuilder, c);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RestClientBuilder json() {
        return this.serializer(JsonSerializer.class).parser(JsonParser.class);
    }

    public RestClientBuilder simpleJson() {
        return this.serializer(SimpleJsonSerializer.class).parser(JsonParser.class);
    }

    public RestClientBuilder xml() {
        return this.serializer(XmlSerializer.class).parser(XmlParser.class);
    }

    public RestClientBuilder html() {
        return this.serializer(HtmlSerializer.class).parser(HtmlParser.class);
    }

    public RestClientBuilder plainText() {
        return this.serializer(PlainTextSerializer.class).parser(PlainTextParser.class);
    }

    public RestClientBuilder msgpack() {
        return this.serializer(MsgPackSerializer.class).parser(MsgPackParser.class);
    }

    public RestClientBuilder uon() {
        return this.serializer(UonSerializer.class).parser(UonParser.class);
    }

    public RestClientBuilder urlEnc() {
        return this.serializer(UrlEncodingSerializer.class).parser(UrlEncodingParser.class);
    }

    public RestClientBuilder openapi() {
        return this.serializer(OpenApiSerializer.class).parser(OpenApiParser.class);
    }

    protected CloseableHttpClient createHttpClient() throws Exception {
        if (this.httpClientConnectionManager == null) {
            this.httpClientBuilder.setConnectionManager(this.createConnectionManager());
        } else {
            this.httpClientBuilder.setConnectionManager(this.httpClientConnectionManager);
        }
        return this.httpClientBuilder.build();
    }

    protected HttpClientBuilder createHttpClientBuilder() {
        HttpClientBuilder b = HttpClientBuilder.create();
        b.setRedirectStrategy((RedirectStrategy)new AllowAllRedirects());
        return b;
    }

    protected HttpClientConnectionManager createConnectionManager() throws KeyManagementException, NoSuchAlgorithmException {
        if (this.enableSsl) {
            HostnameVerifier hv = this.hostnameVerifier != null ? this.hostnameVerifier : new DefaultHostnameVerifier();
            TrustManager[] tm = this.trustManagers;
            String[] sslp = this.sslProtocols == null ? RestClientBuilder.getDefaultProtocols() : this.sslProtocols;
            SecureRandom sr = this.secureRandom;
            KeyManager[] km = this.keyManagers;
            String[] cs = this.cipherSuites;
            RegistryBuilder rb = RegistryBuilder.create();
            rb.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
            SSLContext sslContext = SSLContexts.custom().build();
            sslContext.init(km, tm, sr);
            SSLConnectionSocketFactory sslcsf = new SSLConnectionSocketFactory(sslContext, sslp, cs, hv);
            rb.register("https", (Object)sslcsf).build();
            return this.pooled ? new PoolingHttpClientConnectionManager(rb.build()) : new BasicHttpClientConnectionManager((Lookup)rb.build());
        }
        return this.pooled ? new PoolingHttpClientConnectionManager() : new BasicHttpClientConnectionManager();
    }

    public RestClientBuilder enableSSL() {
        this.enableSsl = true;
        return this;
    }

    public RestClientBuilder enableLaxSSL() throws KeyStoreException, NoSuchAlgorithmException {
        this.enableSsl = true;
        this.hostnameVerifier((HostnameVerifier)new NoopHostnameVerifier());
        this.trustManagers(new SimpleX509TrustManager(true));
        return this;
    }

    public RestClientBuilder sslProtocols(String ... sslProtocols) {
        this.sslProtocols = sslProtocols;
        return this;
    }

    public RestClientBuilder cipherSuites(String ... cipherSuites) {
        this.cipherSuites = cipherSuites;
        return this;
    }

    public RestClientBuilder hostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public RestClientBuilder keyManagers(KeyManager ... keyManagers) {
        this.keyManagers = keyManagers;
        return this;
    }

    public RestClientBuilder trustManagers(TrustManager ... trustManagers) {
        this.trustManagers = trustManagers;
        return this;
    }

    public RestClientBuilder secureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
        return this;
    }

    public RestClientBuilder clientVersion(String version) {
        return this.header("X-Client-Version", version);
    }

    public RestClientBuilder logTo(Level level, Logger log) {
        return this.interceptors(new RestCallLogger(level, log));
    }

    public RestClientBuilder pooled() {
        this.pooled = true;
        return this;
    }

    public RestClientBuilder basicAuth(String host, int port, String user, String pw) {
        AuthScope scope = new AuthScope(host, port);
        UsernamePasswordCredentials up = new UsernamePasswordCredentials(user, pw);
        BasicCredentialsProvider p = new BasicCredentialsProvider();
        p.setCredentials(scope, (Credentials)up);
        this.defaultCredentialsProvider((CredentialsProvider)p);
        return this;
    }

    public RestClientBuilder httpClient(CloseableHttpClient httpClient, boolean keepHttpClientOpen) {
        this.httpClient = httpClient;
        this.set("RestClient.keepHttpClientOpen.b", keepHttpClientOpen);
        return this;
    }

    public RestClientBuilder httpClientConnectionManager(HttpClientConnectionManager httpClientConnectionManager) {
        this.httpClientConnectionManager = httpClientConnectionManager;
        return this;
    }

    public RestClientBuilder headers(Map<String, Object> headers) {
        if (headers != null) {
            for (Map.Entry<String, Object> e : headers.entrySet()) {
                this.header(e.getKey(), e.getValue());
            }
        }
        return this;
    }

    public RestClientBuilder accept(Object value) {
        return this.header("Accept", value);
    }

    public RestClientBuilder acceptCharset(Object value) {
        return this.header("Accept-Charset", value);
    }

    public RestClientBuilder acceptEncoding(Object value) {
        return this.header("Accept-Encoding", value);
    }

    public RestClientBuilder acceptLanguage(Object value) {
        return this.header("Accept-Language", value);
    }

    public RestClientBuilder authorization(Object value) {
        return this.header("Authorization", value);
    }

    public RestClientBuilder cacheControl(Object value) {
        return this.header("Cache-Control", value);
    }

    public RestClientBuilder connection(Object value) {
        return this.header("Connection", value);
    }

    public RestClientBuilder contentLength(Object value) {
        return this.header("Content-Length", value);
    }

    public RestClientBuilder contentType(Object value) {
        return this.header("Content-Type", value);
    }

    public RestClientBuilder date(Object value) {
        return this.header("Date", value);
    }

    public RestClientBuilder expect(Object value) {
        return this.header("Expect", value);
    }

    public RestClientBuilder forwarded(Object value) {
        return this.header("Forwarded", value);
    }

    public RestClientBuilder from(Object value) {
        return this.header("From", value);
    }

    public RestClientBuilder host(Object value) {
        return this.header("Host", value);
    }

    public RestClientBuilder ifMatch(Object value) {
        return this.header("If-Match", value);
    }

    public RestClientBuilder ifModifiedSince(Object value) {
        return this.header("If-Modified-Since", value);
    }

    public RestClientBuilder ifNoneMatch(Object value) {
        return this.header("If-None-Match", value);
    }

    public RestClientBuilder ifRange(Object value) {
        return this.header("If-Range", value);
    }

    public RestClientBuilder ifUnmodifiedSince(Object value) {
        return this.header("If-Unmodified-Since", value);
    }

    public RestClientBuilder maxForwards(Object value) {
        return this.header("If-Unmodified-Since", value);
    }

    public RestClientBuilder noTrace() {
        return this.header("No-Trace", true);
    }

    public RestClientBuilder origin(Object value) {
        return this.header("If-Unmodified-Since", value);
    }

    public RestClientBuilder pragma(Object value) {
        return this.header("Pragma", value);
    }

    public RestClientBuilder proxyAuthorization(Object value) {
        return this.header("Proxy-Authorization", value);
    }

    public RestClientBuilder range(Object value) {
        return this.header("Range", value);
    }

    public RestClientBuilder referer(Object value) {
        return this.header("Referer", value);
    }

    public RestClientBuilder te(Object value) {
        return this.header("TE", value);
    }

    public RestClientBuilder userAgent(Object value) {
        return this.header("User-Agent", value);
    }

    public RestClientBuilder upgrade(Object value) {
        return this.header("Upgrade", value);
    }

    public RestClientBuilder via(Object value) {
        return this.header("Via", value);
    }

    public RestClientBuilder warning(Object value) {
        return this.header("Warning", value);
    }

    public RestClientBuilder executorService(ExecutorService executorService, boolean shutdownOnClose) {
        this.set("RestClient.executorService.o", executorService);
        this.set("RestClient.executorServiceShutdownOnClose.b", shutdownOnClose);
        return this;
    }

    public RestClientBuilder header(String key, Object value) {
        return this.addTo("RestClient.headers.sms", key, value);
    }

    public RestClientBuilder keepHttpClientOpen(boolean value) {
        return this.set("RestClient.keepHttpClientOpen.b", value);
    }

    public RestClientBuilder interceptors(RestCallInterceptor ... value) {
        return this.addTo("RestClient.interceptors.lo", value);
    }

    public RestClientBuilder marshall(Marshall value) {
        if (value == null) {
            this.serializer((Serializer)null).parser((Parser)null);
        } else {
            this.serializer(value.getSerializer()).parser(value.getParser());
        }
        return this;
    }

    public RestClientBuilder parser(Class<? extends Parser> value) {
        return this.set("RestClient.parser.o", value);
    }

    public RestClientBuilder parser(Parser value) {
        return this.set("RestClient.parser.o", value);
    }

    public RestClientBuilder partParser(Class<? extends HttpPartParser> value) {
        return this.set("RestClient.partParser.o", value);
    }

    public RestClientBuilder partParser(HttpPartParser value) {
        return this.set("RestClient.partParser.o", value);
    }

    public RestClientBuilder partSerializer(Class<? extends HttpPartSerializer> value) {
        return this.set("RestClient.partSerializer.o", value);
    }

    public RestClientBuilder partSerializer(HttpPartSerializer value) {
        return this.set("RestClient.partSerializer.o", value);
    }

    public RestClientBuilder retryable(int retries, int interval, RetryOn retryOn) {
        this.set("RestClient.retries.i", retries);
        this.set("RestClient.retryInterval.i", interval);
        this.set("RestClient.retryOn.o", retryOn);
        return this;
    }

    public RestClientBuilder rootUrl(Object value) {
        return this.set("RestClient.rootUri.s", value);
    }

    public RestClientBuilder query(String key, Object value) {
        return this.addTo("RestClient.query.sms", key, value);
    }

    public RestClientBuilder serializer(Class<? extends Serializer> value) {
        return this.set("RestClient.serializer.o", value);
    }

    public RestClientBuilder serializer(Serializer value) {
        return this.set("RestClient.serializer.o", value);
    }

    public RestClientBuilder addBeanTypes(boolean value) {
        return this.set("Serializer.addBeanTypes.b", value);
    }

    public RestClientBuilder addBeanTypes() {
        return this.set("Serializer.addBeanTypes.b", true);
    }

    public RestClientBuilder addRootType(boolean value) {
        return this.set("Serializer.addRootType.b", value);
    }

    public RestClientBuilder addRootType() {
        return this.set("Serializer.addRootType.b", true);
    }

    public RestClientBuilder detectRecursions(boolean value) {
        return this.set("BeanTraverseContext.detectRecursions.b", value);
    }

    public RestClientBuilder detectRecursions() {
        return this.set("BeanTraverseContext.detectRecursions.b", true);
    }

    public RestClientBuilder ignoreRecursions(boolean value) {
        return this.set("BeanTraverseContext.ignoreRecursions.b", value);
    }

    public RestClientBuilder ignoreRecursions() {
        return this.set("BeanTraverseContext.ignoreRecursions.b", true);
    }

    public RestClientBuilder initialDepth(int value) {
        return this.set("BeanTraverseContext.initialDepth.i", value);
    }

    public RestClientBuilder listenerS(Class<? extends SerializerListener> value) {
        return this.set("Serializer.listener.c", value);
    }

    public RestClientBuilder maxDepth(int value) {
        return this.set("BeanTraverseContext.maxDepth.i", value);
    }

    public RestClientBuilder sortCollections(boolean value) {
        return this.set("Serializer.sortCollections.b", value);
    }

    public RestClientBuilder sortCollections() {
        return this.set("Serializer.sortCollections.b", true);
    }

    public RestClientBuilder sortMaps(boolean value) {
        return this.set("Serializer.sortMaps.b", value);
    }

    public RestClientBuilder sortMaps() {
        return this.set("Serializer.sortMaps.b", true);
    }

    public RestClientBuilder trimEmptyCollections(boolean value) {
        return this.set("Serializer.trimEmptyCollections.b", value);
    }

    public RestClientBuilder trimEmptyCollections() {
        return this.set("Serializer.trimEmptyCollections.b", true);
    }

    public RestClientBuilder trimEmptyMaps(boolean value) {
        return this.set("Serializer.trimEmptyMaps.b", value);
    }

    public RestClientBuilder trimEmptyMaps() {
        return this.set("Serializer.trimEmptyMaps.b", true);
    }

    public RestClientBuilder trimNullProperties(boolean value) {
        return this.set("Serializer.trimNullProperties.b", value);
    }

    public RestClientBuilder trimStringsS(boolean value) {
        return this.set("Serializer.trimStrings.b", value);
    }

    public RestClientBuilder trimStringsS() {
        return this.set("Serializer.trimStrings.b", true);
    }

    public RestClientBuilder uriContext(UriContext value) {
        return this.set("Serializer.uriContext.s", value);
    }

    public RestClientBuilder uriRelativity(UriRelativity value) {
        return this.set("Serializer.uriRelativity.s", value);
    }

    public RestClientBuilder uriResolution(UriResolution value) {
        return this.set("Serializer.uriResolution.s", value);
    }

    public RestClientBuilder maxIndent(int value) {
        return this.set("WriterSerializer.maxIndent.i", value);
    }

    public RestClientBuilder quoteChar(char value) {
        return this.set("WriterSerializer.quoteChar.s", Character.valueOf(value));
    }

    public RestClientBuilder sq() {
        return this.set("WriterSerializer.quoteChar.s", Character.valueOf('\''));
    }

    public RestClientBuilder useWhitespace(boolean value) {
        return this.set("WriterSerializer.useWhitespace.b", value);
    }

    public RestClientBuilder useWhitespace() {
        return this.set("WriterSerializer.useWhitespace.b", true);
    }

    public RestClientBuilder ws() {
        return this.set("WriterSerializer.useWhitespace.b", true);
    }

    public RestClientBuilder binaryOutputFormat(BinaryFormat value) {
        return this.set("OutputStreamSerializer.binaryFormat.s", value);
    }

    public RestClientBuilder autoCloseStreams(boolean value) {
        return this.set("Parser.autoCloseStreams.b", value);
    }

    public RestClientBuilder autoCloseStreams() {
        return this.set("Parser.autoCloseStreams.b", true);
    }

    public RestClientBuilder debugOutputLines(int value) {
        this.set("Parser.debugOutputLines.i", value);
        return this;
    }

    public RestClientBuilder listenerP(Class<? extends ParserListener> value) {
        return this.set("Parser.listener.c", value);
    }

    public RestClientBuilder strict(boolean value) {
        return this.set("Parser.strict.b", value);
    }

    public RestClientBuilder strict() {
        return this.set("Parser.strict.b", true);
    }

    public RestClientBuilder trimStringsP(boolean value) {
        return this.set("Parser.trimStrings.b", value);
    }

    public RestClientBuilder trimStringsP() {
        return this.set("Parser.trimStrings.b", true);
    }

    public RestClientBuilder unbuffered(boolean value) {
        return this.set("Parser.unbuffered.b", value);
    }

    public RestClientBuilder unbuffered() {
        return this.set("Parser.unbuffered.b", true);
    }

    public RestClientBuilder fileCharset(String value) {
        return this.set("ReaderParser.fileCharset.s", value);
    }

    public RestClientBuilder inputStreamCharset(String value) {
        return this.set("ReaderParser.streamCharset.s", value);
    }

    public RestClientBuilder binaryInputFormat(BinaryFormat value) {
        return this.set("InputStreamParser.binaryFormat.s", value);
    }

    public RestClientBuilder paramFormat(String value) {
        return this.set("UonSerializer.paramFormat.s", value);
    }

    public RestClientBuilder paramFormatPlain() {
        return this.set("UonSerializer.paramFormat.s", "PLAINTEXT");
    }

    public RestClientBuilder beanClassVisibility(Visibility value) {
        super.beanClassVisibility(value);
        return this;
    }

    public RestClientBuilder beanConstructorVisibility(Visibility value) {
        super.beanConstructorVisibility(value);
        return this;
    }

    public RestClientBuilder beanDictionary(Class<?> ... values) {
        super.beanDictionary((Class[])values);
        return this;
    }

    public RestClientBuilder beanDictionary(Object ... values) {
        super.beanDictionary(values);
        return this;
    }

    public RestClientBuilder beanDictionaryReplace(Class<?> ... values) {
        super.beanDictionaryReplace((Class[])values);
        return this;
    }

    public RestClientBuilder beanDictionaryReplace(Object ... values) {
        super.beanDictionaryReplace(values);
        return this;
    }

    public RestClientBuilder beanDictionaryRemove(Class<?> ... values) {
        super.beanDictionaryRemove((Class[])values);
        return this;
    }

    public RestClientBuilder beanDictionaryRemove(Object ... values) {
        super.beanDictionaryRemove(values);
        return this;
    }

    public RestClientBuilder beanFieldVisibility(Visibility value) {
        super.beanFieldVisibility(value);
        return this;
    }

    public RestClientBuilder beanFilters(Class<?> ... values) {
        super.beanFilters((Class[])values);
        return this;
    }

    public RestClientBuilder beanFilters(Object ... values) {
        super.beanFilters(values);
        return this;
    }

    public RestClientBuilder beanFiltersReplace(Class<?> ... values) {
        super.beanFiltersReplace((Class[])values);
        return this;
    }

    public RestClientBuilder beanFiltersReplace(Object ... values) {
        super.beanFiltersReplace(values);
        return this;
    }

    public RestClientBuilder beanFiltersRemove(Class<?> ... values) {
        super.beanFiltersRemove((Class[])values);
        return this;
    }

    public RestClientBuilder beanFiltersRemove(Object ... values) {
        super.beanFiltersRemove(values);
        return this;
    }

    public RestClientBuilder beanMapPutReturnsOldValue(boolean value) {
        super.beanMapPutReturnsOldValue(value);
        return this;
    }

    public RestClientBuilder beanMapPutReturnsOldValue() {
        super.beanMapPutReturnsOldValue();
        return this;
    }

    public RestClientBuilder beanMethodVisibility(Visibility value) {
        super.beanMethodVisibility(value);
        return this;
    }

    public RestClientBuilder beansRequireDefaultConstructor(boolean value) {
        super.beansRequireDefaultConstructor(value);
        return this;
    }

    public RestClientBuilder beansRequireDefaultConstructor() {
        super.beansRequireDefaultConstructor();
        return this;
    }

    public RestClientBuilder beansRequireSerializable(boolean value) {
        super.beansRequireSerializable(value);
        return this;
    }

    public RestClientBuilder beansRequireSerializable() {
        super.beansRequireSerializable();
        return this;
    }

    public RestClientBuilder beansRequireSettersForGetters(boolean value) {
        super.beansRequireSettersForGetters(value);
        return this;
    }

    public RestClientBuilder beansRequireSettersForGetters() {
        super.beansRequireSettersForGetters();
        return this;
    }

    public RestClientBuilder beansRequireSomeProperties(boolean value) {
        super.beansRequireSomeProperties(value);
        return this;
    }

    public RestClientBuilder beanTypePropertyName(String value) {
        super.beanTypePropertyName(value);
        return this;
    }

    public RestClientBuilder debug() {
        super.debug();
        return this;
    }

    public RestClientBuilder debug(boolean value) {
        super.debug(value);
        return this;
    }

    public <T> RestClientBuilder example(Class<T> c, T o) {
        super.example(c, o);
        return this;
    }

    public <T> RestClientBuilder exampleJson(Class<T> c, String value) {
        super.exampleJson(c, value);
        return this;
    }

    public RestClientBuilder ignoreInvocationExceptionsOnGetters(boolean value) {
        super.ignoreInvocationExceptionsOnGetters(value);
        return this;
    }

    public RestClientBuilder ignoreInvocationExceptionsOnGetters() {
        super.ignoreInvocationExceptionsOnGetters();
        return this;
    }

    public RestClientBuilder ignoreInvocationExceptionsOnSetters(boolean value) {
        super.ignoreInvocationExceptionsOnSetters(value);
        return this;
    }

    public RestClientBuilder ignoreInvocationExceptionsOnSetters() {
        super.ignoreInvocationExceptionsOnSetters();
        return this;
    }

    public RestClientBuilder ignorePropertiesWithoutSetters(boolean value) {
        super.ignorePropertiesWithoutSetters(value);
        return this;
    }

    public RestClientBuilder ignoreUnknownBeanProperties(boolean value) {
        super.ignoreUnknownBeanProperties(value);
        return this;
    }

    public RestClientBuilder ignoreUnknownBeanProperties() {
        super.ignoreUnknownBeanProperties();
        return this;
    }

    public RestClientBuilder ignoreUnknownNullBeanProperties(boolean value) {
        super.ignoreUnknownNullBeanProperties(value);
        return this;
    }

    public RestClientBuilder implClass(Class<?> interfaceClass, Class<?> implClass) {
        super.implClass(interfaceClass, implClass);
        return this;
    }

    public RestClientBuilder implClasses(Map<String, Class<?>> values) {
        super.implClasses(values);
        return this;
    }

    public RestClientBuilder locale(Locale value) {
        super.locale(value);
        return this;
    }

    public RestClientBuilder mediaType(MediaType value) {
        super.mediaType(value);
        return this;
    }

    public RestClientBuilder notBeanClasses(Class<?> ... values) {
        super.notBeanClasses((Class[])values);
        return this;
    }

    public RestClientBuilder notBeanClasses(Object ... values) {
        super.notBeanClasses(values);
        return this;
    }

    public RestClientBuilder notBeanClassesReplace(Class<?> ... values) {
        super.notBeanClassesReplace((Class[])values);
        return this;
    }

    public RestClientBuilder notBeanClassesReplace(Object ... values) {
        super.notBeanClassesReplace(values);
        return this;
    }

    public RestClientBuilder notBeanClassesRemove(Class<?> ... values) {
        super.notBeanClassesRemove((Class[])values);
        return this;
    }

    public RestClientBuilder notBeanClassesRemove(Object ... values) {
        super.notBeanClassesRemove(values);
        return this;
    }

    public RestClientBuilder notBeanPackages(Object ... values) {
        super.notBeanPackages(values);
        return this;
    }

    public RestClientBuilder notBeanPackages(String ... values) {
        super.notBeanPackages(values);
        return this;
    }

    public RestClientBuilder notBeanPackagesReplace(String ... values) {
        super.notBeanPackagesReplace(values);
        return this;
    }

    public RestClientBuilder notBeanPackagesReplace(Object ... values) {
        super.notBeanPackagesReplace(values);
        return this;
    }

    public RestClientBuilder notBeanPackagesRemove(String ... values) {
        super.notBeanPackagesRemove(values);
        return this;
    }

    public RestClientBuilder notBeanPackagesRemove(Object ... values) {
        super.notBeanPackagesRemove(values);
        return this;
    }

    public RestClientBuilder pojoSwaps(Class<?> ... values) {
        super.pojoSwaps((Class[])values);
        return this;
    }

    public RestClientBuilder pojoSwaps(Object ... values) {
        super.pojoSwaps(values);
        return this;
    }

    public RestClientBuilder pojoSwapsReplace(Class<?> ... values) {
        super.pojoSwapsReplace((Class[])values);
        return this;
    }

    public RestClientBuilder pojoSwapsReplace(Object ... values) {
        super.pojoSwapsReplace(values);
        return this;
    }

    public RestClientBuilder pojoSwapsRemove(Class<?> ... values) {
        super.pojoSwapsRemove((Class[])values);
        return this;
    }

    public RestClientBuilder pojoSwapsRemove(Object ... values) {
        super.pojoSwapsRemove(values);
        return this;
    }

    public RestClientBuilder sortProperties(boolean value) {
        super.sortProperties(value);
        return this;
    }

    public RestClientBuilder sortProperties() {
        super.sortProperties();
        return this;
    }

    public RestClientBuilder timeZone(TimeZone value) {
        super.timeZone(value);
        return this;
    }

    public RestClientBuilder useEnumNames(boolean value) {
        super.useEnumNames(value);
        return this;
    }

    public RestClientBuilder useEnumNames() {
        super.useEnumNames();
        return this;
    }

    public RestClientBuilder useInterfaceProxies(boolean value) {
        super.useInterfaceProxies(value);
        return this;
    }

    public RestClientBuilder useJavaBeanIntrospector(boolean value) {
        super.useJavaBeanIntrospector(value);
        return this;
    }

    public RestClientBuilder useJavaBeanIntrospector() {
        super.useJavaBeanIntrospector();
        return this;
    }

    public RestClientBuilder set(String name, Object value) {
        super.set(name, value);
        return this;
    }

    public RestClientBuilder set(Map<String, Object> properties) {
        super.set(properties);
        return this;
    }

    public RestClientBuilder add(Map<String, Object> properties) {
        super.add(properties);
        return this;
    }

    public RestClientBuilder addTo(String name, Object value) {
        super.addTo(name, value);
        return this;
    }

    public RestClientBuilder addTo(String name, String key, Object value) {
        super.addTo(name, key, value);
        return this;
    }

    public RestClientBuilder removeFrom(String name, Object value) {
        super.removeFrom(name, value);
        return this;
    }

    public RestClientBuilder apply(PropertyStore copyFrom) {
        super.apply(copyFrom);
        return this;
    }

    public RestClientBuilder applyAnnotations(AnnotationList al, VarResolverSession vrs) {
        super.applyAnnotations(al, vrs);
        return this;
    }

    public RestClientBuilder applyAnnotations(Class<?> fromClass) {
        super.applyAnnotations(fromClass);
        return this;
    }

    public RestClientBuilder applyAnnotations(Method fromMethod) {
        super.applyAnnotations(fromMethod);
        return this;
    }

    public RestClientBuilder redirectStrategy(RedirectStrategy redirectStrategy) {
        this.httpClientBuilder.setRedirectStrategy(redirectStrategy);
        return this;
    }

    public RestClientBuilder defaultCookieSpecRegistry(Lookup<CookieSpecProvider> cookieSpecRegistry) {
        this.httpClientBuilder.setDefaultCookieSpecRegistry(cookieSpecRegistry);
        return this;
    }

    public RestClientBuilder requestExecutor(HttpRequestExecutor requestExec) {
        this.httpClientBuilder.setRequestExecutor(requestExec);
        return this;
    }

    public RestClientBuilder sslHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.httpClientBuilder.setSSLHostnameVerifier(hostnameVerifier);
        return this;
    }

    public RestClientBuilder publicSuffixMatcher(PublicSuffixMatcher publicSuffixMatcher) {
        this.httpClientBuilder.setPublicSuffixMatcher(publicSuffixMatcher);
        return this;
    }

    public RestClientBuilder sslContext(SSLContext sslContext) {
        this.httpClientBuilder.setSSLContext(sslContext);
        return this;
    }

    public RestClientBuilder sslSocketFactory(LayeredConnectionSocketFactory sslSocketFactory) {
        this.httpClientBuilder.setSSLSocketFactory(sslSocketFactory);
        return this;
    }

    public RestClientBuilder maxConnTotal(int maxConnTotal) {
        this.httpClientBuilder.setMaxConnTotal(maxConnTotal);
        return this;
    }

    public RestClientBuilder maxConnPerRoute(int maxConnPerRoute) {
        this.httpClientBuilder.setMaxConnPerRoute(maxConnPerRoute);
        return this;
    }

    public RestClientBuilder defaultSocketConfig(SocketConfig config) {
        this.httpClientBuilder.setDefaultSocketConfig(config);
        return this;
    }

    public RestClientBuilder defaultConnectionConfig(ConnectionConfig config) {
        this.httpClientBuilder.setDefaultConnectionConfig(config);
        return this;
    }

    public RestClientBuilder connectionTimeToLive(long connTimeToLive, TimeUnit connTimeToLiveTimeUnit) {
        this.httpClientBuilder.setConnectionTimeToLive(connTimeToLive, connTimeToLiveTimeUnit);
        return this;
    }

    public RestClientBuilder connectionManager(HttpClientConnectionManager connManager) {
        this.httpClientConnectionManager = connManager;
        this.httpClientBuilder.setConnectionManager(connManager);
        return this;
    }

    public RestClientBuilder connectionManagerShared(boolean shared) {
        this.httpClientBuilder.setConnectionManagerShared(shared);
        return this;
    }

    public RestClientBuilder connectionReuseStrategy(ConnectionReuseStrategy reuseStrategy) {
        this.httpClientBuilder.setConnectionReuseStrategy(reuseStrategy);
        return this;
    }

    public RestClientBuilder keepAliveStrategy(ConnectionKeepAliveStrategy keepAliveStrategy) {
        this.httpClientBuilder.setKeepAliveStrategy(keepAliveStrategy);
        return this;
    }

    public RestClientBuilder targetAuthenticationStrategy(AuthenticationStrategy targetAuthStrategy) {
        this.httpClientBuilder.setTargetAuthenticationStrategy(targetAuthStrategy);
        return this;
    }

    public RestClientBuilder proxyAuthenticationStrategy(AuthenticationStrategy proxyAuthStrategy) {
        this.httpClientBuilder.setProxyAuthenticationStrategy(proxyAuthStrategy);
        return this;
    }

    public RestClientBuilder userTokenHandler(UserTokenHandler userTokenHandler) {
        this.httpClientBuilder.setUserTokenHandler(userTokenHandler);
        return this;
    }

    public RestClientBuilder disableConnectionState() {
        this.httpClientBuilder.disableConnectionState();
        return this;
    }

    public RestClientBuilder schemePortResolver(SchemePortResolver schemePortResolver) {
        this.httpClientBuilder.setSchemePortResolver(schemePortResolver);
        return this;
    }

    public RestClientBuilder userAgent(String userAgent) {
        this.httpClientBuilder.setUserAgent(userAgent);
        return this;
    }

    public RestClientBuilder defaultHeaders(Collection<? extends Header> defaultHeaders) {
        this.httpClientBuilder.setDefaultHeaders(defaultHeaders);
        return this;
    }

    public RestClientBuilder addInterceptorFirst(HttpResponseInterceptor itcp) {
        this.httpClientBuilder.addInterceptorFirst(itcp);
        return this;
    }

    public RestClientBuilder addInterceptorLast(HttpResponseInterceptor itcp) {
        this.httpClientBuilder.addInterceptorLast(itcp);
        return this;
    }

    public RestClientBuilder addInterceptorFirst(HttpRequestInterceptor itcp) {
        this.httpClientBuilder.addInterceptorFirst(itcp);
        return this;
    }

    public RestClientBuilder addInterceptorLast(HttpRequestInterceptor itcp) {
        this.httpClientBuilder.addInterceptorLast(itcp);
        return this;
    }

    public RestClientBuilder disableCookieManagement() {
        this.httpClientBuilder.disableCookieManagement();
        return this;
    }

    public RestClientBuilder disableContentCompression() {
        this.httpClientBuilder.disableContentCompression();
        return this;
    }

    public RestClientBuilder disableAuthCaching() {
        this.httpClientBuilder.disableAuthCaching();
        return this;
    }

    public RestClientBuilder httpProcessor(HttpProcessor httpprocessor) {
        this.httpClientBuilder.setHttpProcessor(httpprocessor);
        return this;
    }

    public RestClientBuilder retryHandler(HttpRequestRetryHandler retryHandler) {
        this.httpClientBuilder.setRetryHandler(retryHandler);
        return this;
    }

    public RestClientBuilder disableAutomaticRetries() {
        this.httpClientBuilder.disableAutomaticRetries();
        return this;
    }

    public RestClientBuilder proxy(HttpHost proxy) {
        this.httpClientBuilder.setProxy(proxy);
        return this;
    }

    public RestClientBuilder routePlanner(HttpRoutePlanner routePlanner) {
        this.httpClientBuilder.setRoutePlanner(routePlanner);
        return this;
    }

    public RestClientBuilder disableRedirectHandling() {
        this.httpClientBuilder.disableRedirectHandling();
        return this;
    }

    public RestClientBuilder connectionBackoffStrategy(ConnectionBackoffStrategy connectionBackoffStrategy) {
        this.httpClientBuilder.setConnectionBackoffStrategy(connectionBackoffStrategy);
        return this;
    }

    public RestClientBuilder backoffManager(BackoffManager backoffManager) {
        this.httpClientBuilder.setBackoffManager(backoffManager);
        return this;
    }

    public RestClientBuilder serviceUnavailableRetryStrategy(ServiceUnavailableRetryStrategy serviceUnavailStrategy) {
        this.httpClientBuilder.setServiceUnavailableRetryStrategy(serviceUnavailStrategy);
        return this;
    }

    public RestClientBuilder defaultCookieStore(CookieStore cookieStore) {
        this.httpClientBuilder.setDefaultCookieStore(cookieStore);
        return this;
    }

    public RestClientBuilder defaultCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        return this;
    }

    public RestClientBuilder defaultAuthSchemeRegistry(Lookup<AuthSchemeProvider> authSchemeRegistry) {
        this.httpClientBuilder.setDefaultAuthSchemeRegistry(authSchemeRegistry);
        return this;
    }

    public RestClientBuilder contentDecoderRegistry(Map<String, InputStreamFactory> contentDecoderMap) {
        this.httpClientBuilder.setContentDecoderRegistry(contentDecoderMap);
        return this;
    }

    public RestClientBuilder defaultRequestConfig(RequestConfig config) {
        this.httpClientBuilder.setDefaultRequestConfig(config);
        return this;
    }

    public RestClientBuilder useSystemProperties() {
        this.httpClientBuilder.useSystemProperties();
        return this;
    }

    public RestClientBuilder evictExpiredConnections() {
        this.httpClientBuilder.evictExpiredConnections();
        return this;
    }

    public RestClientBuilder evictIdleConnections(long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.httpClientBuilder.evictIdleConnections(maxIdleTime, maxIdleTimeUnit);
        return this;
    }

    private static String[] getDefaultProtocols() {
        String sp = System.getProperty("transport.client.protocol");
        if (StringUtils.isEmpty((String)sp)) {
            return new String[]{"SSL_TLS", "TLS", "SSL"};
        }
        return StringUtils.split((String)sp, (char)',');
    }
}

