// ***************************************************************************************************************************
// * Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements.  See the NOTICE file *
// * distributed with this work for additional information regarding copyright ownership.  The ASF licenses this file        *
// * to you under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance            *
// * with the License.  You may obtain a copy of the License at                                                              *
// *                                                                                                                         *
// *  http://www.apache.org/licenses/LICENSE-2.0                                                                             *
// *                                                                                                                         *
// * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an  *
// * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the License for the        *
// * specific language governing permissions and limitations under the License.                                              *
// ***************************************************************************************************************************
package org.apache.juneau.examples.rest.petstore;

import org.apache.juneau.http.annotation.*;
import org.apache.juneau.rest.exception.*;

/**
 * Exception thrown when trying to add an entry where the ID is already in use.
 */
@SuppressWarnings("serial")
@Response(description="Invalid username provided")
public class InvalidUsername extends BadRequest {

	/**
	 * Constructor.
	 */
	public InvalidUsername() {
		super("Invalid username provided.  Must be between 3 and 8 characters or digits.");
	}
}
