/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.svl;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.juneau.internal.AsciiSet;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.svl.Var;
import org.apache.juneau.svl.VarResolverContext;
import org.apache.juneau.svl.VarResolverException;

public class VarResolverSession {
    private final VarResolverContext context;
    private final Map<String, Object> sessionObjects;
    private static final AsciiSet AS1 = AsciiSet.create((String)"\\{");
    private static final AsciiSet AS2 = AsciiSet.create((String)"\\${}");

    public VarResolverSession(VarResolverContext context, Map<String, Object> sessionObjects) {
        this.context = context;
        this.sessionObjects = sessionObjects != null ? sessionObjects : new HashMap<String, Object>();
    }

    public VarResolverSession sessionObject(String name, Object o) {
        this.sessionObjects.put(name, o);
        return this;
    }

    public String resolve(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        if (s.indexOf(36) == -1 && s.indexOf(92) == -1) {
            return s;
        }
        if (VarResolverSession.isSimpleVar(s)) {
            String var = s.substring(1, s.indexOf(123));
            String val = s.substring(s.indexOf(123) + 1, s.length() - 1);
            Var v = this.getVar(var);
            if (v != null) {
                try {
                    if (v.streamed) {
                        StringWriter sw = new StringWriter();
                        v.resolveTo(this, sw, val);
                        return sw.toString();
                    }
                    s = v.doResolve(this, val);
                    if (s == null) {
                        s = "";
                    }
                    return v.allowRecurse() ? this.resolve(s) : s;
                }
                catch (VarResolverException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new VarResolverException(e, "Problem occurred resolving variable ''{0}'' in string ''{1}''", var, s);
                }
            }
            return s;
        }
        try {
            return this.resolveTo(s, new StringWriter()).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T resolve(T o) {
        if (o == null) {
            return null;
        }
        if (o instanceof CharSequence) {
            return (T)this.resolve(o.toString());
        }
        if (o.getClass().isArray()) {
            if (!VarResolverSession.containsVars(o)) {
                return o;
            }
            Object o2 = Array.newInstance(o.getClass().getComponentType(), Array.getLength(o));
            for (int i = 0; i < Array.getLength(o); ++i) {
                Array.set(o2, i, this.resolve(Array.get(o, i)));
            }
            return (T)o2;
        }
        if (o instanceof Collection) {
            try {
                Collection c = (Collection)o;
                if (!VarResolverSession.containsVars(c)) {
                    return o;
                }
                Collection c2 = (Collection)c.getClass().newInstance();
                for (Object o2 : c) {
                    c2.add(this.resolve(o2));
                }
                return (T)c2;
            }
            catch (VarResolverException e) {
                throw e;
            }
            catch (Exception e) {
                throw new VarResolverException(e, "Problem occurred resolving collection.", new Object[0]);
            }
        }
        if (o instanceof Map) {
            try {
                Map m = (Map)o;
                if (!VarResolverSession.containsVars(m)) {
                    return o;
                }
                Map m2 = (Map)m.getClass().newInstance();
                for (Map.Entry e : m.entrySet()) {
                    m2.put(e.getKey(), this.resolve(e.getValue()));
                }
                return (T)m2;
            }
            catch (VarResolverException e) {
                throw e;
            }
            catch (Exception e) {
                throw new VarResolverException(e, "Problem occurred resolving map.", new Object[0]);
            }
        }
        return o;
    }

    private static boolean containsVars(Object array) {
        for (int i = 0; i < Array.getLength(array); ++i) {
            Object o = Array.get(array, i);
            if (!(o instanceof CharSequence) || !o.toString().contains("$")) continue;
            return true;
        }
        return false;
    }

    private static boolean containsVars(Collection c) {
        for (Object o : c) {
            if (!(o instanceof CharSequence) || !o.toString().contains("$")) continue;
            return true;
        }
        return false;
    }

    private static boolean containsVars(Map m) {
        for (Object o : m.values()) {
            if (!(o instanceof CharSequence) || !o.toString().contains("$")) continue;
            return true;
        }
        return false;
    }

    private static boolean isSimpleVar(String s) {
        int S1 = 1;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        int length = s.length();
        int state = S1;
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (state == S1) {
                if (c == '$') {
                    state = S2;
                    continue;
                }
                return false;
            }
            if (state == S2) {
                if (c == '{') {
                    state = S3;
                    continue;
                }
                if (c >= 'A' && c <= 'z' && (c <= 'Z' || c >= 'a')) continue;
                return false;
            }
            if (state == S3) {
                if (c == '}') {
                    state = S4;
                    continue;
                }
                if (c != '{' && c != '$') continue;
                return false;
            }
            if (state != S4) continue;
            return false;
        }
        return state == S4;
    }

    public Writer resolveTo(String s, Writer out) throws IOException {
        int S1 = 1;
        int S2 = 2;
        int S3 = 3;
        int state = S1;
        boolean isInEscape = false;
        boolean hasInternalVar = false;
        boolean hasInnerEscapes = false;
        String varType = null;
        String varVal = null;
        int x = 0;
        int x2 = 0;
        int depth = 0;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (state == S1) {
                if (isInEscape) {
                    if (c == '\\' || c == '$') {
                        out.append(c);
                    } else {
                        out.append('\\').append(c);
                    }
                    isInEscape = false;
                    continue;
                }
                if (c == '\\') {
                    isInEscape = true;
                    continue;
                }
                if (c == '$') {
                    x = i;
                    x2 = i;
                    state = S2;
                    continue;
                }
                out.append(c);
                continue;
            }
            if (state == S2) {
                if (isInEscape) {
                    isInEscape = false;
                    continue;
                }
                if (c == '\\') {
                    hasInnerEscapes = true;
                    isInEscape = true;
                    continue;
                }
                if (c == '{') {
                    varType = s.substring(x + 1, i);
                    x = i;
                    state = S3;
                    continue;
                }
                if (c >= 'A' && c <= 'z' && (c <= 'Z' || c >= 'a')) continue;
                if (hasInnerEscapes) {
                    out.append(StringUtils.unEscapeChars((String)s.substring(x, i + 1), (AsciiSet)AS1));
                } else {
                    out.append(s, x, i + 1);
                }
                x = i + 1;
                state = S1;
                hasInnerEscapes = false;
                continue;
            }
            if (state != S3) continue;
            if (isInEscape) {
                isInEscape = false;
                continue;
            }
            if (c == '\\') {
                isInEscape = true;
                hasInnerEscapes = true;
                continue;
            }
            if (c == '{') {
                ++depth;
                hasInternalVar = true;
                continue;
            }
            if (c != '}') continue;
            if (depth > 0) {
                --depth;
                continue;
            }
            varVal = s.substring(x + 1, i);
            Var r = this.getVar(varType);
            if (r == null) {
                if (hasInnerEscapes) {
                    out.append(StringUtils.unEscapeChars((String)s.substring(x2, i + 1), (AsciiSet)AS2));
                } else {
                    out.append(s, x2, i + 1);
                }
                x = i + 1;
            } else {
                varVal = hasInternalVar && r.allowNested() ? this.resolve(varVal) : varVal;
                try {
                    if (r.streamed) {
                        r.resolveTo(this, out, varVal);
                    } else {
                        String replacement = r.doResolve(this, varVal);
                        if (replacement == null) {
                            replacement = "";
                        }
                        if (replacement.indexOf(36) != -1 && r.allowRecurse()) {
                            replacement = this.resolve(replacement);
                        }
                        out.append(replacement);
                    }
                }
                catch (VarResolverException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new VarResolverException(e, "Problem occurred resolving variable ''{0}'' in string ''{1}''", varType, s);
                }
                x = i + 1;
            }
            state = 1;
            hasInnerEscapes = false;
        }
        if (isInEscape) {
            out.append('\\');
        } else if (state == S2) {
            out.append('$').append(StringUtils.unEscapeChars((String)s.substring(x + 1), (AsciiSet)AS1));
        } else if (state == S3) {
            out.append('$').append(varType).append('{').append(StringUtils.unEscapeChars((String)s.substring(x + 1), (AsciiSet)AS2));
        }
        return out;
    }

    public <T> T getSessionObject(Class<T> c, String name, boolean throwNotSetException) {
        Object t = null;
        try {
            t = this.sessionObjects.get(name);
            if (t == null) {
                this.sessionObjects.put(name, this.context.getContextObject(name));
                t = this.sessionObjects.get(name);
            }
        }
        catch (Exception e) {
            throw new VarResolverException(e, "Session object ''{0}'' or context object ''SvlContext.{0}'' could not be converted to type ''{1}''.", name, c);
        }
        if (t == null && throwNotSetException) {
            throw new VarResolverException("Session object ''{0}'' or context object ''SvlContext.{0}'' not found.", name);
        }
        return (T)t;
    }

    protected Var getVar(String name) {
        return this.context.getVarMap().get(name);
    }
}

