/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.transform.BeanFilter;
import org.apache.juneau.transform.PropertyFilter;

public class BeanFilterBuilder<T> {
    Class<?> beanClass;
    String typeName;
    String[] includeProperties;
    String[] excludeProperties;
    Class<?> interfaceClass;
    Class<?> stopClass;
    boolean sortProperties;
    boolean fluentSetters;
    Object propertyNamer;
    List<Class<?>> beanDictionary;
    Object propertyFilter;

    protected BeanFilterBuilder() {
        this.beanClass = ClassUtils.resolveParameterType(BeanFilterBuilder.class, 0, this.getClass());
    }

    protected BeanFilterBuilder(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    public BeanFilterBuilder<T> typeName(String value) {
        this.typeName = value;
        return this;
    }

    public BeanFilterBuilder<T> properties(String ... value) {
        this.includeProperties = value;
        return this;
    }

    public BeanFilterBuilder<T> excludeProperties(String ... value) {
        this.excludeProperties = value;
        return this;
    }

    public BeanFilterBuilder<T> interfaceClass(Class<?> value) {
        this.interfaceClass = value;
        return this;
    }

    public BeanFilterBuilder<T> stopClass(Class<?> value) {
        this.stopClass = value;
        return this;
    }

    public BeanFilterBuilder<T> sortProperties(boolean value) {
        this.sortProperties = value;
        return this;
    }

    public BeanFilterBuilder<T> sortProperties() {
        this.sortProperties = true;
        return this;
    }

    public BeanFilterBuilder<T> fluentSetters(boolean value) {
        this.fluentSetters = value;
        return this;
    }

    public BeanFilterBuilder<T> fluentSetters() {
        this.fluentSetters = true;
        return this;
    }

    public BeanFilterBuilder<T> propertyNamer(Class<? extends PropertyNamer> value) {
        this.propertyNamer = value;
        return this;
    }

    public BeanFilterBuilder<T> beanDictionary(Class<?> ... values) {
        if (this.beanDictionary == null) {
            this.beanDictionary = new ArrayList(Arrays.asList(values));
        } else {
            for (Class<?> cc : values) {
                this.beanDictionary.add(cc);
            }
        }
        return this;
    }

    public BeanFilterBuilder<T> propertyFilter(Class<? extends PropertyFilter> value) {
        this.propertyFilter = value;
        return this;
    }

    public BeanFilter build() {
        return new BeanFilter(this);
    }
}

