/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanContext;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.http.ContentType;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserGroupBuilder;
import org.apache.juneau.parser.ParserMatch;

public final class ParserGroup
extends BeanContext {
    public static final ParserGroup EMPTY = ParserGroup.create().build();
    private final ConcurrentHashMap<String, ParserMatch> cache = new ConcurrentHashMap();
    private final MediaType[] mediaTypes;
    private final List<MediaType> mediaTypesList;
    private final Parser[] mediaTypeParsers;
    private final List<Parser> parsers;

    public static ParserGroupBuilder create() {
        return new ParserGroupBuilder();
    }

    @Override
    public ParserGroupBuilder builder() {
        return new ParserGroupBuilder(this);
    }

    public ParserGroup(PropertyStore ps, Parser[] parsers) {
        super(ps);
        this.parsers = CollectionUtils.immutableList(parsers);
        ArrayList<MediaType> lmt = new ArrayList<MediaType>();
        ArrayList<Parser> l = new ArrayList<Parser>();
        for (Parser p : parsers) {
            for (MediaType m : p.getMediaTypes()) {
                lmt.add(m);
                l.add(p);
            }
        }
        this.mediaTypes = lmt.toArray(new MediaType[lmt.size()]);
        this.mediaTypesList = CollectionUtils.unmodifiableList(lmt);
        this.mediaTypeParsers = l.toArray(new Parser[l.size()]);
    }

    public ParserMatch getParserMatch(String contentTypeHeader) {
        ParserMatch pm = this.cache.get(contentTypeHeader);
        if (pm != null) {
            return pm;
        }
        ContentType ct = ContentType.forString(contentTypeHeader);
        int match = ct.findMatch(this.mediaTypes);
        if (match >= 0) {
            pm = new ParserMatch(this.mediaTypes[match], this.mediaTypeParsers[match]);
            this.cache.putIfAbsent(contentTypeHeader, pm);
        }
        return this.cache.get(contentTypeHeader);
    }

    public ParserMatch getParserMatch(MediaType mediaType) {
        return this.getParserMatch(mediaType.toString());
    }

    public Parser getParser(String contentTypeHeader) {
        ParserMatch pm = this.getParserMatch(contentTypeHeader);
        return pm == null ? null : pm.getParser();
    }

    public Parser getParser(MediaType mediaType) {
        ParserMatch pm = this.getParserMatch(mediaType);
        return pm == null ? null : pm.getParser();
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.mediaTypesList;
    }

    public List<Parser> getParsers() {
        return this.parsers;
    }
}

