/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.oapi;

import java.lang.reflect.Type;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.InvalidDataConversionException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.oapi.OpenApiParser;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.uon.UonParserSession;

public class OpenApiParserSession
extends UonParserSession {
    private static final BeanContext BC = BeanContext.DEFAULT;
    private static final ClassMeta<Long> CM_Long = BC.getClassMeta(Long.class);
    private static final ClassMeta<Integer> CM_Integer = BC.getClassMeta(Integer.class);
    private static final ClassMeta<Double> CM_Double = BC.getClassMeta(Double.class);
    private static final ClassMeta<Float> CM_Float = BC.getClassMeta(Float.class);
    private static final ClassMeta<Boolean> CM_Boolean = BC.getClassMeta(Boolean.class);
    private static final ClassMeta<ObjectList> CM_ObjectList = BC.getClassMeta(ObjectList.class);
    private static final ClassMeta<ObjectMap> CM_ObjectMap = BC.getClassMeta(ObjectMap.class);
    private static final HttpPartSchema DEFAULT_SCHEMA = HttpPartSchema.DEFAULT;
    private final OpenApiParser ctx;

    protected OpenApiParserSession(OpenApiParser ctx, ParserSessionArgs args) {
        super(ctx, args);
        this.ctx = ctx;
    }

    @Override
    public <T> T parse(HttpPartType partType, HttpPartSchema schema, String in, ClassMeta<T> type) throws ParseException, SchemaValidationException {
        T t = this.parseInner(partType, schema = ObjectUtils.firstNonNull(schema, this.getSchema(), DEFAULT_SCHEMA), in, type);
        if (t == null && type.isPrimitive()) {
            t = type.getPrimitiveDefault();
        }
        schema.validateOutput(t, this.ctx);
        return t;
    }

    private <T> T parseInner(HttpPartType partType, HttpPartSchema schema, String in, ClassMeta<T> type) throws SchemaValidationException, ParseException {
        schema.validateInput(in);
        if (in == null) {
            if (schema.getDefault() == null) {
                return null;
            }
            in = schema.getDefault();
        } else {
            HttpPartSchema.Type t = schema.getType(type);
            HttpPartSchema.Format f = schema.getFormat(type);
            if (t == HttpPartSchema.Type.STRING) {
                if (type.isObject()) {
                    if (f == HttpPartSchema.Format.BYTE) {
                        return (T)StringUtils.base64Decode(in);
                    }
                    if (f == HttpPartSchema.Format.DATE || f == HttpPartSchema.Format.DATE_TIME) {
                        return (T)StringUtils.parseIsoCalendar(in);
                    }
                    if (f == HttpPartSchema.Format.BINARY) {
                        return (T)StringUtils.fromHex(in);
                    }
                    if (f == HttpPartSchema.Format.BINARY_SPACED) {
                        return (T)StringUtils.fromSpacedHex(in);
                    }
                    if (f == HttpPartSchema.Format.UON) {
                        return (T)super.parse(partType, schema, in, type);
                    }
                    return (T)in;
                }
                if (f == HttpPartSchema.Format.BYTE) {
                    return this.toType(StringUtils.base64Decode(in), type);
                }
                if (f == HttpPartSchema.Format.DATE || f == HttpPartSchema.Format.DATE_TIME) {
                    return (T)this.toType(StringUtils.parseIsoCalendar(in), type);
                }
                if (f == HttpPartSchema.Format.BINARY) {
                    return (T)this.toType(StringUtils.fromHex(in), type);
                }
                if (f == HttpPartSchema.Format.BINARY_SPACED) {
                    return (T)this.toType(StringUtils.fromSpacedHex(in), type);
                }
                if (f == HttpPartSchema.Format.UON) {
                    return (T)super.parse(partType, schema, in, type);
                }
                return (T)this.toType(in, type);
            }
            if (t == HttpPartSchema.Type.ARRAY) {
                ClassMeta<String> eType;
                if (type.isObject()) {
                    type = CM_ObjectList;
                }
                ClassMeta<String> classMeta = eType = type.isObject() ? this.string() : type.getElementType();
                if (eType == null) {
                    eType = schema.getParsedType().getElementType();
                }
                HttpPartSchema.CollectionFormat cf = schema.getCollectionFormat();
                String[] ss = new String[]{};
                if (cf == HttpPartSchema.CollectionFormat.MULTI) {
                    ss = new String[]{in};
                } else if (cf == HttpPartSchema.CollectionFormat.CSV) {
                    ss = StringUtils.split(in, ',');
                } else if (cf == HttpPartSchema.CollectionFormat.PIPES) {
                    ss = StringUtils.split(in, '|');
                } else if (cf == HttpPartSchema.CollectionFormat.SSV) {
                    ss = StringUtils.splitQuoted(in);
                } else if (cf == HttpPartSchema.CollectionFormat.TSV) {
                    ss = StringUtils.split(in, '\t');
                } else {
                    if (cf == HttpPartSchema.CollectionFormat.UON) {
                        return (T)super.parse(partType, null, in, type);
                    }
                    if (cf == HttpPartSchema.CollectionFormat.NO_COLLECTION_FORMAT) {
                        if (StringUtils.firstNonWhitespaceChar(in) == '@' && StringUtils.lastNonWhitespaceChar(in) == ')') {
                            return (T)super.parse(partType, null, in, type);
                        }
                        ss = StringUtils.split(in, ',');
                    }
                }
                HttpPartSchema items = schema.getItems();
                if (items == null) {
                    items = HttpPartSchema.DEFAULT;
                }
                Object[] o = new Object[ss.length];
                for (int i = 0; i < ss.length; ++i) {
                    o[i] = this.parse(partType, items, ss[i], eType);
                }
                if (type.hasTransformFrom(schema.getParsedType()) || schema.getParsedType().hasTransformTo(type)) {
                    return (T)this.toType(this.toType(o, schema.getParsedType()), type);
                }
                return (T)this.toType(o, type);
            }
            if (t == HttpPartSchema.Type.BOOLEAN) {
                if (type.isObject()) {
                    type = CM_Boolean;
                }
                if (type.isBoolean()) {
                    return (T)super.parse(partType, schema, in, type);
                }
                return (T)this.toType(super.parse(partType, schema, in, CM_Boolean), type);
            }
            if (t == HttpPartSchema.Type.INTEGER) {
                if (type.isObject()) {
                    type = f == HttpPartSchema.Format.INT64 ? CM_Long : CM_Integer;
                }
                if (type.isNumber()) {
                    return (T)super.parse(partType, schema, in, type);
                }
                return (T)this.toType(super.parse(partType, schema, in, CM_Integer), type);
            }
            if (t == HttpPartSchema.Type.NUMBER) {
                if (type.isObject()) {
                    type = f == HttpPartSchema.Format.DOUBLE ? CM_Double : CM_Float;
                }
                if (type.isNumber()) {
                    return (T)super.parse(partType, schema, in, type);
                }
                return (T)this.toType(super.parse(partType, schema, in, CM_Integer), type);
            }
            if (t == HttpPartSchema.Type.OBJECT) {
                if (type.isObject()) {
                    type = CM_ObjectMap;
                }
                if (schema.hasProperties() && type.isMapOrBean()) {
                    try {
                        if (type.isBean()) {
                            BeanMap<Object> m = BC.createBeanSession().newBeanMap(type.getInnerClass());
                            for (Map.Entry<String, Object> e : this.parse(partType, DEFAULT_SCHEMA, in, CM_ObjectMap).entrySet()) {
                                String key = e.getKey();
                                BeanPropertyMeta bpm = m.getPropertyMeta(key);
                                m.put(key, this.parse(partType, schema.getProperty(key), StringUtils.asString(e.getValue()), bpm == null ? this.object() : bpm.getClassMeta(), new Type[0]));
                            }
                            return (T)m.getBean();
                        }
                        Map m = (Map)type.newInstance();
                        for (Map.Entry<String, Object> e : this.parse(partType, DEFAULT_SCHEMA, in, CM_ObjectMap).entrySet()) {
                            String key = e.getKey();
                            m.put(key, this.parse(partType, schema.getProperty(key), StringUtils.asString(e.getValue()), this.object()));
                        }
                        return (T)m;
                    }
                    catch (Exception e1) {
                        throw new ParseException(e1, "Could not instantiate type ''{0}''.", type);
                    }
                }
                return (T)super.parse(partType, schema, in, type);
            }
            if (t == HttpPartSchema.Type.FILE) {
                throw new ParseException("File part not supported.", new Object[0]);
            }
            if (t == HttpPartSchema.Type.NO_TYPE) {
                throw new ParseException("Invalid type.", new Object[0]);
            }
        }
        return super.parse(partType, schema, in, type);
    }

    private <T> T toType(Object in, ClassMeta<T> type) throws ParseException {
        try {
            return this.convertToType(in, type);
        }
        catch (InvalidDataConversionException e) {
            throw new ParseException(e.getMessage(), new Object[0]);
        }
    }
}

