/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.json.JsonSchemaSerializer;
import org.apache.juneau.json.JsonSerializerBuilder;
import org.apache.juneau.json.JsonSerializerSession;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.WriterSerializer;

public class JsonSerializer
extends WriterSerializer {
    private static final String PREFIX = "JsonSerializer.";
    public static final String JSON_addBeanTypes = "JsonSerializer.addBeanTypes.b";
    public static final String JSON_escapeSolidus = "JsonSerializer.escapeSolidus.b";
    public static final String JSON_simpleMode = "JsonSerializer.simpleMode.b";
    public static final JsonSerializer DEFAULT = new JsonSerializer(PropertyStore.DEFAULT);
    public static final JsonSerializer DEFAULT_READABLE = new Readable(PropertyStore.DEFAULT);
    private final boolean simpleMode = this.getBooleanProperty("JsonSerializer.simpleMode.b", false);
    private final boolean escapeSolidus = this.getBooleanProperty("JsonSerializer.escapeSolidus.b", false);
    private final boolean addBeanTypes = this.getBooleanProperty("JsonSerializer.addBeanTypes.b", this.getBooleanProperty("Serializer.addBeanTypes.b", false));
    private volatile JsonSchemaSerializer schemaSerializer;

    public JsonSerializer(PropertyStore ps) {
        this(ps, "application/json", "application/json,text/json");
    }

    public JsonSerializer(PropertyStore ps, String produces, String accept) {
        super(ps, produces, accept);
    }

    @Override
    public JsonSerializerBuilder builder() {
        return new JsonSerializerBuilder(this.getPropertyStore());
    }

    public static JsonSerializerBuilder create() {
        return new JsonSerializerBuilder();
    }

    public JsonSchemaSerializer getSchemaSerializer() {
        if (this.schemaSerializer == null) {
            this.schemaSerializer = this.builder().build(JsonSchemaSerializer.class);
        }
        return this.schemaSerializer;
    }

    @Override
    public JsonSerializerSession createSession(SerializerSessionArgs args) {
        return new JsonSerializerSession(this, args);
    }

    protected final boolean isSimpleMode() {
        return this.simpleMode;
    }

    protected final boolean isEscapeSolidus() {
        return this.escapeSolidus;
    }

    @Override
    protected final boolean isAddBeanTypes() {
        return this.addBeanTypes;
    }

    @Override
    public ObjectMap asMap() {
        return super.asMap().append("JsonSerializer", new ObjectMap().append("simpleMode", this.simpleMode).append("escapeSolidus", this.escapeSolidus).append("addBeanTypes", this.addBeanTypes));
    }

    public static class ReadableSafe
    extends JsonSerializer {
        public ReadableSafe(PropertyStore ps) {
            super(ps.builder().set(JsonSerializer.JSON_simpleMode, true).set("WriterSerializer.quoteChar.s", Character.valueOf('\'')).set("Serializer.useWhitespace.b", true).set("BeanTraverseContext.detectRecursions.b", true).build());
        }
    }

    public static class Readable
    extends JsonSerializer {
        public Readable(PropertyStore ps) {
            super(ps.builder().set("Serializer.useWhitespace.b", true).build());
        }
    }
}

