/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.juneau.FormattedIllegalArgumentException;
import org.apache.juneau.internal.FileReaderBuilder;
import org.apache.juneau.internal.FileWriterBuilder;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.utils.IOPipe;

public final class IOUtils {
    public static final Charset UTF8 = Charset.forName("UTF-8");

    public static String readFile(String path) throws IOException {
        return IOUtils.read(new File(path));
    }

    public static String read(Object in) throws IOException {
        if (in == null) {
            return null;
        }
        if (in instanceof CharSequence) {
            return in.toString();
        }
        if (in instanceof File) {
            return IOUtils.read((File)in);
        }
        if (in instanceof Reader) {
            return IOUtils.read((Reader)in);
        }
        if (in instanceof InputStream) {
            return IOUtils.read((InputStream)in);
        }
        if (in instanceof byte[]) {
            return IOUtils.read(new ByteArrayInputStream((byte[])in));
        }
        throw new IOException("Cannot convert object of type '" + in.getClass().getName() + "' to a String.");
    }

    public static String readAll(Object ... in) throws IOException {
        if (in.length == 1) {
            return IOUtils.read(in[0]);
        }
        StringWriter sw = new StringWriter();
        for (Object o : in) {
            sw.write(StringUtils.emptyIfNull(IOUtils.read(o)));
        }
        return sw.toString();
    }

    public static String read(File in) throws IOException {
        if (in == null || !in.exists()) {
            return null;
        }
        try (Reader r = FileReaderBuilder.create(in).build();){
            String string = IOUtils.read(r, 0, 1024);
            return string;
        }
    }

    public static String read(Reader in) throws IOException {
        return IOUtils.read(in, 0, 1024);
    }

    public static String read(InputStream in, Charset cs) throws IOException {
        if (in == null) {
            return null;
        }
        return IOUtils.read(new InputStreamReader(in, cs));
    }

    public static String read(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        return IOUtils.read(new InputStreamReader(in, Charset.defaultCharset()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(Reader in, int length, int bufferSize) throws IOException {
        if (in == null) {
            return null;
        }
        if (bufferSize == 0) {
            bufferSize = 1024;
        }
        length = length <= 0 ? bufferSize : length;
        StringBuilder sb = new StringBuilder(length);
        try {
            char[] buf = new char[Math.min(bufferSize, length)];
            int i = 0;
            while ((i = in.read(buf)) != -1) {
                sb.append(buf, 0, i);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            in.close();
        }
    }

    public static byte[] readBytes(Object in, int buffSize) throws IOException {
        if (in == null) {
            return new byte[0];
        }
        if (in instanceof byte[]) {
            return (byte[])in;
        }
        if (in instanceof CharSequence) {
            return in.toString().getBytes(UTF8);
        }
        if (in instanceof InputStream) {
            return IOUtils.readBytes((InputStream)in, buffSize);
        }
        if (in instanceof Reader) {
            return IOUtils.read((Reader)in, 0, buffSize).getBytes(UTF8);
        }
        if (in instanceof File) {
            return IOUtils.readBytes((File)in, buffSize);
        }
        throw new IOException("Cannot convert object of type '" + in.getClass().getName() + "' to a byte array.");
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        return IOUtils.readBytes(in, 1024);
    }

    public static byte[] readBytes(InputStream in, int buffSize) throws IOException {
        if (buffSize == 0) {
            buffSize = 1024;
        }
        try (ByteArrayOutputStream buff = new ByteArrayOutputStream(buffSize);){
            int nRead;
            byte[] b = new byte[buffSize];
            while ((nRead = in.read(b, 0, b.length)) != -1) {
                buff.write(b, 0, nRead);
            }
            buff.flush();
            byte[] byArray = buff.toByteArray();
            return byArray;
        }
    }

    public static byte[] readBytes(File in) throws IOException {
        return IOUtils.readBytes(in, 1024);
    }

    public static byte[] readBytes(File in, int buffSize) throws IOException {
        if (buffSize == 0) {
            buffSize = 1024;
        }
        if (!in.exists() || !in.canRead()) {
            return new byte[0];
        }
        buffSize = Math.min((int)in.length(), buffSize);
        try (FileInputStream fis = new FileInputStream(in);){
            byte[] byArray = IOUtils.readBytes(fis, buffSize);
            return byArray;
        }
    }

    public static byte[] readBytes(Object in) throws IOException {
        return IOUtils.readBytes(in, 1024);
    }

    public static byte[] readBytes(Object ... in) throws IOException {
        if (in.length == 1) {
            return IOUtils.readBytes(in[0]);
        }
        try (ByteArrayOutputStream buff = new ByteArrayOutputStream(1024);){
            for (Object o : in) {
                byte[] bo = IOUtils.readBytes(o);
                if (bo == null) continue;
                buff.write(bo);
            }
            buff.flush();
            byte[] byArray = buff.toByteArray();
            return byArray;
        }
    }

    public static int write(File out, Reader in) throws IOException {
        ThrowableUtils.assertFieldNotNull(out, "out");
        ThrowableUtils.assertFieldNotNull(in, "in");
        try (Writer w = FileWriterBuilder.create(out).build();){
            int n = IOPipe.create(in, w).run();
            return n;
        }
    }

    public static int write(File out, InputStream in) throws IOException {
        ThrowableUtils.assertFieldNotNull(out, "out");
        ThrowableUtils.assertFieldNotNull(in, "in");
        try (FileOutputStream os = new FileOutputStream(out);){
            int n = IOPipe.create(in, os).run();
            return n;
        }
    }

    public static void pipe(Object in, Writer out) throws IOException {
        IOPipe.create(in, out).run();
    }

    public static void pipe(Object in, OutputStream out) throws IOException {
        IOPipe.create(in, out).run();
    }

    public static Reader getBufferedReader(Reader r) {
        if (r == null || r instanceof BufferedReader || r instanceof StringReader) {
            return r;
        }
        return new BufferedReader(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long count(InputStream is) throws IOException {
        ThrowableUtils.assertFieldNotNull(is, "is");
        long c = 0L;
        try {
            long i;
            while ((i = is.skip(1024L)) != 0L) {
                c += i;
            }
        }
        finally {
            is.close();
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long count(Reader r) throws IOException {
        ThrowableUtils.assertFieldNotNull(r, "r");
        long c = 0L;
        try {
            long i;
            while ((i = r.skip(1024L)) != 0L) {
                c += i;
            }
        }
        finally {
            r.close();
        }
        return c;
    }

    public static int getBufferSize(String contentLength) {
        try {
            if (StringUtils.isNotEmpty(contentLength)) {
                long l = Long.decode(contentLength);
                if (l > 0x100000L) {
                    return 0x100000;
                }
                if (l <= 0L) {
                    return 8192;
                }
                return (int)l;
            }
        }
        catch (Exception e) {
            return 8192;
        }
        return 8192;
    }

    public static void closeQuietly(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Reader r) {
        try {
            if (r != null) {
                r.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Writer w) {
        try {
            if (w != null) {
                w.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Object ... o) {
        for (Object o2 : o) {
            if (o2 instanceof InputStream) {
                IOUtils.closeQuietly((InputStream)o2);
            }
            if (o2 instanceof OutputStream) {
                IOUtils.closeQuietly((OutputStream)o2);
            }
            if (o2 instanceof Reader) {
                IOUtils.closeQuietly((Reader)o2);
            }
            if (!(o2 instanceof Writer)) continue;
            IOUtils.closeQuietly((Writer)o2);
        }
    }

    public static void flush(Object ... o) throws IOException {
        IOException ex = null;
        for (Object o2 : o) {
            try {
                if (o2 instanceof OutputStream) {
                    ((OutputStream)o2).flush();
                }
                if (!(o2 instanceof Writer)) continue;
                ((Writer)o2).flush();
            }
            catch (IOException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public static void close(Object ... o) throws IOException {
        IOException ex = null;
        for (Object o2 : o) {
            try {
                if (o2 instanceof InputStream) {
                    ((InputStream)o2).close();
                }
                if (o2 instanceof OutputStream) {
                    ((OutputStream)o2).close();
                }
                if (o2 instanceof Reader) {
                    ((Reader)o2).close();
                }
                if (!(o2 instanceof Writer)) continue;
                ((Writer)o2).close();
            }
            catch (IOException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public static Reader toReader(Object o) throws IOException {
        if (o == null) {
            return null;
        }
        if (o instanceof CharSequence) {
            return new StringReader(o.toString());
        }
        if (o instanceof File) {
            return new FileReader((File)o);
        }
        if (o instanceof Reader) {
            return (Reader)o;
        }
        if (o instanceof InputStream) {
            return new InputStreamReader((InputStream)o, "UTF-8");
        }
        if (o instanceof byte[]) {
            return new InputStreamReader((InputStream)new ByteArrayInputStream((byte[])o), "UTF-8");
        }
        throw new FormattedIllegalArgumentException("Invalid object of type {0} passed to IOUtils.toReader(Object)", o.getClass());
    }

    public static InputStream toInputStream(Object o) throws IOException {
        if (o == null) {
            return null;
        }
        if (o instanceof InputStream) {
            return (InputStream)o;
        }
        if (o instanceof File) {
            return new FileInputStream((File)o);
        }
        if (o instanceof byte[]) {
            return new ByteArrayInputStream((byte[])o);
        }
        if (o instanceof CharSequence) {
            return new ByteArrayInputStream(((CharSequence)o).toString().getBytes(UTF8));
        }
        if (o instanceof Reader) {
            return new ByteArrayInputStream(IOUtils.read((Reader)o).getBytes(UTF8));
        }
        throw new FormattedIllegalArgumentException("Invalid object of type {0} passed to IOUtils.toInputStream(Object)", o.getClass());
    }

    public static void write(String path, String contents) throws IOException {
        IOUtils.write(new File(path), new StringReader(contents));
    }

    public static String loadSystemResourceAsString(String name, String ... paths) throws IOException {
        for (String path : paths) {
            File f;
            File p = new File(path);
            if (!p.exists() || !(f = new File(p, name)).exists() || !f.canRead()) continue;
            return IOUtils.read(f);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        for (String path : paths) {
            String string;
            String n = ".".equals(path) ? name : path + '/' + name;
            try (InputStream is = cl.getResourceAsStream(n);){
                if (is != null) {
                    string = IOUtils.read(is);
                    return string;
                }
            }
            is = ClassLoader.getSystemResourceAsStream(n);
            var9_11 = null;
            try {
                if (is == null) continue;
                string = IOUtils.read(is);
                return string;
            }
            catch (Throwable throwable) {
                var9_11 = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (var9_11 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            var9_11.addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        return null;
    }
}

