/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.json.SimpleJsonSerializer;

public final class CollectionUtils {
    public static <K, V> LinkedHashMap<K, V> reverse(Map<K, V> in) {
        if (in == null) {
            return null;
        }
        LinkedHashMap m = new LinkedHashMap();
        ArrayList<K> keys = new ArrayList<K>(in.keySet());
        ArrayList<V> values = new ArrayList<V>(in.values());
        for (int i = in.size() - 1; i >= 0; --i) {
            m.put(keys.get(i), values.get(i));
        }
        return m;
    }

    public static <T> List<T> addIfNotNull(List<T> l, T o) {
        if (o != null) {
            l.add(o);
        }
        return l;
    }

    public static List<?> addReverse(List list, List append) {
        ListIterator i = append.listIterator(append.size());
        while (i.hasPrevious()) {
            list.add(i.previous());
        }
        return list;
    }

    public static List<?> addReverse(List list, Object[] append) {
        for (int i = append.length - 1; i >= 0; --i) {
            list.add(append[i]);
        }
        return list;
    }

    public static <T> Iterable<T> reverseIterable(final Collection<T> c) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                if (c == null) {
                    return Collections.EMPTY_LIST.iterator();
                }
                ArrayList l = new ArrayList(c);
                Collections.reverse(l);
                return l.iterator();
            }
        };
    }

    public static <T> List<T> reverse(List<T> l) {
        Collections.reverse(l);
        return l;
    }

    public static <T> List<T> reverseCopy(List<T> l) {
        if (l == null || l.isEmpty()) {
            return l;
        }
        ArrayList<T> l2 = new ArrayList<T>(l);
        Collections.reverse(l2);
        return l2;
    }

    public static List<Object> collapse(Object ... o) {
        return CollectionUtils.collapse(new LinkedList<Object>(), o);
    }

    public static List<Object> collapse(List<Object> l, Object ... o) {
        for (Object o2 : o) {
            if (o2 == null) continue;
            if (o2.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(o2); ++i) {
                    CollectionUtils.collapse(l, Array.get(o2, i));
                }
                continue;
            }
            if (o2 instanceof Collection) {
                for (Object o3 : (Collection)o2) {
                    CollectionUtils.collapse(l, o3);
                }
                continue;
            }
            l.add(o2);
        }
        return l;
    }

    public static <T> List<T> immutableList(Collection<T> l) {
        if (l == null || l.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(l));
    }

    public static <T> List<T> unmodifiableList(List<T> l) {
        if (l == null || l.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(l);
    }

    public static <T> List<T> immutableList(T[] l) {
        if (l == null || l.length == 0) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(Arrays.asList(l)));
    }

    public static <K, V> Map<K, V> immutableMap(Map<K, V> m) {
        if (m == null || m.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(new LinkedHashMap<K, V>(m));
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<K, V> m) {
        if (m == null || m.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(m);
    }

    public static void assertTypes(List<Object> l, Class<?> ... c) {
        for (Object o : l) {
            boolean matches = false;
            if (o.getClass() == Class.class) {
                Class o2 = (Class)o;
                for (int i = 0; i < c.length && !matches; ++i) {
                    matches = c[i].isAssignableFrom(o2);
                }
            } else {
                for (int i = 0; i < c.length && !matches; ++i) {
                    matches = c[i].isInstance(o);
                }
            }
            if (matches) continue;
            throw new FormattedRuntimeException("Invalid list entry ''{0}'' ({1}).  Not one of the following types: {2}", CollectionUtils.string(o), CollectionUtils.className(o), c);
        }
    }

    static String string(Object value) {
        return SimpleJsonSerializer.DEFAULT.toString(value);
    }

    static String className(Object value) {
        return value.getClass().getSimpleName();
    }
}

