/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.httppart.bean;

import java.io.OutputStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.Value;
import org.apache.juneau.http.annotation.Body;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.ResponseBody;
import org.apache.juneau.http.annotation.ResponseHeader;
import org.apache.juneau.http.annotation.ResponseStatus;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSchemaBuilder;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.ResponseBeanPropertyMeta;
import org.apache.juneau.httppart.bean.Utils;
import org.apache.juneau.internal.ClassUtils;

public class ResponseBeanMeta {
    public static ResponseBeanMeta NULL = new ResponseBeanMeta(new Builder(PropertyStore.DEFAULT));
    private final ClassMeta<?> cm;
    private final Map<String, ResponseBeanPropertyMeta> properties;
    private final int code;
    private final Map<String, ResponseBeanPropertyMeta> headerMethods;
    private final ResponseBeanPropertyMeta statusMethod;
    private final ResponseBeanPropertyMeta bodyMethod;
    private final HttpPartSerializer partSerializer;
    private final HttpPartParser partParser;
    private final HttpPartSchema schema;

    public static ResponseBeanMeta create(Type t, PropertyStore ps) {
        if (!ClassUtils.hasAnnotation(Response.class, t)) {
            return null;
        }
        Builder b = new Builder(ps);
        if (Value.isType(t)) {
            b.apply(Value.getParameterType(t));
        } else {
            b.apply(t);
        }
        for (Response r : ClassUtils.getAnnotationsParentFirst(Response.class, t)) {
            b.apply(r);
        }
        return b.build();
    }

    public static ResponseBeanMeta create(Method m, PropertyStore ps) {
        if (!ClassUtils.hasAnnotation(Response.class, m)) {
            return null;
        }
        Builder b = new Builder(ps);
        Type t = m.getGenericReturnType();
        if (Value.isType(t)) {
            b.apply(Value.getParameterType(t));
        } else {
            b.apply(t);
        }
        for (Response r : ClassUtils.getAnnotationsParentFirst(Response.class, m)) {
            b.apply(r);
        }
        return b.build();
    }

    public static ResponseBeanMeta create(Method m, int i, PropertyStore ps) {
        if (!ClassUtils.hasAnnotation(Response.class, m, i)) {
            return null;
        }
        Builder b = new Builder(ps);
        Type t = m.getGenericParameterTypes()[i];
        if (Value.isType(t)) {
            b.apply(Value.getParameterType(t));
        } else {
            b.apply(t);
        }
        for (Response r : ClassUtils.getAnnotationsParentFirst(Response.class, m, i)) {
            b.apply(r);
        }
        return b.build();
    }

    ResponseBeanMeta(Builder b) {
        this.cm = b.cm;
        this.code = b.code;
        this.partSerializer = ClassUtils.newInstance(HttpPartSerializer.class, b.partSerializer, true, b.ps);
        this.partParser = ClassUtils.newInstance(HttpPartParser.class, b.partParser, true, b.ps);
        this.schema = b.schema.build();
        LinkedHashMap<String, ResponseBeanPropertyMeta> properties = new LinkedHashMap<String, ResponseBeanPropertyMeta>();
        LinkedHashMap<String, ResponseBeanPropertyMeta> hm = new LinkedHashMap<String, ResponseBeanPropertyMeta>();
        for (Map.Entry<String, ResponseBeanPropertyMeta.Builder> e : b.headerMethods.entrySet()) {
            ResponseBeanPropertyMeta pm = e.getValue().build(this.partSerializer, this.partParser);
            hm.put(e.getKey(), pm);
            properties.put(pm.getGetter().getName(), pm);
        }
        this.headerMethods = Collections.unmodifiableMap(hm);
        this.bodyMethod = b.bodyMethod == null ? null : b.bodyMethod.schema(this.schema).build(this.partSerializer, this.partParser);
        ResponseBeanPropertyMeta responseBeanPropertyMeta = this.statusMethod = b.statusMethod == null ? null : b.statusMethod.build(null, null);
        if (this.bodyMethod != null) {
            properties.put(this.bodyMethod.getGetter().getName(), this.bodyMethod);
        }
        if (this.statusMethod != null) {
            properties.put(this.statusMethod.getGetter().getName(), this.statusMethod);
        }
        this.properties = Collections.unmodifiableMap(properties);
    }

    public int getCode() {
        return this.code;
    }

    public HttpPartSchema getSchema() {
        return this.schema;
    }

    public Collection<ResponseBeanPropertyMeta> getHeaderMethods() {
        return this.headerMethods.values();
    }

    public ResponseBeanPropertyMeta getBodyMethod() {
        return this.bodyMethod;
    }

    public ResponseBeanPropertyMeta getStatusMethod() {
        return this.statusMethod;
    }

    public HttpPartSerializer getPartSerializer() {
        return this.partSerializer;
    }

    public ClassMeta<?> getClassMeta() {
        return this.cm;
    }

    public ResponseBeanPropertyMeta getProperty(String name) {
        return this.properties.get(name);
    }

    public Collection<ResponseBeanPropertyMeta> getProperties() {
        return this.properties.values();
    }

    static class Builder {
        ClassMeta<?> cm;
        int code;
        PropertyStore ps;
        Class<? extends HttpPartSerializer> partSerializer;
        Class<? extends HttpPartParser> partParser;
        HttpPartSchemaBuilder schema = HttpPartSchema.create();
        Map<String, ResponseBeanPropertyMeta.Builder> headerMethods = new LinkedHashMap<String, ResponseBeanPropertyMeta.Builder>();
        ResponseBeanPropertyMeta.Builder bodyMethod;
        ResponseBeanPropertyMeta.Builder statusMethod;

        Builder(PropertyStore ps) {
            this.ps = ps;
        }

        Builder apply(Type t) {
            Class<?> c = ClassUtils.toClass(t);
            this.cm = BeanContext.DEFAULT.getClassMeta(c);
            for (Method m : ClassUtils.getAllMethods(c, false)) {
                if (!ClassUtils.isPublic(m)) continue;
                Utils.assertNoAnnotations(m, Response.class, Body.class, Header.class, Query.class, FormData.class, Path.class);
                if (ClassUtils.hasAnnotation(ResponseHeader.class, m)) {
                    Utils.assertNoArgs(m, ResponseHeader.class);
                    Utils.assertReturnNotVoid(m, ResponseHeader.class);
                    HttpPartSchema s = HttpPartSchema.create(ClassUtils.getAnnotation(ResponseHeader.class, m), Utils.getPropertyName(m));
                    this.headerMethods.put(s.getName(), ResponseBeanPropertyMeta.create(HttpPartType.RESPONSE_HEADER, s, m));
                    continue;
                }
                if (ClassUtils.hasAnnotation(ResponseStatus.class, m)) {
                    Utils.assertNoArgs(m, ResponseHeader.class);
                    Utils.assertReturnType(m, ResponseHeader.class, Integer.TYPE, Integer.class);
                    this.statusMethod = ResponseBeanPropertyMeta.create(HttpPartType.RESPONSE_STATUS, m);
                    continue;
                }
                if (!ClassUtils.hasAnnotation(ResponseBody.class, m)) continue;
                Class<?>[] pt = m.getParameterTypes();
                if (pt.length == 0) {
                    Utils.assertReturnNotVoid(m, ResponseHeader.class);
                } else {
                    Utils.assertArgType(m, ResponseHeader.class, OutputStream.class, Writer.class);
                }
                this.bodyMethod = ResponseBeanPropertyMeta.create(HttpPartType.RESPONSE_BODY, m);
            }
            return this;
        }

        Builder apply(Response a) {
            if (a != null) {
                if (a.partSerializer() != HttpPartSerializer.Null.class) {
                    this.partSerializer = a.partSerializer();
                }
                if (a.partParser() != HttpPartParser.Null.class) {
                    this.partParser = a.partParser();
                }
                if (a.value().length > 0) {
                    this.code = a.value()[0];
                }
                if (a.code().length > 0) {
                    this.code = a.code()[0];
                }
                this.schema.apply((Annotation)a.schema());
            }
            return this;
        }

        ResponseBeanMeta build() {
            return new ResponseBeanMeta(this);
        }
    }
}

