/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.html.HtmlDocSerializer;
import org.apache.juneau.html.HtmlDocTemplate;
import org.apache.juneau.html.HtmlStrippedDocSerializerSession;
import org.apache.juneau.html.HtmlWriter;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSessionArgs;

public class HtmlDocSerializerSession
extends HtmlStrippedDocSerializerSession {
    private final HtmlDocSerializer ctx;
    private final String[] navlinks;
    private final String[] head;
    private final String[] header;
    private final String[] nav;
    private final String[] aside;
    private final String[] footer;
    private final Set<String> style;
    private final Set<String> stylesheet;
    private final Set<String> script;

    protected HtmlDocSerializerSession(HtmlDocSerializer ctx, SerializerSessionArgs args) {
        super(ctx, args);
        this.ctx = ctx;
        this.header = this.getProperty("HtmlDocSerializer.header.ls", String[].class, ctx.getHeader());
        this.nav = this.getProperty("HtmlDocSerializer.nav.ls", String[].class, ctx.getNav());
        this.aside = this.getProperty("HtmlDocSerializer.aside.ls", String[].class, ctx.getAside());
        this.footer = this.getProperty("HtmlDocSerializer.footer.ls", String[].class, ctx.getFooter());
        this.navlinks = this.getProperty("HtmlDocSerializer.navlinks.ls", String[].class, ctx.getNavlinks());
        this.style = new LinkedHashSet<Object>(Arrays.asList((Object[])this.getProperty("HtmlDocSerializer.style.ls", String[].class, ctx.getStyle())));
        this.stylesheet = new LinkedHashSet<Object>(Arrays.asList((Object[])this.getProperty("HtmlDocSerializer.stylesheet.ls", String[].class, ctx.getStylesheet())));
        this.script = new LinkedHashSet<Object>(Arrays.asList((Object[])this.getProperty("HtmlDocSerializer.script.ls", String[].class, ctx.getScript())));
        this.head = this.getProperty("HtmlDocSerializer.head.ls", String[].class, ctx.getHead());
    }

    @Override
    public ObjectMap asMap() {
        return super.asMap().append("HtmlDocSerializerSession", new ObjectMap().append("aside", this.aside).append("head", this.head).append("header", this.header).append("footer", this.footer).append("nav", this.nav).append("navlinks", this.navlinks).append("script", this.script).append("style", this.style).append("stylesheet", this.stylesheet));
    }

    public final String[] getNavLinks() {
        return this.navlinks;
    }

    @Override
    protected void doSerialize(SerializerPipe out, Object o) throws Exception {
        try (HtmlWriter w = this.getHtmlWriter(out);){
            this.getTemplate().writeTo(this, w, o);
        }
    }

    public void parentSerialize(Object out, Object o) throws Exception {
        try (SerializerPipe pipe = this.createPipe(out);){
            super.doSerialize(pipe, o);
        }
    }

    protected final Set<String> getStyle() {
        return this.style;
    }

    protected final Set<String> getStylesheet() {
        return this.stylesheet;
    }

    protected final Set<String> getScript() {
        return this.script;
    }

    protected final String[] getNavlinks() {
        return this.navlinks;
    }

    protected final String[] getHead() {
        return this.head;
    }

    protected final String[] getHeader() {
        return this.header;
    }

    protected final String[] getNav() {
        return this.nav;
    }

    protected final String[] getAside() {
        return this.aside;
    }

    protected final String[] getFooter() {
        return this.footer;
    }

    protected final String getNoResultsMessage() {
        return this.ctx.getNoResultsMessage();
    }

    protected final boolean isNowrap() {
        return this.ctx.isNowrap();
    }

    protected final HtmlDocTemplate getTemplate() {
        return this.ctx.getTemplate();
    }
}

