/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ConfigException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyConverter;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.PropertyType;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.SimpleJsonSerializer;

public class PropertyStoreBuilder {
    private static final Map<Integer, PropertyStore> CACHE = new ConcurrentHashMap<Integer, PropertyStore>();
    static final Map<String, PropertyType> SUFFIX_MAP = new ConcurrentHashMap<String, PropertyType>();
    private final Map<String, PropertyGroupBuilder> groups = new ConcurrentSkipListMap<String, PropertyGroupBuilder>();
    private volatile PropertyStore propertyStore;
    private static final Pattern INDEXED_LINK_PATTERN;

    PropertyStoreBuilder(PropertyStore ps) {
        this.apply(ps);
    }

    PropertyStoreBuilder() {
    }

    public synchronized PropertyStore build() {
        PropertyStore ps;
        if (this.propertyStore == null) {
            this.propertyStore = new PropertyStore(this.groups);
        }
        if ((ps = CACHE.get(this.propertyStore.hashCode())) == null) {
            CACHE.put(this.propertyStore.hashCode(), this.propertyStore);
        } else {
            if (!ps.equals(this.propertyStore)) {
                throw new RuntimeException("Property store mismatch!  This shouldn't happen.");
            }
            this.propertyStore = ps;
        }
        return this.propertyStore;
    }

    public synchronized PropertyStoreBuilder apply(PropertyStore copyFrom) {
        this.propertyStore = null;
        if (copyFrom != null) {
            for (Map.Entry<String, PropertyStore.PropertyGroup> e : copyFrom.groups.entrySet()) {
                String gName = e.getKey();
                PropertyGroupBuilder g1 = this.groups.get(gName);
                PropertyStore.PropertyGroup g2 = e.getValue();
                if (g1 == null) {
                    this.groups.put(gName, g2.builder());
                    continue;
                }
                g1.apply(g2);
            }
        }
        return this;
    }

    public synchronized PropertyStoreBuilder set(String key, Object value) {
        this.propertyStore = null;
        String g = PropertyStoreBuilder.group(key);
        int i = key.indexOf(47);
        if (i != -1) {
            String command = key.substring(i + 1);
            String arg = null;
            String key2 = key.substring(0, i);
            int j = command.indexOf(46);
            if (j != -1) {
                arg = command.substring(j + 1);
                command = command.substring(0, j);
            }
            if ("add".equals(command)) {
                return this.addTo(key2, arg, value);
            }
            if ("remove".equals(command)) {
                if (arg != null) {
                    throw new ConfigException("Invalid key specified: ''{0}''", key);
                }
                return this.removeFrom(key2, value);
            }
            throw new ConfigException("Invalid key specified: ''{0}''", key);
        }
        String n = g.isEmpty() ? key : key.substring(g.length() + 1);
        PropertyGroupBuilder gb = this.groups.get(g);
        if (gb == null) {
            gb = new PropertyGroupBuilder();
            this.groups.put(g, gb);
        }
        gb.set(n, value);
        if (gb.isEmpty()) {
            this.groups.remove(g);
        }
        return this;
    }

    public synchronized PropertyStoreBuilder remove(String key) {
        this.propertyStore = null;
        return this.set(key, null);
    }

    public synchronized PropertyStoreBuilder set(Map<String, Object> newProperties) {
        this.propertyStore = null;
        this.clear();
        this.add(newProperties);
        return this;
    }

    public synchronized PropertyStoreBuilder add(Map<String, Object> newProperties) {
        this.propertyStore = null;
        if (newProperties != null) {
            for (Map.Entry<String, Object> e : newProperties.entrySet()) {
                this.set(e.getKey(), e.getValue());
            }
        }
        return this;
    }

    public synchronized PropertyStoreBuilder addTo(String key, String arg, Object value) {
        this.propertyStore = null;
        String g = PropertyStoreBuilder.group(key);
        String n = g.isEmpty() ? key : key.substring(g.length() + 1);
        PropertyGroupBuilder gb = this.groups.get(g);
        if (gb == null) {
            gb = new PropertyGroupBuilder();
            this.groups.put(g, gb);
        }
        gb.addTo(n, arg, value);
        if (gb.isEmpty()) {
            this.groups.remove(g);
        }
        return this;
    }

    public synchronized PropertyStoreBuilder addTo(String key, Object value) {
        this.propertyStore = null;
        return this.addTo(key, null, value);
    }

    public synchronized PropertyStoreBuilder removeFrom(String key, Object value) {
        this.propertyStore = null;
        String g = PropertyStoreBuilder.group(key);
        String n = g.isEmpty() ? key : key.substring(g.length() + 1);
        PropertyGroupBuilder gb = this.groups.get(g);
        if (gb == null) {
            gb = new PropertyGroupBuilder();
        }
        gb.removeFrom(n, value);
        if (gb.isEmpty()) {
            this.groups.remove(g);
        }
        return this;
    }

    public Object peek(String key) {
        String g = PropertyStoreBuilder.group(key);
        String n = g.isEmpty() ? key : key.substring(g.length() + 1);
        PropertyGroupBuilder gb = this.groups.get(g);
        if (gb == null) {
            return null;
        }
        MutableProperty bp = gb.properties.get(n);
        if (bp == null) {
            return null;
        }
        return bp.peek();
    }

    public synchronized void clear() {
        this.propertyStore = null;
        this.groups.clear();
    }

    static Set<Object> merge(Set<Object> oldSet, PropertyConverter<?> pc, Object o) throws Exception {
        return PropertyStoreBuilder.merge(oldSet, new LinkedHashSet<Object>(), PropertyStoreBuilder.normalize(pc, o));
    }

    private static Set<Object> merge(Set<Object> oldSet, Set<Object> newSet, List<Object> l) {
        for (Object o : l) {
            if (PropertyStoreBuilder.isNone(o)) {
                newSet.clear();
                continue;
            }
            if (PropertyStoreBuilder.isInherit(o)) {
                newSet.addAll(oldSet);
                continue;
            }
            newSet.add(o);
        }
        return newSet;
    }

    static List<Object> merge(List<Object> oldList, PropertyConverter<?> pc, Object o) throws Exception {
        return PropertyStoreBuilder.merge(oldList, new ArrayList<Object>(), PropertyStoreBuilder.normalize(pc, o));
    }

    private static List<Object> merge(List<Object> oldList, List<Object> newList, List<Object> l) {
        for (Object o : l) {
            if (PropertyStoreBuilder.isIndexed(o)) {
                Matcher lm = INDEXED_LINK_PATTERN.matcher(o.toString());
                lm.matches();
                String key = lm.group(1);
                int i2 = Math.min(newList.size(), Integer.parseInt(lm.group(2)));
                String remainder = lm.group(3);
                newList.add(i2, key.isEmpty() ? remainder : key + ":" + remainder);
                continue;
            }
            if (PropertyStoreBuilder.isNone(o)) {
                newList.clear();
                continue;
            }
            if (PropertyStoreBuilder.isInherit(o)) {
                if (oldList == null) continue;
                for (Object o2 : oldList) {
                    newList.add(o2);
                }
                continue;
            }
            newList.remove(o);
            newList.add(o);
        }
        return newList;
    }

    static List<Object> normalize(PropertyConverter<?> pc, Object o) throws Exception {
        return PropertyStoreBuilder.normalize(new ArrayList<Object>(), pc, o);
    }

    static List<Object> normalize(List<Object> l, PropertyConverter<?> pc, Object o) throws Exception {
        if (o != null) {
            if (o.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(o); ++i) {
                    PropertyStoreBuilder.normalize(l, pc, Array.get(o, i));
                }
            } else if (o instanceof Collection) {
                for (Object o2 : (Collection)o) {
                    PropertyStoreBuilder.normalize(l, pc, o2);
                }
            } else if (PropertyStoreBuilder.isObjectList(o)) {
                PropertyStoreBuilder.normalize(l, pc, new ObjectList(o.toString()));
            } else {
                l.add(pc == null ? o : pc.convert(o));
            }
        }
        return l;
    }

    static String string(Object value) {
        return SimpleJsonSerializer.DEFAULT.toString(value);
    }

    static String className(Object value) {
        return value.getClass().getSimpleName();
    }

    static boolean isObjectMap(Object o) {
        if (o instanceof CharSequence) {
            String s = o.toString();
            return s.startsWith("{") && s.endsWith("}") && BeanContext.DEFAULT != null;
        }
        return false;
    }

    private static String group(String key) {
        if (key == null || key.indexOf(46) == -1) {
            return "";
        }
        return key.substring(0, key.indexOf(46));
    }

    static boolean isObjectList(Object o) {
        if (o instanceof CharSequence) {
            String s = o.toString();
            return s.startsWith("[") && s.endsWith("]") && BeanContext.DEFAULT != null;
        }
        return false;
    }

    private static boolean isNone(Object o) {
        if (o instanceof CharSequence) {
            String s = o.toString();
            return "NONE".equals(s);
        }
        return false;
    }

    private static boolean isIndexed(Object o) {
        if (o instanceof CharSequence) {
            String s = o.toString();
            return s.indexOf(91) != -1 && INDEXED_LINK_PATTERN.matcher(s).matches();
        }
        return false;
    }

    private static boolean isInherit(Object o) {
        if (o instanceof CharSequence) {
            String s = o.toString();
            return "INHERIT".equals(s);
        }
        return false;
    }

    static {
        for (PropertyType pt : PropertyType.values()) {
            SUFFIX_MAP.put(pt.getSuffix(), pt);
        }
        INDEXED_LINK_PATTERN = Pattern.compile("(?s)(\\S*)\\[(\\d+)\\]\\:(.*)");
    }

    static class MutableLinkedMapProperty
    extends MutableMapProperty {
        MutableLinkedMapProperty(String name, PropertyType type, Object value) {
            super(name, type, value);
            this.set(value);
        }

        @Override
        protected Map<String, Object> createMap() {
            return Collections.synchronizedMap(new LinkedHashMap());
        }

        @Override
        synchronized PropertyStore.Property build() {
            return new PropertyStore.Property(this.name, Collections.unmodifiableMap(new LinkedHashMap(this.map)), this.type);
        }
    }

    static class MutableMapProperty
    extends MutableProperty {
        protected Map<String, Object> map = this.createMap();

        MutableMapProperty(String name, PropertyType type, Object value) {
            super(name, type);
            this.set(value);
        }

        protected Map<String, Object> createMap() {
            return new ConcurrentHashMap<String, Object>();
        }

        @Override
        synchronized PropertyStore.Property build() {
            return new PropertyStore.Property(this.name, Collections.unmodifiableMap(new TreeMap<String, Object>(this.map)), this.type);
        }

        @Override
        synchronized void set(Object value) {
            this.map.clear();
            this.add(null, value);
        }

        @Override
        synchronized void apply(Object values) {
            for (Map.Entry e : ((Map)values).entrySet()) {
                this.add((String)e.getKey(), e.getValue());
            }
        }

        @Override
        synchronized void add(String arg, Object o) {
            if (arg != null) {
                if ((o = this.convert(o)) == null) {
                    this.map.remove(arg);
                } else {
                    this.map.put(arg, o);
                }
            } else if (o != null) {
                if (o instanceof Map) {
                    Map m = (Map)o;
                    for (Map.Entry e : m.entrySet()) {
                        if (e.getKey() == null) continue;
                        this.add(e.getKey().toString(), e.getValue());
                    }
                } else if (PropertyStoreBuilder.isObjectMap(o)) {
                    try {
                        this.add(null, new ObjectMap(o.toString()));
                    }
                    catch (Exception e) {
                        throw new ConfigException(e, "Cannot add {0} ({1}) to property ''{2}'' ({3}).", new Object[]{PropertyStoreBuilder.string(o), PropertyStoreBuilder.className(o), this.name, this.type});
                    }
                } else {
                    throw new ConfigException("Cannot add {0} ({1}) to property ''{2}'' ({3}).", new Object[]{PropertyStoreBuilder.string(o), PropertyStoreBuilder.className(o), this.name, this.type});
                }
            }
        }

        @Override
        synchronized boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        synchronized Object peek() {
            return this.map;
        }
    }

    static class MutableListProperty
    extends MutableProperty {
        private final List<Object> list = Collections.synchronizedList(new LinkedList());

        MutableListProperty(String name, PropertyType type, Object value) {
            super(name, type);
            this.set(value);
        }

        @Override
        synchronized PropertyStore.Property build() {
            return new PropertyStore.Property(this.name, Collections.unmodifiableList(new ArrayList<Object>(this.list)), this.type);
        }

        @Override
        synchronized void set(Object value) {
            try {
                List<Object> newList = PropertyStoreBuilder.merge(this.list, this.type.converter, value);
                this.list.clear();
                this.list.addAll(newList);
            }
            catch (Exception e) {
                throw new ConfigException(e, "Cannot set value {0} ({1}) on property ''{2}'' ({3}).", new Object[]{PropertyStoreBuilder.string(value), PropertyStoreBuilder.className(value), this.name, this.type});
            }
        }

        @Override
        synchronized void apply(Object values) {
            this.list.addAll((List)values);
        }

        @Override
        synchronized void add(String arg, Object o) {
            int index;
            if (arg != null && !StringUtils.isNumeric(arg)) {
                throw new ConfigException("Invalid argument ''{0}'' on add command for property ''{1}'' ({2})", new Object[]{arg, this.name, this.type});
            }
            int n = index = arg == null ? 0 : Integer.parseInt(arg);
            if (index < 0) {
                index = 0;
            } else if (index > this.list.size()) {
                index = this.list.size();
            }
            try {
                List<Object> l = PropertyStoreBuilder.normalize(this.type.converter, o);
                this.list.removeAll(l);
                this.list.addAll(index, l);
            }
            catch (Exception e) {
                throw new ConfigException(e, "Cannot add value {0} ({1}) to property ''{2}'' ({3}).", new Object[]{PropertyStoreBuilder.string(o), PropertyStoreBuilder.className(o), this.name, this.type});
            }
        }

        @Override
        synchronized void remove(Object o) {
            try {
                this.list.removeAll(PropertyStoreBuilder.normalize(this.type.converter, o));
            }
            catch (Exception e) {
                throw new ConfigException(e, "Cannot remove value {0} ({1}) from property ''{2}'' ({3}).", new Object[]{PropertyStoreBuilder.string(o), PropertyStoreBuilder.className(o), this.name, this.type});
            }
        }

        @Override
        synchronized boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        synchronized Object peek() {
            return this.list;
        }
    }

    static class MutableSetProperty
    extends MutableProperty {
        private final Set<Object> set;

        MutableSetProperty(String name, PropertyType type, Object value) {
            super(name, type);
            this.set = new ConcurrentSkipListSet<Object>(type.comparator());
            this.set(value);
        }

        @Override
        synchronized PropertyStore.Property build() {
            return new PropertyStore.Property(this.name, Collections.unmodifiableSet(new LinkedHashSet<Object>(this.set)), this.type);
        }

        @Override
        synchronized void set(Object value) {
            try {
                Set<Object> newSet = PropertyStoreBuilder.merge(this.set, this.type.converter, value);
                this.set.clear();
                this.set.addAll(newSet);
            }
            catch (Exception e) {
                throw new ConfigException(e, "Cannot set value {0} ({1}) on property ''{2}'' ({3}).", new Object[]{PropertyStoreBuilder.string(value), PropertyStoreBuilder.className(value), this.name, this.type});
            }
        }

        @Override
        synchronized void apply(Object values) {
            this.set.addAll((Set)values);
        }

        @Override
        synchronized void add(String arg, Object o) {
            if (arg != null) {
                throw new ConfigException("Cannot use argument ''{0}'' on add command for property ''{1}'' ({2})", new Object[]{arg, this.name, this.type});
            }
            try {
                this.set.addAll(PropertyStoreBuilder.normalize(this.type.converter, o));
            }
            catch (Exception e) {
                throw new ConfigException(e, "Cannot add value {0} ({1}) to property ''{2}'' ({3}).", new Object[]{PropertyStoreBuilder.string(o), PropertyStoreBuilder.className(o), this.name, this.type});
            }
        }

        @Override
        synchronized void remove(Object o) {
            try {
                this.set.removeAll(PropertyStoreBuilder.normalize(this.type.converter, o));
            }
            catch (Exception e) {
                throw new ConfigException(e, "Cannot remove value {0} ({1}) from property ''{2}'' ({3}).", new Object[]{PropertyStoreBuilder.string(o), PropertyStoreBuilder.className(o), this.name, this.type});
            }
        }

        @Override
        synchronized boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        synchronized Object peek() {
            return this.set;
        }
    }

    static class MutableSimpleProperty
    extends MutableProperty {
        private Object value;

        MutableSimpleProperty(String name, PropertyType type, Object value) {
            super(name, type);
            this.set(value);
        }

        @Override
        synchronized PropertyStore.Property build() {
            return new PropertyStore.Property(this.name, this.value, this.type);
        }

        @Override
        synchronized void set(Object value) {
            this.value = this.convert(value);
        }

        @Override
        synchronized void apply(Object value) {
            this.value = this.convert(value);
        }

        @Override
        synchronized boolean isEmpty() {
            return this.value == null;
        }

        @Override
        synchronized Object peek() {
            return this.value;
        }
    }

    static abstract class MutableProperty {
        final String name;
        final PropertyType type;

        MutableProperty(String name, PropertyType type) {
            this.name = name;
            this.type = type;
        }

        static MutableProperty create(String name, Object value) {
            int i = name.lastIndexOf(46);
            String type = i == -1 ? "s" : name.substring(i + 1);
            PropertyType pt = SUFFIX_MAP.get(type);
            if (pt == null) {
                throw new ConfigException("Invalid type specified on property ''{0}''", name);
            }
            switch (pt) {
                case STRING: 
                case BOOLEAN: 
                case INTEGER: 
                case CLASS: 
                case OBJECT: {
                    return new MutableSimpleProperty(name, pt, value);
                }
                case SET_STRING: 
                case SET_INTEGER: 
                case SET_CLASS: {
                    return new MutableSetProperty(name, pt, value);
                }
                case LIST_STRING: 
                case LIST_INTEGER: 
                case LIST_CLASS: 
                case LIST_OBJECT: {
                    return new MutableListProperty(name, pt, value);
                }
                case SORTED_MAP_STRING: 
                case SORTED_MAP_INTEGER: 
                case SORTED_MAP_CLASS: 
                case SORTED_MAP_OBJECT: {
                    return new MutableMapProperty(name, pt, value);
                }
                case ORDERED_MAP_STRING: 
                case ORDERED_MAP_INTEGER: 
                case ORDERED_MAP_CLASS: 
                case ORDERED_MAP_OBJECT: {
                    return new MutableLinkedMapProperty(name, pt, value);
                }
            }
            return new MutableSimpleProperty(name, PropertyType.STRING, value);
        }

        abstract PropertyStore.Property build();

        abstract boolean isEmpty();

        abstract void set(Object var1);

        abstract void apply(Object var1);

        abstract Object peek();

        void add(String arg, Object value) {
            throw new ConfigException("Cannot add value {0} ({1}) to property ''{2}'' ({3}).", new Object[]{PropertyStoreBuilder.string(value), PropertyStoreBuilder.className(value), this.name, this.type});
        }

        void remove(Object value) {
            throw new ConfigException("Cannot remove value {0} ({1}) from property ''{2}'' ({3}).", new Object[]{PropertyStoreBuilder.string(value), PropertyStoreBuilder.className(value), this.name, this.type});
        }

        Object convert(Object value) {
            return value == null ? null : this.type.converter.convert(value);
        }
    }

    static class PropertyGroupBuilder {
        final Map<String, MutableProperty> properties = new ConcurrentSkipListMap<String, MutableProperty>();

        PropertyGroupBuilder() {
            this(Collections.EMPTY_MAP);
        }

        synchronized void apply(PropertyStore.PropertyGroup copyFrom) {
            for (Map.Entry<String, PropertyStore.Property> e : copyFrom.properties.entrySet()) {
                String pName = e.getKey();
                MutableProperty p1 = this.properties.get(pName);
                PropertyStore.Property p2 = e.getValue();
                if (p1 == null) {
                    this.properties.put(pName, p2.mutable());
                    continue;
                }
                p1.apply(p2.value);
            }
        }

        PropertyGroupBuilder(Map<String, PropertyStore.Property> properties) {
            for (Map.Entry<String, PropertyStore.Property> p : properties.entrySet()) {
                this.properties.put(p.getKey(), p.getValue().mutable());
            }
        }

        synchronized void set(String key, Object value) {
            MutableProperty p = this.properties.get(key);
            if (p == null) {
                p = MutableProperty.create(key, value);
                if (!p.isEmpty()) {
                    this.properties.put(key, p);
                }
            } else {
                p.set(value);
                if (p.isEmpty()) {
                    this.properties.remove(key);
                } else {
                    this.properties.put(key, p);
                }
            }
        }

        synchronized void addTo(String key, String arg, Object value) {
            MutableProperty p = this.properties.get(key);
            if (p == null) {
                p = MutableProperty.create(key, null);
                p.add(arg, value);
                if (!p.isEmpty()) {
                    this.properties.put(key, p);
                }
            } else {
                p.add(arg, value);
                if (p.isEmpty()) {
                    this.properties.remove(key);
                } else {
                    this.properties.put(key, p);
                }
            }
        }

        synchronized void removeFrom(String key, Object value) {
            MutableProperty p = this.properties.get(key);
            if (p == null) {
                p = MutableProperty.create(key, null);
                p.remove(value);
            } else {
                p.remove(value);
                if (p.isEmpty()) {
                    this.properties.remove(key);
                } else {
                    this.properties.put(key, p);
                }
            }
        }

        synchronized boolean isEmpty() {
            return this.properties.isEmpty();
        }

        synchronized PropertyStore.PropertyGroup build() {
            return new PropertyStore.PropertyGroup(this.properties);
        }
    }
}

