/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMetaExtended;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.Visibility;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanConstructor;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.annotation.BeanProperty;
import org.apache.juneau.internal.ClassFlags;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.transform.BeanFilter;
import org.apache.juneau.utils.MetadataMap;

public class BeanMeta<T> {
    protected final ClassMeta<T> classMeta;
    protected final Class<T> c;
    protected final Map<String, BeanPropertyMeta> properties;
    protected final Map<Method, String> getterProps;
    protected final Map<Method, String> setterProps;
    protected final BeanContext ctx;
    protected final BeanFilter beanFilter;
    protected final Map<Class<?>, Class<?>[]> typeVarImpls;
    protected final Constructor<T> constructor;
    protected final String[] constructorArgs;
    private final MetadataMap extMeta;
    final String typePropertyName;
    private final BeanPropertyMeta typeProperty;
    final BeanPropertyMeta dynaProperty;
    private final String dictionaryName;
    final String notABeanReason;
    final BeanRegistry beanRegistry;
    final boolean sortProperties;
    final boolean fluentSetters;

    protected BeanMeta(ClassMeta<T> classMeta, BeanContext ctx, BeanFilter beanFilter, String[] pNames) {
        this.classMeta = classMeta;
        this.ctx = ctx;
        this.c = classMeta.getInnerClass();
        Builder<T> b = new Builder<T>(classMeta, ctx, beanFilter, pNames);
        this.notABeanReason = b.init(this);
        this.beanFilter = beanFilter;
        this.dictionaryName = b.dictionaryName;
        this.properties = CollectionUtils.unmodifiableMap(b.properties);
        this.getterProps = CollectionUtils.unmodifiableMap(b.getterProps);
        this.setterProps = CollectionUtils.unmodifiableMap(b.setterProps);
        this.dynaProperty = b.dynaProperty;
        this.typeVarImpls = CollectionUtils.unmodifiableMap(b.typeVarImpls);
        this.constructor = b.constructor;
        this.constructorArgs = b.constructorArgs;
        this.extMeta = b.extMeta;
        this.beanRegistry = b.beanRegistry;
        this.typePropertyName = b.typePropertyName;
        this.typeProperty = BeanPropertyMeta.builder(this, this.typePropertyName).canRead().canWrite().rawMetaType(ctx.string()).beanRegistry(this.beanRegistry).build();
        this.sortProperties = b.sortProperties;
        this.fluentSetters = b.fluentSetters;
    }

    @BeanIgnore
    public final ClassMeta<T> getClassMeta() {
        return this.classMeta;
    }

    public final String getDictionaryName() {
        return this.dictionaryName;
    }

    public final BeanPropertyMeta getTypeProperty() {
        return this.typeProperty;
    }

    static final List<BeanMethod> findBeanMethods(Class<?> c, Class<?> stopClass, Visibility v, Set<String> fixedBeanProps, Set<String> filterProps, PropertyNamer pn, boolean fluentSetters) {
        LinkedList<BeanMethod> l = new LinkedList<BeanMethod>();
        for (Class<?> c2 : BeanMeta.findClasses(c, stopClass)) {
            for (Method m : c2.getDeclaredMethods()) {
                BeanIgnore bi;
                if (ClassUtils.isStatic(m) || m.isBridge() || (bi = ClassUtils.getAnnotation(BeanIgnore.class, m)) != null) continue;
                BeanProperty bp = ClassUtils.getAnnotation(BeanProperty.class, m);
                if (!v.isVisible(m) && bp == null) continue;
                String n = m.getName();
                Class<?>[] pt = m.getParameterTypes();
                Class<?> rt = m.getReturnType();
                MethodType methodType = MethodType.UNKNOWN;
                String bpName = BeanMeta.bpName(bp);
                if (!(StringUtils.isEmpty(bpName) || filterProps.isEmpty() || filterProps.contains(bpName))) {
                    throw new BeanRuntimeException(c, "Found @BeanProperty(\"{0}\") but name was not found in @Bean(properties)", bpName);
                }
                if (pt.length == 0) {
                    if ("*".equals(bpName)) {
                        if (ClassUtils.isParentClass(Collection.class, rt)) {
                            methodType = MethodType.EXTRAKEYS;
                        } else if (ClassUtils.isParentClass(Map.class, rt)) {
                            methodType = MethodType.GETTER;
                        }
                        n = bpName;
                    } else if (n.startsWith("get") && !rt.equals(Void.TYPE)) {
                        methodType = MethodType.GETTER;
                        n = n.substring(3);
                    } else if (n.startsWith("is") && (rt.equals(Boolean.TYPE) || rt.equals(Boolean.class))) {
                        methodType = MethodType.GETTER;
                        n = n.substring(2);
                    } else if (bpName != null) {
                        methodType = MethodType.GETTER;
                        if (bpName.isEmpty()) {
                            if (n.startsWith("get")) {
                                n = n.substring(3);
                            } else if (n.startsWith("is")) {
                                n = n.substring(2);
                            }
                            bpName = n;
                        } else {
                            n = bpName;
                        }
                    }
                } else if (pt.length == 1) {
                    if ("*".equals(bpName)) {
                        if (ClassUtils.isParentClass(Map.class, pt[0])) {
                            methodType = MethodType.SETTER;
                            n = bpName;
                        } else if (pt[0] == String.class) {
                            methodType = MethodType.GETTER;
                            n = bpName;
                        }
                    } else if (n.startsWith("set") && (ClassUtils.isParentClass(rt, c) || rt.equals(Void.TYPE))) {
                        methodType = MethodType.SETTER;
                        n = n.substring(3);
                    } else if (bpName != null) {
                        methodType = MethodType.SETTER;
                        if (bpName.isEmpty()) {
                            if (n.startsWith("set")) {
                                n = n.substring(3);
                            }
                            bpName = n;
                        } else {
                            n = bpName;
                        }
                    } else if (fluentSetters && ClassUtils.isParentClass(rt, c)) {
                        methodType = MethodType.SETTER;
                    }
                } else if (pt.length == 2 && "*".equals(bpName) && pt[0] == String.class) {
                    methodType = n.startsWith("set") && (ClassUtils.isParentClass(rt, c) || rt.equals(Void.TYPE)) ? MethodType.SETTER : MethodType.GETTER;
                    n = bpName;
                }
                n = pn.getPropertyName(n);
                if ("*".equals(bpName) && methodType == MethodType.UNKNOWN) {
                    throw new BeanRuntimeException(c, "Found @BeanProperty(\"*\") but could not determine method type on method ''{0}''.", m.getName());
                }
                if (methodType == MethodType.UNKNOWN) continue;
                if (bpName != null && !bpName.isEmpty()) {
                    n = bpName;
                    if (!fixedBeanProps.isEmpty() && !fixedBeanProps.contains(n)) {
                        n = null;
                    }
                }
                if (n == null) continue;
                l.add(new BeanMethod(n, methodType, m));
            }
        }
        return l;
    }

    static final Collection<Field> findBeanFields(Class<?> c, Class<?> stopClass, Visibility v, Set<String> filterProps) {
        LinkedList<Field> l = new LinkedList<Field>();
        for (Class<?> c2 : BeanMeta.findClasses(c, stopClass)) {
            for (Field f : c2.getDeclaredFields()) {
                if (ClassUtils.isAny(f, ClassFlags.STATIC, ClassFlags.TRANSIENT) || f.isAnnotationPresent(BeanIgnore.class)) continue;
                BeanProperty bp = f.getAnnotation(BeanProperty.class);
                String bpName = BeanMeta.bpName(bp);
                if (!v.isVisible(f) && bp == null) continue;
                if (!(StringUtils.isEmpty(bpName) || filterProps.isEmpty() || filterProps.contains(bpName))) {
                    throw new BeanRuntimeException(c, "Found @BeanProperty(\"{0}\") but name was not found in @Bean(properties)", bpName);
                }
                l.add(f);
            }
        }
        return l;
    }

    static final Field findInnerBeanField(Class<?> c, Class<?> stopClass, String name) {
        for (Class<?> c2 : BeanMeta.findClasses(c, stopClass)) {
            for (Field f : c2.getDeclaredFields()) {
                if (ClassUtils.isAny(f, ClassFlags.STATIC, ClassFlags.TRANSIENT) || f.isAnnotationPresent(BeanIgnore.class) || !f.getName().equals(name)) continue;
                return f;
            }
        }
        return null;
    }

    private static List<Class<?>> findClasses(Class<?> c, Class<?> stopClass) {
        LinkedList l = new LinkedList();
        BeanMeta.findClasses(c, l, stopClass);
        return l;
    }

    private static void findClasses(Class<?> c, LinkedList<Class<?>> l, Class<?> stopClass) {
        while (c != null && stopClass != c) {
            l.addFirst(c);
            for (Class<?> ci : c.getInterfaces()) {
                BeanMeta.findClasses(ci, l, stopClass);
            }
            c = c.getSuperclass();
        }
    }

    public Collection<BeanPropertyMeta> getPropertyMetas() {
        return this.properties.values();
    }

    public Collection<BeanPropertyMeta> getPropertyMetas(String ... pNames) {
        if (pNames == null) {
            return this.getPropertyMetas();
        }
        ArrayList<BeanPropertyMeta> l = new ArrayList<BeanPropertyMeta>(pNames.length);
        for (int i = 0; i < pNames.length; ++i) {
            l.add(this.getPropertyMeta(pNames[i]));
        }
        return l;
    }

    public <M extends BeanMetaExtended> M getExtendedMeta(Class<M> metaDataClass) {
        return (M)((BeanMetaExtended)this.extMeta.get(metaDataClass, this));
    }

    public BeanPropertyMeta getPropertyMeta(String name) {
        BeanPropertyMeta bpm = this.properties.get(name);
        if (bpm == null) {
            bpm = this.dynaProperty;
        }
        return bpm;
    }

    protected T newBean(Object outer) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.classMeta.isMemberClass()) {
            if (this.constructor != null) {
                return this.constructor.newInstance(outer);
            }
        } else {
            if (this.constructor != null) {
                return this.constructor.newInstance(null);
            }
            InvocationHandler h = this.classMeta.getProxyInvocationHandler();
            if (h != null) {
                ClassLoader cl = this.classMeta.innerClass.getClassLoader();
                return (T)Proxy.newProxyInstance(cl, new Class[]{this.classMeta.innerClass, Serializable.class}, h);
            }
        }
        return null;
    }

    static final void findTypeVarImpls(Type t, Map<Class<?>, Class<?>[]> m) {
        ParameterizedType pt;
        Type rt;
        if (t instanceof Class) {
            Class c = (Class)t;
            BeanMeta.findTypeVarImpls(c.getGenericSuperclass(), m);
            for (Type ci : c.getGenericInterfaces()) {
                BeanMeta.findTypeVarImpls(ci, m);
            }
        } else if (t instanceof ParameterizedType && (rt = (pt = (ParameterizedType)t).getRawType()) instanceof Class) {
            Type[] gImpls = pt.getActualTypeArguments();
            Class[] gTypes = new Class[gImpls.length];
            for (int i = 0; i < gImpls.length; ++i) {
                Type gt = gImpls[i];
                if (gt instanceof Class) {
                    gTypes[i] = (Class)gt;
                    continue;
                }
                if (!(gt instanceof TypeVariable)) continue;
                TypeVariable tv = (TypeVariable)gt;
                for (Type upperBound : tv.getBounds()) {
                    if (!(upperBound instanceof Class)) continue;
                    gTypes[i] = (Class)upperBound;
                }
            }
            m.put((Class)rt, gTypes);
            BeanMeta.findTypeVarImpls(pt.getRawType(), m);
        }
    }

    static final String bpName(BeanProperty bp) {
        if (bp == null) {
            return null;
        }
        if (!bp.name().isEmpty()) {
            return bp.name();
        }
        return bp.value();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.c.getName());
        sb.append(" {\n");
        for (BeanPropertyMeta pm : this.properties.values()) {
            sb.append('\t').append(pm.toString()).append(",\n");
        }
        sb.append('}');
        return sb.toString();
    }

    private static final class BeanMethod {
        String propertyName;
        MethodType methodType;
        Method method;
        Class<?> type;

        BeanMethod(String propertyName, MethodType type, Method method) {
            this.propertyName = propertyName;
            this.methodType = type;
            this.method = method;
            this.type = type == MethodType.SETTER ? method.getParameterTypes()[0] : method.getReturnType();
        }

        boolean matchesPropertyType(BeanPropertyMeta.Builder b) {
            if (b == null) {
                return false;
            }
            if ("*".equals(b.name)) {
                return true;
            }
            Class<?> pt = null;
            if (b.getter != null) {
                pt = b.getter.getReturnType();
            } else if (b.field != null) {
                pt = b.field.getType();
            }
            if (pt == null) {
                return true;
            }
            if (!ClassUtils.isParentClass(this.type, pt)) {
                return false;
            }
            if (b.setter == null) {
                return true;
            }
            Class<?> prevType = b.setter.getParameterTypes()[0];
            return ClassUtils.isParentClass(prevType, this.type, true);
        }

        public String toString() {
            return this.method.toString();
        }
    }

    static enum MethodType {
        UNKNOWN,
        GETTER,
        SETTER,
        EXTRAKEYS;

    }

    private static final class Builder<T> {
        ClassMeta<T> classMeta;
        BeanContext ctx;
        BeanFilter beanFilter;
        String[] pNames;
        Map<String, BeanPropertyMeta> properties;
        Map<Method, String> getterProps = new HashMap<Method, String>();
        Map<Method, String> setterProps = new HashMap<Method, String>();
        BeanPropertyMeta dynaProperty;
        Map<Class<?>, Class<?>[]> typeVarImpls;
        Constructor<T> constructor;
        String[] constructorArgs = new String[0];
        MetadataMap extMeta = new MetadataMap();
        PropertyNamer propertyNamer;
        BeanRegistry beanRegistry;
        String dictionaryName;
        String typePropertyName;
        boolean sortProperties;
        boolean fluentSetters;

        Builder(ClassMeta<T> classMeta, BeanContext ctx, BeanFilter beanFilter, String[] pNames) {
            this.classMeta = classMeta;
            this.ctx = ctx;
            this.beanFilter = beanFilter;
            this.pNames = pNames;
        }

        /*
         * WARNING - void declaration
         */
        String init(BeanMeta<T> beanMeta) {
            Class<T> c = this.classMeta.getInnerClass();
            try {
                Object m;
                Class<Object> stopClass;
                Bean bean;
                Visibility conVis = this.ctx.getBeanConstructorVisibility();
                Visibility cVis = this.ctx.getBeanClassVisibility();
                Visibility mVis = this.ctx.getBeanMethodVisibility();
                Visibility fVis = this.ctx.getBeanFieldVisibility();
                ArrayList bdClasses = new ArrayList();
                if (this.beanFilter != null && this.beanFilter.getBeanDictionary() != null) {
                    bdClasses.addAll(Arrays.asList(this.beanFilter.getBeanDictionary()));
                }
                if ((bean = this.classMeta.innerClass.getAnnotation(Bean.class)) != null && !bean.typeName().isEmpty()) {
                    bdClasses.add(this.classMeta.innerClass);
                }
                this.beanRegistry = new BeanRegistry(this.ctx, null, bdClasses.toArray(new Class[bdClasses.size()]));
                for (Bean b : ClassUtils.getAnnotationsParentFirst(Bean.class, this.classMeta.innerClass)) {
                    if (b.typePropertyName().isEmpty()) continue;
                    this.typePropertyName = b.typePropertyName();
                }
                if (this.typePropertyName == null) {
                    this.typePropertyName = this.ctx.getBeanTypePropertyName();
                }
                this.fluentSetters = this.ctx.isFluentSetters() || this.beanFilter != null && this.beanFilter.isFluentSetters();
                Class<T> c2 = this.beanFilter != null && this.beanFilter.getInterfaceClass() != null ? this.beanFilter.getInterfaceClass() : c;
                Class clazz = stopClass = this.beanFilter != null ? this.beanFilter.getStopClass() : Object.class;
                if (stopClass == null) {
                    stopClass = Object.class;
                }
                LinkedHashMap<String, BeanPropertyMeta.Builder> normalProps = new LinkedHashMap<String, BeanPropertyMeta.Builder>();
                if (this.ctx.isNotABean(c)) {
                    return "Class matches exclude-class list";
                }
                if (!cVis.isVisible(c.getModifiers()) && !c.isAnonymousClass()) {
                    return "Class is not public";
                }
                if (c.isAnnotationPresent(BeanIgnore.class)) {
                    return "Class is annotated with @BeanIgnore";
                }
                if (this.beanFilter == null && this.ctx.isBeansRequireSerializable() && !ClassUtils.isParentClass(Serializable.class, c)) {
                    return "Class is not serializable";
                }
                for (Constructor<?> x : c.getConstructors()) {
                    if (!x.isAnnotationPresent(BeanConstructor.class)) continue;
                    if (this.constructor != null) {
                        throw new BeanRuntimeException(c, "Multiple instances of '@BeanConstructor' found.", new Object[0]);
                    }
                    this.constructor = x;
                    this.constructorArgs = StringUtils.split(x.getAnnotation(BeanConstructor.class).properties());
                    if (this.constructorArgs.length != x.getParameterTypes().length) {
                        throw new BeanRuntimeException(c, "Number of properties defined in '@BeanConstructor' annotation does not match number of parameters in constructor.", new Object[0]);
                    }
                    ClassUtils.setAccessible(this.constructor, false);
                }
                if (this.constructor == null) {
                    this.constructor = this.ctx.getImplClassConstructor(c, conVis);
                }
                if (this.constructor == null) {
                    this.constructor = ClassUtils.findNoArgConstructor(c, conVis);
                }
                if (this.constructor == null && this.beanFilter == null && this.ctx.isBeansRequireDefaultConstructor()) {
                    return "Class does not have the required no-arg constructor";
                }
                ClassUtils.setAccessible(this.constructor, false);
                LinkedHashSet<String> fixedBeanProps = new LinkedHashSet<String>();
                String[] includeProperties = this.ctx.getIncludeProperties(c);
                String[] excludeProperties = this.ctx.getExcludeProperties(c);
                HashSet<String> filterProps = new HashSet<String>();
                if (this.beanFilter != null) {
                    if (this.beanFilter.getProperties() != null) {
                        filterProps.addAll(Arrays.asList(this.beanFilter.getProperties()));
                    }
                    if (this.beanFilter.getProperties() != null && includeProperties == null) {
                        for (String string : this.beanFilter.getProperties()) {
                            fixedBeanProps.add(string);
                        }
                    }
                    if (this.beanFilter.getPropertyNamer() != null) {
                        this.propertyNamer = this.beanFilter.getPropertyNamer();
                    }
                }
                if (includeProperties != null) {
                    fixedBeanProps.addAll(Arrays.asList(includeProperties));
                }
                if (this.propertyNamer == null) {
                    this.propertyNamer = this.ctx.getPropertyNamer();
                }
                for (String string : fixedBeanProps) {
                    normalProps.put(string, BeanPropertyMeta.builder(beanMeta, string));
                }
                if (this.ctx.isUseJavaBeanIntrospector()) {
                    Object bi = null;
                    bi = !c2.isInterface() ? Introspector.getBeanInfo(c2, stopClass) : Introspector.getBeanInfo(c2, null);
                    if (bi != null) {
                        void var19_48;
                        PropertyDescriptor[] propertyDescriptorArray = bi.getPropertyDescriptors();
                        int n = propertyDescriptorArray.length;
                        boolean bl = false;
                        while (var19_48 < n) {
                            PropertyDescriptor pd = propertyDescriptorArray[var19_48];
                            String name = pd.getName();
                            if (!normalProps.containsKey(name)) {
                                normalProps.put(name, BeanPropertyMeta.builder(beanMeta, name));
                            }
                            ((BeanPropertyMeta.Builder)normalProps.get(name)).setGetter(pd.getReadMethod()).setSetter(pd.getWriteMethod());
                            ++var19_48;
                        }
                    }
                } else {
                    for (Field field : BeanMeta.findBeanFields(c2, stopClass, fVis, filterProps)) {
                        String name = this.findPropertyName(field, fixedBeanProps);
                        if (name == null) continue;
                        if (!normalProps.containsKey(name)) {
                            normalProps.put(name, BeanPropertyMeta.builder(beanMeta, name));
                        }
                        ((BeanPropertyMeta.Builder)normalProps.get(name)).setField(field);
                    }
                    List<BeanMethod> bms = BeanMeta.findBeanMethods(c2, stopClass, mVis, fixedBeanProps, filterProps, this.propertyNamer, this.fluentSetters);
                    for (BeanMethod bm : bms) {
                        String string = bm.propertyName;
                        m = bm.method;
                        if (!normalProps.containsKey(string)) {
                            normalProps.put(string, new BeanPropertyMeta.Builder(beanMeta, string));
                        }
                        BeanPropertyMeta.Builder bpm2 = (BeanPropertyMeta.Builder)normalProps.get(string);
                        if (bm.methodType != MethodType.GETTER) continue;
                        if (bpm2.getter != null) {
                            if (((Method)m).getAnnotation(BeanProperty.class) == null && bpm2.getter.getAnnotation(BeanProperty.class) != null) {
                                m = bpm2.getter;
                            } else if (((Method)m).getName().startsWith("is") && bpm2.getter.getName().startsWith("get")) {
                                m = bpm2.getter;
                            }
                        }
                        bpm2.setGetter((Method)m);
                    }
                    for (BeanMethod bm : bms) {
                        BeanPropertyMeta.Builder builder;
                        if (bm.methodType != MethodType.SETTER || !bm.matchesPropertyType(builder = (BeanPropertyMeta.Builder)normalProps.get(bm.propertyName))) continue;
                        builder.setSetter(bm.method);
                    }
                    for (BeanMethod bm : bms) {
                        if (bm.methodType != MethodType.EXTRAKEYS) continue;
                        BeanPropertyMeta.Builder builder = (BeanPropertyMeta.Builder)normalProps.get(bm.propertyName);
                        builder.setExtraKeys(bm.method);
                    }
                }
                this.typeVarImpls = new HashMap();
                BeanMeta.findTypeVarImpls(c, this.typeVarImpls);
                if (this.typeVarImpls.isEmpty()) {
                    this.typeVarImpls = null;
                }
                Iterator<Object> i = normalProps.values().iterator();
                while (i.hasNext()) {
                    BeanPropertyMeta.Builder builder = (BeanPropertyMeta.Builder)i.next();
                    try {
                        if (builder.field == null) {
                            builder.setInnerField(BeanMeta.findInnerBeanField(c, stopClass, builder.name));
                        }
                        if (builder.validate(this.ctx, this.beanRegistry, this.typeVarImpls)) {
                            if (builder.getter != null) {
                                this.getterProps.put(builder.getter, builder.name);
                            }
                            if (builder.setter == null) continue;
                            this.setterProps.put(builder.setter, builder.name);
                            continue;
                        }
                        i.remove();
                    }
                    catch (ClassNotFoundException e) {
                        throw new BeanRuntimeException(c, e.getLocalizedMessage(), new Object[0]);
                    }
                }
                for (String string : fixedBeanProps) {
                    if (normalProps.containsKey(string)) continue;
                    throw new BeanRuntimeException(c, "The property ''{0}'' was defined on the @Bean(properties=X) annotation but was not found on the class definition.", string);
                }
                for (Iterator<Object> iterator : this.constructorArgs) {
                    m = (BeanPropertyMeta.Builder)normalProps.get(iterator);
                    if (m == null) {
                        throw new BeanRuntimeException(c, "The property ''{0}'' was defined on the @BeanConstructor(properties=X) annotation but was not found on the class definition.", iterator);
                    }
                    ((BeanPropertyMeta.Builder)m).setAsConstructorArg();
                }
                if (this.beanFilter == null && this.ctx.isBeansRequireSomeProperties() && normalProps.size() == 0) {
                    return "No properties detected on bean class";
                }
                this.sortProperties = (this.ctx.isSortProperties() || this.beanFilter != null && this.beanFilter.isSortProperties()) && fixedBeanProps.isEmpty();
                this.properties = this.sortProperties ? new TreeMap<String, BeanPropertyMeta>() : new LinkedHashMap<String, BeanPropertyMeta>();
                if (this.beanFilter != null && this.beanFilter.getTypeName() != null) {
                    this.dictionaryName = this.beanFilter.getTypeName();
                }
                if (this.dictionaryName == null) {
                    this.dictionaryName = this.findDictionaryName(this.classMeta);
                }
                for (Map.Entry entry : normalProps.entrySet()) {
                    BeanPropertyMeta pMeta = ((BeanPropertyMeta.Builder)entry.getValue()).build();
                    if (pMeta.isDyna()) {
                        this.dynaProperty = pMeta;
                    }
                    this.properties.put((String)entry.getKey(), pMeta);
                }
                if (this.beanFilter != null) {
                    String[] includeKeys = this.beanFilter.getProperties();
                    String[] stringArray = this.beanFilter.getExcludeProperties();
                    if (stringArray != null && excludeProperties == null) {
                        for (String k : stringArray) {
                            this.properties.remove(k);
                        }
                    } else if (includeKeys != null) {
                        LinkedHashMap<String, BeanPropertyMeta> properties2 = new LinkedHashMap<String, BeanPropertyMeta>();
                        for (String k : includeKeys) {
                            if (!this.properties.containsKey(k)) continue;
                            properties2.put(k, this.properties.get(k));
                        }
                        this.properties = properties2;
                    }
                }
                if (excludeProperties != null) {
                    for (String string : excludeProperties) {
                        this.properties.remove(string);
                    }
                }
                if (this.pNames != null) {
                    void var19_60;
                    LinkedHashMap<String, BeanPropertyMeta> properties2 = new LinkedHashMap<String, BeanPropertyMeta>();
                    String[] stringArray = this.pNames;
                    int n = stringArray.length;
                    boolean bl = false;
                    while (var19_60 < n) {
                        String k = stringArray[var19_60];
                        if (this.properties.containsKey(k)) {
                            properties2.put(k, this.properties.get(k));
                        }
                        ++var19_60;
                    }
                    this.properties = properties2;
                }
            }
            catch (BeanRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                return "Exception:  " + StringUtils.getStackTrace(e);
            }
            return null;
        }

        private String findDictionaryName(ClassMeta<?> cm) {
            String s;
            String s2;
            BeanRegistry br = cm.getBeanRegistry();
            if (br != null && (s2 = br.getTypeName(this.classMeta)) != null) {
                return s2;
            }
            Class pcm = cm.innerClass.getSuperclass();
            if (pcm != null && (s = this.findDictionaryName(this.ctx.getClassMeta(pcm))) != null) {
                return s;
            }
            for (Class<?> icm : cm.innerClass.getInterfaces()) {
                String s3 = this.findDictionaryName(this.ctx.getClassMeta(icm));
                if (s3 == null) continue;
                return s3;
            }
            return null;
        }

        private String findPropertyName(Field f, Set<String> fixedBeanProps) {
            BeanProperty bp = f.getAnnotation(BeanProperty.class);
            String name = BeanMeta.bpName(bp);
            if (StringUtils.isNotEmpty(name)) {
                if (fixedBeanProps.isEmpty() || fixedBeanProps.contains(name)) {
                    return name;
                }
                return null;
            }
            name = this.propertyNamer.getPropertyName(f.getName());
            if (fixedBeanProps.isEmpty() || fixedBeanProps.contains(name)) {
                return name;
            }
            return null;
        }
    }
}

