/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.marshall;

import java.lang.reflect.Type;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;

public abstract class Marshall {
    private final Serializer s;
    private final Parser p;

    protected Marshall(Serializer s, Parser p) {
        this.s = s;
        this.p = p;
    }

    public Object write(Object o) throws SerializeException {
        return this.s.createSession().serialize(o);
    }

    public final void write(Object o, Object output) throws SerializeException {
        this.s.createSession().serialize(o, output);
    }

    public final String toString(Object o) {
        try {
            return this.s.serializeToString(o);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final Marshall println(Object o) {
        System.out.println(this.toString(o));
        return this;
    }

    public final <T> T read(Object input, Type type, Type ... args) throws ParseException {
        return (T)this.p.createSession().parse(input, type, args);
    }

    public final <T> T read(Object input, Class<T> type) throws ParseException {
        return (T)this.p.createSession().parse(input, type);
    }
}

