/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client.remote;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.rest.client.remote.RemoteMethod;
import org.apache.juneau.rest.client.remote.RemoteReturn;

public final class RemoteMethodReturn {
    private final Type returnType;
    private final RemoteReturn returnValue;
    private final ResponseBeanMeta meta;

    RemoteMethodReturn(Method m) {
        RemoteReturn rv;
        RemoteMethod rm = m.getAnnotation(RemoteMethod.class);
        Class<?> rt = m.getReturnType();
        RemoteReturn remoteReturn = rt == Void.TYPE ? RemoteReturn.NONE : (rv = rm == null ? RemoteReturn.BODY : rm.returns());
        if (ClassUtils.hasAnnotation(Response.class, rt) && rt.isInterface()) {
            this.meta = ResponseBeanMeta.create((Method)m, (PropertyStore)PropertyStore.DEFAULT);
            rv = RemoteReturn.BEAN;
        } else {
            this.meta = null;
        }
        this.returnType = m.getGenericReturnType();
        this.returnValue = rv;
    }

    public ResponseBeanMeta getResponseBeanMeta() {
        return this.meta;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public RemoteReturn getReturnValue() {
        return this.returnValue;
    }
}

