/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import org.apache.http.Header;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.NoCloseOutputStream;
import org.apache.juneau.rest.client.RestCallException;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.utils.IOPipe;

public final class RestRequestEntity
extends BasicHttpEntity {
    final Object output;
    final Serializer serializer;
    final HttpPartSchema schema;
    byte[] outputBytes;

    public RestRequestEntity(Object input, Serializer serializer, HttpPartSchema schema) {
        this.output = input;
        this.serializer = serializer;
        this.schema = schema;
        if (serializer != null && serializer.getResponseContentType() != null) {
            this.setContentType((Header)new BasicHeader("Content-Type", serializer.getResponseContentType().toString()));
        }
    }

    public void writeTo(OutputStream os) throws IOException {
        block30: {
            os = new NoCloseOutputStream(os);
            if (this.output instanceof InputStream) {
                IOPipe.create((Object)this.output, (Object)os).run();
            } else {
                if (this.output instanceof Reader) {
                    try (OutputStreamWriter osw = new OutputStreamWriter(os, IOUtils.UTF8);){
                        IOPipe.create((Object)this.output, (Object)osw).run();
                    }
                }
                try {
                    if (this.serializer == null) {
                        os.close();
                        break block30;
                    }
                    SerializerSessionArgs sArgs = new SerializerSessionArgs(null, null, null, null, null, this.schema, Boolean.valueOf(false), null, null);
                    SerializerSession session = this.serializer.createSession(sArgs);
                    try (Closeable c = session.isWriterSerializer() ? new OutputStreamWriter(os, IOUtils.UTF8) : os;){
                        session.serialize(this.output, (Object)c);
                    }
                }
                catch (SerializeException e) {
                    throw new RestCallException((Exception)((Object)e));
                }
            }
        }
    }

    public boolean isRepeatable() {
        return true;
    }

    public InputStream getContent() {
        if (this.outputBytes == null) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                this.writeTo(baos);
                this.outputBytes = baos.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new ByteArrayInputStream(this.outputBytes);
    }
}

