/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanSession;
import org.apache.juneau.BinaryFormat;
import org.apache.juneau.Context;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.Session;
import org.apache.juneau.SessionArgs;
import org.apache.juneau.Writable;
import org.apache.juneau.config.ConfigBuilder;
import org.apache.juneau.config.ConfigMod;
import org.apache.juneau.config.encode.ConfigEncoder;
import org.apache.juneau.config.encode.ConfigXorEncoder;
import org.apache.juneau.config.event.ConfigEventListener;
import org.apache.juneau.config.event.ConfigEvents;
import org.apache.juneau.config.internal.ConfigEntry;
import org.apache.juneau.config.internal.ConfigMap;
import org.apache.juneau.config.store.ConfigClasspathStore;
import org.apache.juneau.config.store.ConfigFileStore;
import org.apache.juneau.config.store.ConfigStore;
import org.apache.juneau.config.vars.ConfigVar;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;

public final class Config
extends Context
implements ConfigEventListener,
Writable {
    private static volatile Config SYSTEM_DEFAULT = Config.findSystemDefault();
    private static final String PREFIX = "Config.";
    public static final String CONFIG_name = "Config.name.s";
    public static final String CONFIG_store = "Config.store.o";
    public static final String CONFIG_serializer = "Config.serializer.o";
    public static final String CONFIG_parser = "Config.parser.o";
    public static final String CONFIG_encoder = "Config.encoder.o";
    public static final String CONFIG_varResolver = "Config.varResolver.o";
    public static final String CONFIG_binaryLineLength = "Config.binaryLineLength.i";
    public static final String CONFIG_binaryFormat = "Config.binaryFormat.s";
    public static final String CONFIG_multiLineValuesOnSeparateLines = "Config.multiLineValuesOnSeparateLines.b";
    public static final String CONFIG_readOnly = "Config.readOnly.b";
    private final String name;
    private final ConfigStore store;
    private final WriterSerializer serializer;
    private final ReaderParser parser;
    private final ConfigEncoder encoder;
    private final VarResolverSession varSession;
    private final int binaryLineLength;
    private final BinaryFormat binaryFormat;
    private final boolean multiLineValuesOnSeparateLines;
    private final boolean readOnly;
    private final ConfigMap configMap;
    private final BeanSession beanSession;
    private final List<ConfigEventListener> listeners = Collections.synchronizedList(new LinkedList());

    public static synchronized void setSystemDefault(Config systemDefault) {
        SYSTEM_DEFAULT = systemDefault;
    }

    public static synchronized Config getSystemDefault() {
        return SYSTEM_DEFAULT;
    }

    private static synchronized Config findSystemDefault() {
        for (String n : Config.getCandidateSystemDefaultConfigNames()) {
            Config config = Config.find(n);
            if (config == null) continue;
            return config;
        }
        return null;
    }

    public static synchronized List<String> getCandidateSystemDefaultConfigNames() {
        ArrayList<String> l = new ArrayList<String>();
        String s = System.getProperty("juneau.configFile");
        if (s != null) {
            l.add(s);
            return l;
        }
        String cmd = System.getProperty("sun.java.command", "not_found").split("\\s+")[0];
        if (cmd.endsWith(".jar") && !cmd.contains("surefirebooter")) {
            cmd = cmd.replaceAll(".*?([^\\\\\\/]+)\\.jar$", "$1");
            l.add(cmd + ".cfg");
            cmd = cmd.replaceAll("[\\.\\_].*$", "");
            l.add(cmd + ".cfg");
        }
        TreeSet<File> files = new TreeSet<File>(Arrays.asList(new File(".").listFiles()));
        for (File f : files) {
            if (!f.getName().endsWith(".cfg")) continue;
            l.add(f.getName());
        }
        l.add("juneau.cfg");
        l.add("default.cfg");
        return l;
    }

    private static synchronized Config find(String name) {
        if (name == null) {
            return null;
        }
        if (ConfigFileStore.DEFAULT.exists(name)) {
            return Config.create(name).store(ConfigFileStore.DEFAULT).build();
        }
        if (ConfigClasspathStore.DEFAULT.exists(name)) {
            return Config.create(name).store(ConfigClasspathStore.DEFAULT).build();
        }
        return null;
    }

    public static ConfigBuilder create() {
        return new ConfigBuilder();
    }

    public static ConfigBuilder create(String name) {
        return new ConfigBuilder().name(name);
    }

    public ConfigBuilder builder() {
        return new ConfigBuilder(this.getPropertyStore());
    }

    public Config(PropertyStore ps) throws IOException {
        super(ps);
        this.name = this.getStringProperty(CONFIG_name, "Configuration.cfg");
        this.store = (ConfigStore)this.getInstanceProperty(CONFIG_store, ConfigStore.class, ConfigFileStore.DEFAULT);
        this.configMap = this.store.getMap(this.name);
        this.configMap.register(this);
        this.serializer = (WriterSerializer)this.getInstanceProperty(CONFIG_serializer, WriterSerializer.class, SimpleJsonSerializer.DEFAULT);
        this.parser = (ReaderParser)this.getInstanceProperty(CONFIG_parser, ReaderParser.class, JsonParser.DEFAULT);
        this.beanSession = this.parser.createBeanSession();
        this.encoder = (ConfigEncoder)this.getInstanceProperty(CONFIG_encoder, ConfigEncoder.class, ConfigXorEncoder.INSTANCE);
        this.varSession = ((VarResolver)this.getInstanceProperty(CONFIG_varResolver, VarResolver.class, VarResolver.DEFAULT)).builder().vars(new Class[]{ConfigVar.class}).contextObject("config", (Object)this).build().createSession();
        this.binaryLineLength = this.getIntegerProperty(CONFIG_binaryLineLength, -1);
        this.binaryFormat = (BinaryFormat)this.getProperty(CONFIG_binaryFormat, BinaryFormat.class, BinaryFormat.BASE64);
        this.multiLineValuesOnSeparateLines = this.getBooleanProperty(CONFIG_multiLineValuesOnSeparateLines, false);
        this.readOnly = this.getBooleanProperty(CONFIG_readOnly, false);
    }

    Config(Config copyFrom, VarResolverSession varSession) {
        super(null);
        this.name = copyFrom.name;
        this.store = copyFrom.store;
        this.configMap = copyFrom.configMap;
        this.configMap.register(this);
        this.serializer = copyFrom.serializer;
        this.parser = copyFrom.parser;
        this.encoder = copyFrom.encoder;
        this.varSession = varSession;
        this.binaryLineLength = copyFrom.binaryLineLength;
        this.binaryFormat = copyFrom.binaryFormat;
        this.multiLineValuesOnSeparateLines = copyFrom.multiLineValuesOnSeparateLines;
        this.readOnly = copyFrom.readOnly;
        this.beanSession = copyFrom.beanSession;
    }

    public Config resolving(VarResolverSession varSession) {
        return new Config(this, varSession);
    }

    public String getName() {
        return this.name;
    }

    public String get(String key) {
        String skey;
        String sname = this.sname(key);
        ConfigEntry ce = this.configMap.getEntry(sname, skey = this.skey(key));
        if (ce == null || ce.getValue() == null) {
            return null;
        }
        String val = ce.getValue();
        for (ConfigMod m : ConfigMod.asModifiersReverse(ce.getModifiers())) {
            if (m != ConfigMod.ENCODED || !this.encoder.isEncoded(val)) continue;
            val = this.encoder.decode(key, val);
        }
        return val;
    }

    public Config set(String key, String value) {
        this.checkWrite();
        ThrowableUtils.assertFieldNotNull((Object)key, (String)"key");
        String sname = this.sname(key);
        String skey = this.skey(key);
        ConfigEntry ce = this.configMap.getEntry(sname, skey);
        if (ce == null && value == null) {
            return this;
        }
        String mod = ce == null ? "" : ce.getModifiers();
        String s = StringUtils.asString((Object)value);
        for (ConfigMod m : ConfigMod.asModifiers(mod)) {
            if (m != ConfigMod.ENCODED) continue;
            s = this.encoder.encode(key, s);
        }
        this.configMap.setEntry(sname, skey, s, null, null, null);
        return this;
    }

    public Config set(String key, Object value) throws SerializeException {
        return this.set(key, value, null);
    }

    public Config set(String key, Object value, Serializer serializer) throws SerializeException {
        return this.set(key, this.serialize(value, serializer));
    }

    public Config set(String key, Object value, Serializer serializer, ConfigMod modifier, String comment, List<String> preLines) throws SerializeException {
        ConfigMod[] configModArray;
        if (modifier == null) {
            configModArray = null;
        } else {
            ConfigMod[] configModArray2 = new ConfigMod[1];
            configModArray = configModArray2;
            configModArray2[0] = modifier;
        }
        return this.set(key, value, serializer, configModArray, comment, preLines);
    }

    public Config set(String key, Object value, Serializer serializer, ConfigMod[] modifiers, String comment, List<String> preLines) throws SerializeException {
        this.checkWrite();
        ThrowableUtils.assertFieldNotNull((Object)key, (String)"key");
        String sname = this.sname(key);
        String skey = this.skey(key);
        String s = this.serialize(value, serializer);
        if (modifiers != null) {
            for (ConfigMod m : modifiers) {
                if (m != ConfigMod.ENCODED) continue;
                s = this.encoder.encode(key, s);
            }
        }
        this.configMap.setEntry(sname, skey, s, modifiers == null ? null : ConfigMod.asString(modifiers), comment, preLines);
        return this;
    }

    public Config remove(String key) {
        this.checkWrite();
        String sname = this.sname(key);
        String skey = this.skey(key);
        this.configMap.removeEntry(sname, skey);
        return this;
    }

    public Config encodeEntries() {
        this.checkWrite();
        for (String section : this.configMap.getSections()) {
            for (String key : this.configMap.getKeys(section)) {
                ConfigEntry ce = this.configMap.getEntry(section, key);
                if (ce == null || !ce.hasModifier('*') || this.encoder.isEncoded(ce.getValue())) continue;
                this.configMap.setEntry(section, key, this.encoder.encode(section + '/' + key, ce.getValue()), null, null, null);
            }
        }
        return this;
    }

    public String getString(String key) {
        String s = this.get(key);
        if (s == null) {
            return null;
        }
        if (this.varSession != null) {
            s = this.varSession.resolve(s);
        }
        return s;
    }

    public String getString(String key, String def) {
        String s = this.get(key);
        if (StringUtils.isEmpty((String)s)) {
            return def;
        }
        if (this.varSession != null) {
            s = this.varSession.resolve(s);
        }
        return s;
    }

    public String[] getStringArray(String key) {
        return this.getStringArray(key, new String[0]);
    }

    public String[] getStringArray(String key, String[] def) {
        String s = this.getString(key);
        if (StringUtils.isEmpty((String)s)) {
            return def;
        }
        String[] r = StringUtils.split((String)s);
        return r.length == 0 ? def : r;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int def) {
        String s = this.getString(key);
        if (StringUtils.isEmpty((String)s)) {
            return def;
        }
        return StringUtils.parseIntWithSuffix((String)s);
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean def) {
        String s = this.getString(key);
        return StringUtils.isEmpty((String)s) ? def : Boolean.parseBoolean(s);
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long def) {
        String s = this.getString(key);
        if (StringUtils.isEmpty((String)s)) {
            return def;
        }
        return StringUtils.parseLongWithSuffix((String)s);
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double def) {
        String s = this.getString(key);
        if (StringUtils.isEmpty((String)s)) {
            return def;
        }
        return Double.valueOf(s);
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float def) {
        String s = this.getString(key);
        if (StringUtils.isEmpty((String)s)) {
            return def;
        }
        return Float.valueOf(s).floatValue();
    }

    public byte[] getBytes(String key) throws ParseException {
        String s = this.get(key);
        if (s == null) {
            return null;
        }
        if (s.isEmpty()) {
            return new byte[0];
        }
        return this.getObject(key, byte[].class);
    }

    public byte[] getBytes(String key, byte[] def) throws ParseException {
        String s = this.get(key);
        if (s == null) {
            return def;
        }
        if (s.isEmpty()) {
            return def;
        }
        return this.getObjectWithDefault(key, def, byte[].class);
    }

    public <T> T getObject(String key, Type type, Type ... args) throws ParseException {
        return this.getObject(key, (Parser)null, type, args);
    }

    public <T> T getObject(String key, Parser parser, Type type, Type ... args) throws ParseException {
        ThrowableUtils.assertFieldNotNull((Object)type, (String)"type");
        return this.parse(this.getString(key), parser, type, args);
    }

    public <T> T getObject(String key, Class<T> type) throws ParseException {
        return this.getObject(key, (Parser)null, type);
    }

    public <T> T getObject(String key, Parser parser, Class<T> type) throws ParseException {
        ThrowableUtils.assertFieldNotNull(type, (String)"c");
        return this.parse(this.getString(key), parser, type, new Type[0]);
    }

    public <T> T getObjectWithDefault(String key, T def, Class<T> type) throws ParseException {
        return this.getObjectWithDefault(key, null, def, type);
    }

    public <T> T getObjectWithDefault(String key, Parser parser, T def, Class<T> type) throws ParseException {
        ThrowableUtils.assertFieldNotNull(type, (String)"c");
        T t = this.parse(this.getString(key), parser, type, new Type[0]);
        return t == null ? def : t;
    }

    public <T> T getObjectWithDefault(String key, T def, Type type, Type ... args) throws ParseException {
        return this.getObjectWithDefault(key, null, def, type, args);
    }

    public <T> T getObjectWithDefault(String key, Parser parser, T def, Type type, Type ... args) throws ParseException {
        ThrowableUtils.assertFieldNotNull((Object)type, (String)"type");
        T t = this.parse(this.getString(key), parser, type, args);
        return t == null ? def : t;
    }

    public ObjectMap getObjectMap(String key) throws ParseException {
        return this.getObject(key, ObjectMap.class);
    }

    public ObjectMap getObjectMap(String key, ObjectMap def) throws ParseException {
        return this.getObjectWithDefault(key, def, ObjectMap.class);
    }

    public ObjectList getObjectList(String key) throws ParseException {
        return this.getObject(key, ObjectList.class);
    }

    public ObjectList getObjectList(String key, ObjectList def) throws ParseException {
        return this.getObjectWithDefault(key, def, ObjectList.class);
    }

    public Set<String> getKeys(String section) {
        return this.configMap.getKeys(this.section(section));
    }

    public Config writeProperties(String section, Object bean, boolean ignoreUnknownProperties) throws ParseException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.checkWrite();
        ThrowableUtils.assertFieldNotNull((Object)bean, (String)"bean");
        section = this.section(section);
        Set<String> keys = this.configMap.getKeys(section);
        if (keys == null) {
            throw new IllegalArgumentException("Section '" + section + "' not found in configuration.");
        }
        BeanMap bm = this.beanSession.toBeanMap(bean);
        for (String k : keys) {
            BeanPropertyMeta bpm = bm.getPropertyMeta(k);
            if (bpm == null) {
                if (ignoreUnknownProperties) continue;
                throw new ParseException("Unknown property ''{0}'' encountered in configuration section ''{1}''.", new Object[]{k, section});
            }
            bm.put(k, this.getObject(section + '/' + k, bpm.getClassMeta().getInnerClass()));
        }
        return this;
    }

    public <T> T getSectionAsBean(String section, Class<T> c) throws ParseException {
        return this.getSectionAsBean(section, c, false);
    }

    public <T> T getSectionAsBean(String section, Class<T> c, boolean ignoreUnknownProperties) throws ParseException {
        ThrowableUtils.assertFieldNotNull(c, (String)"c");
        section = this.section(section);
        if (!this.configMap.hasSection(section)) {
            return null;
        }
        Set<String> keys = this.configMap.getKeys(section);
        BeanMap bm = this.beanSession.newBeanMap(c);
        for (String k : keys) {
            BeanPropertyMeta bpm = bm.getPropertyMeta(k);
            if (bpm == null) {
                if (ignoreUnknownProperties) continue;
                throw new ParseException("Unknown property ''{0}'' encountered in configuration section ''{1}''.", new Object[]{k, section});
            }
            bm.put(k, this.getObject(section + '/' + k, bpm.getClassMeta().getInnerClass()));
        }
        return (T)bm.getBean();
    }

    public ObjectMap getSectionAsMap(String section) throws ParseException {
        if (!this.configMap.hasSection(section = this.section(section))) {
            return null;
        }
        Set<String> keys = this.configMap.getKeys(section);
        ObjectMap om = new ObjectMap();
        for (String k : keys) {
            om.put((Object)k, this.getObject(section + '/' + k, Object.class));
        }
        return om;
    }

    public <T> T getSectionAsInterface(String section, final Class<T> c) {
        ThrowableUtils.assertFieldNotNull(c, (String)"c");
        final String section2 = this.section(section);
        if (!c.isInterface()) {
            throw new IllegalArgumentException("Class '" + c.getName() + "' passed to getSectionAsInterface() is not an interface.");
        }
        InvocationHandler h = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                BeanInfo bi = Introspector.getBeanInfo(c, null);
                for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                    Method rm = pd.getReadMethod();
                    Method wm = pd.getWriteMethod();
                    if (method.equals(rm)) {
                        return Config.this.getObject(section2 + '/' + pd.getName(), rm.getGenericReturnType(), new Type[0]);
                    }
                    if (!method.equals(wm)) continue;
                    return Config.this.set(section2 + '/' + pd.getName(), args[0]);
                }
                throw new UnsupportedOperationException("Unsupported interface method.  method='" + method + "'");
            }
        };
        return (T)Proxy.newProxyInstance(c.getClassLoader(), new Class[]{c}, h);
    }

    public boolean exists(String key) {
        return StringUtils.isNotEmpty((String)this.getString(key, null));
    }

    public Config setSection(String name, List<String> preLines) {
        try {
            return this.setSection(this.section(name), preLines, null);
        }
        catch (SerializeException e) {
            throw new RuntimeException(e);
        }
    }

    public Config setSection(String name, List<String> preLines, Map<String, Object> contents) throws SerializeException {
        this.checkWrite();
        this.configMap.setSection(this.section(name), preLines);
        if (contents != null) {
            for (Map.Entry<String, Object> e : contents.entrySet()) {
                this.set(this.section(name) + '/' + e.getKey(), e.getValue());
            }
        }
        return this;
    }

    public Config removeSection(String name) {
        this.checkWrite();
        this.configMap.removeSection(name);
        return this;
    }

    public Config load(Map<String, Map<String, Object>> m) throws SerializeException {
        if (m != null) {
            for (Map.Entry<String, Map<String, Object>> e : m.entrySet()) {
                this.setSection(e.getKey(), null, e.getValue());
            }
        }
        return this;
    }

    public Config commit() throws IOException {
        this.checkWrite();
        this.configMap.commit();
        return this;
    }

    public Writer writeTo(Writer w) throws IOException {
        return this.configMap.writeTo(w);
    }

    public Config addListener(ConfigEventListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public Config removeListener(ConfigEventListener listener) {
        this.listeners.remove(listener);
        return this;
    }

    public void close() throws IOException {
        this.configMap.unregister(this);
    }

    public Config load(Reader contents, boolean synchronous) throws IOException, InterruptedException {
        this.checkWrite();
        this.configMap.load(IOUtils.read((Reader)contents), synchronous);
        return this;
    }

    public Config load(String contents, boolean synchronous) throws IOException, InterruptedException {
        this.checkWrite();
        this.configMap.load(contents, synchronous);
        return this;
    }

    public Config rollback() {
        this.checkWrite();
        this.configMap.rollback();
        return this;
    }

    public ObjectMap asMap() {
        return this.configMap.asMap();
    }

    public Session createSession(SessionArgs args) {
        throw new UnsupportedOperationException();
    }

    public SessionArgs createDefaultSessionArgs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onConfigChange(ConfigEvents events) {
        for (ConfigEventListener l : this.listeners) {
            l.onConfigChange(events);
        }
    }

    public MediaType getMediaType() {
        return MediaType.PLAIN;
    }

    private String serialize(Object value, Serializer serializer) throws SerializeException {
        if (value == null) {
            return "";
        }
        if (serializer == null) {
            serializer = this.serializer;
        }
        Class<?> c = value.getClass();
        if (value instanceof CharSequence) {
            return this.nlIfMl((CharSequence)value);
        }
        if (this.isSimpleType(c)) {
            return value.toString();
        }
        if (value instanceof byte[]) {
            String s = null;
            byte[] b = (byte[])value;
            s = this.binaryFormat == BinaryFormat.HEX ? StringUtils.toHex((byte[])b) : (this.binaryFormat == BinaryFormat.SPACED_HEX ? StringUtils.toSpacedHex((byte[])b) : StringUtils.base64Encode((byte[])b));
            int l = this.binaryLineLength;
            if (l <= 0 || s.length() <= l) {
                return s;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < s.length(); i += l) {
                sb.append(this.binaryLineLength > 0 ? "\n" : "").append(s.substring(i, Math.min(s.length(), i + l)));
            }
            return sb.toString();
        }
        String r = null;
        r = this.multiLineValuesOnSeparateLines ? "\n" + (String)serializer.serialize(value) : (String)serializer.serialize(value);
        if (r.startsWith("'")) {
            return r.substring(1, r.length() - 1);
        }
        return r;
    }

    private String nlIfMl(CharSequence cs) {
        String s = cs.toString();
        if (s.indexOf(10) != -1 && this.multiLineValuesOnSeparateLines) {
            return "\n" + s;
        }
        return s;
    }

    private <T> T parse(String s, Parser parser, Type type, Type ... args) throws ParseException {
        if (StringUtils.isEmpty((String)s)) {
            return null;
        }
        if (this.isSimpleType(type)) {
            return (T)this.beanSession.convertToType((Object)s, (Class)type);
        }
        if (type == byte[].class) {
            if (s.indexOf(10) != -1) {
                s = s.replaceAll("\n", "");
            }
            try {
                switch (this.binaryFormat) {
                    case HEX: {
                        return (T)StringUtils.fromHex((String)s);
                    }
                    case SPACED_HEX: {
                        return (T)StringUtils.fromSpacedHex((String)s);
                    }
                }
                return (T)StringUtils.base64Decode((String)s);
            }
            catch (Exception e) {
                throw new ParseException((Throwable)e, "Value could not be converted to a byte array.", new Object[0]);
            }
        }
        if (parser == null) {
            parser = this.parser;
        }
        if (parser instanceof JsonParser) {
            char s1 = StringUtils.firstNonWhitespaceChar((String)s);
            if (this.isArray(type) && s1 != '[') {
                s = '[' + s + ']';
            } else if (s1 != '[' && s1 != '{' && !"null".equals(s)) {
                s = '\'' + s + '\'';
            }
        }
        return (T)parser.parse((Object)s, type, args);
    }

    private boolean isSimpleType(Type t) {
        if (!(t instanceof Class)) {
            return false;
        }
        Class c = (Class)t;
        return c == String.class || c.isPrimitive() || c.isAssignableFrom(Number.class) || c == Boolean.class || c.isEnum();
    }

    private boolean isArray(Type t) {
        if (!(t instanceof Class)) {
            return false;
        }
        Class c = (Class)t;
        return c.isArray();
    }

    private String sname(String key) {
        ThrowableUtils.assertFieldNotNull((Object)key, (String)"key");
        int i = key.indexOf(47);
        if (i == -1) {
            return "";
        }
        return key.substring(0, i);
    }

    private String skey(String key) {
        int i = key.indexOf(47);
        if (i == -1) {
            return key;
        }
        return key.substring(i + 1);
    }

    private String section(String section) {
        ThrowableUtils.assertFieldNotNull((Object)section, (String)"section");
        if (StringUtils.isEmpty((String)section)) {
            return "";
        }
        return section;
    }

    private void checkWrite() {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Cannot call this method on a read-only configuration.");
        }
    }

    public String toString() {
        return this.configMap.toString();
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

