/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.util.HashMap;
import java.util.Map;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfCommon;
import org.apache.juneau.jena.RdfParserBuilder;
import org.apache.juneau.jena.RdfParserSession;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.parser.ReaderParserSession;
import org.apache.juneau.xml.Namespace;

public class RdfParser
extends ReaderParser
implements RdfCommon {
    private static final Namespace DEFAULT_JUNEAU_NS = Namespace.create((String)"j", (String)"http://www.apache.org/juneau/");
    private static final Namespace DEFAULT_JUNEAUBP_NS = Namespace.create((String)"jp", (String)"http://www.apache.org/juneaubp/");
    private static final String PREFIX = "RdfParser.";
    public static final String RDF_trimWhitespace = "RdfParser.trimWhitespace.b";
    private final boolean trimWhitespace;
    private final boolean looseCollections;
    private final String rdfLanguage;
    private final Namespace juneauNs;
    private final Namespace juneauBpNs;
    private final RdfCollectionFormat collectionFormat;
    final Map<String, Object> jenaSettings = new HashMap<String, Object>();

    public RdfParser(PropertyStore ps, String ... consumes) {
        super(ps, consumes);
        this.trimWhitespace = this.getBooleanProperty(RDF_trimWhitespace, false);
        this.looseCollections = this.getBooleanProperty("RdfCommon.looseCollections.b", false);
        this.rdfLanguage = this.getStringProperty("RdfCommon.language.s", "RDF/XML-ABBREV");
        this.juneauNs = (Namespace)this.getInstanceProperty("RdfCommon.juneauNs.s", Namespace.class, DEFAULT_JUNEAU_NS);
        this.juneauBpNs = (Namespace)this.getInstanceProperty("RdfCommon.juneauBpNs.s", Namespace.class, DEFAULT_JUNEAUBP_NS);
        this.collectionFormat = (RdfCollectionFormat)((Object)this.getProperty("RdfCommon.collectionFormat.s", RdfCollectionFormat.class, (Object)RdfCollectionFormat.DEFAULT));
    }

    public RdfParser(PropertyStore ps) {
        this(ps, "text/xml+rdf");
    }

    public RdfParserBuilder builder() {
        return new RdfParserBuilder(this.getPropertyStore());
    }

    public static RdfParserBuilder create() {
        return new RdfParserBuilder();
    }

    public ReaderParserSession createSession(ParserSessionArgs args) {
        return new RdfParserSession(this, args);
    }

    protected final boolean isTrimWhitespace() {
        return this.trimWhitespace;
    }

    protected final boolean isLooseCollections() {
        return this.looseCollections;
    }

    protected final String getRdfLanguage() {
        return this.rdfLanguage;
    }

    protected final Namespace getJuneauNs() {
        return this.juneauNs;
    }

    protected final Namespace getJuneauBpNs() {
        return this.juneauBpNs;
    }

    protected final RdfCollectionFormat getCollectionFormat() {
        return this.collectionFormat;
    }

    public ObjectMap asMap() {
        return super.asMap().append("RdfParser", (Object)new ObjectMap().append("trimWhitespace", (Object)this.trimWhitespace).append("looseCollections", (Object)this.looseCollections).append("rdfLanguage", (Object)this.rdfLanguage).append("juneauNs", (Object)this.juneauNs).append("juneauBpNs", (Object)this.juneauBpNs).append("collectionFormat", (Object)this.collectionFormat));
    }
}

