/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanProperty;
import org.apache.juneau.dto.swagger.HeaderInfo;
import org.apache.juneau.dto.swagger.SchemaInfo;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.dto.swagger.SwaggerElement;
import org.apache.juneau.internal.BeanPropertyUtils;
import org.apache.juneau.internal.MultiSet;
import org.apache.juneau.utils.ASet;

@Bean(properties="description,schema,headers,x-example,examples,*")
public class ResponseInfo
extends SwaggerElement {
    private String description;
    private SchemaInfo schema;
    private Map<String, HeaderInfo> headers;
    private Object example;
    private Map<String, Object> examples;

    public ResponseInfo() {
    }

    public ResponseInfo(ResponseInfo copyFrom) {
        super(copyFrom);
        this.description = copyFrom.description;
        SchemaInfo schemaInfo = this.schema = copyFrom.schema == null ? null : copyFrom.schema.copy();
        if (copyFrom.headers == null) {
            this.headers = null;
        } else {
            this.headers = new LinkedHashMap<String, HeaderInfo>();
            for (Map.Entry<String, HeaderInfo> e : copyFrom.headers.entrySet()) {
                this.headers.put(e.getKey(), e.getValue().copy());
            }
        }
        this.example = copyFrom.example;
        this.examples = copyFrom.examples == null ? null : new LinkedHashMap<String, Object>(copyFrom.examples);
    }

    public ResponseInfo copy() {
        return new ResponseInfo(this);
    }

    public ResponseInfo copyFrom(ResponseInfo r) {
        if (r != null) {
            if (r.description != null) {
                this.description = r.description;
            }
            if (r.schema != null) {
                this.schema = r.schema;
            }
            if (r.headers != null) {
                this.headers = r.headers;
            }
            if (r.example != null) {
                this.example = r.example;
            }
            if (r.examples != null) {
                this.examples = r.examples;
            }
        }
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public ResponseInfo setDescription(String value) {
        this.description = value;
        return this;
    }

    public ResponseInfo description(Object value) {
        return this.setDescription(BeanPropertyUtils.toStringVal((Object)value));
    }

    public SchemaInfo getSchema() {
        return this.schema;
    }

    public ResponseInfo setSchema(SchemaInfo value) {
        this.schema = value;
        return this;
    }

    public ResponseInfo schema(Object value) {
        return this.setSchema((SchemaInfo)BeanPropertyUtils.toType((Object)value, SchemaInfo.class, (Type[])new Type[0]));
    }

    public Map<String, HeaderInfo> getHeaders() {
        return this.headers;
    }

    public ResponseInfo setHeaders(Map<String, HeaderInfo> value) {
        this.headers = BeanPropertyUtils.newMap(value);
        return this;
    }

    public ResponseInfo addHeaders(Map<String, HeaderInfo> values) {
        this.headers = BeanPropertyUtils.addToMap(this.headers, values);
        return this;
    }

    public ResponseInfo header(String name, HeaderInfo header) {
        this.addHeaders(Collections.singletonMap(name, header));
        return this;
    }

    public ResponseInfo headers(Object ... values) {
        this.headers = BeanPropertyUtils.addToMap(this.headers, (Object[])values, String.class, HeaderInfo.class, (Type[])new Type[0]);
        return this;
    }

    public HeaderInfo getHeader(String name) {
        return this.getHeaders().get(name);
    }

    @BeanProperty(value="x-example")
    public Object getExample() {
        return this.example;
    }

    @BeanProperty(value="x-example")
    public ResponseInfo setExample(Object value) {
        this.example = value;
        return this;
    }

    public ResponseInfo example(Object value) {
        this.example = value;
        return this;
    }

    public Map<String, Object> getExamples() {
        return this.examples;
    }

    public ResponseInfo setExamples(Map<String, Object> value) {
        this.examples = BeanPropertyUtils.newMap(value);
        return this;
    }

    public ResponseInfo addExamples(Map<String, Object> values) {
        this.examples = BeanPropertyUtils.addToMap(this.examples, values);
        return this;
    }

    public ResponseInfo example(String mimeType, Object example) {
        this.examples = BeanPropertyUtils.addToMap(this.examples, (Object)mimeType, (Object)example);
        return this;
    }

    public ResponseInfo examples(Object ... values) {
        this.examples = BeanPropertyUtils.addToMap(this.examples, (Object[])values, String.class, Object.class, (Type[])new Type[0]);
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "description": {
                return (T)BeanPropertyUtils.toType((Object)this.getDescription(), type, (Type[])new Type[0]);
            }
            case "schema": {
                return (T)BeanPropertyUtils.toType((Object)this.getSchema(), type, (Type[])new Type[0]);
            }
            case "headers": {
                return (T)BeanPropertyUtils.toType(this.getHeaders(), type, (Type[])new Type[0]);
            }
            case "example": {
                return (T)BeanPropertyUtils.toType((Object)this.getExample(), type, (Type[])new Type[0]);
            }
            case "examples": {
                return (T)BeanPropertyUtils.toType(this.getExamples(), type, (Type[])new Type[0]);
            }
        }
        return super.get(property, type);
    }

    @Override
    public ResponseInfo set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "description": {
                return this.description(value);
            }
            case "schema": {
                return this.schema(value);
            }
            case "headers": {
                return this.setHeaders(null).headers(value);
            }
            case "example": {
                return this.setExample(value);
            }
            case "examples": {
                return this.setExamples(null).examples(value);
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        ASet s = new ASet().appendIf(this.description != null, (Object)"description").appendIf(this.schema != null, (Object)"schema").appendIf(this.headers != null, (Object)"headers").appendIf(this.example != null, (Object)"example").appendIf(this.examples != null, (Object)"examples");
        return new MultiSet(new Collection[]{s, super.keySet()});
    }

    public boolean hasHeaders() {
        return this.headers != null && !this.headers.isEmpty();
    }

    public ResponseInfo resolveRefs(Swagger swagger, Deque<String> refStack, int maxDepth) {
        if (this.schema != null) {
            this.schema = this.schema.resolveRefs(swagger, refStack, maxDepth);
        }
        if (this.headers != null) {
            for (Map.Entry<String, HeaderInfo> e : this.headers.entrySet()) {
                e.setValue(e.getValue().resolveRefs(swagger, refStack, maxDepth));
            }
        }
        return this;
    }
}

