/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.uon;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializerSession;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.SerializerWriter;
import org.apache.juneau.serializer.WriterSerializerSession;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.uon.ParamFormat;
import org.apache.juneau.uon.UonSerializer;
import org.apache.juneau.uon.UonUtils;
import org.apache.juneau.uon.UonWriter;

public class UonSerializerSession
extends WriterSerializerSession
implements HttpPartSerializerSession {
    private final UonSerializer ctx;
    private final boolean plainTextParams;

    public UonSerializerSession(UonSerializer ctx, Boolean encode, SerializerSessionArgs args) {
        super(ctx, args);
        this.ctx = ctx;
        this.plainTextParams = ctx.getParamFormat() == ParamFormat.PLAINTEXT;
    }

    @Override
    public ObjectMap asMap() {
        return super.asMap().append("UonSerializerSession", new ObjectMap());
    }

    protected final UonWriter getUonWriter(SerializerPipe out) throws Exception {
        Object output = out.getRawOutput();
        if (output instanceof UonWriter) {
            return (UonWriter)output;
        }
        UonWriter w = new UonWriter(this, out.getWriter(), this.isUseWhitespace(), this.getMaxIndent(), this.isEncodeChars(), this.isTrimStrings(), this.plainTextParams, this.getUriResolver());
        out.setWriter(w);
        return w;
    }

    private final UonWriter getUonWriter(Writer out) throws Exception {
        return new UonWriter(this, out, this.isUseWhitespace(), this.getMaxIndent(), this.isEncodeChars(), this.isTrimStrings(), this.plainTextParams, this.getUriResolver());
    }

    @Override
    protected void doSerialize(SerializerPipe out, Object o) throws Exception {
        this.serializeAnything(this.getUonWriter(out), o, this.getExpectedRootType(o), "root", null);
    }

    protected SerializerWriter serializeAnything(UonWriter out, Object o, ClassMeta<?> eType, String attrName, BeanPropertyMeta pMeta) throws Exception {
        ClassMeta<Object> aType;
        boolean isRecursion;
        if (o == null) {
            out.appendObject(null, false);
            return out;
        }
        if (eType == null) {
            eType = this.object();
        }
        boolean bl = isRecursion = (aType = this.push(attrName, o, eType)) == null;
        if (aType == null) {
            o = null;
            aType = this.object();
        }
        ClassMeta<Object> sType = aType;
        String typeName = this.getBeanTypeName(eType, aType, pMeta);
        PojoSwap<Object, ?> swap = aType.getPojoSwap(this);
        if (swap != null) {
            o = swap.swap(this, o);
            sType = swap.getSwapClassMeta(this);
            if (sType.isObject()) {
                sType = this.getClassMetaForObject(o);
            }
        }
        if (o == null || sType.isChar() && ((Character)o).charValue() == '\u0000') {
            out.appendObject(null, false);
        } else if (sType.isBoolean()) {
            out.appendBoolean(o);
        } else if (sType.isNumber()) {
            out.appendNumber(o);
        } else if (sType.isBean()) {
            this.serializeBeanMap(out, this.toBeanMap(o), typeName);
        } else if (sType.isUri() || pMeta != null && pMeta.isUri()) {
            out.appendUri(o);
        } else if (sType.isMap()) {
            if (o instanceof BeanMap) {
                this.serializeBeanMap(out, (BeanMap)o, typeName);
            } else {
                this.serializeMap(out, (Map)o, eType);
            }
        } else if (sType.isCollection()) {
            this.serializeCollection(out, (Collection)o, eType);
        } else if (sType.isArray()) {
            this.serializeCollection(out, UonSerializerSession.toList(sType.getInnerClass(), o), eType);
        } else if (sType.isReader() || sType.isInputStream()) {
            IOUtils.pipe(o, out);
        } else {
            out.appendObject(o, false);
        }
        if (!isRecursion) {
            this.pop();
        }
        return out;
    }

    private SerializerWriter serializeMap(UonWriter out, Map m, ClassMeta<?> type) throws Exception {
        m = this.sort(m);
        ClassMeta<?> keyType = type.getKeyType();
        ClassMeta<?> valueType = type.getValueType();
        if (!this.plainTextParams) {
            out.append('(');
        }
        Iterator mapEntries = m.entrySet().iterator();
        while (mapEntries.hasNext()) {
            Map.Entry e = mapEntries.next();
            Object value = e.getValue();
            Object key = this.generalize(e.getKey(), keyType);
            out.cr(this.indent).appendObject(key, false).append('=');
            this.serializeAnything(out, value, valueType, this.toString(key), null);
            if (!mapEntries.hasNext()) continue;
            out.append(',');
        }
        if (m.size() > 0) {
            out.cre(this.indent - 1);
        }
        if (!this.plainTextParams) {
            out.append(')');
        }
        return out;
    }

    private SerializerWriter serializeBeanMap(UonWriter out, BeanMap<?> m, String typeName) throws Exception {
        if (!this.plainTextParams) {
            out.append('(');
        }
        boolean addComma = false;
        for (BeanPropertyValue p : m.getValues(this.isTrimNullProperties(), typeName != null ? UonSerializerSession.createBeanTypeNameProperty(m, typeName) : null)) {
            BeanPropertyMeta pMeta = p.getMeta();
            if (!pMeta.canRead()) continue;
            ClassMeta<?> cMeta = p.getClassMeta();
            String key = p.getName();
            Object value = p.getValue();
            Throwable t = p.getThrown();
            if (t != null) {
                this.onBeanGetterException(pMeta, t);
            }
            if (this.canIgnoreValue(cMeta, key, value)) continue;
            if (addComma) {
                out.append(',');
            }
            out.cr(this.indent).appendObject(key, false).append('=');
            this.serializeAnything(out, value, cMeta, key, pMeta);
            addComma = true;
        }
        if (m.size() > 0) {
            out.cre(this.indent - 1);
        }
        if (!this.plainTextParams) {
            out.append(')');
        }
        return out;
    }

    private SerializerWriter serializeCollection(UonWriter out, Collection c, ClassMeta<?> type) throws Exception {
        ClassMeta<?> elementType = type.getElementType();
        c = this.sort(c);
        if (!this.plainTextParams) {
            out.append('@').append('(');
        }
        Iterator i = c.iterator();
        while (i.hasNext()) {
            out.cr(this.indent);
            this.serializeAnything(out, i.next(), elementType, "<iterator>", null);
            if (!i.hasNext()) continue;
            out.append(',');
        }
        if (c.size() > 0) {
            out.cre(this.indent - 1);
        }
        if (!this.plainTextParams) {
            out.append(')');
        }
        return out;
    }

    @Override
    public String serialize(HttpPartType type, HttpPartSchema schema, Object value) throws SerializeException, SchemaValidationException {
        try {
            ClassMeta<Object> cm = this.getClassMetaForObject(value);
            if (cm != null) {
                String s;
                if (cm.isNumber() || cm.isBoolean()) {
                    return ClassUtils.toString(value);
                }
                if (cm.isString() && ((s = ClassUtils.toString(value)).isEmpty() || !UonUtils.needsQuotes(s))) {
                    return s;
                }
            }
            StringWriter w = new StringWriter();
            this.serializeAnything(this.getUonWriter(w), value, this.getExpectedRootType(value), "root", null);
            return w.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String serialize(HttpPartSchema schema, Object value) throws SerializeException, SchemaValidationException {
        return this.serialize(null, schema, value);
    }

    protected final boolean isEncodeChars() {
        return this.ctx.isEncodeChars();
    }

    @Override
    protected final boolean isAddBeanTypes() {
        return this.ctx.isAddBeanTypes();
    }

    protected final ParamFormat getParamFormat() {
        return this.ctx.getParamFormat();
    }
}

