/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.svl;

import java.io.Writer;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.svl.VarResolverSession;

public abstract class Var {
    private final String name;
    final boolean streamed;

    public Var(String name, boolean streamed) {
        this.name = name;
        this.streamed = streamed;
        if (name == null) {
            ThrowableUtils.illegalArg("Invalid var name.  Must consist of only uppercase and lowercase ASCII letters.", new Object[0]);
        } else {
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (c >= 'A' && c <= 'z' && (c <= 'Z' || c >= 'a')) continue;
                ThrowableUtils.illegalArg("Invalid var name.  Must consist of only uppercase and lowercase ASCII letters.", new Object[0]);
            }
        }
    }

    protected String getName() {
        return this.name;
    }

    protected boolean allowNested() {
        return true;
    }

    protected boolean allowRecurse() {
        return true;
    }

    protected String doResolve(VarResolverSession session, String arg) throws Exception {
        return this.resolve(session, arg);
    }

    public abstract String resolve(VarResolverSession var1, String var2) throws Exception;

    public abstract void resolveTo(VarResolverSession var1, Writer var2, String var3) throws Exception;
}

