/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.BeanRecursionException;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.BeanSessionArgs;
import org.apache.juneau.BeanTraverseSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.UriResolver;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerListener;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.transform.PojoSwap;

public abstract class SerializerSession
extends BeanTraverseSession {
    private final Serializer ctx;
    private final UriResolver uriResolver;
    private final Method javaMethod;
    private final boolean useWhitespace;
    private final SerializerListener listener;

    protected SerializerSession(Serializer ctx, SerializerSessionArgs args) {
        super(ctx, (BeanSessionArgs)(args == null ? SerializerSessionArgs.DEFAULT : args));
        this.ctx = ctx;
        args = args == null ? SerializerSessionArgs.DEFAULT : args;
        this.javaMethod = args.javaMethod;
        this.uriResolver = new UriResolver(ctx.getUriResolution(), ctx.getUriRelativity(), args.uriContext == null ? ctx.getUriContext() : args.uriContext);
        this.listener = this.newInstance(SerializerListener.class, ctx.getListener());
        this.useWhitespace = args.useWhitespace != null ? args.useWhitespace.booleanValue() : ctx.isUseWhitespace();
    }

    protected SerializerSession(SerializerSessionArgs args) {
        this(Serializer.DEFAULT, args);
    }

    @Override
    public ObjectMap asMap() {
        return super.asMap().append("SerializerSession", new ObjectMap().append("uriResolver", this.uriResolver));
    }

    protected SerializerPipe createPipe(Object output) {
        return new SerializerPipe(output);
    }

    protected abstract void doSerialize(SerializerPipe var1, Object var2) throws Exception;

    public abstract Object serialize(Object var1) throws SerializeException;

    public abstract String serializeToString(Object var1) throws SerializeException;

    public abstract boolean isWriterSerializer();

    public final void serialize(Object o, Object out) throws SerializeException {
        try (SerializerPipe pipe = this.createPipe(out);){
            this.doSerialize(pipe, o);
        }
        catch (SerializeException e) {
            throw e;
        }
        catch (StackOverflowError e) {
            throw new SerializeException(this, "Stack overflow occurred.  This can occur when trying to serialize models containing loops.  It's recommended you use the BeanTraverseContext.BEANTRAVERSE_detectRecursions setting to help locate the loop.", new Object[0]).initCause(e);
        }
        catch (Exception e) {
            throw new SerializeException(this, e);
        }
        finally {
            this.checkForWarnings();
        }
    }

    protected final Method getJavaMethod() {
        return this.javaMethod;
    }

    protected final UriResolver getUriResolver() {
        return this.uriResolver;
    }

    protected final void onBeanGetterException(BeanPropertyMeta p, Throwable t) {
        if (this.listener != null) {
            this.listener.onBeanGetterException(this, t, p);
        }
        String prefix = this.isDebug() ? this.getStack(false) + ": " : "";
        this.addWarning("{0}Could not call getValue() on property ''{1}'' of class ''{2}'', exception = {3}", prefix, p.getName(), p.getBeanMeta().getClassMeta(), t.getLocalizedMessage());
    }

    @Override
    protected void onError(Throwable t, String msg, Object ... args) {
        if (this.listener != null) {
            this.listener.onError(this, t, StringUtils.format(msg, args));
        }
        super.onError(t, msg, args);
    }

    public final String trim(Object o) {
        if (o == null) {
            return null;
        }
        String s = o.toString();
        if (this.isTrimStrings()) {
            s = s.trim();
        }
        return s;
    }

    protected final Object generalize(Object o, ClassMeta<?> type) throws SerializeException {
        try {
            PojoSwap<?, ?> f;
            if (o == null) {
                return null;
            }
            PojoSwap<?, ?> pojoSwap = f = type == null || type.isObject() ? this.getClassMeta(o.getClass()).getPojoSwap(this) : type.getPojoSwap(this);
            if (f == null) {
                return o;
            }
            return f.swap(this, o);
        }
        catch (SerializeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializeException(e);
        }
    }

    public final boolean canIgnoreValue(ClassMeta<?> cm, String attrName, Object value) throws SerializeException {
        if (this.isTrimNullProperties() && value == null) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (cm == null) {
            cm = this.object();
        }
        if (this.isTrimEmptyCollections()) {
            if ((cm.isArray() || cm.isObject() && value.getClass().isArray()) && ((Object[])value).length == 0) {
                return true;
            }
            if ((cm.isCollection() || cm.isObject() && ClassUtils.isParentClass(Collection.class, value.getClass())) && ((Collection)value).isEmpty()) {
                return true;
            }
        }
        if (this.isTrimEmptyMaps() && (cm.isMap() || cm.isObject() && ClassUtils.isParentClass(Map.class, value.getClass())) && ((Map)value).isEmpty()) {
            return true;
        }
        try {
            if (this.isTrimNullProperties() && this.willRecurse(attrName, value, cm)) {
                return true;
            }
        }
        catch (BeanRecursionException e) {
            throw new SerializeException(e);
        }
        return false;
    }

    public final <K, V> Map<K, V> sort(Map<K, V> m) {
        if (this.isSortMaps() && m != null && !m.isEmpty() && m.keySet().iterator().next() instanceof Comparable) {
            return new TreeMap<K, V>(m);
        }
        return m;
    }

    public final <E> Collection<E> sort(Collection<E> c) {
        if (this.isSortCollections() && c != null && !c.isEmpty() && c.iterator().next() instanceof Comparable) {
            return new TreeSet<E>(c);
        }
        return c;
    }

    protected static final List<Object> toList(Class<?> type, Object array) {
        Class<?> componentType = type.getComponentType();
        if (componentType.isPrimitive()) {
            int l = Array.getLength(array);
            ArrayList<Object> list = new ArrayList<Object>(l);
            for (int i = 0; i < l; ++i) {
                list.add(Array.get(array, i));
            }
            return list;
        }
        return Arrays.asList((Object[])array);
    }

    public final String resolveUri(Object uri) {
        return this.uriResolver.resolve(uri);
    }

    protected final String relativizeUri(Object relativeTo, Object uri) {
        return this.uriResolver.relativize(relativeTo, uri);
    }

    public final String toString(Object o) {
        if (o == null) {
            return null;
        }
        if (o.getClass() == Class.class) {
            return ClassUtils.getReadableClassName((Class)o);
        }
        if (o.getClass().isEnum()) {
            return this.getClassMetaForObject(o).toString(o);
        }
        String s = o.toString();
        if (this.isTrimStrings()) {
            s = s.trim();
        }
        return s;
    }

    protected static final BeanPropertyValue createBeanTypeNameProperty(BeanMap<?> m, String typeName) {
        BeanMeta<?> bm = m.getMeta();
        return new BeanPropertyValue(bm.getTypeProperty(), bm.getTypeProperty().getName(), typeName, null);
    }

    protected final String getBeanTypeName(ClassMeta<?> eType, ClassMeta<?> aType, BeanPropertyMeta pMeta) {
        if (eType == aType) {
            return null;
        }
        if (!this.isAddBeanTypes()) {
            return null;
        }
        String eTypeTn = eType.getDictionaryName();
        String tn = aType.getDictionaryName();
        if (tn != null && !tn.equals(eTypeTn)) {
            return tn;
        }
        BeanRegistry br = eType.getBeanRegistry();
        if (br != null && (tn = br.getTypeName(aType)) != null && !tn.equals(eTypeTn)) {
            return tn;
        }
        BeanRegistry beanRegistry = br = pMeta == null ? null : pMeta.getBeanRegistry();
        if (br != null && (tn = br.getTypeName(aType)) != null && !tn.equals(eTypeTn)) {
            return tn;
        }
        br = this.getBeanRegistry();
        if (br != null && (tn = br.getTypeName(aType)) != null && !tn.equals(eTypeTn)) {
            return tn;
        }
        return null;
    }

    protected final ClassMeta<?> getExpectedRootType(Object o) {
        return this.isAddRootType() ? this.object() : this.getClassMetaForObject(o);
    }

    public Map<String, String> getResponseHeaders() {
        return Collections.emptyMap();
    }

    public SerializerListener getListener() {
        return this.listener;
    }

    public <T extends SerializerListener> T getListener(Class<T> c) {
        return (T)this.listener;
    }

    public final boolean isUseWhitespace() {
        return this.useWhitespace;
    }

    protected boolean isAddBeanTypes() {
        return this.ctx.isAddBeanTypes();
    }

    protected final boolean isTrimNullProperties() {
        return this.ctx.isTrimNullProperties();
    }

    protected final boolean isTrimEmptyCollections() {
        return this.ctx.isTrimEmptyCollections();
    }

    protected final boolean isTrimEmptyMaps() {
        return this.ctx.isTrimEmptyMaps();
    }

    protected boolean isTrimStrings() {
        return this.ctx.isTrimStrings();
    }

    protected final boolean isSortCollections() {
        return this.ctx.isSortCollections();
    }

    protected final boolean isSortMaps() {
        return this.ctx.isSortMaps();
    }

    protected final boolean isAddRootType() {
        return this.ctx.isAddRootType();
    }

    protected final UriContext getUriContext() {
        return this.getUriContext();
    }

    protected final UriResolution getUriResolution() {
        return this.ctx.getUriResolution();
    }

    protected final UriRelativity getUriRelativity() {
        return this.ctx.getUriRelativity();
    }
}

