/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.NoCloseOutputStream;
import org.apache.juneau.internal.NoCloseWriter;
import org.apache.juneau.internal.StringBuilderWriter;

public final class SerializerPipe
implements Closeable {
    private final Object output;
    private final boolean autoClose;
    private OutputStream outputStream;
    private Writer writer;

    SerializerPipe(Object output) {
        this.output = output;
        this.autoClose = output instanceof File;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.output == null) {
            throw new IOException("Output cannot be null.");
        }
        if (this.output instanceof OutputStream) {
            this.outputStream = (OutputStream)this.output;
        } else if (this.output instanceof File) {
            this.outputStream = new BufferedOutputStream(new FileOutputStream((File)this.output));
        } else {
            throw new IOException("Cannot convert object of type " + this.output.getClass().getName() + " to an OutputStream.");
        }
        return new NoCloseOutputStream(this.outputStream);
    }

    public Writer getWriter() throws IOException {
        if (this.output == null) {
            throw new IOException("Output cannot be null.");
        }
        if (this.output instanceof Writer) {
            this.writer = (Writer)this.output;
        } else if (this.output instanceof OutputStream) {
            this.writer = new OutputStreamWriter((OutputStream)this.output, IOUtils.UTF8);
        } else if (this.output instanceof File) {
            this.writer = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream((File)this.output)));
        } else if (this.output instanceof StringBuilder) {
            this.writer = new StringBuilderWriter((StringBuilder)this.output);
        } else {
            throw new IOException("Cannot convert object of type " + this.output.getClass().getName() + " to a Writer.");
        }
        return new NoCloseWriter(this.writer);
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public Object getRawOutput() {
        return this.output;
    }

    @Override
    public void close() {
        try {
            IOUtils.flush(this.writer, this.outputStream);
            if (this.autoClose) {
                IOUtils.close(this.writer, this.outputStream);
            }
        }
        catch (IOException e) {
            throw new BeanRuntimeException(e);
        }
    }
}

