/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.mock;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.rest.BasicRestLogger;
import org.apache.juneau.rest.NoOpRestLogger;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestServlet;
import org.apache.juneau.rest.mock.MockServletRequest;
import org.apache.juneau.utils.MockHttpConnection;

public class MockRest
implements MockHttpConnection {
    private static Map<Class<?>, RestContext> CONTEXTS = new ConcurrentHashMap();
    private final RestContext rc;

    private MockRest(Class<?> c, boolean debug) throws Exception {
        if (!CONTEXTS.containsKey(c)) {
            Object r = c.newInstance();
            RestContext rc = RestContext.create(r).logger(debug ? BasicRestLogger.class : NoOpRestLogger.class).build();
            if (r instanceof RestServlet) {
                ((RestServlet)((Object)r)).setContext(rc);
            } else {
                rc.postInit();
            }
            rc.postInitChildFirst();
            CONTEXTS.put(c, rc);
        }
        this.rc = CONTEXTS.get(c);
    }

    public static MockRest create(Class<?> c) throws RuntimeException {
        return MockRest.create(c, false);
    }

    public static MockRest create(Class<?> c, boolean debug) throws RuntimeException {
        try {
            return new MockRest(c, debug);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MockServletRequest request(String method, String path, Object body) throws Exception {
        return MockServletRequest.create(method, path, new Object[0]).body(body).restContext(this.rc);
    }

    public MockServletRequest request(String method, String path) throws Exception {
        return this.request(method, path, null);
    }

    public MockServletRequest get(String path) throws Exception {
        return this.request("GET", path, null);
    }

    public MockServletRequest put(String path, Object body) throws Exception {
        return this.request("PUT", path, body);
    }

    public MockServletRequest post(String path, Object body) throws Exception {
        return this.request("POST", path, body);
    }

    public MockServletRequest delete(String path) throws Exception {
        return this.request("DELETE", path, null);
    }

    public MockServletRequest options(String path) throws Exception {
        return this.request("OPTIONS", path, null);
    }
}

