/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client.remote;

import java.lang.reflect.Method;
import org.apache.juneau.http.annotation.Body;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.internal.ClassUtils;

public final class RemoteMethodArg {
    private final int index;
    private final HttpPartType partType;
    private final HttpPartSerializer serializer;
    private final HttpPartSchema schema;
    private final String name;
    private final boolean skipIfEmpty;

    RemoteMethodArg(int index, HttpPartType partType, HttpPartSchema schema) {
        this.index = index;
        this.partType = partType;
        this.serializer = RemoteMethodArg.createSerializer(partType, schema);
        this.schema = schema;
        this.name = schema == null ? null : schema.getName();
        this.skipIfEmpty = schema == null ? false : schema.isSkipIfEmpty();
    }

    private static HttpPartSerializer createSerializer(HttpPartType partType, HttpPartSchema schema) {
        if (schema == null) {
            return null;
        }
        return ClassUtils.newInstance(HttpPartSerializer.class, schema.getSerializer());
    }

    public String getName() {
        return this.name;
    }

    public boolean isSkipIfEmpty() {
        return this.skipIfEmpty;
    }

    public int getIndex() {
        return this.index;
    }

    public HttpPartType getPartType() {
        return this.partType;
    }

    public HttpPartSerializer getSerializer(HttpPartSerializer _default) {
        return this.serializer == null ? _default : this.serializer;
    }

    public HttpPartSchema getSchema() {
        return this.schema;
    }

    static RemoteMethodArg create(Method m, int i) {
        if (ClassUtils.hasAnnotation(Header.class, m, i)) {
            return new RemoteMethodArg(i, HttpPartType.HEADER, HttpPartSchema.create(Header.class, m, i));
        }
        if (ClassUtils.hasAnnotation(Query.class, m, i)) {
            return new RemoteMethodArg(i, HttpPartType.QUERY, HttpPartSchema.create(Query.class, m, i));
        }
        if (ClassUtils.hasAnnotation(FormData.class, m, i)) {
            return new RemoteMethodArg(i, HttpPartType.FORMDATA, HttpPartSchema.create(FormData.class, m, i));
        }
        if (ClassUtils.hasAnnotation(Path.class, m, i)) {
            return new RemoteMethodArg(i, HttpPartType.PATH, HttpPartSchema.create(Path.class, m, i));
        }
        if (ClassUtils.hasAnnotation(Body.class, m, i)) {
            return new RemoteMethodArg(i, HttpPartType.BODY, HttpPartSchema.create(Body.class, m, i));
        }
        return null;
    }
}

