/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client.mock;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.utils.MockHttpConnection;
import org.apache.juneau.utils.MockHttpRequest;
import org.apache.juneau.utils.MockHttpResponse;

public class MockHttpClientConnection
implements HttpClientConnection {
    private final MockHttpConnection c;
    private volatile MockHttpRequest req;
    private volatile MockHttpResponse res;

    public MockHttpClientConnection(MockHttpConnection c) {
        this.c = c;
    }

    public void close() throws IOException {
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isStale() {
        return false;
    }

    public void setSocketTimeout(int timeout) {
    }

    public int getSocketTimeout() {
        return Integer.MAX_VALUE;
    }

    public void shutdown() throws IOException {
    }

    public HttpConnectionMetrics getMetrics() {
        return null;
    }

    public boolean isResponseAvailable(int timeout) throws IOException {
        return true;
    }

    public void sendRequestHeader(HttpRequest request) throws HttpException, IOException {
        try {
            RequestLine rl = request.getRequestLine();
            this.req = this.c.request(rl.getMethod(), rl.getUri(), null);
            for (Header h : request.getAllHeaders()) {
                this.req.header(h.getName(), h.getValue());
            }
        }
        catch (Exception e) {
            throw new HttpException(e.getMessage(), (Throwable)e);
        }
    }

    public void sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        this.req.body(request.getEntity() == null ? "" : (Object)IOUtils.readBytes(request.getEntity().getContent(), 1024));
    }

    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        try {
            this.res = this.req.execute();
            BasicHttpResponse response = new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, this.res.getStatus(), this.res.getMessage()));
            for (Map.Entry<String, String[]> e : this.res.getHeaders().entrySet()) {
                for (String hv : e.getValue()) {
                    response.addHeader(e.getKey(), hv);
                }
            }
            return response;
        }
        catch (Exception e) {
            throw new HttpException(e.getMessage(), (Throwable)e);
        }
    }

    public void receiveResponseEntity(HttpResponse response) throws HttpException, IOException {
        BasicHttpEntity e = new BasicHttpEntity();
        e.setContent((InputStream)new ByteArrayInputStream(this.res.getBody()));
        response.setEntity((HttpEntity)e);
    }

    public void flush() throws IOException {
    }
}

