/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.util.Map;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;

public class StaticFileMapping {
    final Class<?> resourceClass;
    final String path;
    final String location;
    final Map<String, Object> responseHeaders;

    public StaticFileMapping(Class<?> resourceClass, String path, String location, Map<String, Object> responseHeaders) {
        this.resourceClass = resourceClass;
        this.path = StringUtils.trimSlashes(path);
        this.location = StringUtils.trimSlashes(location);
        this.responseHeaders = CollectionUtils.immutableMap(responseHeaders);
    }

    public StaticFileMapping(Class<?> resourceClass, String mappingString) {
        this.resourceClass = resourceClass;
        String[] parts = StringUtils.split(mappingString, ':', 3);
        if (parts == null || parts.length <= 1) {
            throw new FormattedRuntimeException("Invalid mapping string format: ''{0}'' on resource class ''{1}''", mappingString, resourceClass.getName());
        }
        this.path = StringUtils.trimSlashes(parts[0]);
        this.location = StringUtils.trimSlashes(parts[1]);
        if (parts.length == 3) {
            try {
                this.responseHeaders = CollectionUtils.unmodifiableMap(new ObjectMap(parts[2]));
            }
            catch (ParseException e) {
                throw new FormattedRuntimeException(e, "Invalid mapping string format: ''{0}'' on resource class ''{1}''", mappingString, resourceClass.getName());
            }
        } else {
            this.responseHeaders = null;
        }
    }
}

