/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.UriResolver;
import org.apache.juneau.config.Config;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.http.HttpMethod;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.MediaTypeRange;
import org.apache.juneau.http.ReaderResource;
import org.apache.juneau.http.StreamResource;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.RequestBeanMeta;
import org.apache.juneau.httppart.bean.RequestBeanPropertyMeta;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.oapi.OpenApiParser;
import org.apache.juneau.oapi.OpenApiSerializer;
import org.apache.juneau.parser.ParserGroup;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.rest.RequestBody;
import org.apache.juneau.rest.RequestFormData;
import org.apache.juneau.rest.RequestHeaders;
import org.apache.juneau.rest.RequestPath;
import org.apache.juneau.rest.RequestProperties;
import org.apache.juneau.rest.RequestQuery;
import org.apache.juneau.rest.ResponsePartMeta;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestInfoProvider;
import org.apache.juneau.rest.RestJavaMethod;
import org.apache.juneau.rest.RestLogger;
import org.apache.juneau.rest.exception.InternalServerError;
import org.apache.juneau.rest.exception.UnsupportedMediaType;
import org.apache.juneau.rest.helper.ResolvingReaderResource;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.rest.widget.Widget;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.uon.UonParser;
import org.apache.juneau.uon.UonSerializer;
import org.apache.juneau.utils.MessageBundle;

public final class RestRequest
extends HttpServletRequestWrapper {
    private final RestContext context;
    private RestJavaMethod restJavaMethod;
    private final String method;
    private RequestBody body;
    private Method javaMethod;
    private RequestProperties properties;
    private final boolean debug;
    private BeanSession beanSession;
    private VarResolverSession varSession;
    private final RequestQuery queryParams;
    private RequestFormData formData;
    private RequestPath pathParams;
    private boolean isPost;
    private UriContext uriContext;
    private String charset;
    private String authorityPath;
    private RequestHeaders headers;
    private Config cf;
    private Swagger swagger;
    private SerializerSessionArgs serializerSessionArgs;
    private ParserSessionArgs parserSessionArgs;

    RestRequest(RestContext context, HttpServletRequest req) throws ServletException {
        super(req);
        this.context = context;
        try {
            String b;
            this.isPost = req.getMethod().equalsIgnoreCase("POST");
            this.queryParams = new RequestQuery(this);
            if (this.isPost) {
                RestUtils.parseQuery(this.getQueryString(), this.queryParams);
            } else {
                this.queryParams.putAll(req.getParameterMap());
            }
            String _method = super.getMethod();
            String m = this.getQuery().getString("method");
            if (context.allowMethodParam(m)) {
                _method = m;
            }
            this.method = _method;
            this.headers = new RequestHeaders(this);
            Enumeration e = this.getHeaderNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                this.headers.put(name, super.getHeaders(name));
            }
            this.body = new RequestBody(this);
            if (context.isAllowBodyParam() && (b = this.getQuery().getString("body")) != null) {
                this.headers.put("Content-Type", UonSerializer.DEFAULT.getResponseContentType());
                this.body.load(MediaType.UON, UonParser.DEFAULT, b.getBytes(IOUtils.UTF8));
            }
            if (context.isAllowHeaderParams()) {
                this.headers.queryParams(this.queryParams);
            }
            this.debug = "true".equals(this.getQuery().getString("debug", "false")) || "true".equals(this.getHeaders().getString("Debug", "false"));
            this.pathParams = new RequestPath(this);
        }
        catch (RestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    final void init(RestJavaMethod rjm, RequestProperties properties) {
        this.restJavaMethod = rjm;
        this.javaMethod = rjm.method;
        this.properties = properties;
        this.beanSession = rjm.beanContext.createSession();
        this.pathParams.parser(rjm.partParser);
        this.queryParams.addDefault(rjm.defaultQuery).parser(rjm.partParser);
        this.headers.addDefault(rjm.defaultRequestHeaders).addDefault(this.context.getDefaultRequestHeaders()).parser(rjm.partParser);
        this.body.encoders(rjm.encoders).parsers(rjm.parsers).headers(this.headers).maxInput(rjm.maxInput);
        String stylesheet = this.getQuery().getString("stylesheet");
        if (stylesheet != null) {
            this.getSession().setAttribute("stylesheet", (Object)stylesheet.replace(' ', '$'));
        }
        if ((stylesheet = (String)this.getSession().getAttribute("stylesheet")) != null) {
            properties.put("HtmlDocSerializer.stylesheet.ls", new String[]{stylesheet});
        }
        if (this.debug) {
            String msg = "\n=== HTTP Request (incoming) ====================================================" + this.toString() + "\n=== END ========================================================================";
            this.context.getLogger().log(Level.WARNING, msg, new Object[0]);
        }
    }

    public String getDescription() {
        String qs = this.getQueryString();
        return "HTTP " + this.getMethod() + " " + this.getRequestURI() + (qs == null ? "" : "?" + qs);
    }

    public Object getAttribute(String name, Object def) {
        Object o = super.getAttribute(name);
        return o == null ? def : o;
    }

    public RestRequest attr(String name, Object value) {
        this.setAttribute(name, value);
        return this;
    }

    public RequestProperties getProperties() {
        return this.properties;
    }

    public RestRequest prop(String name, Object value) {
        this.properties.append(name, value);
        return this;
    }

    public RequestHeaders getHeaders() {
        return this.headers;
    }

    public String getHeader(String name) {
        return this.getHeaders().getString(name);
    }

    public Enumeration<String> getHeaders(String name) {
        String[] v = (String[])this.headers.get(name);
        if (v == null || v.length == 0) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return Collections.enumeration(Arrays.asList(v));
    }

    public List<MediaType> getProduces() {
        return this.restJavaMethod == null ? Collections.emptyList() : this.restJavaMethod.supportedAcceptTypes;
    }

    public List<MediaType> getConsumes() {
        return this.restJavaMethod == null ? Collections.emptyList() : this.restJavaMethod.supportedContentTypes;
    }

    public PropertyStore getPropertyStore() {
        return this.restJavaMethod == null ? PropertyStore.DEFAULT : this.restJavaMethod.propertyStore;
    }

    public void setCharacterEncoding(String charset) {
        this.charset = charset;
    }

    public String getCharacterEncoding() throws UnsupportedMediaType {
        if (this.charset == null) {
            int i;
            String h = this.getHeader("Content-Type");
            if (h != null && (i = h.indexOf(";charset=")) > 0) {
                this.charset = h.substring(i + 9).trim();
            }
            if (this.charset == null && this.restJavaMethod != null) {
                this.charset = this.restJavaMethod.defaultCharset;
            }
            if (this.charset == null) {
                this.charset = "UTF-8";
            }
            if (!Charset.isSupported(this.charset)) {
                throw new UnsupportedMediaType("Unsupported charset in header ''Content-Type'': ''{0}''", h);
            }
        }
        return this.charset;
    }

    public Locale getLocale() {
        MediaTypeRange[] mr;
        String h = this.headers.getString("Accept-Language");
        if (h != null && (mr = MediaTypeRange.parse(h)).length > 0) {
            return RestRequest.toLocale(mr[0].getMediaType().getType());
        }
        return super.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        MediaTypeRange[] mr;
        String h = this.headers.getString("Accept-Language");
        if (h != null && (mr = MediaTypeRange.parse(h)).length > 0) {
            ArrayList<Locale> l = new ArrayList<Locale>(mr.length);
            for (MediaTypeRange r : mr) {
                l.add(RestRequest.toLocale(r.getMediaType().getType()));
            }
            return Collections.enumeration(l);
        }
        return super.getLocales();
    }

    public RequestQuery getQuery() {
        return this.queryParams;
    }

    public String getQuery(String name) {
        return this.getQuery().getString(name);
    }

    public RequestFormData getFormData() throws InternalServerError {
        try {
            if (this.formData == null) {
                this.formData = new RequestFormData(this, this.restJavaMethod == null ? OpenApiParser.DEFAULT : this.restJavaMethod.partParser);
                if (!this.body.isLoaded()) {
                    this.formData.putAll(this.getParameterMap());
                } else {
                    Map<String, String[]> m = RestUtils.parseQuery(this.body.getReader());
                    for (Map.Entry<String, String[]> e : m.entrySet()) {
                        for (String v : e.getValue()) {
                            this.formData.put(e.getKey(), v);
                        }
                    }
                }
            }
            this.formData.addDefault(this.restJavaMethod == null ? null : this.restJavaMethod.defaultFormData);
            return this.formData;
        }
        catch (Exception e) {
            throw new InternalServerError(e);
        }
    }

    public String getFormData(String name) {
        return this.getFormData().getString(name);
    }

    public RequestPath getPathMatch() {
        return this.pathParams;
    }

    public String getPath(String name) {
        return (String)this.getPathMatch().get(name);
    }

    public String getPathRemainder() {
        return this.getPathMatch().getRemainder();
    }

    public RequestBody getBody() {
        return this.body;
    }

    public BufferedReader getReader() throws IOException {
        return this.getBody().getReader();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.getBody().getInputStream();
    }

    ServletInputStream getRawInputStream() throws IOException {
        return super.getInputStream();
    }

    public String getContextPath() {
        String cp = this.context.getUriContext();
        return cp == null ? super.getContextPath() : cp;
    }

    public String getAuthorityPath() {
        if (this.authorityPath == null) {
            this.authorityPath = this.context.getUriAuthority();
        }
        if (this.authorityPath == null) {
            String scheme = this.getScheme();
            int port = this.getServerPort();
            StringBuilder sb = new StringBuilder(this.getScheme()).append("://").append(this.getServerName());
            if (!(port == 80 && "http".equals(scheme) || port == 443 && "https".equals(scheme))) {
                sb.append(':').append(port);
            }
            this.authorityPath = sb.toString();
        }
        return this.authorityPath;
    }

    public String getServletPath() {
        String cp = this.context.getUriContext();
        String sp = super.getServletPath();
        return cp == null || !sp.startsWith(cp) ? sp : sp.substring(cp.length());
    }

    public UriContext getUriContext() {
        if (this.uriContext == null) {
            this.uriContext = new UriContext(this.getAuthorityPath(), this.getContextPath(), this.getServletPath(), StringUtils.urlEncodePath(super.getPathInfo()));
        }
        return this.uriContext;
    }

    public UriResolver getUriResolver(UriResolution resolution, UriRelativity relativity) {
        return new UriResolver(resolution, relativity, this.getUriContext());
    }

    public UriResolver getUriResolver() {
        return new UriResolver(this.context.getUriResolution(), this.context.getUriRelativity(), this.getUriContext());
    }

    public URI getUri(boolean includeQuery, Map<String, ?> addQueryParams) {
        String uri = this.getRequestURI();
        if (includeQuery || addQueryParams != null) {
            StringBuilder sb = new StringBuilder(uri);
            RequestQuery rq = this.queryParams.copy();
            if (addQueryParams != null) {
                for (Map.Entry<String, ?> e : addQueryParams.entrySet()) {
                    rq.put(e.getKey(), e.getValue());
                }
            }
            if (!rq.isEmpty()) {
                sb.append('?').append(rq.toQueryString());
            }
            uri = sb.toString();
        }
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public RestInfoProvider getInfoProvider() {
        return this.context.getInfoProvider();
    }

    public Swagger getSwagger() {
        try {
            if (this.swagger == null) {
                this.swagger = this.context.getInfoProvider().getSwagger(this);
            }
            return this.swagger;
        }
        catch (RestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerError(e);
        }
    }

    public String getSiteName() {
        try {
            return this.context.getInfoProvider().getSiteName(this);
        }
        catch (RestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerError(e);
        }
    }

    public String getResourceTitle() {
        try {
            return this.context.getInfoProvider().getTitle(this);
        }
        catch (RestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerError(e);
        }
    }

    public String getResourceDescription() {
        try {
            return this.context.getInfoProvider().getDescription(this);
        }
        catch (RestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerError(e);
        }
    }

    public String getMethodSummary() {
        try {
            return this.context.getInfoProvider().getMethodSummary(this.javaMethod, this);
        }
        catch (RestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerError(e);
        }
    }

    public String getMethodDescription() throws RestException, InternalServerError {
        try {
            return this.context.getInfoProvider().getMethodDescription(this.javaMethod, this);
        }
        catch (RestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerError(e);
        }
    }

    public SerializerGroup getSerializers() {
        return this.restJavaMethod == null ? SerializerGroup.EMPTY : this.restJavaMethod.serializers;
    }

    public ParserGroup getParsers() {
        return this.restJavaMethod == null ? ParserGroup.EMPTY : this.restJavaMethod.parsers;
    }

    public HttpPartParser getPartParser() {
        return this.restJavaMethod == null ? OpenApiParser.DEFAULT : this.restJavaMethod.partParser;
    }

    public HttpPartSerializer getPartSerializer() {
        return this.restJavaMethod == null ? OpenApiSerializer.DEFAULT : this.restJavaMethod.partSerializer;
    }

    public String getMethod() {
        return this.method;
    }

    public HttpMethod getHttpMethod() {
        return HttpMethod.forString(this.method);
    }

    public int getContentLength() {
        return this.getBody().getContentLength();
    }

    int getRawContentLength() {
        return super.getContentLength();
    }

    public boolean isPlainText() {
        return "true".equals(this.getQuery().getString("plainText", "false"));
    }

    public MessageBundle getMessageBundle() {
        return this.context.getMessages().getBundle(this.getLocale());
    }

    public String getMessage(String key, Object ... args) {
        return this.context.getMessages().getString(this.getLocale(), key, args);
    }

    public RestContext getContext() {
        return this.context;
    }

    public Method getJavaMethod() {
        return this.javaMethod;
    }

    public BeanSession getBeanSession() {
        return this.beanSession;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public VarResolverSession getVarResolverSession() {
        if (this.varSession == null) {
            this.varSession = this.context.getVarResolver().createSession(this.context.getCallHandler().getSessionObjects(this));
        }
        return this.varSession;
    }

    public ReaderResource getClasspathReaderResource(String name, boolean resolveVars, MediaType mediaType, boolean cached) throws IOException {
        String s = this.context.getClasspathResourceAsString(name, this.getLocale());
        if (s == null) {
            return null;
        }
        ResolvingReaderResource.Builder b = ResolvingReaderResource.create().mediaType(mediaType).contents(s);
        if (resolveVars) {
            b.varResolver(this.getVarResolverSession());
        }
        if (cached) {
            b.cached();
        }
        return b.build();
    }

    public ReaderResource getClasspathReaderResource(String name, boolean resolveVars) throws IOException {
        return this.getClasspathReaderResource(name, resolveVars, MediaType.forString(this.context.getMediaTypeForName(name)), false);
    }

    public ReaderResource getClasspathReaderResource(String name) throws IOException {
        return this.getClasspathReaderResource(name, false, MediaType.forString(this.context.getMediaTypeForName(name)), false);
    }

    public StreamResource getClasspathStreamResource(String name, MediaType mediaType, boolean cached) throws IOException {
        InputStream is = this.context.getClasspathResource(name, this.getLocale());
        if (is == null) {
            return null;
        }
        StreamResource.Builder b = StreamResource.create().mediaType(mediaType).contents(is);
        if (cached) {
            b.cached();
        }
        return b.build();
    }

    public StreamResource getClasspathStreamResource(String name) throws IOException {
        return this.getClasspathStreamResource(name, MediaType.forString(this.context.getMediaTypeForName(name)), false);
    }

    public Config getConfig() {
        if (this.cf == null) {
            this.cf = this.context.getConfig().resolving(this.getVarResolverSession());
        }
        return this.cf;
    }

    public Map<String, Widget> getWidgets() {
        return this.restJavaMethod == null ? Collections.emptyMap() : this.restJavaMethod.widgets;
    }

    public <T> T getRequest(Class<T> c) {
        return this.getRequest(RequestBeanMeta.create(c, this.getContext().getPropertyStore()));
    }

    public <T> T getRequest(final RequestBeanMeta rbm) {
        try {
            Class<?> c = rbm.getClassMeta().getInnerClass();
            BeanMeta<?> bm = this.getBeanSession().getBeanMeta(c);
            return (T)Proxy.newProxyInstance(c.getClassLoader(), new Class[]{c}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    RequestBeanPropertyMeta pm = rbm.getProperty(method.getName());
                    if (pm != null) {
                        HttpPartParser pp = pm.getParser(RestRequest.this.getPartParser());
                        HttpPartSchema schema = pm.getSchema();
                        String name = pm.getPartName();
                        ClassMeta type = RestRequest.this.getContext().getBeanContext().getClassMeta(method.getGenericReturnType(), new Type[0]);
                        HttpPartType pt = pm.getPartType();
                        if (pt == HttpPartType.BODY) {
                            return RestRequest.this.getBody().schema(schema).asType(type, new Type[0]);
                        }
                        if (pt == HttpPartType.QUERY) {
                            return RestRequest.this.getQuery().get(pp, schema, name, type, new Type[0]);
                        }
                        if (pt == HttpPartType.FORMDATA) {
                            return RestRequest.this.getFormData().get(pp, schema, name, type, new Type[0]);
                        }
                        if (pt == HttpPartType.HEADER) {
                            return RestRequest.this.getHeaders().get(pp, schema, name, type, new Type[0]);
                        }
                        if (pt == HttpPartType.PATH) {
                            return RestRequest.this.getPathMatch().get(pp, schema, name, type, new Type[0]);
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\n").append(this.getDescription()).append("\n");
        sb.append("---Headers---\n");
        Enumeration e = this.getHeaderNames();
        while (e.hasMoreElements()) {
            String string = (String)e.nextElement();
            sb.append("\t").append(string).append(": ").append(this.getHeader(string)).append("\n");
        }
        sb.append("---Default Servlet Headers---\n");
        for (Map.Entry entry : this.context.getDefaultRequestHeaders().entrySet()) {
            sb.append("\t").append((String)entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        if (this.javaMethod == null) {
            sb.append("***init() not called yet!***\n");
        } else if (this.method.equals("PUT") || this.method.equals("POST")) {
            try {
                sb.append("---Body UTF-8---\n");
                sb.append(this.body.asString()).append("\n");
                sb.append("---Body Hex---\n");
                sb.append(this.body.asSpacedHex()).append("\n");
            }
            catch (Exception e1) {
                sb.append(e1.getLocalizedMessage());
                this.context.getLogger().log(Level.WARNING, e1, "Error occurred while trying to read debug input.", new Object[0]);
            }
        }
        return sb.toString();
    }

    public SerializerSessionArgs getSerializerSessionArgs() {
        if (this.serializerSessionArgs == null) {
            this.serializerSessionArgs = new SerializerSessionArgs(this.getProperties(), this.getJavaMethod(), this.getLocale(), this.getHeaders().getTimeZone(), null, null, this.isDebug() ? Boolean.valueOf(true) : null, this.getUriContext(), this.isPlainText() ? Boolean.valueOf(true) : null);
        }
        return this.serializerSessionArgs;
    }

    public ParserSessionArgs getParserSessionArgs() {
        if (this.parserSessionArgs == null) {
            this.parserSessionArgs = new ParserSessionArgs(this.getProperties(), this.getJavaMethod(), this.getLocale(), this.getHeaders().getTimeZone(), null, null, this.isDebug() ? Boolean.valueOf(true) : null, this.getUriContext());
        }
        return this.parserSessionArgs;
    }

    public RestLogger getLogger() {
        return this.context.getLogger();
    }

    void close() {
        if (this.cf != null) {
            try {
                this.cf.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public ResponseBeanMeta getResponseBeanMeta(Object o) {
        return this.restJavaMethod == null ? null : this.restJavaMethod.getResponseBeanMeta(o);
    }

    public ResponsePartMeta getResponseHeaderMeta(Object o) {
        return this.restJavaMethod == null ? null : this.restJavaMethod.getResponseHeaderMeta(o);
    }

    public ResponsePartMeta getResponseBodyMeta(Object o) {
        return this.restJavaMethod == null ? null : this.restJavaMethod.getResponseBodyMeta(o);
    }

    private static Locale toLocale(String lang) {
        String country = "";
        int i = lang.indexOf(45);
        if (i > -1) {
            country = lang.substring(i + 1).trim();
            lang = lang.substring(0, i).trim();
        }
        return new Locale(lang, country);
    }

    void setJavaMethod(Method method) {
        this.javaMethod = method;
    }
}

