/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanContextBuilder;
import org.apache.juneau.InvalidDataConversionException;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.PropertyStoreBuilder;
import org.apache.juneau.encoders.EncoderGroup;
import org.apache.juneau.encoders.IdentityEncoder;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.ResponseBody;
import org.apache.juneau.http.annotation.ResponseHeader;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.HttpUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.Utils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserBuilder;
import org.apache.juneau.parser.ParserGroup;
import org.apache.juneau.parser.ParserGroupBuilder;
import org.apache.juneau.rest.ClientVersionMatcher;
import org.apache.juneau.rest.HtmlDocBuilder;
import org.apache.juneau.rest.RequestProperties;
import org.apache.juneau.rest.ResponsePartMeta;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestConverter;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestGuard;
import org.apache.juneau.rest.RestMatcher;
import org.apache.juneau.rest.RestMethodParam;
import org.apache.juneau.rest.RestMethodProperties;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestServletException;
import org.apache.juneau.rest.annotation.HtmlDoc;
import org.apache.juneau.rest.annotation.Property;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.exception.BadRequest;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.rest.util.UrlPathPattern;
import org.apache.juneau.rest.widget.Widget;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.serializer.SerializerGroupBuilder;
import org.apache.juneau.svl.VarResolver;

public class RestJavaMethod
implements Comparable<RestJavaMethod> {
    private final String httpMethod;
    private final UrlPathPattern pathPattern;
    final RestMethodParam[] methodParams;
    private final RestGuard[] guards;
    private final RestMatcher[] optionalMatchers;
    private final RestMatcher[] requiredMatchers;
    private final RestConverter[] converters;
    private final RestMethodProperties properties;
    private final Integer priority;
    private final RestContext context;
    final Method method;
    final PropertyStore propertyStore;
    final SerializerGroup serializers;
    final ParserGroup parsers;
    final EncoderGroup encoders;
    final HttpPartSerializer partSerializer;
    final HttpPartParser partParser;
    final Map<String, Object> defaultRequestHeaders;
    final Map<String, Object> defaultQuery;
    final Map<String, Object> defaultFormData;
    final String defaultCharset;
    final long maxInput;
    final BeanContext beanContext;
    final Map<String, Widget> widgets;
    final List<MediaType> supportedAcceptTypes;
    final List<MediaType> supportedContentTypes;
    final Map<Class<?>, ResponseBeanMeta> responseBeanMetas = new ConcurrentHashMap();
    final Map<Class<?>, ResponsePartMeta> headerPartMetas = new ConcurrentHashMap();
    final Map<Class<?>, ResponsePartMeta> bodyPartMetas = new ConcurrentHashMap();
    final ResponseBeanMeta responseMeta;

    RestJavaMethod(Object servlet, Method method, RestContext context) throws RestServletException {
        Builder b = new Builder(servlet, method, context);
        this.context = context;
        this.method = method;
        this.httpMethod = b.httpMethod;
        this.pathPattern = b.pathPattern;
        this.methodParams = b.methodParams;
        this.guards = b.guards;
        this.optionalMatchers = b.optionalMatchers;
        this.requiredMatchers = b.requiredMatchers;
        this.converters = b.converters;
        this.serializers = b.serializers;
        this.parsers = b.parsers;
        this.encoders = b.encoders;
        this.partParser = b.partParser;
        this.partSerializer = b.partSerializer;
        this.beanContext = b.beanContext;
        this.properties = b.properties;
        this.propertyStore = b.propertyStore;
        this.defaultRequestHeaders = b.defaultRequestHeaders;
        this.defaultQuery = b.defaultQuery;
        this.defaultFormData = b.defaultFormData;
        this.defaultCharset = b.defaultCharset;
        this.maxInput = b.maxInput;
        this.priority = b.priority;
        this.supportedAcceptTypes = b.supportedAcceptTypes;
        this.supportedContentTypes = b.supportedContentTypes;
        this.responseMeta = b.responseMeta;
        this.widgets = CollectionUtils.unmodifiableMap(b.widgets);
    }

    ResponseBeanMeta getResponseBeanMeta(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        ResponseBeanMeta rbm = this.responseBeanMetas.get(c);
        if (rbm == null) {
            rbm = ResponseBeanMeta.create(c, this.serializers.getPropertyStore());
            if (rbm == null) {
                rbm = ResponseBeanMeta.NULL;
            }
            this.responseBeanMetas.put(c, rbm);
        }
        if (rbm == ResponseBeanMeta.NULL) {
            return null;
        }
        return rbm;
    }

    ResponsePartMeta getResponseHeaderMeta(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        ResponsePartMeta pm = this.headerPartMetas.get(c);
        if (pm == null) {
            ResponseHeader a = c.getAnnotation(ResponseHeader.class);
            if (a != null) {
                HttpPartSchema schema = HttpPartSchema.create(a);
                HttpPartSerializer serializer = RestJavaMethod.createPartSerializer(schema.getSerializer(), this.serializers.getPropertyStore(), this.partSerializer);
                pm = new ResponsePartMeta(HttpPartType.HEADER, schema, serializer);
            }
            if (pm == null) {
                pm = ResponsePartMeta.NULL;
            }
            this.headerPartMetas.put(c, pm);
        }
        if (pm == ResponsePartMeta.NULL) {
            return null;
        }
        return pm;
    }

    ResponsePartMeta getResponseBodyMeta(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        ResponsePartMeta pm = this.bodyPartMetas.get(c);
        if (pm == null) {
            ResponseBody a = c.getAnnotation(ResponseBody.class);
            if (a != null) {
                HttpPartSchema schema = HttpPartSchema.create(a);
                HttpPartSerializer serializer = RestJavaMethod.createPartSerializer(schema.getSerializer(), this.serializers.getPropertyStore(), this.partSerializer);
                pm = new ResponsePartMeta(HttpPartType.BODY, schema, serializer);
            }
            if (pm == null) {
                pm = ResponsePartMeta.NULL;
            }
            this.bodyPartMetas.put(c, pm);
        }
        if (pm == ResponsePartMeta.NULL) {
            return null;
        }
        return pm;
    }

    boolean hasGuardsOrMatchers() {
        return this.guards.length != 0 || this.requiredMatchers.length != 0 || this.optionalMatchers.length != 0;
    }

    String getHttpMethod() {
        return this.httpMethod;
    }

    String getPathPattern() {
        return this.pathPattern.toString();
    }

    boolean isRequestAllowed(RestRequest req) {
        for (RestGuard guard : this.guards) {
            req.setJavaMethod(this.method);
            if (guard.isRequestAllowed(req)) continue;
            return false;
        }
        return true;
    }

    int invoke(String pathInfo, RestRequest req, RestResponse res) throws Throwable {
        String[] patternVals = this.pathPattern.match(pathInfo);
        if (patternVals == null) {
            return 404;
        }
        String remainder = null;
        if (patternVals.length > this.pathPattern.getVars().length) {
            remainder = patternVals[this.pathPattern.getVars().length];
        }
        for (int i = 0; i < this.pathPattern.getVars().length; ++i) {
            req.getPathMatch().put(this.pathPattern.getVars()[i], patternVals[i]);
        }
        req.getPathMatch().pattern(this.pathPattern.getPatternString()).remainder(remainder);
        RequestProperties requestProperties = new RequestProperties(req.getVarResolverSession(), this.properties);
        req.init(this, requestProperties);
        res.init(this, requestProperties);
        for (RestGuard guard : this.context.getGuards()) {
            if (guard.guard(req, res)) continue;
            return 401;
        }
        for (RestMatcher m : this.requiredMatchers) {
            if (m.matches(req)) continue;
            return 412;
        }
        if (this.optionalMatchers.length > 0) {
            boolean matches = false;
            for (RestMatcher m : this.optionalMatchers) {
                matches |= m.matches(req);
            }
            if (!matches) {
                return 412;
            }
        }
        this.context.preCall(req, res);
        Object[] args = new Object[this.methodParams.length];
        for (int i = 0; i < this.methodParams.length; ++i) {
            try {
                args[i] = this.methodParams[i].resolve(req, res);
                continue;
            }
            catch (RestException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BadRequest((Throwable)e, "Invalid data conversion.  Could not convert {0} ''{1}'' to type ''{2}'' on method ''{3}.{4}''.", this.methodParams[i].getParamType().name(), this.methodParams[i].getName(), this.methodParams[i].getType(), this.method.getDeclaringClass().getName(), this.method.getName());
            }
        }
        try {
            for (RestGuard guard : this.guards) {
                if (guard.guard(req, res)) continue;
                return 200;
            }
            try {
                Object output = this.method.invoke(this.context.getResource(), args);
                if (res.getStatus() == 0) {
                    res.setStatus(200);
                }
                if (!(this.method.getReturnType().equals(Void.TYPE) || output == null && res.getOutputStreamCalled())) {
                    res.setOutput(output);
                }
            }
            catch (InvocationTargetException e) {
                Throwable e2 = e.getTargetException();
                res.setStatus(500);
                if (this.getResponseBodyMeta(e2) != null || this.getResponseBeanMeta(e2) != null) {
                    res.setOutput(e2);
                }
                throw e;
            }
            this.context.postCall(req, res);
            if (res.hasOutput()) {
                for (RestConverter converter : this.converters) {
                    res.setOutput(converter.convert(req, res.getOutput()));
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new BadRequest((Throwable)e, "Invalid argument type passed to the following method: ''{0}''.\n\tArgument types: {1}", this.method.toString(), ClassUtils.getReadableClassNames(args));
        }
        catch (InvocationTargetException e) {
            Throwable e2 = e.getTargetException();
            if (e2 instanceof RestException) {
                throw (RestException)e2;
            }
            if (e2 instanceof ParseException) {
                throw new BadRequest(e2);
            }
            if (e2 instanceof InvalidDataConversionException) {
                throw new BadRequest(e2);
            }
            throw e2;
        }
        return 200;
    }

    public String toString() {
        return "SimpleMethod: name=" + this.httpMethod + ", path=" + this.pathPattern.getPatternString();
    }

    @Override
    public int compareTo(RestJavaMethod o) {
        int c = this.priority.compareTo(o.priority);
        if (c != 0) {
            return c;
        }
        c = this.pathPattern.compareTo(o.pathPattern);
        if (c != 0) {
            return c;
        }
        c = Utils.compare(o.requiredMatchers.length, this.requiredMatchers.length);
        if (c != 0) {
            return c;
        }
        c = Utils.compare(o.optionalMatchers.length, this.optionalMatchers.length);
        if (c != 0) {
            return c;
        }
        c = Utils.compare(o.guards.length, this.guards.length);
        if (c != 0) {
            return c;
        }
        return 0;
    }

    public SerializerGroup getSerializers() {
        return this.serializers;
    }

    public ParserGroup getParsers() {
        return this.parsers;
    }

    public HttpPartSerializer getPartSerializer() {
        return this.partSerializer;
    }

    public HttpPartParser getPartParser() {
        return this.partParser;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RestJavaMethod)) {
            return false;
        }
        return this.compareTo((RestJavaMethod)o) == 0;
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    static String[] resolveVars(VarResolver vr, String[] in) {
        String[] out = new String[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = vr.resolve(in[i]);
        }
        return out;
    }

    static HttpPartSerializer createPartSerializer(Class<? extends HttpPartSerializer> c, PropertyStore ps, HttpPartSerializer _default) {
        HttpPartSerializer hps = ClassUtils.newInstance(HttpPartSerializer.class, c, true, ps);
        return hps == null ? _default : hps;
    }

    private static final class Builder {
        String httpMethod;
        String defaultCharset;
        UrlPathPattern pathPattern;
        RestMethodParam[] methodParams;
        RestGuard[] guards;
        RestMatcher[] optionalMatchers;
        RestMatcher[] requiredMatchers;
        RestConverter[] converters;
        SerializerGroup serializers;
        ParserGroup parsers;
        EncoderGroup encoders;
        HttpPartParser partParser;
        HttpPartSerializer partSerializer;
        BeanContext beanContext;
        RestMethodProperties properties;
        PropertyStore propertyStore;
        Map<String, Object> defaultRequestHeaders;
        Map<String, Object> defaultQuery;
        Map<String, Object> defaultFormData;
        long maxInput;
        Integer priority;
        Map<String, Widget> widgets;
        List<MediaType> supportedAcceptTypes;
        List<MediaType> supportedContentTypes;
        ResponseBeanMeta responseMeta;

        /*
         * WARNING - void declaration
         */
        Builder(Object servlet, Method method, RestContext context) throws RestServletException {
            String sig = method.getDeclaringClass().getName() + '.' + method.getName();
            try {
                String defaultContentType;
                Object[] bpxMap;
                int n;
                Object[] c;
                int i;
                String p;
                RestMethod m = ClassUtils.getAnnotation(RestMethod.class, method);
                if (m == null) {
                    throw new RestServletException("@RestMethod annotation not found on method ''{0}''", sig);
                }
                VarResolver vr = context.getVarResolver();
                this.serializers = context.getSerializers();
                this.parsers = context.getParsers();
                this.partSerializer = context.getPartSerializer();
                this.partParser = context.getPartParser();
                this.beanContext = context.getBeanContext();
                this.encoders = context.getEncoders();
                this.properties = new RestMethodProperties(context.getProperties());
                this.defaultCharset = context.getDefaultCharset();
                this.maxInput = context.getMaxInput();
                if (!m.defaultCharset().isEmpty()) {
                    this.defaultCharset = vr.resolve(m.defaultCharset());
                }
                if (!m.maxInput().isEmpty()) {
                    this.maxInput = StringUtils.parseLongWithSuffix(vr.resolve(m.maxInput()));
                }
                HtmlDocBuilder hdb = new HtmlDocBuilder(this.properties);
                HtmlDoc hd = m.htmldoc();
                hdb.process(hd);
                this.widgets = new HashMap<String, Widget>(context.getWidgets());
                for (Class<? extends Widget> wc : hd.widgets()) {
                    Widget w = this.beanContext.newInstance(Widget.class, wc);
                    this.widgets.put(w.getName(), w);
                    hdb.script("INHERIT", "$W{" + w.getName() + ".script}");
                    hdb.style("INHERIT", "$W{" + w.getName() + ".style}");
                }
                SerializerGroupBuilder sgb = null;
                ParserGroupBuilder pgb = null;
                ParserBuilder uepb = null;
                BeanContextBuilder bcb = null;
                PropertyStore cps = context.getPropertyStore();
                Object[] mSerializers = RestUtils.merge(cps.getArrayProperty("RestContext.serializers.lo", Object.class), m.serializers());
                Object[] mParsers = RestUtils.merge(cps.getArrayProperty("RestContext.parsers.lo", Object.class), m.parsers());
                Object[] mPojoSwaps = RestUtils.merge(cps.getArrayProperty("BeanContext.pojoSwaps.lo", Object.class), m.pojoSwaps());
                Object[] mBeanFilters = RestUtils.merge(cps.getArrayProperty("BeanContext.beanFilters.lc", Object.class), m.beanFilters());
                if (m.serializers().length > 0 || m.parsers().length > 0 || m.properties().length > 0 || m.flags().length > 0 || m.beanFilters().length > 0 || m.pojoSwaps().length > 0 || m.bpi().length > 0 || m.bpx().length > 0) {
                    sgb = SerializerGroup.create();
                    pgb = ParserGroup.create();
                    uepb = Parser.create();
                    bcb = this.beanContext.builder();
                    sgb.append(mSerializers);
                    pgb.append(mParsers);
                }
                if (StringUtils.isEmpty(p = m.path())) {
                    p = HttpUtils.detectHttpPath(method, true);
                }
                this.httpMethod = StringUtils.emptyIfNull(StringUtils.firstNonEmpty(m.name(), m.method())).toUpperCase(Locale.ENGLISH);
                if (this.httpMethod.isEmpty()) {
                    this.httpMethod = HttpUtils.detectHttpMethod(method, true, "GET");
                }
                if ("METHOD".equals(this.httpMethod)) {
                    this.httpMethod = "*";
                }
                this.priority = m.priority();
                this.converters = new RestConverter[m.converters().length];
                for (i = 0; i < this.converters.length; ++i) {
                    this.converters[i] = this.beanContext.newInstance(RestConverter.class, m.converters()[i]);
                }
                this.guards = new RestGuard[m.guards().length];
                for (i = 0; i < this.guards.length; ++i) {
                    this.guards[i] = this.beanContext.newInstance(RestGuard.class, m.guards()[i]);
                }
                LinkedList<RestMatcher> optionalMatchers = new LinkedList<RestMatcher>();
                LinkedList<RestMatcher> requiredMatchers = new LinkedList<RestMatcher>();
                for (int i2 = 0; i2 < m.matchers().length; ++i2) {
                    c = m.matchers()[i2];
                    RestMatcher matcher22 = this.beanContext.newInstance(RestMatcher.class, c, true, servlet, method);
                    if (matcher22.mustMatch()) {
                        requiredMatchers.add(matcher22);
                        continue;
                    }
                    optionalMatchers.add(matcher22);
                }
                if (!m.clientVersion().isEmpty()) {
                    requiredMatchers.add(new ClientVersionMatcher(context.getClientVersionHeader(), method));
                }
                this.requiredMatchers = requiredMatchers.toArray(new RestMatcher[requiredMatchers.size()]);
                this.optionalMatchers = optionalMatchers.toArray(new RestMatcher[optionalMatchers.size()]);
                PropertyStoreBuilder psb = PropertyStore.create().add(this.properties).set("BeanContext.beanFilters.lc", mBeanFilters).set("BeanContext.pojoSwaps.lo", mPojoSwaps);
                for (Property property : m.properties()) {
                    psb.set(property.name(), property.value());
                }
                c = m.flags();
                int matcher22 = c.length;
                for (n = 0; n < matcher22; ++n) {
                    Object object = c[n];
                    psb.set((String)object, true);
                }
                this.propertyStore = psb.build();
                if (sgb != null) {
                    String s;
                    sgb.apply(this.propertyStore);
                    if (m.bpi().length > 0) {
                        void var25_43;
                        LinkedHashMap<String, String> bpiMap = new LinkedHashMap<String, String>();
                        String[] matcher22 = m.bpi();
                        n = matcher22.length;
                        boolean bl = false;
                        while (var25_43 < n) {
                            s = matcher22[var25_43];
                            for (String s2 : StringUtils.split(s, ';')) {
                                int i3 = s2.indexOf(58);
                                if (i3 == -1) {
                                    throw new RestServletException("Invalid format for @RestMethod(bpi) on method ''{0}''.  Must be in the format \"ClassName: comma-delimited-tokens\".  \nValue: {1}", sig, s);
                                }
                                bpiMap.put(s2.substring(0, i3).trim(), s2.substring(i3 + 1).trim());
                            }
                            ++var25_43;
                        }
                        sgb.includeProperties(bpiMap);
                    }
                    if (m.bpx().length > 0) {
                        void var25_45;
                        bpxMap = new LinkedHashMap();
                        String[] matcher22 = m.bpx();
                        n = matcher22.length;
                        boolean bl = false;
                        while (var25_45 < n) {
                            s = matcher22[var25_45];
                            for (String s2 : StringUtils.split(s, ';')) {
                                int i2 = s2.indexOf(58);
                                if (i2 == -1) {
                                    throw new RestServletException("Invalid format for @RestMethod(bpx) on method ''{0}''.  Must be in the format \"ClassName: comma-delimited-tokens\".  \nValue: {1}", sig, s);
                                }
                                bpxMap.put(s2.substring(0, i2).trim(), s2.substring(i2 + 1).trim());
                            }
                            ++var25_45;
                        }
                        sgb.excludeProperties((Map<String, String>)bpxMap);
                    }
                    sgb.beanFilters(mBeanFilters);
                    sgb.pojoSwaps(mPojoSwaps);
                }
                if (pgb != null) {
                    pgb.apply(this.propertyStore);
                    pgb.beanFilters(mBeanFilters);
                    pgb.pojoSwaps(mPojoSwaps);
                }
                if (uepb != null) {
                    uepb.apply(this.propertyStore);
                    uepb.beanFilters(mBeanFilters);
                    uepb.pojoSwaps(mPojoSwaps);
                }
                if (bcb != null) {
                    bcb.apply(this.propertyStore);
                    bcb.pojoSwaps(mPojoSwaps);
                }
                if (m.properties().length > 0 || m.flags().length > 0) {
                    this.properties = new RestMethodProperties(this.properties);
                    for (Property property : m.properties()) {
                        this.properties.put(property.name(), property.value());
                    }
                    bpxMap = m.flags();
                    int matcher22 = bpxMap.length;
                    for (n = 0; n < matcher22; ++n) {
                        Object object = bpxMap[n];
                        this.properties.put(object, true);
                    }
                }
                if (m.encoders().length > 0) {
                    void var25_49;
                    String[] g = EncoderGroup.create().append(IdentityEncoder.INSTANCE);
                    Class<?>[] matcher22 = m.encoders();
                    n = matcher22.length;
                    boolean bl = false;
                    while (var25_49 < n) {
                        Class<?> c2 = matcher22[var25_49];
                        try {
                            g.append(c2);
                        }
                        catch (Exception e) {
                            throw new RestServletException("Exception occurred while trying to instantiate ConfigEncoder on method ''{0}'': ''{1}''", sig, c2.getSimpleName()).initCause(e);
                        }
                        ++var25_49;
                    }
                    this.encoders = g.build();
                }
                this.defaultRequestHeaders = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
                for (String string : m.defaultRequestHeaders()) {
                    String[] h = RestUtils.parseKeyValuePair(vr.resolve(string));
                    if (h == null) {
                        throw new RestServletException("Invalid default request header specified on method ''{0}'': ''{1}''.  Must be in the format: ''name[:=]value''", sig, string);
                    }
                    this.defaultRequestHeaders.put(h[0], h[1]);
                }
                String defaultAccept = vr.resolve(m.defaultAccept());
                if (StringUtils.isNotEmpty(defaultAccept)) {
                    this.defaultRequestHeaders.put("Accept", defaultAccept);
                }
                if (StringUtils.isNotEmpty(defaultContentType = vr.resolve(m.defaultContentType()))) {
                    this.defaultRequestHeaders.put("Content-Type", defaultAccept);
                }
                this.defaultQuery = new LinkedHashMap<String, Object>();
                for (String s : m.defaultQuery()) {
                    String[] h = RestUtils.parseKeyValuePair(vr.resolve(s));
                    if (h == null) {
                        throw new RestServletException("Invalid default query parameter specified on method ''{0}'': ''{1}''.  Must be in the format: ''name[:=]value''", sig, s);
                    }
                    this.defaultQuery.put(h[0], h[1]);
                }
                this.defaultFormData = new LinkedHashMap<String, Object>();
                for (String s : m.defaultFormData()) {
                    String[] h = RestUtils.parseKeyValuePair(vr.resolve(s));
                    if (h == null) {
                        throw new RestServletException("Invalid default form data parameter specified on method ''{0}'': ''{1}''.  Must be in the format: ''name[:=]value''", sig, s);
                    }
                    this.defaultFormData.put(h[0], h[1]);
                }
                Type[] pt = method.getGenericParameterTypes();
                Annotation[][] annotationArray = method.getParameterAnnotations();
                for (int i4 = 0; i4 < pt.length; ++i4) {
                    for (Annotation a : annotationArray[i4]) {
                        FormData f;
                        if (a instanceof Header) {
                            Header h = (Header)a;
                            if (h._default().length <= 0) continue;
                            this.defaultRequestHeaders.put(StringUtils.firstNonEmpty(h.name(), h.value()), RestUtils.parseAnything(StringUtils.joinnl(h._default())));
                            continue;
                        }
                        if (a instanceof Query) {
                            Query q = (Query)a;
                            if (q._default().length <= 0) continue;
                            this.defaultQuery.put(StringUtils.firstNonEmpty(q.name(), q.value()), RestUtils.parseAnything(StringUtils.joinnl(q._default())));
                            continue;
                        }
                        if (!(a instanceof FormData) || (f = (FormData)a)._default().length <= 0) continue;
                        this.defaultFormData.put(StringUtils.firstNonEmpty(f.name(), f.value()), RestUtils.parseAnything(StringUtils.joinnl(f._default())));
                    }
                }
                this.pathPattern = new UrlPathPattern(p);
                if (sgb != null) {
                    this.serializers = sgb.build();
                }
                if (pgb != null) {
                    this.parsers = pgb.build();
                }
                if (uepb != null && this.partParser instanceof Parser) {
                    Parser pp = (Parser)((Object)this.partParser);
                    this.partParser = (HttpPartParser)((Object)pp.builder().apply(uepb.getPropertyStore()).build());
                }
                if (bcb != null) {
                    this.beanContext = bcb.build();
                }
                this.supportedAcceptTypes = m.produces().length > 0 ? CollectionUtils.immutableList(MediaType.forStrings(RestJavaMethod.resolveVars(vr, m.produces()))) : this.serializers.getSupportedMediaTypes();
                this.supportedContentTypes = m.consumes().length > 0 ? CollectionUtils.immutableList(MediaType.forStrings(RestJavaMethod.resolveVars(vr, m.consumes()))) : this.parsers.getSupportedMediaTypes();
                this.methodParams = context.findParams(method, false, this.pathPattern);
                if (ClassUtils.hasAnnotation(Response.class, method)) {
                    this.responseMeta = ResponseBeanMeta.create(method, this.serializers.getPropertyStore());
                }
                ClassUtils.setAccessible(method, true);
            }
            catch (RestServletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RestServletException("Exception occurred while initializing method ''{0}''", sig).initCause(e);
            }
        }
    }
}

