/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.juneau.BeanContextBuilder;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.PropertyStoreBuilder;
import org.apache.juneau.ResourceResolver;
import org.apache.juneau.Visibility;
import org.apache.juneau.config.Config;
import org.apache.juneau.config.ConfigBuilder;
import org.apache.juneau.config.vars.ConfigVar;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.IdentityEncoder;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.oapi.OpenApiParser;
import org.apache.juneau.oapi.OpenApiSerializer;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.rest.BasicRestLogger;
import org.apache.juneau.rest.HtmlDocBuilder;
import org.apache.juneau.rest.MessageBundleLocation;
import org.apache.juneau.rest.ResponseHandler;
import org.apache.juneau.rest.RestCallHandler;
import org.apache.juneau.rest.RestChild;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestContextProperties;
import org.apache.juneau.rest.RestConverter;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestGuard;
import org.apache.juneau.rest.RestInfoProvider;
import org.apache.juneau.rest.RestLogger;
import org.apache.juneau.rest.RestMethodParam;
import org.apache.juneau.rest.RestResourceResolver;
import org.apache.juneau.rest.RestServletException;
import org.apache.juneau.rest.StaticFileMapping;
import org.apache.juneau.rest.annotation.HookEvent;
import org.apache.juneau.rest.annotation.HtmlDoc;
import org.apache.juneau.rest.annotation.Property;
import org.apache.juneau.rest.annotation.RestHook;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.rest.reshandlers.DefaultHandler;
import org.apache.juneau.rest.reshandlers.InputStreamHandler;
import org.apache.juneau.rest.reshandlers.ReaderHandler;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.rest.vars.FileVar;
import org.apache.juneau.rest.widget.Widget;
import org.apache.juneau.serializer.SerializerListener;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverBuilder;
import org.apache.juneau.utils.ClasspathResourceFinder;
import org.apache.juneau.utils.ClasspathResourceManager;

public class RestContextBuilder
extends BeanContextBuilder
implements ServletConfig {
    final ServletConfig inner;
    Class<?> resourceClass;
    Object resource;
    ServletContext servletContext;
    RestContext parentContext;
    RestContextProperties properties;
    Config config;
    VarResolverBuilder varResolverBuilder;
    String path;
    HtmlDocBuilder htmlDocBuilder;

    RestContextBuilder(ServletConfig servletConfig, Class<?> resourceClass, RestContext parentContext) throws ServletException {
        this.inner = servletConfig;
        this.resourceClass = resourceClass;
        this.parentContext = parentContext;
        this.properties = new RestContextProperties();
        this.logger(BasicRestLogger.class);
        this.partSerializer(OpenApiSerializer.class);
        this.partParser(OpenApiParser.class);
        this.staticFileResponseHeader("Cache-Control", "max-age=86400, public");
        this.encoders(IdentityEncoder.INSTANCE);
        try {
            this.htmlDocBuilder = new HtmlDocBuilder(this.properties);
            this.varResolverBuilder = new VarResolverBuilder().defaultVars().vars(ConfigVar.class).vars(FileVar.class).contextObject("crm", new ClasspathResourceManager(resourceClass));
            VarResolver vr = this.varResolverBuilder.build();
            LinkedHashMap<Class<?>, RestResource> restResourceAnnotationsParentFirst = ClassUtils.getAnnotationsMapParentFirst(RestResource.class, resourceClass);
            String configPath = "";
            for (RestResource r : restResourceAnnotationsParentFirst.values()) {
                if (r.config().isEmpty()) continue;
                configPath = r.config();
            }
            String cf = vr.resolve(configPath);
            if ("SYSTEM_DEFAULT".equals(cf)) {
                this.config = Config.getSystemDefault();
            }
            if (this.config == null) {
                ConfigBuilder cb = Config.create().varResolver(vr);
                if (!cf.isEmpty()) {
                    cb.name(cf);
                }
                this.config = cb.build();
            }
            this.varResolverBuilder.contextObject("config", this.config);
            vr = this.varResolverBuilder.build();
            if (servletConfig != null) {
                Enumeration ep = servletConfig.getInitParameterNames();
                while (ep.hasMoreElements()) {
                    String p = (String)ep.nextElement();
                    String initParam = servletConfig.getInitParameter(p);
                    this.set(vr.resolve(p), vr.resolve(initParam));
                }
            }
            for (Map.Entry e : restResourceAnnotationsParentFirst.entrySet()) {
                Class c = (Class)e.getKey();
                RestResource r = (RestResource)e.getValue();
                for (Property property : r.properties()) {
                    this.set(vr.resolve(property.name()), vr.resolve(property.value()));
                }
                for (String string : r.flags()) {
                    this.set(string, true);
                }
                this.serializers(false, RestUtils.merge(ObjectUtils.toType(this.psb.peek("RestContext.serializers.lo"), Object[].class), r.serializers()));
                this.parsers(false, RestUtils.merge(ObjectUtils.toType(this.psb.peek("RestContext.parsers.lo"), Object[].class), r.parsers()));
                this.partSerializer(r.partSerializer());
                this.partParser(r.partParser());
                this.encoders(r.encoders());
                if (r.produces().length > 0) {
                    this.produces(false, RestContextBuilder.resolveVars(vr, r.produces()));
                }
                if (r.consumes().length > 0) {
                    this.consumes(false, RestContextBuilder.resolveVars(vr, r.consumes()));
                }
                this.defaultRequestHeaders(RestContextBuilder.resolveVars(vr, r.defaultRequestHeaders()));
                this.defaultAccept(vr.resolve(r.defaultAccept()));
                this.defaultContentType(vr.resolve(r.defaultContentType()));
                this.defaultResponseHeaders(RestContextBuilder.resolveVars(vr, r.defaultResponseHeaders()));
                this.responseHandlers(r.responseHandlers());
                this.converters(r.converters());
                this.guards(ArrayUtils.reverse(r.guards()));
                this.children(r.children());
                this.beanFilters(false, RestUtils.merge(ObjectUtils.toType(this.psb.peek("BeanContext.beanFilters.lc"), Object[].class), r.beanFilters()));
                this.pojoSwaps(false, RestUtils.merge(ObjectUtils.toType(this.psb.peek("BeanContext.pojoSwaps.lo"), Object[].class), r.pojoSwaps()));
                this.paramResolvers(r.paramResolvers());
                this.serializerListener(r.serializerListener());
                this.parserListener(r.parserListener());
                this.uriContext(vr.resolve(r.uriContext()));
                this.uriAuthority(vr.resolve(r.uriAuthority()));
                this.uriRelativity(vr.resolve(r.uriRelativity()));
                this.uriResolution(vr.resolve(r.uriResolution()));
                for (String string : r.staticFiles()) {
                    this.staticFiles(c, vr.resolve(string));
                }
                if (!r.messages().isEmpty()) {
                    this.messages(c, vr.resolve(r.messages()));
                }
                this.staticFileResponseHeaders(RestContextBuilder.resolveVars(vr, r.staticFileResponseHeaders()));
                if (!r.useClasspathResourceCaching().isEmpty()) {
                    this.useClasspathResourceCaching(Boolean.valueOf(vr.resolve(r.useClasspathResourceCaching())));
                }
                if (r.classpathResourceFinder() != ClasspathResourceFinder.Null.class) {
                    this.classpathResourceFinder(r.classpathResourceFinder());
                }
                if (!r.path().isEmpty()) {
                    this.path(vr.resolve(r.path()));
                }
                if (!r.clientVersionHeader().isEmpty()) {
                    this.clientVersionHeader(vr.resolve(r.clientVersionHeader()));
                }
                if (r.resourceResolver() != RestResourceResolver.Null.class) {
                    this.resourceResolver(r.resourceResolver());
                }
                if (r.logger() != RestLogger.Null.class) {
                    this.logger(r.logger());
                }
                if (r.callHandler() != RestCallHandler.Null.class) {
                    this.callHandler(r.callHandler());
                }
                if (r.infoProvider() != RestInfoProvider.Null.class) {
                    this.infoProvider(r.infoProvider());
                }
                if (!r.allowHeaderParams().isEmpty()) {
                    this.allowHeaderParams(Boolean.valueOf(vr.resolve(r.allowHeaderParams())));
                }
                if (!r.allowedMethodParams().isEmpty()) {
                    this.allowedMethodParams(vr.resolve(r.allowedMethodParams()));
                }
                if (!r.allowBodyParam().isEmpty()) {
                    this.allowBodyParam(Boolean.valueOf(vr.resolve(r.allowBodyParam())));
                }
                if (!r.renderResponseStackTraces().isEmpty()) {
                    this.renderResponseStackTraces(Boolean.valueOf(vr.resolve(r.renderResponseStackTraces())));
                }
                if (!r.useStackTraceHashes().isEmpty()) {
                    this.useStackTraceHashes(Boolean.valueOf(vr.resolve(r.useStackTraceHashes())));
                }
                if (!r.defaultCharset().isEmpty()) {
                    this.defaultCharset(vr.resolve(r.defaultCharset()));
                }
                if (!r.maxInput().isEmpty()) {
                    this.maxInput(vr.resolve(r.maxInput()));
                }
                if (!r.debug().isEmpty()) {
                    this.debug(Boolean.valueOf(vr.resolve(r.debug())));
                }
                this.mimeTypes(RestContextBuilder.resolveVars(vr, r.mimeTypes()));
                HtmlDoc hd = r.htmldoc();
                this.widgets(hd.widgets());
                this.htmlDocBuilder.process(hd);
            }
            this.responseHandlers(ReaderHandler.class, InputStreamHandler.class, DefaultHandler.class);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    @Override
    public RestContext build() {
        try {
            return new RestContext(this);
        }
        catch (RestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String[] resolveVars(VarResolver vr, String[] in) {
        String[] out = new String[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = vr.resolve(in[i]);
        }
        return out;
    }

    RestContextBuilder init(Object resource) throws ServletException {
        Widget[] widgets;
        this.resource = resource;
        HtmlDocBuilder hdb = this.getHtmlDocBuilder();
        PropertyStore ps = this.getPropertyStore();
        for (Widget w : widgets = ps.getInstanceArrayProperty("RestContext.widgets.lo", Widget.class, new Widget[0], ResourceResolver.FUZZY, ps, resource)) {
            hdb.script("INHERIT", "$W{" + w.getName() + ".script}");
            hdb.style("INHERIT", "$W{" + w.getName() + ".style}");
        }
        this.widgets(false, widgets);
        LinkedHashMap<String, Method> map = new LinkedHashMap<String, Method>();
        for (Method m : ClassUtils.getAllMethods(this.resourceClass, true)) {
            if (!m.isAnnotationPresent(RestHook.class) || m.getAnnotation(RestHook.class).value() != HookEvent.INIT) continue;
            ClassUtils.setAccessible(m, false);
            String sig = ClassUtils.getMethodSignature(m);
            if (map.containsKey(sig)) continue;
            map.put(sig, m);
        }
        for (Method m : map.values()) {
            ClassUtils.assertArgsOfType(m, RestContextBuilder.class, ServletConfig.class);
            Class<?>[] pt = m.getParameterTypes();
            Object[] args = new Object[pt.length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = pt[i] == RestContextBuilder.class ? this : this.inner;
            }
            try {
                m.invoke(resource, args);
            }
            catch (Exception e) {
                throw new RestServletException("Exception thrown from @RestHook(INIT) method {0}.", m).initCause(e);
            }
        }
        return this;
    }

    RestContextBuilder servletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        return this;
    }

    public RestContextBuilder vars(Class<?> ... vars) {
        this.varResolverBuilder.vars(vars);
        return this;
    }

    public RestContextBuilder varContextObject(String name, Object object) {
        this.varResolverBuilder.contextObject(name, object);
        return this;
    }

    public RestContextBuilder config(Config config) {
        this.config = config;
        return this;
    }

    public HtmlDocBuilder getHtmlDocBuilder() {
        return this.htmlDocBuilder;
    }

    protected PropertyStoreBuilder createPropertyStore() {
        return PropertyStore.create().add(this.properties);
    }

    public Config getConfig() {
        return this.config;
    }

    public RestContextProperties getProperties() {
        return this.properties;
    }

    public VarResolverBuilder getVarResolverBuilder() {
        return this.varResolverBuilder;
    }

    public RestContextBuilder allowBodyParam(boolean value) {
        return this.set("RestContext.allowBodyParam.b", value);
    }

    public RestContextBuilder allowedMethodParams(String ... value) {
        return this.set("RestContext.allowedMethodParams.s", StringUtils.join((Object[])value, ','));
    }

    public RestContextBuilder allowHeaderParams(boolean value) {
        return this.set("RestContext.allowHeaderParams.b", value);
    }

    public RestContextBuilder callHandler(Class<? extends RestCallHandler> value) {
        return this.set("RestContext.callHandler.o", value);
    }

    public RestContextBuilder callHandler(RestCallHandler value) {
        return this.set("RestContext.callHandler.o", value);
    }

    public RestContextBuilder children(Class<?> ... values) {
        return this.addTo("RestContext.children.lo", values);
    }

    public RestContextBuilder children(Object ... values) {
        return this.addTo("RestContext.children.lo", values);
    }

    public RestContextBuilder child(String path, Object child) {
        return this.addTo("RestContext.children.lo", new RestChild(path, child));
    }

    public RestContextBuilder classpathResourceFinder(Class<? extends ClasspathResourceFinder> value) {
        return this.set("RestContext.classpathResourceFinder.o", value);
    }

    public RestContextBuilder classpathResourceFinder(ClasspathResourceFinder value) {
        return this.set("RestContext.classpathResourceFinder.o", value);
    }

    public RestContextBuilder clientVersionHeader(String value) {
        return this.set("RestContext.clientVersionHeader.s", value);
    }

    public RestContextBuilder converters(Class<?> ... values) {
        return this.addTo("RestContext.converters.lo", values);
    }

    public RestContextBuilder converters(RestConverter ... values) {
        return this.addTo("RestContext.converters.lo", values);
    }

    @Override
    public RestContextBuilder debug(boolean value) {
        super.debug(value);
        return this.set("RestContext.debug.b", value);
    }

    public RestContextBuilder defaultCharset(String value) {
        return this.set("RestContext.defaultCharset.s", value);
    }

    public RestContextBuilder defaultCharset(Charset value) {
        return this.set("RestContext.defaultCharset.s", value);
    }

    public RestContextBuilder defaultRequestHeaders(String ... headers) throws RestServletException {
        for (String header : headers) {
            String[] h = RestUtils.parseHeader(header);
            if (h == null) {
                throw new RestServletException("Invalid default request header specified: ''{0}''.  Must be in the format: ''Header-Name: header-value''", header);
            }
            this.defaultRequestHeader(h[0], h[1]);
        }
        return this;
    }

    public RestContextBuilder defaultAccept(String value) {
        if (StringUtils.isNotEmpty(value)) {
            this.defaultRequestHeader("Accept", value);
        }
        return this;
    }

    public RestContextBuilder defaultContentType(String value) {
        if (StringUtils.isNotEmpty(value)) {
            this.defaultRequestHeader("Content-Type", value);
        }
        return this;
    }

    public RestContextBuilder defaultRequestHeader(String name, Object value) {
        return this.addTo("RestContext.defaultRequestHeaders.smo", name, value);
    }

    public RestContextBuilder defaultResponseHeaders(String ... headers) throws RestServletException {
        for (String header : headers) {
            String[] h = RestUtils.parseHeader(header);
            if (h == null) {
                throw new RestServletException("Invalid default response header specified: ''{0}''.  Must be in the format: ''Header-Name: header-value''", header);
            }
            this.defaultResponseHeader(h[0], h[1]);
        }
        return this;
    }

    public RestContextBuilder defaultResponseHeader(String name, Object value) {
        return this.addTo("RestContext.defaultResponseHeaders.omo", name, value);
    }

    public RestContextBuilder encoders(Class<?> ... values) {
        return this.addTo("RestContext.encoders.lo", values);
    }

    public RestContextBuilder encoders(Encoder ... values) {
        return this.addTo("RestContext.encoders.lo", values);
    }

    public RestContextBuilder guards(Class<?> ... values) {
        return this.addTo("RestContext.guards.lo", values);
    }

    public RestContextBuilder guards(RestGuard ... values) {
        return this.addTo("RestContext.guards.lo", values);
    }

    public RestContextBuilder infoProvider(Class<? extends RestInfoProvider> value) {
        return this.set("RestContext.infoProvider.o", value);
    }

    public RestContextBuilder infoProvider(RestInfoProvider value) {
        return this.set("RestContext.infoProvider.o", value);
    }

    public RestContextBuilder logger(Class<? extends RestLogger> value) {
        return this.set("RestContext.logger.o", value);
    }

    public RestContextBuilder logger(RestLogger value) {
        return this.set("RestContext.logger.o", value);
    }

    public RestContextBuilder maxInput(String value) {
        return this.set("RestContext.maxInput.s", value);
    }

    public RestContextBuilder messages(MessageBundleLocation ... values) {
        return this.addTo("RestContext.messages.lo", values);
    }

    public RestContextBuilder messages(Class<?> baseClass, String bundlePath) {
        return this.addTo("RestContext.messages.lo", new MessageBundleLocation(baseClass, bundlePath));
    }

    public RestContextBuilder messages(String bundlePath) {
        return this.addTo("RestContext.messages.lo", new MessageBundleLocation(null, bundlePath));
    }

    public RestContextBuilder mimeTypes(String ... values) {
        return this.addTo("RestContext.mimeTypes.ss", values);
    }

    public RestContextBuilder paramResolvers(Class<? extends RestMethodParam> ... values) {
        return this.addTo("RestContext.paramResolvers.lo", values);
    }

    public RestContextBuilder paramResolvers(RestMethodParam ... values) {
        return this.addTo("RestContext.paramResolvers.lo", values);
    }

    public RestContextBuilder parserListener(Class<? extends ParserListener> value) {
        if (value != ParserListener.Null.class) {
            this.set("Parser.listener.c", value);
        }
        return this;
    }

    public RestContextBuilder parsers(Class<?> ... values) {
        return this.addTo("RestContext.parsers.lo", values);
    }

    public RestContextBuilder parsers(boolean append, Object ... values) {
        return this.set(append, "RestContext.parsers.lo", values);
    }

    public RestContextBuilder parsers(Object ... values) {
        return this.addTo("RestContext.parsers.lo", values);
    }

    public RestContextBuilder partParser(Class<? extends HttpPartParser> value) {
        if (value != HttpPartParser.Null.class) {
            this.set("RestContext.partParser.o", value);
        }
        return this;
    }

    public RestContextBuilder partParser(HttpPartParser value) {
        return this.set("RestContext.partParser.o", value);
    }

    public RestContextBuilder partSerializer(Class<? extends HttpPartSerializer> value) {
        if (value != HttpPartSerializer.Null.class) {
            this.set("RestContext.partSerializer.o", value);
        }
        return this;
    }

    public RestContextBuilder partSerializer(HttpPartSerializer value) {
        return this.set("RestContext.partSerializer.o", value);
    }

    public RestContextBuilder path(String value) {
        if (StringUtils.startsWith(value, '/')) {
            value = value.substring(1);
        }
        this.path = value;
        return this;
    }

    public RestContextBuilder renderResponseStackTraces(boolean value) {
        return this.set("RestContext.renderResponseStackTraces.b", value);
    }

    public RestContextBuilder renderResponseStackTraces() {
        return this.set("RestContext.renderResponseStackTraces.b", true);
    }

    public RestContextBuilder resourceResolver(Class<? extends RestResourceResolver> value) {
        return this.set("RestContext.resourceResolver.o", value);
    }

    public RestContextBuilder resourceResolver(RestResourceResolver value) {
        return this.set("RestContext.resourceResolver.o", value);
    }

    public RestContextBuilder responseHandlers(Class<?> ... values) {
        return this.addTo("RestContext.responseHandlers.lo", values);
    }

    public RestContextBuilder responseHandlers(ResponseHandler ... values) {
        return this.addTo("RestContext.responseHandlers.lo", values);
    }

    public RestContextBuilder serializerListener(Class<? extends SerializerListener> value) {
        if (value != SerializerListener.Null.class) {
            this.set("Serializer.listener.c", value);
        }
        return this;
    }

    public RestContextBuilder serializers(Class<?> ... values) {
        return this.addTo("RestContext.serializers.lo", values);
    }

    public RestContextBuilder serializers(boolean append, Object ... values) {
        return this.set(append, "RestContext.serializers.lo", values);
    }

    public RestContextBuilder serializers(Object ... values) {
        return this.addTo("RestContext.serializers.lo", values);
    }

    public RestContextBuilder staticFileResponseHeaders(boolean append, Map<String, String> headers) {
        return this.set(append, "RestContext.staticFileResponseHeaders.omo", headers);
    }

    public RestContextBuilder staticFileResponseHeaders(String ... headers) throws RestServletException {
        for (String header : headers) {
            String[] h = RestUtils.parseHeader(header);
            if (h == null) {
                throw new RestServletException("Invalid static file response header specified: ''{0}''.  Must be in the format: ''Header-Name: header-value''", header);
            }
            this.staticFileResponseHeader(h[0], h[1]);
        }
        return this;
    }

    public RestContextBuilder staticFileResponseHeader(String name, String value) {
        return this.addTo("RestContext.staticFileResponseHeaders.omo", name, value);
    }

    public RestContextBuilder staticFiles(StaticFileMapping ... values) {
        return this.addTo("RestContext.staticFiles.lo", values);
    }

    public RestContextBuilder staticFiles(String mappingString) {
        return this.staticFiles(new StaticFileMapping(this.resourceClass, mappingString));
    }

    public RestContextBuilder staticFiles(Class<?> baseClass, String mappingString) {
        if (StringUtils.isNotEmpty(mappingString)) {
            this.staticFiles(new StaticFileMapping(baseClass, mappingString));
        }
        return this;
    }

    public RestContextBuilder staticFiles(String path, String location) {
        return this.staticFiles(new StaticFileMapping(null, path, location, null));
    }

    public RestContextBuilder staticFiles(Class<?> baseClass, String path, String location) {
        return this.staticFiles(new StaticFileMapping(baseClass, path, location, null));
    }

    public RestContextBuilder produces(boolean append, String ... values) {
        return this.set(append, "RestContext.produces.ls", values);
    }

    public RestContextBuilder produces(boolean append, MediaType ... values) {
        return this.set(append, "RestContext.produces.ls", values);
    }

    public RestContextBuilder consumes(boolean append, String ... values) {
        return this.set(append, "RestContext.consumes.ls", values);
    }

    public RestContextBuilder consumes(boolean append, MediaType ... values) {
        return this.set(append, "RestContext.consumes.ls", values);
    }

    public RestContextBuilder uriAuthority(String value) {
        if (!value.isEmpty()) {
            this.set("RestContext.uriAuthority.s", value);
        }
        return this;
    }

    public RestContextBuilder uriContext(String value) {
        if (!value.isEmpty()) {
            this.set("RestContext.uriContext.s", value);
        }
        return this;
    }

    public RestContextBuilder uriRelativity(String value) {
        if (!value.isEmpty()) {
            this.set("RestContext.uriRelativity.s", value);
        }
        return this;
    }

    public RestContextBuilder uriResolution(String value) {
        if (!value.isEmpty()) {
            this.set("RestContext.uriResolution.s", value);
        }
        return this;
    }

    public RestContextBuilder useClasspathResourceCaching(boolean value) {
        return this.set("RestContext.useClasspathResourceCaching.b", value);
    }

    public RestContextBuilder useStackTraceHashes(boolean value) {
        return this.set("RestContext.useStackTraceHashes.b", value);
    }

    public RestContextBuilder widgets(Class<? extends Widget> ... values) {
        return this.addTo("RestContext.widgets.lo", values);
    }

    public RestContextBuilder widgets(Widget ... values) {
        return this.addTo("RestContext.widgets.lo", values);
    }

    public RestContextBuilder widgets(boolean append, Widget ... values) {
        return this.set(append, "RestContext.widgets.lo", values);
    }

    @Override
    public RestContextBuilder beanClassVisibility(Visibility value) {
        super.beanClassVisibility(value);
        return this;
    }

    @Override
    public RestContextBuilder beanConstructorVisibility(Visibility value) {
        super.beanConstructorVisibility(value);
        return this;
    }

    @Override
    public RestContextBuilder beanDictionary(boolean append, Object ... values) {
        super.beanDictionary(append, values);
        return this;
    }

    @Override
    public RestContextBuilder beanDictionary(Class<?> ... values) {
        super.beanDictionary(values);
        return this;
    }

    @Override
    public RestContextBuilder beanDictionary(Object ... values) {
        super.beanDictionary(values);
        return this;
    }

    @Override
    public RestContextBuilder beanDictionaryRemove(Object ... values) {
        super.beanDictionaryRemove(values);
        return this;
    }

    @Override
    public RestContextBuilder beanFieldVisibility(Visibility value) {
        super.beanFieldVisibility(value);
        return this;
    }

    @Override
    public RestContextBuilder beanFilters(boolean append, Object ... values) {
        super.beanFilters(append, values);
        return this;
    }

    @Override
    public RestContextBuilder beanFilters(Class<?> ... values) {
        super.beanFilters(values);
        return this;
    }

    @Override
    public RestContextBuilder beanFilters(Object ... values) {
        super.beanFilters(values);
        return this;
    }

    @Override
    public RestContextBuilder beanFiltersRemove(Object ... values) {
        super.beanFiltersRemove(values);
        return this;
    }

    @Override
    public RestContextBuilder beanMapPutReturnsOldValue(boolean value) {
        super.beanMapPutReturnsOldValue(value);
        return this;
    }

    @Override
    public RestContextBuilder beanMapPutReturnsOldValue() {
        super.beanMapPutReturnsOldValue();
        return this;
    }

    @Override
    public RestContextBuilder beanMethodVisibility(Visibility value) {
        super.beanMethodVisibility(value);
        return this;
    }

    @Override
    public RestContextBuilder beansRequireDefaultConstructor(boolean value) {
        super.beansRequireDefaultConstructor(value);
        return this;
    }

    @Override
    public RestContextBuilder beansRequireDefaultConstructor() {
        super.beansRequireDefaultConstructor();
        return this;
    }

    @Override
    public RestContextBuilder beansRequireSerializable(boolean value) {
        super.beansRequireSerializable(value);
        return this;
    }

    @Override
    public RestContextBuilder beansRequireSerializable() {
        super.beansRequireSerializable();
        return this;
    }

    @Override
    public RestContextBuilder beansRequireSettersForGetters(boolean value) {
        super.beansRequireSettersForGetters(value);
        return this;
    }

    @Override
    public RestContextBuilder beansRequireSettersForGetters() {
        super.beansRequireSettersForGetters();
        return this;
    }

    @Override
    public RestContextBuilder beansRequireSomeProperties(boolean value) {
        super.beansRequireSomeProperties(value);
        return this;
    }

    @Override
    public RestContextBuilder beanTypePropertyName(String value) {
        super.beanTypePropertyName(value);
        return this;
    }

    @Override
    public RestContextBuilder debug() {
        super.debug();
        return this;
    }

    @Override
    public <T> RestContextBuilder example(Class<T> c, T o) {
        super.example(c, o);
        return this;
    }

    @Override
    public RestContextBuilder ignoreInvocationExceptionsOnGetters(boolean value) {
        super.ignoreInvocationExceptionsOnGetters(value);
        return this;
    }

    @Override
    public RestContextBuilder ignoreInvocationExceptionsOnGetters() {
        super.ignoreInvocationExceptionsOnGetters();
        return this;
    }

    @Override
    public RestContextBuilder ignoreInvocationExceptionsOnSetters(boolean value) {
        super.ignoreInvocationExceptionsOnSetters(value);
        return this;
    }

    @Override
    public RestContextBuilder ignoreInvocationExceptionsOnSetters() {
        super.ignoreInvocationExceptionsOnSetters();
        return this;
    }

    @Override
    public RestContextBuilder ignorePropertiesWithoutSetters(boolean value) {
        super.ignorePropertiesWithoutSetters(value);
        return this;
    }

    @Override
    public RestContextBuilder ignoreUnknownBeanProperties(boolean value) {
        super.ignoreUnknownBeanProperties(value);
        return this;
    }

    @Override
    public RestContextBuilder ignoreUnknownBeanProperties() {
        super.ignoreUnknownBeanProperties();
        return this;
    }

    @Override
    public RestContextBuilder ignoreUnknownNullBeanProperties(boolean value) {
        super.ignoreUnknownNullBeanProperties(value);
        return this;
    }

    public <T> RestContextBuilder implClass(Class<T> interfaceClass, Class<? extends T> implClass) {
        super.implClass(interfaceClass, implClass);
        return this;
    }

    @Override
    public RestContextBuilder implClasses(Map<String, Class<?>> values) {
        super.implClasses(values);
        return this;
    }

    @Override
    public RestContextBuilder locale(Locale value) {
        super.locale(value);
        return this;
    }

    @Override
    public RestContextBuilder mediaType(MediaType value) {
        super.mediaType(value);
        return this;
    }

    @Override
    public RestContextBuilder notBeanClasses(boolean append, Object ... values) {
        super.notBeanClasses(append, values);
        return this;
    }

    @Override
    public RestContextBuilder notBeanClasses(Class<?> ... values) {
        super.notBeanClasses(values);
        return this;
    }

    @Override
    public RestContextBuilder notBeanClasses(Object ... values) {
        super.notBeanClasses(values);
        return this;
    }

    @Override
    public RestContextBuilder notBeanClassesRemove(Object ... values) {
        super.notBeanClassesRemove(values);
        return this;
    }

    @Override
    public RestContextBuilder notBeanPackages(boolean append, Object ... values) {
        super.notBeanPackages(append, values);
        return this;
    }

    @Override
    public RestContextBuilder notBeanPackages(Object ... values) {
        super.notBeanPackages(values);
        return this;
    }

    @Override
    public RestContextBuilder notBeanPackages(String ... values) {
        super.notBeanPackages(values);
        return this;
    }

    @Override
    public RestContextBuilder notBeanPackagesRemove(Object ... values) {
        super.notBeanPackagesRemove(values);
        return this;
    }

    @Override
    public RestContextBuilder pojoSwaps(boolean append, Object ... values) {
        super.pojoSwaps(append, values);
        return this;
    }

    @Override
    public RestContextBuilder pojoSwaps(Class<?> ... values) {
        super.pojoSwaps(values);
        return this;
    }

    @Override
    public RestContextBuilder pojoSwaps(Object ... values) {
        super.pojoSwaps(values);
        return this;
    }

    @Override
    public RestContextBuilder pojoSwapsRemove(Object ... values) {
        super.pojoSwapsRemove(values);
        return this;
    }

    @Override
    public RestContextBuilder sortProperties(boolean value) {
        super.sortProperties(value);
        return this;
    }

    @Override
    public RestContextBuilder sortProperties() {
        super.sortProperties();
        return this;
    }

    @Override
    public RestContextBuilder timeZone(TimeZone value) {
        super.timeZone(value);
        return this;
    }

    @Override
    public RestContextBuilder useEnumNames() {
        super.useEnumNames();
        return this;
    }

    @Override
    public RestContextBuilder useInterfaceProxies(boolean value) {
        super.useInterfaceProxies(value);
        return this;
    }

    @Override
    public RestContextBuilder useJavaBeanIntrospector(boolean value) {
        super.useJavaBeanIntrospector(value);
        return this;
    }

    @Override
    public RestContextBuilder useJavaBeanIntrospector() {
        super.useJavaBeanIntrospector();
        return this;
    }

    @Override
    public RestContextBuilder set(String name, Object value) {
        super.set(name, value);
        this.properties.put(name, value);
        return this;
    }

    @Override
    public RestContextBuilder set(boolean append, String name, Object value) {
        super.set(append, name, value);
        return this;
    }

    @Override
    public RestContextBuilder set(Map<String, Object> properties) {
        super.set((Map)properties);
        this.properties.clear();
        this.properties.putAll(properties);
        return this;
    }

    @Override
    public RestContextBuilder add(Map<String, Object> properties) {
        super.add((Map)properties);
        return this;
    }

    @Override
    public RestContextBuilder addTo(String name, Object value) {
        super.addTo(name, value);
        return this;
    }

    @Override
    public RestContextBuilder addTo(String name, String key, Object value) {
        super.addTo(name, key, value);
        return this;
    }

    @Override
    public RestContextBuilder removeFrom(String name, Object value) {
        super.removeFrom(name, value);
        return this;
    }

    @Override
    public RestContextBuilder apply(PropertyStore copyFrom) {
        super.apply(copyFrom);
        return this;
    }

    public String getInitParameter(String name) {
        return this.inner.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.inner.getInitParameterNames();
    }

    public ServletContext getServletContext() {
        return this.inner.getServletContext();
    }

    public String getServletName() {
        return this.inner.getServletName();
    }
}

