/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.BeanSessionArgs;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.ResourceResolver;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.config.Config;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderGroup;
import org.apache.juneau.encoders.EncoderGroupBuilder;
import org.apache.juneau.html.HtmlParser;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.StreamResource;
import org.apache.juneau.http.annotation.Body;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.HasFormData;
import org.apache.juneau.http.annotation.HasQuery;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.Request;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.ResponseHeader;
import org.apache.juneau.http.annotation.ResponseStatus;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.msgpack.MsgPackParser;
import org.apache.juneau.oapi.OpenApiParser;
import org.apache.juneau.oapi.OpenApiSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserGroup;
import org.apache.juneau.remote.RemoteInterfaceMeta;
import org.apache.juneau.remote.RemoteInterfaceMethod;
import org.apache.juneau.rest.BasicRestCallHandler;
import org.apache.juneau.rest.BasicRestInfoProvider;
import org.apache.juneau.rest.BasicRestResourceResolver;
import org.apache.juneau.rest.MessageBundleLocation;
import org.apache.juneau.rest.NoOpRestLogger;
import org.apache.juneau.rest.ResponseHandler;
import org.apache.juneau.rest.RestCallHandler;
import org.apache.juneau.rest.RestCallRouter;
import org.apache.juneau.rest.RestChild;
import org.apache.juneau.rest.RestContextBuilder;
import org.apache.juneau.rest.RestContextProperties;
import org.apache.juneau.rest.RestConverter;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestGuard;
import org.apache.juneau.rest.RestInfoProvider;
import org.apache.juneau.rest.RestJavaMethod;
import org.apache.juneau.rest.RestLogger;
import org.apache.juneau.rest.RestMethodParam;
import org.apache.juneau.rest.RestParamDefaults;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResourceResolver;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestServlet;
import org.apache.juneau.rest.RestServletException;
import org.apache.juneau.rest.StaticFileMapping;
import org.apache.juneau.rest.annotation.HookEvent;
import org.apache.juneau.rest.annotation.Method;
import org.apache.juneau.rest.annotation.RestHook;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.exception.BadRequest;
import org.apache.juneau.rest.exception.InternalServerError;
import org.apache.juneau.rest.exception.NotFound;
import org.apache.juneau.rest.util.UrlPathPattern;
import org.apache.juneau.rest.vars.FileVar;
import org.apache.juneau.rest.vars.LocalizationVar;
import org.apache.juneau.rest.vars.RequestAttributeVar;
import org.apache.juneau.rest.vars.RequestFormDataVar;
import org.apache.juneau.rest.vars.RequestHeaderVar;
import org.apache.juneau.rest.vars.RequestPathVar;
import org.apache.juneau.rest.vars.RequestQueryVar;
import org.apache.juneau.rest.vars.RequestVar;
import org.apache.juneau.rest.vars.RestInfoVar;
import org.apache.juneau.rest.vars.SerializedRequestAttrVar;
import org.apache.juneau.rest.vars.ServletInitParamVar;
import org.apache.juneau.rest.vars.SwaggerVar;
import org.apache.juneau.rest.vars.UrlEncodeVar;
import org.apache.juneau.rest.vars.UrlVar;
import org.apache.juneau.rest.vars.WidgetVar;
import org.apache.juneau.rest.widget.Widget;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.uon.UonParser;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.utils.ClasspathResourceFinder;
import org.apache.juneau.utils.ClasspathResourceFinderBasic;
import org.apache.juneau.utils.ClasspathResourceManager;
import org.apache.juneau.utils.ExtendedMimetypesFileTypeMap;
import org.apache.juneau.utils.MessageBundle;
import org.apache.juneau.xml.XmlParser;

public final class RestContext
extends BeanContext {
    private static final String PREFIX = "RestContext.";
    public static final String REST_allowBodyParam = "RestContext.allowBodyParam.b";
    public static final String REST_allowedMethodParams = "RestContext.allowedMethodParams.s";
    public static final String REST_allowHeaderParams = "RestContext.allowHeaderParams.b";
    public static final String REST_callHandler = "RestContext.callHandler.o";
    public static final String REST_children = "RestContext.children.lo";
    public static final String REST_classpathResourceFinder = "RestContext.classpathResourceFinder.o";
    public static final String REST_clientVersionHeader = "RestContext.clientVersionHeader.s";
    public static final String REST_converters = "RestContext.converters.lo";
    public static final String REST_debug = "RestContext.debug.b";
    public static final String REST_defaultCharset = "RestContext.defaultCharset.s";
    public static final String REST_defaultRequestHeaders = "RestContext.defaultRequestHeaders.smo";
    public static final String REST_defaultResponseHeaders = "RestContext.defaultResponseHeaders.omo";
    public static final String REST_encoders = "RestContext.encoders.lo";
    public static final String REST_guards = "RestContext.guards.lo";
    public static final String REST_infoProvider = "RestContext.infoProvider.o";
    public static final String REST_logger = "RestContext.logger.o";
    public static final String REST_maxInput = "RestContext.maxInput.s";
    public static final String REST_messages = "RestContext.messages.lo";
    public static final String REST_mimeTypes = "RestContext.mimeTypes.ss";
    public static final String REST_paramResolvers = "RestContext.paramResolvers.lo";
    public static final String REST_parsers = "RestContext.parsers.lo";
    public static final String REST_partParser = "RestContext.partParser.o";
    public static final String REST_partSerializer = "RestContext.partSerializer.o";
    public static final String REST_path = "RestContext.path.s";
    public static final String REST_renderResponseStackTraces = "RestContext.renderResponseStackTraces.b";
    public static final String REST_resourceResolver = "RestContext.resourceResolver.o";
    public static final String REST_responseHandlers = "RestContext.responseHandlers.lo";
    public static final String REST_serializers = "RestContext.serializers.lo";
    public static final String REST_staticFileResponseHeaders = "RestContext.staticFileResponseHeaders.omo";
    public static final String REST_staticFiles = "RestContext.staticFiles.lo";
    public static final String REST_produces = "RestContext.produces.ls";
    public static final String REST_consumes = "RestContext.consumes.ls";
    public static final String REST_useClasspathResourceCaching = "RestContext.useClasspathResourceCaching.b";
    public static final String REST_useStackTraceHashes = "RestContext.useStackTraceHashes.b";
    public static final String REST_uriAuthority = "RestContext.uriAuthority.s";
    public static final String REST_uriContext = "RestContext.uriContext.s";
    public static final String REST_uriRelativity = "RestContext.uriRelativity.s";
    public static final String REST_uriResolution = "RestContext.uriResolution.s";
    public static final String REST_widgets = "RestContext.widgets.lo";
    private final Object resource;
    final RestContextBuilder builder;
    private final boolean allowHeaderParams;
    private final boolean allowBodyParam;
    private final boolean renderResponseStackTraces;
    private final boolean useStackTraceHashes;
    private final boolean useClasspathResourceCaching;
    private final boolean debug;
    private final String defaultCharset;
    private final String clientVersionHeader;
    private final String uriAuthority;
    private final String uriContext;
    private final long maxInput;
    final String fullPath;
    private final Map<String, Widget> widgets;
    private final Set<String> allowedMethodParams;
    private final RestContextProperties properties;
    private final Map<Class<?>, RestMethodParam> paramResolvers;
    private final SerializerGroup serializers;
    private final ParserGroup parsers;
    private final HttpPartSerializer partSerializer;
    private final HttpPartParser partParser;
    private final EncoderGroup encoders;
    private final List<MediaType> consumes;
    private final List<MediaType> produces;
    private final Map<String, Object> defaultRequestHeaders;
    private final Map<String, Object> defaultResponseHeaders;
    private final Map<String, Object> staticFileResponseHeaders;
    private final BeanContext beanContext;
    private final RestConverter[] converters;
    private final RestGuard[] guards;
    private final ResponseHandler[] responseHandlers;
    private final MimetypesFileTypeMap mimetypesFileTypeMap;
    private final StaticFileMapping[] staticFiles;
    private final String[] staticFilesPaths;
    private final MessageBundle msgs;
    private final Config config;
    private final VarResolver varResolver;
    private final Map<String, RestCallRouter> callRouters;
    private final Map<String, RestJavaMethod> callMethods;
    private final Map<String, RestContext> childResources;
    private final RestLogger logger;
    private final RestCallHandler callHandler;
    private final RestInfoProvider infoProvider;
    private final RestException initException;
    private final RestContext parentContext;
    private final RestResourceResolver resourceResolver;
    private final UriResolution uriResolution;
    private final UriRelativity uriRelativity;
    private final java.lang.reflect.Method[] postInitMethods;
    private final java.lang.reflect.Method[] postInitChildFirstMethods;
    private final java.lang.reflect.Method[] preCallMethods;
    private final java.lang.reflect.Method[] postCallMethods;
    private final java.lang.reflect.Method[] startCallMethods;
    private final java.lang.reflect.Method[] endCallMethods;
    private final java.lang.reflect.Method[] destroyMethods;
    private final RestMethodParam[][] preCallMethodParams;
    private final RestMethodParam[][] postCallMethodParams;
    private final Class<?>[][] postInitMethodParams;
    private final Class<?>[][] postInitChildFirstMethodParams;
    private final Class<?>[][] startCallMethodParams;
    private final Class<?>[][] endCallMethodParams;
    private final Class<?>[][] destroyMethodParams;
    private final Map<String, StaticFile> staticFilesCache = new ConcurrentHashMap<String, StaticFile>();
    private final ClasspathResourceManager staticResourceManager;
    private final ConcurrentHashMap<Integer, AtomicInteger> stackTraceHashes = new ConcurrentHashMap();
    private final ThreadLocal<RestRequest> req = new ThreadLocal();
    private final ThreadLocal<RestResponse> res = new ThreadLocal();

    public static RestContextBuilder create(Object resource) throws ServletException {
        return new RestContextBuilder(null, resource.getClass(), null).init(resource);
    }

    static RestContextBuilder create(ServletConfig servletConfig, Class<?> resourceClass, RestContext parentContext) throws ServletException {
        return new RestContextBuilder(servletConfig, resourceClass, parentContext);
    }

    RestContext(RestContextBuilder builder) throws Exception {
        super(builder.getPropertyStore());
        RestException _initException = null;
        try {
            ServletContext servletContext = builder.servletContext;
            this.resource = builder.resource;
            this.builder = builder;
            this.parentContext = builder.parentContext;
            this.resourceResolver = this.getInstanceProperty(REST_resourceResolver, this.resource, RestResourceResolver.class, this.parentContext == null ? BasicRestResourceResolver.class : this.parentContext.resourceResolver, ResourceResolver.FUZZY, this);
            PropertyStore ps = this.getPropertyStore().builder().add(builder.properties).build();
            Class<?> resourceClass = this.resource.getClass();
            this.uriContext = StringUtils.nullIfEmpty(this.getStringProperty(REST_uriContext, null));
            this.uriAuthority = StringUtils.nullIfEmpty(this.getStringProperty(REST_uriAuthority, null));
            this.uriResolution = this.getProperty(REST_uriResolution, UriResolution.class, UriResolution.ROOT_RELATIVE);
            this.uriRelativity = this.getProperty(REST_uriRelativity, UriRelativity.class, UriRelativity.RESOURCE);
            this.allowHeaderParams = this.getBooleanProperty(REST_allowHeaderParams, true);
            this.allowBodyParam = this.getBooleanProperty(REST_allowBodyParam, true);
            this.allowedMethodParams = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(StringUtils.split(this.getStringProperty(REST_allowedMethodParams, "HEAD,OPTIONS")))));
            this.renderResponseStackTraces = this.getBooleanProperty(REST_renderResponseStackTraces, false);
            this.useStackTraceHashes = this.getBooleanProperty(REST_useStackTraceHashes, true);
            this.debug = this.getBooleanProperty(REST_debug, super.isDebug());
            this.defaultCharset = this.getStringProperty(REST_defaultCharset, "utf-8");
            this.maxInput = this.getLongProperty(REST_maxInput, 100000000L);
            this.clientVersionHeader = this.getStringProperty(REST_clientVersionHeader, "X-Client-Version");
            this.converters = this.getInstanceArrayProperty(REST_converters, this.resource, RestConverter.class, new RestConverter[0], this.resourceResolver, this);
            this.guards = this.getInstanceArrayProperty(REST_guards, this.resource, RestGuard.class, new RestGuard[0], this.resourceResolver, this);
            this.responseHandlers = this.getInstanceArrayProperty(REST_responseHandlers, this.resource, ResponseHandler.class, new ResponseHandler[0], this.resourceResolver, this);
            HashMap _paramResolvers = new HashMap();
            for (RestMethodParam rp : this.getInstanceArrayProperty(REST_paramResolvers, RestMethodParam.class, new RestMethodParam[0], this.resourceResolver, this)) {
                _paramResolvers.put(rp.forClass(), rp);
            }
            this.paramResolvers = CollectionUtils.unmodifiableMap(_paramResolvers);
            TreeMap<String, String> _defaultRequestHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            _defaultRequestHeaders.putAll(this.getMapProperty(REST_defaultRequestHeaders, String.class));
            this.defaultRequestHeaders = CollectionUtils.unmodifiableMap(new LinkedHashMap(_defaultRequestHeaders));
            this.defaultResponseHeaders = this.getMapProperty(REST_defaultResponseHeaders, Object.class);
            this.staticFileResponseHeaders = this.getMapProperty(REST_staticFileResponseHeaders, Object.class);
            this.logger = this.getInstanceProperty(REST_logger, this.resource, RestLogger.class, NoOpRestLogger.class, this.resourceResolver, this);
            if (this.debug) {
                this.logger.setLevel(Level.FINE);
            }
            this.varResolver = builder.varResolverBuilder.vars(FileVar.class, LocalizationVar.class, RequestAttributeVar.class, RequestFormDataVar.class, RequestHeaderVar.class, RequestPathVar.class, RequestQueryVar.class, RequestVar.class, RestInfoVar.class, SerializedRequestAttrVar.class, ServletInitParamVar.class, SwaggerVar.class, UrlVar.class, UrlEncodeVar.class, WidgetVar.class).build();
            this.config = builder.config.resolving(this.varResolver.createSession());
            this.properties = builder.properties;
            this.serializers = SerializerGroup.create().append(this.getInstanceArrayProperty(REST_serializers, Serializer.class, new Serializer[0], this.resourceResolver, this.resource, ps)).build();
            this.parsers = ParserGroup.create().append(this.getInstanceArrayProperty(REST_parsers, Parser.class, new Parser[0], this.resourceResolver, this.resource, ps)).build();
            this.partSerializer = this.getInstanceProperty(REST_partSerializer, HttpPartSerializer.class, OpenApiSerializer.class, this.resourceResolver, this.resource, ps);
            this.partParser = this.getInstanceProperty(REST_partParser, HttpPartParser.class, OpenApiParser.class, this.resourceResolver, this.resource, ps);
            this.encoders = new EncoderGroupBuilder().append(this.getInstanceArrayProperty(REST_encoders, Encoder.class, new Encoder[0], this.resourceResolver, this.resource, ps)).build();
            this.beanContext = BeanContext.create().apply(ps).build();
            this.mimetypesFileTypeMap = new ExtendedMimetypesFileTypeMap();
            for (String mimeType : this.getArrayProperty(REST_mimeTypes, String.class)) {
                this.mimetypesFileTypeMap.addMimeTypes(mimeType);
            }
            ClasspathResourceFinder rf = this.getInstanceProperty(REST_classpathResourceFinder, ClasspathResourceFinder.class, ClasspathResourceFinderBasic.class, this.resourceResolver, this);
            this.useClasspathResourceCaching = this.getProperty(REST_useClasspathResourceCaching, Boolean.TYPE, true);
            this.staticResourceManager = new ClasspathResourceManager(resourceClass, rf, this.useClasspathResourceCaching);
            this.consumes = this.getListProperty(REST_consumes, MediaType.class, this.parsers.getSupportedMediaTypes());
            this.produces = this.getListProperty(REST_produces, MediaType.class, this.serializers.getSupportedMediaTypes());
            this.staticFiles = ArrayUtils.reverse(this.getArrayProperty(REST_staticFiles, StaticFileMapping.class));
            TreeSet<String> s = new TreeSet<String>();
            for (StaticFileMapping sfm : this.staticFiles) {
                s.add(sfm.path);
            }
            this.staticFilesPaths = s.toArray(new String[s.size()]);
            MessageBundleLocation[] mbl = this.getInstanceArrayProperty(REST_messages, MessageBundleLocation.class, new MessageBundleLocation[0]);
            if (mbl.length == 0) {
                this.msgs = new MessageBundle(resourceClass, "");
            } else {
                this.msgs = new MessageBundle(mbl[0] != null ? mbl[0].baseClass : resourceClass, mbl[0].bundlePath);
                for (int i = 1; i < mbl.length; ++i) {
                    this.msgs.addSearchPath(mbl[i] != null ? mbl[i].baseClass : resourceClass, mbl[i].bundlePath);
                }
            }
            this.fullPath = (builder.parentContext == null ? "" : builder.parentContext.fullPath + '/') + builder.path;
            this.childResources = Collections.synchronizedMap(new LinkedHashMap());
            LinkedHashMap<String, Widget> _widgets = new LinkedHashMap<String, Widget>();
            for (Widget w : this.getInstanceArrayProperty(REST_widgets, this.resource, Widget.class, new Widget[0], this.resourceResolver, ps)) {
                _widgets.put(w.getName(), w);
            }
            this.widgets = CollectionUtils.unmodifiableMap(_widgets);
            LinkedList<String> methodsFound = new LinkedList<String>();
            LinkedHashMap<String, RestCallRouter.Builder> routers = new LinkedHashMap<String, RestCallRouter.Builder>();
            LinkedHashMap<String, RestJavaMethod> _javaRestMethods = new LinkedHashMap<String, RestJavaMethod>();
            LinkedHashMap<String, java.lang.reflect.Method> _startCallMethods = new LinkedHashMap<String, java.lang.reflect.Method>();
            LinkedHashMap<String, java.lang.reflect.Method> _preCallMethods = new LinkedHashMap<String, java.lang.reflect.Method>();
            LinkedHashMap<String, java.lang.reflect.Method> _postCallMethods = new LinkedHashMap<String, java.lang.reflect.Method>();
            LinkedHashMap<String, java.lang.reflect.Method> _endCallMethods = new LinkedHashMap<String, java.lang.reflect.Method>();
            LinkedHashMap<String, java.lang.reflect.Method> _postInitMethods = new LinkedHashMap<String, java.lang.reflect.Method>();
            LinkedHashMap<String, java.lang.reflect.Method> _postInitChildFirstMethods = new LinkedHashMap<String, java.lang.reflect.Method>();
            LinkedHashMap<String, java.lang.reflect.Method> _destroyMethods = new LinkedHashMap<String, java.lang.reflect.Method>();
            ArrayList<RestMethodParam[]> _preCallMethodParams = new ArrayList<RestMethodParam[]>();
            ArrayList<RestMethodParam[]> _postCallMethodParams = new ArrayList<RestMethodParam[]>();
            ArrayList<Class<?>[]> _startCallMethodParams = new ArrayList<Class<?>[]>();
            ArrayList<Class<?>[]> _endCallMethodParams = new ArrayList<Class<?>[]>();
            ArrayList<Class<?>[]> _postInitMethodParams = new ArrayList<Class<?>[]>();
            ArrayList<Class<?>[]> _postInitChildFirstMethodParams = new ArrayList<Class<?>[]>();
            ArrayList<Class<?>[]> _destroyMethodParams = new ArrayList<Class<?>[]>();
            for (java.lang.reflect.Method method : resourceClass.getMethods()) {
                RestMethod a = ClassUtils.getAnnotation(RestMethod.class, method);
                if (a == null) continue;
                methodsFound.add(method.getName() + "," + StringUtils.emptyIfNull(StringUtils.firstNonEmpty(a.name(), a.method())) + "," + a.path());
                try {
                    if (!ClassUtils.isPublic(method)) {
                        throw new RestServletException("@RestMethod method {0}.{1} must be defined as public.", resourceClass.getName(), method.getName());
                    }
                    RestJavaMethod sm = new RestJavaMethod(this.resource, method, this);
                    String httpMethod = sm.getHttpMethod();
                    if ("RRPC".equals(httpMethod)) {
                        ClassMeta interfaceClass = this.beanContext.getClassMeta(method.getGenericReturnType(), new Type[0]);
                        final RemoteInterfaceMeta rim = new RemoteInterfaceMeta(interfaceClass.getInnerClass(), null);
                        if (rim.getMethodsByPath().isEmpty()) {
                            throw new RestException(500, "Method {0} returns an interface {1} that doesn't define any remote methods.", ClassUtils.getMethodSignature(method), interfaceClass.getReadableName());
                        }
                        sm = new RestJavaMethod(this.resource, method, this){

                            @Override
                            int invoke(String pathInfo, RestRequest req, RestResponse res) throws Throwable {
                                int rc = super.invoke(pathInfo, req, res);
                                if (rc != 200) {
                                    return rc;
                                }
                                Object o = res.getOutput();
                                if ("GET".equals(req.getMethod())) {
                                    res.setOutput(rim.getMethodsByPath().keySet());
                                    return 200;
                                }
                                if ("POST".equals(req.getMethod())) {
                                    RemoteInterfaceMethod rmm;
                                    if (pathInfo.indexOf(47) != -1) {
                                        pathInfo = pathInfo.substring(pathInfo.lastIndexOf(47) + 1);
                                    }
                                    if ((rmm = rim.getMethodMetaByPath(pathInfo = StringUtils.urlDecode(pathInfo))) != null) {
                                        java.lang.reflect.Method m = rmm.getJavaMethod();
                                        try {
                                            Parser p = req.getBody().getParser();
                                            Object[] args = null;
                                            if (m.getGenericParameterTypes().length == 0) {
                                                args = new Object[]{};
                                            } else {
                                                try (BufferedReader in = p.isReaderParser() ? req.getReader() : req.getInputStream();){
                                                    args = p.parseArgs(in, m.getGenericParameterTypes());
                                                }
                                            }
                                            Object output = m.invoke(o, args);
                                            res.setOutput(output);
                                            return 200;
                                        }
                                        catch (Exception e) {
                                            throw new InternalServerError(e);
                                        }
                                    }
                                }
                                return 404;
                            }
                        };
                        _javaRestMethods.put(method.getName(), sm);
                        RestContext.addToRouter(routers, "GET", sm);
                        RestContext.addToRouter(routers, "POST", sm);
                        continue;
                    }
                    _javaRestMethods.put(method.getName(), sm);
                    RestContext.addToRouter(routers, httpMethod, sm);
                }
                catch (Throwable e) {
                    throw new RestServletException("Problem occurred trying to serialize methods on class {0}, methods={1}", resourceClass.getName(), SimpleJsonSerializer.DEFAULT.serialize(methodsFound)).initCause(e);
                }
            }
            for (java.lang.reflect.Method m : ClassUtils.getAllMethods(resourceClass, true)) {
                if (!ClassUtils.isPublic(m) || !m.isAnnotationPresent(RestHook.class)) continue;
                HookEvent he = m.getAnnotation(RestHook.class).value();
                String sig = ClassUtils.getMethodSignature(m);
                switch (he) {
                    case PRE_CALL: {
                        if (_preCallMethods.containsKey(sig)) break;
                        ClassUtils.setAccessible(m, false);
                        _preCallMethods.put(sig, m);
                        _preCallMethodParams.add(this.findParams(m, true, null));
                        break;
                    }
                    case POST_CALL: {
                        if (_postCallMethods.containsKey(sig)) break;
                        ClassUtils.setAccessible(m, false);
                        _postCallMethods.put(sig, m);
                        _postCallMethodParams.add(this.findParams(m, true, null));
                        break;
                    }
                    case START_CALL: {
                        if (_startCallMethods.containsKey(sig)) break;
                        ClassUtils.setAccessible(m, false);
                        _startCallMethods.put(sig, m);
                        _startCallMethodParams.add(m.getParameterTypes());
                        ClassUtils.assertArgsOfType(m, HttpServletRequest.class, HttpServletResponse.class);
                        break;
                    }
                    case END_CALL: {
                        if (_endCallMethods.containsKey(sig)) break;
                        ClassUtils.setAccessible(m, false);
                        _endCallMethods.put(sig, m);
                        _endCallMethodParams.add(m.getParameterTypes());
                        ClassUtils.assertArgsOfType(m, HttpServletRequest.class, HttpServletResponse.class);
                        break;
                    }
                    case POST_INIT: {
                        if (_postInitMethods.containsKey(sig)) break;
                        ClassUtils.setAccessible(m, false);
                        _postInitMethods.put(sig, m);
                        _postInitMethodParams.add(m.getParameterTypes());
                        ClassUtils.assertArgsOfType(m, RestContext.class);
                        break;
                    }
                    case POST_INIT_CHILD_FIRST: {
                        if (_postInitChildFirstMethods.containsKey(sig)) break;
                        ClassUtils.setAccessible(m, false);
                        _postInitChildFirstMethods.put(sig, m);
                        _postInitChildFirstMethodParams.add(m.getParameterTypes());
                        ClassUtils.assertArgsOfType(m, RestContext.class);
                        break;
                    }
                    case DESTROY: {
                        if (_destroyMethods.containsKey(sig)) break;
                        ClassUtils.setAccessible(m, false);
                        _destroyMethods.put(sig, m);
                        _destroyMethodParams.add(m.getParameterTypes());
                        ClassUtils.assertArgsOfType(m, RestContext.class);
                        break;
                    }
                }
            }
            this.callMethods = CollectionUtils.unmodifiableMap(_javaRestMethods);
            this.preCallMethods = _preCallMethods.values().toArray(new java.lang.reflect.Method[_preCallMethods.size()]);
            this.postCallMethods = _postCallMethods.values().toArray(new java.lang.reflect.Method[_postCallMethods.size()]);
            this.startCallMethods = _startCallMethods.values().toArray(new java.lang.reflect.Method[_startCallMethods.size()]);
            this.endCallMethods = _endCallMethods.values().toArray(new java.lang.reflect.Method[_endCallMethods.size()]);
            this.postInitMethods = _postInitMethods.values().toArray(new java.lang.reflect.Method[_postInitMethods.size()]);
            this.postInitChildFirstMethods = _postInitChildFirstMethods.values().toArray(new java.lang.reflect.Method[_postInitChildFirstMethods.size()]);
            this.destroyMethods = _destroyMethods.values().toArray(new java.lang.reflect.Method[_destroyMethods.size()]);
            this.preCallMethodParams = (RestMethodParam[][])_preCallMethodParams.toArray((T[])new RestMethodParam[_preCallMethodParams.size()][]);
            this.postCallMethodParams = (RestMethodParam[][])_postCallMethodParams.toArray((T[])new RestMethodParam[_postCallMethodParams.size()][]);
            this.startCallMethodParams = (Class[][])_startCallMethodParams.toArray((T[])new Class[_startCallMethodParams.size()][]);
            this.endCallMethodParams = (Class[][])_endCallMethodParams.toArray((T[])new Class[_endCallMethodParams.size()][]);
            this.postInitMethodParams = (Class[][])_postInitMethodParams.toArray((T[])new Class[_postInitMethodParams.size()][]);
            this.postInitChildFirstMethodParams = (Class[][])_postInitChildFirstMethodParams.toArray((T[])new Class[_postInitChildFirstMethodParams.size()][]);
            this.destroyMethodParams = (Class[][])_destroyMethodParams.toArray((T[])new Class[_destroyMethodParams.size()][]);
            LinkedHashMap<String, RestCallRouter> _callRouters = new LinkedHashMap<String, RestCallRouter>();
            for (RestCallRouter.Builder crb : routers.values()) {
                _callRouters.put(crb.getHttpMethodName(), crb.build());
            }
            this.callRouters = CollectionUtils.unmodifiableMap(_callRouters);
            for (Object o : this.getArrayProperty(REST_children, Object.class)) {
                String path = null;
                Object r = null;
                if (o instanceof RestChild) {
                    RestChild rc = (RestChild)o;
                    path = rc.path;
                    r = rc.resource;
                } else if (o instanceof Class) {
                    Class c = (Class)o;
                    if (c == builder.resourceClass) continue;
                    r = c;
                } else {
                    r = o;
                }
                RestContextBuilder childBuilder = null;
                if (o instanceof Class) {
                    Class oc = (Class)o;
                    childBuilder = RestContext.create(builder.inner, oc, this);
                    r = this.resourceResolver.resolve(this.resource, oc, childBuilder, new Object[0]);
                } else {
                    r = o;
                    childBuilder = RestContext.create(builder.inner, o.getClass(), this);
                }
                childBuilder.init(r);
                if (r instanceof RestServlet) {
                    ((RestServlet)((Object)r)).innerInit(childBuilder);
                }
                childBuilder.servletContext(servletContext);
                RestContext rc2 = childBuilder.build();
                if (r instanceof RestServlet) {
                    ((RestServlet)((Object)r)).setContext(rc2);
                }
                path = childBuilder.path;
                this.childResources.put(path, rc2);
            }
            this.callHandler = this.getInstanceProperty(REST_callHandler, this.resource, RestCallHandler.class, BasicRestCallHandler.class, this.resourceResolver, this);
            this.infoProvider = this.getInstanceProperty(REST_infoProvider, this.resource, RestInfoProvider.class, BasicRestInfoProvider.class, this.resourceResolver, this);
        }
        catch (RestException e) {
            _initException = e;
            throw e;
        }
        catch (Exception e) {
            _initException = new RestException(e, 500);
            throw e;
        }
        finally {
            this.initException = _initException;
        }
    }

    private static void addToRouter(Map<String, RestCallRouter.Builder> routers, String httpMethodName, RestJavaMethod cm) throws RestServletException {
        if (!routers.containsKey(httpMethodName)) {
            routers.put(httpMethodName, new RestCallRouter.Builder(httpMethodName));
        }
        routers.get(httpMethodName).add(cm);
    }

    protected RestResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public VarResolver getVarResolver() {
        return this.varResolver;
    }

    public Config getConfig() {
        return this.config;
    }

    protected StaticFile resolveStaticFile(String pathInfo) throws NotFound, IOException {
        if (!this.staticFilesCache.containsKey(pathInfo)) {
            String p = StringUtils.urlDecode(StringUtils.trimSlashes(pathInfo));
            if (p.indexOf("..") != -1) {
                throw new NotFound("Invalid path");
            }
            StreamResource sr = null;
            for (StaticFileMapping sfm : this.staticFiles) {
                String remainder;
                String path = sfm.path;
                if (!p.startsWith(path)) continue;
                String string = remainder = p.equals(path) ? "" : p.substring(path.length());
                if (!remainder.isEmpty() && !remainder.startsWith("/")) continue;
                String p2 = sfm.location + remainder;
                try (InputStream is = this.getClasspathResource(sfm.resourceClass, p2, null);){
                    if (is == null) continue;
                    int i = p2.lastIndexOf(47);
                    String name = i == -1 ? p2 : p2.substring(i + 1);
                    String mediaType = this.mimetypesFileTypeMap.getContentType(name);
                    Map<String, Object> responseHeaders = sfm.responseHeaders != null ? sfm.responseHeaders : this.staticFileResponseHeaders;
                    sr = new StreamResource(MediaType.forString(mediaType), responseHeaders, true, is);
                    break;
                }
            }
            StaticFile sf = new StaticFile(sr);
            if (this.useClasspathResourceCaching) {
                if (this.staticFilesCache.size() > 100) {
                    this.staticFilesCache.clear();
                }
                this.staticFilesCache.put(pathInfo, sf);
            }
            return sf;
        }
        return this.staticFilesCache.get(pathInfo);
    }

    public InputStream getClasspathResource(String name, Locale locale) throws IOException {
        return this.staticResourceManager.getStream(name, locale);
    }

    public InputStream getClasspathResource(Class<?> baseClass, String name, Locale locale) throws IOException {
        return this.staticResourceManager.getStream(baseClass, name, locale);
    }

    public String getClasspathResourceAsString(String name, Locale locale) throws IOException {
        return this.staticResourceManager.getString(name, locale);
    }

    public String getClasspathResourceAsString(Class<?> baseClass, String name, Locale locale) throws IOException {
        return this.staticResourceManager.getString(baseClass, name, locale);
    }

    public <T> T getClasspathResource(Class<T> c, MediaType mediaType, String name, Locale locale) throws IOException, ServletException {
        return this.getClasspathResource(null, c, mediaType, name, locale);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T getClasspathResource(Class<?> baseClass, Class<T> c, MediaType mediaType, String name, Locale locale) throws IOException, ServletException {
        InputStream is = this.getClasspathResource(baseClass, name, locale);
        if (is == null) {
            return null;
        }
        try {
            Parser p = this.parsers.getParser(mediaType);
            if (p == null) {
                if (mediaType == MediaType.JSON) {
                    p = JsonParser.DEFAULT;
                }
                if (mediaType == MediaType.XML) {
                    p = XmlParser.DEFAULT;
                }
                if (mediaType == MediaType.HTML) {
                    p = HtmlParser.DEFAULT;
                }
                if (mediaType == MediaType.UON) {
                    p = UonParser.DEFAULT;
                }
                if (mediaType == MediaType.URLENCODING) {
                    p = UrlEncodingParser.DEFAULT;
                }
                if (mediaType == MediaType.MSGPACK) {
                    p = MsgPackParser.DEFAULT;
                }
            }
            if (p == null) throw new ServletException("Unknown media type '" + mediaType + "'");
            try (Closeable in = p.isReaderParser() ? new InputStreamReader(is, IOUtils.UTF8) : is;){
                T t = p.parse((Object)in, c);
                return t;
            }
            catch (ParseException e) {
                throw new ServletException("Could not parse resource '" + name + " as media type '" + mediaType + "'.", (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new ServletException("Could not parse resource with name '" + name + "'", (Throwable)e);
        }
    }

    public String getPath() {
        return this.fullPath;
    }

    public Map<String, Widget> getWidgets() {
        return this.widgets;
    }

    public RestLogger getLogger() {
        return this.logger;
    }

    public MessageBundle getMessages() {
        return this.msgs;
    }

    public RestInfoProvider getInfoProvider() {
        return this.infoProvider;
    }

    public RestCallHandler getCallHandler() {
        return this.callHandler;
    }

    protected Map<String, RestCallRouter> getCallRouters() {
        return this.callRouters;
    }

    public Object getResource() {
        return this.resource;
    }

    public RestServlet getRestServlet() {
        return this.resource instanceof RestServlet ? (RestServlet)((Object)this.resource) : null;
    }

    protected void checkForInitException() throws RestException {
        if (this.initException != null) {
            throw this.initException;
        }
    }

    public RestContext getParentContext() {
        return this.parentContext;
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    public RestContextProperties getProperties() {
        return this.properties;
    }

    public SerializerGroup getSerializers() {
        return this.serializers;
    }

    public ParserGroup getParsers() {
        return this.parsers;
    }

    public String getServletInitParameter(String name) {
        return this.builder.getInitParameter(name);
    }

    public Map<String, RestContext> getChildResources() {
        return Collections.unmodifiableMap(this.childResources);
    }

    public int getStackTraceOccurrence(Throwable e) {
        if (!this.useStackTraceHashes) {
            return 0;
        }
        int h = e.hashCode();
        this.stackTraceHashes.putIfAbsent(h, new AtomicInteger());
        return this.stackTraceHashes.get(h).incrementAndGet();
    }

    public boolean isRenderResponseStackTraces() {
        return this.renderResponseStackTraces;
    }

    public boolean isAllowHeaderParams() {
        return this.allowHeaderParams;
    }

    public boolean isAllowBodyParam() {
        return this.allowBodyParam;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    public String getDefaultCharset() {
        return this.defaultCharset;
    }

    public long getMaxInput() {
        return this.maxInput;
    }

    public String getClientVersionHeader() {
        return this.clientVersionHeader;
    }

    public boolean allowMethodParam(String m) {
        return StringUtils.isNotEmpty(m) && (this.allowedMethodParams.contains(m) || this.allowedMethodParams.contains("*"));
    }

    public HttpPartParser getPartParser() {
        return this.partParser;
    }

    public HttpPartSerializer getPartSerializer() {
        return this.partSerializer;
    }

    public EncoderGroup getEncoders() {
        return this.encoders;
    }

    public List<MediaType> getProduces() {
        return this.produces;
    }

    public List<MediaType> getConsumes() {
        return this.consumes;
    }

    public Map<String, Object> getDefaultRequestHeaders() {
        return this.defaultRequestHeaders;
    }

    public Map<String, Object> getDefaultResponseHeaders() {
        return this.defaultResponseHeaders;
    }

    public RestConverter[] getConverters() {
        return this.converters;
    }

    public RestGuard[] getGuards() {
        return this.guards;
    }

    protected ResponseHandler[] getResponseHandlers() {
        return this.responseHandlers;
    }

    public boolean hasChildResources() {
        return !this.childResources.isEmpty();
    }

    public RestContext getChildResource(String path) {
        return this.childResources.get(path);
    }

    public String getUriAuthority() {
        if (this.uriAuthority != null) {
            return this.uriAuthority;
        }
        if (this.parentContext != null) {
            return this.parentContext.getUriAuthority();
        }
        return null;
    }

    public String getUriContext() {
        if (this.uriContext != null) {
            return this.uriContext;
        }
        if (this.parentContext != null) {
            return this.parentContext.getUriContext();
        }
        return null;
    }

    public UriRelativity getUriRelativity() {
        return this.uriRelativity;
    }

    public UriResolution getUriResolution() {
        return this.uriResolution;
    }

    public RestMethodParam[] getRestMethodParams(java.lang.reflect.Method method) {
        return this.callMethods.get((Object)method.getName()).methodParams;
    }

    public String getMediaTypeForName(String name) {
        return this.mimetypesFileTypeMap.getContentType(name);
    }

    public boolean isStaticFile(String p) {
        return StringUtils.pathStartsWith(p, this.staticFilesPaths);
    }

    public Map<String, RestJavaMethod> getCallMethods() {
        return this.callMethods;
    }

    protected RestMethodParam[] findParams(java.lang.reflect.Method method, boolean isPreOrPost, UrlPathPattern pathPattern) throws ServletException {
        Type[] pt = method.getGenericParameterTypes();
        RestMethodParam[] rp = new RestMethodParam[pt.length];
        PropertyStore ps = this.getPropertyStore();
        for (int i = 0; i < pt.length; ++i) {
            Type t = pt[i];
            if (t instanceof Class) {
                Class c = (Class)t;
                rp[i] = this.paramResolvers.get(c);
                if (rp[i] == null) {
                    rp[i] = RestParamDefaults.STANDARD_RESOLVERS.get(c);
                }
            }
            if (ClassUtils.hasAnnotation(Header.class, method, i)) {
                rp[i] = new RestParamDefaults.HeaderObject(method, i, ps);
            } else if (ClassUtils.hasAnnotation(Query.class, method, i)) {
                rp[i] = new RestParamDefaults.QueryObject(method, i, ps);
            } else if (ClassUtils.hasAnnotation(FormData.class, method, i)) {
                rp[i] = new RestParamDefaults.FormDataObject(method, i, ps);
            } else if (ClassUtils.hasAnnotation(Path.class, method, i)) {
                rp[i] = new RestParamDefaults.PathObject(method, i, ps, pathPattern);
            } else if (ClassUtils.hasAnnotation(Body.class, method, i)) {
                rp[i] = new RestParamDefaults.BodyObject(method, i, ps);
            } else if (ClassUtils.hasAnnotation(Request.class, method, i)) {
                rp[i] = new RestParamDefaults.RequestObject(method, i, ps);
            } else if (ClassUtils.hasAnnotation(Response.class, method, i)) {
                rp[i] = new RestParamDefaults.ResponseObject(method, i, ps);
            } else if (ClassUtils.hasAnnotation(ResponseHeader.class, method, i)) {
                rp[i] = new RestParamDefaults.ResponseHeaderObject(method, i, ps);
            } else if (ClassUtils.hasAnnotation(ResponseStatus.class, method, i)) {
                rp[i] = new RestParamDefaults.ResponseStatusObject(method, t);
            } else if (ClassUtils.hasAnnotation(HasFormData.class, method, i)) {
                rp[i] = new RestParamDefaults.HasFormDataObject(method, i);
            } else if (ClassUtils.hasAnnotation(HasQuery.class, method, i)) {
                rp[i] = new RestParamDefaults.HasQueryObject(method, i);
            } else if (ClassUtils.hasAnnotation(Method.class, method, i)) {
                rp[i] = new RestParamDefaults.MethodObject(method, t);
            }
            if (rp[i] != null || isPreOrPost) continue;
            throw new RestServletException("Invalid parameter specified for method ''{0}'' at index position {1}", method, i);
        }
        return rp;
    }

    void preCall(RestRequest req, RestResponse res) throws RestException {
        for (int i = 0; i < this.preCallMethods.length; ++i) {
            RestContext.preOrPost(this.resource, this.preCallMethods[i], this.preCallMethodParams[i], req, res);
        }
    }

    void postCall(RestRequest req, RestResponse res) throws RestException {
        for (int i = 0; i < this.postCallMethods.length; ++i) {
            RestContext.preOrPost(this.resource, this.postCallMethods[i], this.postCallMethodParams[i], req, res);
        }
    }

    private static void preOrPost(Object resource, java.lang.reflect.Method m, RestMethodParam[] mp, RestRequest req, RestResponse res) throws RestException {
        if (m != null) {
            Object[] args = new Object[mp.length];
            for (int i = 0; i < mp.length; ++i) {
                try {
                    args[i] = mp[i].resolve(req, res);
                    continue;
                }
                catch (RestException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BadRequest((Throwable)e, "Invalid data conversion.  Could not convert {0} ''{1}'' to type ''{2}'' on method ''{3}.{4}''.", mp[i].getParamType().name(), mp[i].getName(), mp[i].getType(), m.getDeclaringClass().getName(), m.getName());
                }
            }
            try {
                m.invoke(resource, args);
            }
            catch (RestException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InternalServerError(e);
            }
        }
    }

    void startCall(HttpServletRequest req, HttpServletResponse res) {
        for (int i = 0; i < this.startCallMethods.length; ++i) {
            RestContext.startOrFinish(this.resource, this.startCallMethods[i], this.startCallMethodParams[i], req, res);
        }
    }

    void finishCall(HttpServletRequest req, HttpServletResponse res) {
        for (int i = 0; i < this.endCallMethods.length; ++i) {
            RestContext.startOrFinish(this.resource, this.endCallMethods[i], this.endCallMethodParams[i], req, res);
        }
    }

    private static void startOrFinish(Object resource, java.lang.reflect.Method m, Class<?>[] p, HttpServletRequest req, HttpServletResponse res) throws RestException, InternalServerError {
        if (m != null) {
            Object[] args = new Object[p.length];
            for (int i = 0; i < p.length; ++i) {
                if (p[i] == HttpServletRequest.class) {
                    args[i] = req;
                    continue;
                }
                if (p[i] != HttpServletResponse.class) continue;
                args[i] = res;
            }
            try {
                m.invoke(resource, args);
            }
            catch (RestException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InternalServerError(e);
            }
        }
    }

    public RestContext postInit() throws ServletException {
        for (int i = 0; i < this.postInitMethods.length; ++i) {
            this.postInitOrDestroy(this.resource, this.postInitMethods[i], this.postInitMethodParams[i]);
        }
        for (RestContext childContext : this.childResources.values()) {
            childContext.postInit();
        }
        return this;
    }

    public RestContext postInitChildFirst() throws ServletException {
        for (RestContext childContext : this.childResources.values()) {
            childContext.postInitChildFirst();
        }
        for (int i = 0; i < this.postInitChildFirstMethods.length; ++i) {
            this.postInitOrDestroy(this.resource, this.postInitChildFirstMethods[i], this.postInitChildFirstMethodParams[i]);
        }
        return this;
    }

    private void postInitOrDestroy(Object r, java.lang.reflect.Method m, Class<?>[] p) {
        if (m != null) {
            Object[] args = new Object[p.length];
            for (int i = 0; i < p.length; ++i) {
                if (p[i] == RestContext.class) {
                    args[i] = this;
                    continue;
                }
                if (p[i] == RestContextBuilder.class) {
                    args[i] = this.builder;
                    continue;
                }
                if (p[i] != ServletConfig.class) continue;
                args[i] = this.builder.inner;
            }
            try {
                m.invoke(r, args);
            }
            catch (RestException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InternalServerError(e);
            }
        }
    }

    protected void destroy() {
        for (int i = 0; i < this.destroyMethods.length; ++i) {
            try {
                this.postInitOrDestroy(this.resource, this.destroyMethods[i], this.destroyMethodParams[i]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (RestContext r : this.childResources.values()) {
            r.destroy();
            if (!(r.resource instanceof Servlet)) continue;
            ((Servlet)r.resource).destroy();
        }
    }

    @Override
    public BeanSession createSession(BeanSessionArgs args) {
        throw new NoSuchMethodError();
    }

    @Override
    public BeanSessionArgs createDefaultSessionArgs() {
        throw new NoSuchMethodError();
    }

    public RestRequest getRequest() {
        return this.req.get();
    }

    void setRequest(RestRequest req) {
        if (this.req.get() != null) {
            System.err.println("WARNING:  Thread-local request object was not cleaned up from previous request.  " + this + ", thread=[" + Thread.currentThread().getId() + "]");
        }
        this.req.set(req);
    }

    public RestResponse getResponse() {
        return this.res.get();
    }

    void setResponse(RestResponse res) {
        if (this.res.get() != null) {
            System.err.println("WARNING:  Thread-local response object was not cleaned up from previous request.  " + this + ", thread=[" + Thread.currentThread().getId() + "]");
        }
        this.res.set(res);
    }

    void clearState() {
        this.req.remove();
        this.res.remove();
    }

    @Override
    public String toString() {
        Object r = this.getResource();
        return "RestContext: hashCode=[" + System.identityHashCode(this) + "], resource=[" + (r == null ? null : r.getClass() + "," + System.identityHashCode(r)) + "]";
    }

    protected class StaticFile {
        StreamResource resource;
        ResponseBeanMeta meta;

        protected StaticFile(StreamResource resource) {
            this.resource = resource;
            this.meta = resource == null ? null : ResponseBeanMeta.create(resource.getClass(), RestContext.this.getPropertyStore());
        }
    }
}

