/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.BinaryFormat;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParserReader;
import org.apache.juneau.parser.Position;
import org.apache.juneau.parser.Positionable;

public final class ParserPipe
implements Closeable {
    private final Object input;
    final boolean debug;
    final boolean strict;
    final boolean autoCloseStreams;
    final boolean unbuffered;
    private final String fileCharset;
    private final String inputStreamCharset;
    private String inputString;
    private InputStream inputStream;
    private Reader reader;
    private ParserReader parserReader;
    private boolean doClose;
    private BinaryFormat binaryFormat;
    private Positionable positionable;

    public ParserPipe(Object input, boolean debug, boolean strict, boolean autoCloseStreams, boolean unbuffered, String fileCharset, String inputStreamCharset) {
        this.input = input;
        this.debug = debug;
        this.strict = strict;
        this.autoCloseStreams = autoCloseStreams;
        this.unbuffered = unbuffered;
        this.fileCharset = fileCharset;
        this.inputStreamCharset = inputStreamCharset;
        if (input instanceof CharSequence) {
            this.inputString = input.toString();
        }
        this.binaryFormat = null;
    }

    public ParserPipe(Object input, boolean debug, boolean autoCloseStreams, boolean unbuffered, BinaryFormat binaryFormat) {
        this.input = input;
        this.debug = debug;
        this.strict = false;
        this.autoCloseStreams = autoCloseStreams;
        this.unbuffered = unbuffered;
        this.fileCharset = null;
        this.inputStreamCharset = null;
        if (input instanceof CharSequence) {
            this.inputString = input.toString();
        }
        this.binaryFormat = binaryFormat;
    }

    public ParserPipe(Object input) {
        this(input, false, false, false, false, null, null);
    }

    public InputStream getInputStream() throws IOException {
        if (this.input == null) {
            return null;
        }
        if (this.input instanceof InputStream) {
            if (this.debug) {
                byte[] b = IOUtils.readBytes((InputStream)this.input, 1024);
                this.inputString = StringUtils.toHex(b);
                this.inputStream = new ByteArrayInputStream(b);
            } else {
                this.inputStream = (InputStream)this.input;
                this.doClose = this.autoCloseStreams;
            }
        } else if (this.input instanceof byte[]) {
            if (this.debug) {
                this.inputString = StringUtils.toHex((byte[])this.input);
            }
            this.inputStream = new ByteArrayInputStream((byte[])this.input);
            this.doClose = false;
        } else if (this.input instanceof String) {
            this.inputString = (String)this.input;
            this.inputStream = new ByteArrayInputStream(this.convertFromString((String)this.input));
            this.doClose = false;
        } else if (this.input instanceof File) {
            if (this.debug) {
                byte[] b = IOUtils.readBytes((File)this.input);
                this.inputString = StringUtils.toHex(b);
                this.inputStream = new ByteArrayInputStream(b);
            } else {
                this.inputStream = new FileInputStream((File)this.input);
                this.doClose = true;
            }
        } else {
            throw new IOException("Cannot convert object of type " + this.input.getClass().getName() + " to an InputStream.");
        }
        return this.inputStream;
    }

    private byte[] convertFromString(String in) {
        switch (this.binaryFormat) {
            case BASE64: {
                return StringUtils.base64Decode(in);
            }
            case HEX: {
                return StringUtils.fromHex(in);
            }
            case SPACED_HEX: {
                return StringUtils.fromSpacedHex(in);
            }
        }
        return new byte[0];
    }

    public Reader getReader() throws IOException {
        if (this.input == null) {
            return null;
        }
        if (this.input instanceof Reader) {
            if (this.debug) {
                this.inputString = IOUtils.read((Reader)this.input);
                this.reader = new StringReader(this.inputString);
            } else {
                this.reader = (Reader)this.input;
                this.doClose = this.autoCloseStreams;
            }
        } else if (this.input instanceof CharSequence) {
            this.inputString = this.input.toString();
            this.reader = new ParserReader(this);
            this.doClose = false;
        } else if (this.input instanceof InputStream || this.input instanceof byte[]) {
            this.doClose = this.input instanceof InputStream && this.autoCloseStreams;
            InputStream is = this.input instanceof InputStream ? (InputStream)this.input : new ByteArrayInputStream((byte[])this.input);
            CharsetDecoder cd = ("default".equalsIgnoreCase(this.inputStreamCharset) ? Charset.defaultCharset() : Charset.forName(this.inputStreamCharset)).newDecoder();
            if (this.strict) {
                cd.onMalformedInput(CodingErrorAction.REPORT);
                cd.onUnmappableCharacter(CodingErrorAction.REPORT);
            } else {
                cd.onMalformedInput(CodingErrorAction.REPLACE);
                cd.onUnmappableCharacter(CodingErrorAction.REPLACE);
            }
            this.reader = new InputStreamReader(is, cd);
            if (this.debug) {
                this.inputString = IOUtils.read(this.reader);
                this.reader = new StringReader(this.inputString);
            }
        } else if (this.input instanceof File) {
            CharsetDecoder cd = ("DEFAULT".equalsIgnoreCase(this.fileCharset) ? Charset.defaultCharset() : Charset.forName(this.fileCharset)).newDecoder();
            if (this.strict) {
                cd.onMalformedInput(CodingErrorAction.REPORT);
                cd.onUnmappableCharacter(CodingErrorAction.REPORT);
            } else {
                cd.onMalformedInput(CodingErrorAction.REPLACE);
                cd.onUnmappableCharacter(CodingErrorAction.REPLACE);
            }
            this.reader = new InputStreamReader((InputStream)new FileInputStream((File)this.input), cd);
            if (this.debug) {
                this.inputString = IOUtils.read(this.reader);
                this.reader = new StringReader(this.inputString);
            }
            this.doClose = true;
        } else {
            throw new IOException("Cannot convert object of type " + this.input.getClass().getName() + " to a Reader.");
        }
        return this.reader;
    }

    public Reader getBufferedReader() throws Exception {
        return IOUtils.getBufferedReader(this.getReader());
    }

    public String getInputAsString() {
        return this.inputString;
    }

    public ParserReader getParserReader() throws Exception {
        if (this.input == null) {
            return null;
        }
        this.parserReader = this.input instanceof ParserReader ? (ParserReader)this.input : new ParserReader(this);
        return this.parserReader;
    }

    public boolean isString() {
        return this.inputString != null;
    }

    public void setPositionable(Positionable positionable) {
        this.positionable = positionable;
    }

    Position getPosition() {
        if (this.positionable == null) {
            return Position.UNKNOWN;
        }
        Position p = this.positionable.getPosition();
        if (p == null) {
            return Position.UNKNOWN;
        }
        return p;
    }

    @Override
    public void close() {
        try {
            if (this.doClose) {
                IOUtils.close(this.reader, this.inputStream);
            }
        }
        catch (IOException e) {
            throw new BeanRuntimeException(e);
        }
    }
}

