/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.internal.IOUtils;

public class ByteArrayCache {
    public static final ByteArrayCache DEFAULT = new ByteArrayCache();
    private final ConcurrentHashMap<ByteArray, byte[]> cache = new ConcurrentHashMap();

    public byte[] cache(byte[] contents) {
        if (contents == null) {
            return null;
        }
        ByteArray ba = new ByteArray(contents);
        this.cache.putIfAbsent(ba, ba.contents);
        return this.cache.get(ba);
    }

    public byte[] cache(InputStream contents) throws IOException {
        if (contents == null) {
            return null;
        }
        ByteArray ba = new ByteArray(IOUtils.readBytes(contents, 1024));
        this.cache.putIfAbsent(ba, ba.contents);
        return this.cache.get(ba);
    }

    public int size() {
        return this.cache.size();
    }

    static final class ByteArray {
        int hashCode;
        byte[] contents;

        ByteArray(byte[] contents) {
            this.contents = contents;
            int multiplier = 1;
            for (int i = 0; i < contents.length; ++i) {
                this.hashCode += contents[i] * multiplier;
                int shifted = multiplier << 5;
                multiplier = shifted - multiplier;
            }
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                // empty if block
            }
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o instanceof ByteArray) {
                ByteArray ba = (ByteArray)o;
                if (ba.hashCode == this.hashCode) {
                    return Arrays.equals(ba.contents, this.contents);
                }
            }
            return false;
        }
    }
}

