/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;

public final class BeanPropertyUtils {
    public static String toStringVal(Object o) {
        return StringUtils.asString(o);
    }

    public static Boolean toBoolean(Object o) {
        return ObjectUtils.toBoolean(o);
    }

    public static Number toNumber(Object o) {
        return ObjectUtils.toNumber(o);
    }

    public static Integer toInteger(Object o) {
        return ObjectUtils.toInteger(o);
    }

    public static URI toURI(Object o) {
        return StringUtils.toURI(o);
    }

    public static <T> List<T> addToList(List<T> appendTo, Object[] values, Class<T> type, Type ... args) {
        if (values == null) {
            return appendTo;
        }
        try {
            List<T> l = appendTo;
            if (appendTo == null) {
                l = new ArrayList<T>();
            }
            for (Object o : values) {
                if (o == null) continue;
                if (StringUtils.isObjectList(o, false)) {
                    for (Object o2 : new ObjectList(o.toString())) {
                        l.add(BeanPropertyUtils.toType(o2, type, args));
                    }
                    continue;
                }
                if (o instanceof Collection) {
                    for (Object o2 : (Collection)o) {
                        l.add(BeanPropertyUtils.toType(o2, type, args));
                    }
                    continue;
                }
                if (o.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(o); ++i) {
                        l.add(BeanPropertyUtils.toType(Array.get(o, i), type, args));
                    }
                    continue;
                }
                l.add(BeanPropertyUtils.toType(o, type, args));
            }
            return l.isEmpty() ? null : l;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static <K, V> Map<K, V> addToMap(Map<K, V> appendTo, Object[] values, Class<K> keyType, Class<V> valueType, Type ... valueTypeArgs) {
        if (values == null) {
            return appendTo;
        }
        try {
            Map<K, V> m = appendTo;
            if (m == null) {
                m = new LinkedHashMap();
            }
            for (Object o : values) {
                if (o == null) continue;
                if (StringUtils.isObjectMap(o, false)) {
                    for (Map.Entry<String, Object> entry : new ObjectMap(o.toString()).entrySet()) {
                        m.put(BeanPropertyUtils.toType(entry.getKey(), keyType, new Type[0]), BeanPropertyUtils.toType(entry.getValue(), valueType, valueTypeArgs));
                    }
                    continue;
                }
                if (o instanceof Map) {
                    for (Map.Entry<String, Object> entry : ((Map)o).entrySet()) {
                        m.put(BeanPropertyUtils.toType(entry.getKey(), keyType, new Type[0]), BeanPropertyUtils.toType(entry.getValue(), valueType, valueTypeArgs));
                    }
                    continue;
                }
                throw new FormattedRuntimeException("Invalid object type {0} passed to addToMap()", o.getClass().getName());
            }
            return m.isEmpty() ? null : m;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T toType(Object o, Class<T> type, Type ... args) {
        return ObjectUtils.toType(o, type, args);
    }

    public static <T> List<T> newList(Collection<T> val) {
        if (val == null) {
            return null;
        }
        return new ArrayList<T>(val);
    }

    public static <T> List<T> addToList(List<T> l, Collection<T> val) {
        if (val != null) {
            if (l == null) {
                l = new ArrayList<T>(val);
            } else {
                l.addAll(val);
            }
        }
        return l;
    }

    public static <K, V> Map<K, V> newMap(Map<K, V> val) {
        if (val == null) {
            return null;
        }
        return new LinkedHashMap<K, V>(val);
    }

    public static <K, V> Map<K, V> addToMap(Map<K, V> m, Map<K, V> val) {
        if (val != null) {
            if (m == null) {
                m = new LinkedHashMap<K, V>(val);
            } else {
                m.putAll(val);
            }
        }
        return m;
    }

    public static <K, V> Map<K, V> addToMap(Map<K, V> m, K key, V value) {
        if (m == null) {
            m = new LinkedHashMap();
        }
        m.put(key, value);
        return m;
    }

    public static <K, V> Map<K, V> newSortedMap(Map<K, V> val, Comparator<K> comparator) {
        if (val == null) {
            return null;
        }
        TreeMap<K, V> m = new TreeMap<K, V>(comparator);
        m.putAll(val);
        return m;
    }

    public static <K, V> Map<K, V> addToSortedMap(Map<K, V> m, Map<K, V> val, Comparator<K> comparator) {
        if (val != null) {
            if (m == null) {
                m = new TreeMap(comparator);
                m.putAll(val);
            } else {
                m.putAll(val);
            }
        }
        return m;
    }

    public static <K, V> Map<K, V> addToSortedMap(Map<K, V> m, K key, V value, Comparator<K> comparator) {
        if (m == null) {
            m = new TreeMap(comparator);
        }
        m.put(key, value);
        return m;
    }
}

