/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.httppart.bean;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.juneau.annotation.InvalidAnnotationException;
import org.apache.juneau.internal.ClassUtils;

class Utils {
    Utils() {
    }

    @SafeVarargs
    static final void assertNoAnnotations(Method m, Class<? extends Annotation> a, Class<? extends Annotation> ... c) throws InvalidAnnotationException {
        for (Class<? extends Annotation> cc : c) {
            if (!ClassUtils.hasAnnotation(cc, m)) continue;
            throw new InvalidAnnotationException("@{0} annotation cannot be used in a @{1} bean.  Method=''{2}''", cc.getSimpleName(), a.getSimpleName(), m);
        }
    }

    static void assertNoArgs(Method m, Class<?> a) throws InvalidAnnotationException {
        if (m.getParameterTypes().length != 0) {
            throw new InvalidAnnotationException("Method with @{0} annotation cannot have arguments.  Method=''{1}''", a.getSimpleName(), m);
        }
    }

    static void assertReturnNotVoid(Method m, Class<?> a) throws InvalidAnnotationException {
        Class<?> rt = m.getReturnType();
        if (rt == Void.TYPE) {
            throw new InvalidAnnotationException("Invalid return type for method with annotation @{0}.  Method=''{1}''", a.getSimpleName(), m);
        }
    }

    static void assertReturnType(Method m, Class<? extends Annotation> a, Class<?> ... c) throws InvalidAnnotationException {
        Class<?> rt = m.getReturnType();
        for (Class<?> cc : c) {
            if (rt != cc) continue;
            return;
        }
        throw new InvalidAnnotationException("Invalid return type for method with annotation @{0}.  Method=''{1}''", a.getSimpleName(), m);
    }

    static void assertArgType(Method m, Class<? extends Annotation> a, Class<?> ... c) throws InvalidAnnotationException {
        Class<?>[] ptt = m.getParameterTypes();
        if (ptt.length != 1) {
            throw new InvalidAnnotationException("Only one parameter can be passed to method with @{0} annotation.  Method=''{0}''", a.getSimpleName(), m);
        }
        Class<?> rt = ptt[0];
        for (Class<?> cc : c) {
            if (rt != cc) continue;
            return;
        }
        throw new InvalidAnnotationException("Invalid return type for method with annotation @{0}.  Method=''{1}''", a.getSimpleName(), m);
    }

    static String getPropertyName(Method m) {
        String n = m.getName();
        if (n.startsWith("get") && n.length() > 3) {
            return Introspector.decapitalize(n.substring(3));
        }
        if (n.startsWith("is") && n.length() > 2) {
            return Introspector.decapitalize(n.substring(2));
        }
        return n;
    }
}

