/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.httppart.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSchemaBuilder;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.Utils;
import org.apache.juneau.internal.ClassUtils;

public class RequestBeanPropertyMeta {
    private final Method getter;
    private final HttpPartType partType;
    private final HttpPartSerializer serializer;
    private final HttpPartParser parser;
    private final HttpPartSchema schema;

    static Builder create(HttpPartType partType, Class<? extends Annotation> c, Method m) {
        HttpPartSchemaBuilder sb = HttpPartSchema.create().name(Utils.getPropertyName(m));
        for (Annotation annotation : ClassUtils.getAnnotationsParentFirst(c, m)) {
            sb.apply(annotation);
        }
        return new Builder().partType(partType).schema(sb.build()).getter(m);
    }

    RequestBeanPropertyMeta(Builder b, HttpPartSerializer serializer, HttpPartParser parser) {
        this.partType = b.partType;
        this.schema = b.schema;
        this.getter = b.getter;
        this.serializer = this.schema.getSerializer() == null ? serializer : ClassUtils.newInstance(HttpPartSerializer.class, this.schema.getSerializer(), true, b.ps);
        this.parser = this.schema.getParser() == null ? parser : ClassUtils.newInstance(HttpPartParser.class, this.schema.getParser(), true, b.ps);
    }

    public String getPartName() {
        return this.schema == null ? null : this.schema.getName();
    }

    public Method getGetter() {
        return this.getter;
    }

    public HttpPartType getPartType() {
        return this.partType;
    }

    public HttpPartSerializer getSerializer(HttpPartSerializer _default) {
        return this.serializer == null ? _default : this.serializer;
    }

    public HttpPartParser getParser(HttpPartParser _default) {
        return this.parser == null ? _default : this.parser;
    }

    public HttpPartSchema getSchema() {
        return this.schema;
    }

    static class Builder {
        HttpPartType partType;
        HttpPartSchema schema;
        Method getter;
        PropertyStore ps = PropertyStore.DEFAULT;

        Builder() {
        }

        Builder getter(Method value) {
            this.getter = value;
            return this;
        }

        Builder partType(HttpPartType value) {
            this.partType = value;
            return this;
        }

        Builder schema(HttpPartSchema value) {
            this.schema = value;
            return this;
        }

        RequestBeanPropertyMeta build(HttpPartSerializer serializer, HttpPartParser parser) {
            return new RequestBeanPropertyMeta(this, serializer, parser);
        }
    }
}

