/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.httppart;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ContextRuntimeException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSchemaBuilder;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.ASet;

public class HttpPartSchema {
    public static final HttpPartSchema DEFAULT = HttpPartSchema.create().allowEmptyValue(true).build();
    final String name;
    final Set<Integer> codes;
    final String _default;
    final Set<String> _enum;
    final Map<String, HttpPartSchema> properties;
    final boolean allowEmptyValue;
    final boolean exclusiveMaximum;
    final boolean exclusiveMinimum;
    final boolean required;
    final boolean uniqueItems;
    final boolean skipIfEmpty;
    final CollectionFormat collectionFormat;
    final Type type;
    final Format format;
    final Pattern pattern;
    final HttpPartSchema items;
    final HttpPartSchema additionalProperties;
    final Number maximum;
    final Number minimum;
    final Number multipleOf;
    final Long maxLength;
    final Long minLength;
    final Long maxItems;
    final Long minItems;
    final Long maxProperties;
    final Long minProperties;
    final Class<? extends HttpPartParser> parser;
    final Class<? extends HttpPartSerializer> serializer;
    final ClassMeta<?> parsedType;

    public static HttpPartSchemaBuilder create() {
        return new HttpPartSchemaBuilder();
    }

    public static HttpPartSchema create(Class<? extends Annotation> c, Method m, int mi) {
        return HttpPartSchema.create().apply(c, m, mi).build();
    }

    public static HttpPartSchema create(Class<? extends Annotation> c, Method m) {
        return HttpPartSchema.create().apply(c, m).build();
    }

    public static HttpPartSchema create(Class<? extends Annotation> c, java.lang.reflect.Type t) {
        return HttpPartSchema.create().apply(c, t).build();
    }

    public static HttpPartSchemaBuilder create(String type) {
        return HttpPartSchema.create().type(type);
    }

    public static HttpPartSchemaBuilder create(String type, String format) {
        return HttpPartSchema.create().type(type).format(format);
    }

    public static HttpPartSchema create(Annotation a) {
        return HttpPartSchema.create().apply(a).build();
    }

    public static HttpPartSchema create(Annotation a, String defaultName) {
        return HttpPartSchema.create().name(defaultName).apply(a).build();
    }

    HttpPartSchema(HttpPartSchemaBuilder b) {
        this.name = b.name;
        this.codes = HttpPartSchema.copy(b.codes);
        this._default = b._default;
        this._enum = HttpPartSchema.copy(b._enum);
        this.properties = HttpPartSchema.build(b.properties, b.noValidate);
        this.allowEmptyValue = this.resolve(b.allowEmptyValue);
        this.exclusiveMaximum = this.resolve(b.exclusiveMaximum);
        this.exclusiveMinimum = this.resolve(b.exclusiveMinimum);
        this.required = this.resolve(b.required);
        this.uniqueItems = this.resolve(b.uniqueItems);
        this.skipIfEmpty = this.resolve(b.skipIfEmpty);
        this.collectionFormat = b.collectionFormat;
        this.type = b.type;
        this.format = b.format;
        this.pattern = b.pattern;
        this.items = HttpPartSchema.build(b.items, b.noValidate);
        this.additionalProperties = HttpPartSchema.build(b.additionalProperties, b.noValidate);
        this.maximum = b.maximum;
        this.minimum = b.minimum;
        this.multipleOf = b.multipleOf;
        this.maxItems = b.maxItems;
        this.maxLength = b.maxLength;
        this.maxProperties = b.maxProperties;
        this.minItems = b.minItems;
        this.minLength = b.minLength;
        this.minProperties = b.minProperties;
        this.parser = b.parser;
        this.serializer = b.serializer;
        Class parsedType = Object.class;
        if (this.type == Type.ARRAY) {
            if (this.items != null) {
                parsedType = Array.newInstance(this.items.parsedType.getInnerClass(), 0).getClass();
            }
        } else if (this.type == Type.BOOLEAN) {
            parsedType = Boolean.class;
        } else if (this.type == Type.INTEGER) {
            parsedType = this.format == Format.INT64 ? Long.class : Integer.class;
        } else if (this.type == Type.NUMBER) {
            parsedType = this.format == Format.DOUBLE ? Double.class : Float.class;
        } else if (this.type == Type.STRING) {
            parsedType = this.format == Format.BYTE || this.format == Format.BINARY || this.format == Format.BINARY_SPACED ? byte[].class : (this.format == Format.DATE || this.format == Format.DATE_TIME ? Calendar.class : String.class);
        }
        this.parsedType = BeanContext.DEFAULT.getClassMeta(parsedType);
        if (b.noValidate) {
            return;
        }
        ArrayList<String> errors = new ArrayList<String>();
        AList<String> notAllowed = new AList<String>();
        boolean invalidFormat = false;
        switch (this.type) {
            case STRING: {
                notAllowed.appendIf(this.properties != null, "properties");
                notAllowed.appendIf(this.additionalProperties != null, "additionalProperties");
                notAllowed.appendIf(this.exclusiveMaximum, "exclusiveMaximum");
                notAllowed.appendIf(this.exclusiveMinimum, "exclusiveMinimum");
                notAllowed.appendIf(this.uniqueItems, "uniqueItems");
                notAllowed.appendIf(this.collectionFormat != CollectionFormat.NO_COLLECTION_FORMAT, "collectionFormat");
                notAllowed.appendIf(this.items != null, "items");
                notAllowed.appendIf(this.maximum != null, "maximum");
                notAllowed.appendIf(this.minimum != null, "minimum");
                notAllowed.appendIf(this.multipleOf != null, "multipleOf");
                notAllowed.appendIf(this.maxItems != null, "maxItems");
                notAllowed.appendIf(this.minItems != null, "minItems");
                notAllowed.appendIf(this.minProperties != null, "minProperties");
                invalidFormat = !this.format.isOneOf(Format.BYTE, Format.BINARY, Format.BINARY_SPACED, Format.DATE, Format.DATE_TIME, Format.PASSWORD, Format.UON, Format.NO_FORMAT);
                break;
            }
            case ARRAY: {
                notAllowed.appendIf(this.properties != null, "properties");
                notAllowed.appendIf(this.additionalProperties != null, "additionalProperties");
                notAllowed.appendIf(this.exclusiveMaximum, "exclusiveMaximum");
                notAllowed.appendIf(this.exclusiveMinimum, "exclusiveMinimum");
                notAllowed.appendIf(this.pattern != null, "pattern");
                notAllowed.appendIf(this.maximum != null, "maximum");
                notAllowed.appendIf(this.minimum != null, "minimum");
                notAllowed.appendIf(this.multipleOf != null, "multipleOf");
                notAllowed.appendIf(this.maxLength != null, "maxLength");
                notAllowed.appendIf(this.minLength != null, "minLength");
                notAllowed.appendIf(this.maxProperties != null, "maxProperties");
                notAllowed.appendIf(this.minProperties != null, "minProperties");
                invalidFormat = !this.format.isOneOf(Format.NO_FORMAT, Format.UON);
                break;
            }
            case BOOLEAN: {
                notAllowed.appendIf(!this._enum.isEmpty(), "_enum");
                notAllowed.appendIf(this.properties != null, "properties");
                notAllowed.appendIf(this.additionalProperties != null, "additionalProperties");
                notAllowed.appendIf(this.exclusiveMaximum, "exclusiveMaximum");
                notAllowed.appendIf(this.exclusiveMinimum, "exclusiveMinimum");
                notAllowed.appendIf(this.uniqueItems, "uniqueItems");
                notAllowed.appendIf(this.collectionFormat != CollectionFormat.NO_COLLECTION_FORMAT, "collectionFormat");
                notAllowed.appendIf(this.pattern != null, "pattern");
                notAllowed.appendIf(this.items != null, "items");
                notAllowed.appendIf(this.maximum != null, "maximum");
                notAllowed.appendIf(this.minimum != null, "minimum");
                notAllowed.appendIf(this.multipleOf != null, "multipleOf");
                notAllowed.appendIf(this.maxItems != null, "maxItems");
                notAllowed.appendIf(this.maxLength != null, "maxLength");
                notAllowed.appendIf(this.maxProperties != null, "maxProperties");
                notAllowed.appendIf(this.minItems != null, "minItems");
                notAllowed.appendIf(this.minLength != null, "minLength");
                notAllowed.appendIf(this.minProperties != null, "minProperties");
                invalidFormat = !this.format.isOneOf(Format.NO_FORMAT, Format.UON);
                break;
            }
            case FILE: {
                break;
            }
            case INTEGER: {
                notAllowed.appendIf(this.properties != null, "properties");
                notAllowed.appendIf(this.additionalProperties != null, "additionalProperties");
                notAllowed.appendIf(this.uniqueItems, "uniqueItems");
                notAllowed.appendIf(this.collectionFormat != CollectionFormat.NO_COLLECTION_FORMAT, "collectionFormat");
                notAllowed.appendIf(this.pattern != null, "pattern");
                notAllowed.appendIf(this.items != null, "items");
                notAllowed.appendIf(this.maxItems != null, "maxItems");
                notAllowed.appendIf(this.maxLength != null, "maxLength");
                notAllowed.appendIf(this.maxProperties != null, "maxProperties");
                notAllowed.appendIf(this.minItems != null, "minItems");
                notAllowed.appendIf(this.minLength != null, "minLength");
                notAllowed.appendIf(this.minProperties != null, "minProperties");
                invalidFormat = !this.format.isOneOf(Format.NO_FORMAT, Format.UON, Format.INT32, Format.INT64);
                break;
            }
            case NUMBER: {
                notAllowed.appendIf(this.properties != null, "properties");
                notAllowed.appendIf(this.additionalProperties != null, "additionalProperties");
                notAllowed.appendIf(this.uniqueItems, "uniqueItems");
                notAllowed.appendIf(this.collectionFormat != CollectionFormat.NO_COLLECTION_FORMAT, "collectionFormat");
                notAllowed.appendIf(this.pattern != null, "pattern");
                notAllowed.appendIf(this.items != null, "items");
                notAllowed.appendIf(this.maxItems != null, "maxItems");
                notAllowed.appendIf(this.maxLength != null, "maxLength");
                notAllowed.appendIf(this.maxProperties != null, "maxProperties");
                notAllowed.appendIf(this.minItems != null, "minItems");
                notAllowed.appendIf(this.minLength != null, "minLength");
                notAllowed.appendIf(this.minProperties != null, "minProperties");
                invalidFormat = !this.format.isOneOf(Format.NO_FORMAT, Format.UON, Format.FLOAT, Format.DOUBLE);
                break;
            }
            case OBJECT: {
                notAllowed.appendIf(this.exclusiveMaximum, "exclusiveMaximum");
                notAllowed.appendIf(this.exclusiveMinimum, "exclusiveMinimum");
                notAllowed.appendIf(this.uniqueItems, "uniqueItems");
                notAllowed.appendIf(this.collectionFormat != CollectionFormat.NO_COLLECTION_FORMAT, "collectionFormat");
                notAllowed.appendIf(this.pattern != null, "pattern");
                notAllowed.appendIf(this.items != null, "items");
                notAllowed.appendIf(this.maximum != null, "maximum");
                notAllowed.appendIf(this.minimum != null, "minimum");
                notAllowed.appendIf(this.multipleOf != null, "multipleOf");
                notAllowed.appendIf(this.maxItems != null, "maxItems");
                notAllowed.appendIf(this.maxLength != null, "maxLength");
                notAllowed.appendIf(this.minItems != null, "minItems");
                notAllowed.appendIf(this.minLength != null, "minLength");
                invalidFormat = !this.format.isOneOf(Format.NO_FORMAT, Format.UON);
                break;
            }
        }
        if (!notAllowed.isEmpty()) {
            errors.add("Attributes not allow for type='" + (Object)((Object)this.type) + "': " + StringUtils.join(notAllowed, ","));
        }
        if (invalidFormat) {
            errors.add("Invalid format for type='" + (Object)((Object)this.type) + "': '" + (Object)((Object)this.format) + "'");
        }
        if (this.exclusiveMaximum && this.maximum == null) {
            errors.add("Cannot specify exclusiveMaximum with maximum.");
        }
        if (this.exclusiveMinimum && this.minimum == null) {
            errors.add("Cannot specify exclusiveMinimum with minimum.");
        }
        if (this.required && this._default != null) {
            errors.add("Cannot specify a default value on a required value.");
        }
        if (this.minLength != null && this.maxLength != null && this.maxLength < this.minLength) {
            errors.add("maxLength cannot be less than minLength.");
        }
        if (this.minimum != null && this.maximum != null && this.maximum.doubleValue() < this.minimum.doubleValue()) {
            errors.add("maximum cannot be less than minimum.");
        }
        if (this.minItems != null && this.maxItems != null && this.maxItems < this.minItems) {
            errors.add("maxItems cannot be less than minItems.");
        }
        if (this.minProperties != null && this.maxProperties != null && this.maxProperties < this.minProperties) {
            errors.add("maxProperties cannot be less than minProperties.");
        }
        if (this.minLength != null && this.minLength < 0L) {
            errors.add("minLength cannot be less than zero.");
        }
        if (this.maxLength != null && this.maxLength < 0L) {
            errors.add("maxLength cannot be less than zero.");
        }
        if (this.minItems != null && this.minItems < 0L) {
            errors.add("minItems cannot be less than zero.");
        }
        if (this.maxItems != null && this.maxItems < 0L) {
            errors.add("maxItems cannot be less than zero.");
        }
        if (this.minProperties != null && this.minProperties < 0L) {
            errors.add("minProperties cannot be less than zero.");
        }
        if (this.maxProperties != null && this.maxProperties < 0L) {
            errors.add("maxProperties cannot be less than zero.");
        }
        if (this.type == Type.ARRAY && this.items != null && this.items.getType() == Type.OBJECT && this.format != Format.UON && this.format != Format.NO_FORMAT) {
            errors.add("Cannot define an array of objects unless array format is 'uon'.");
        }
        if (!errors.isEmpty()) {
            throw new ContextRuntimeException("Schema specification errors: \n\t" + StringUtils.join(errors, "\n\t"), new Object[0]);
        }
    }

    public ClassMeta<?> getParsedType() {
        return this.parsedType;
    }

    public String getName() {
        return this.name;
    }

    public Set<Integer> getCodes() {
        return this.codes;
    }

    public Set<Integer> getCodes(Integer def) {
        return this.codes.isEmpty() ? Collections.singleton(def) : this.codes;
    }

    public Integer getCode(Integer def) {
        return this.codes.isEmpty() ? def : this.codes.iterator().next();
    }

    public Type getType() {
        return this.type;
    }

    public Type getType(ClassMeta<?> cm) {
        if (this.type != Type.NO_TYPE) {
            return this.type;
        }
        if (cm.isMapOrBean()) {
            return Type.OBJECT;
        }
        if (cm.isCollectionOrArray()) {
            return Type.ARRAY;
        }
        if (cm.isNumber()) {
            if (cm.isDecimal()) {
                return Type.NUMBER;
            }
            return Type.INTEGER;
        }
        if (cm.isBoolean()) {
            return Type.BOOLEAN;
        }
        return Type.STRING;
    }

    public String getDefault() {
        return this._default;
    }

    public CollectionFormat getCollectionFormat() {
        return this.collectionFormat;
    }

    public Format getFormat() {
        return this.format;
    }

    public Format getFormat(ClassMeta<?> cm) {
        if (this.format != Format.NO_FORMAT) {
            return this.format;
        }
        if (cm.isNumber()) {
            if (cm.isDecimal()) {
                if (cm.isDouble()) {
                    return Format.DOUBLE;
                }
                return Format.FLOAT;
            }
            if (cm.isLong()) {
                return Format.INT64;
            }
            return Format.INT32;
        }
        return this.format;
    }

    public HttpPartSchema getItems() {
        return this.items;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Long getMaxLength() {
        return this.maxLength;
    }

    public Long getMinLength() {
        return this.minLength;
    }

    public Long getMaxItems() {
        return this.maxItems;
    }

    public Long getMinItems() {
        return this.minItems;
    }

    public Long getMaxProperties() {
        return this.maxProperties;
    }

    public Long getMinProperties() {
        return this.minProperties;
    }

    public boolean isExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public boolean isExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public boolean isUniqueItems() {
        return this.uniqueItems;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isSkipIfEmpty() {
        return this.skipIfEmpty;
    }

    public boolean isAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public Set<String> getEnum() {
        return this._enum;
    }

    public Class<? extends HttpPartParser> getParser() {
        return this.parser;
    }

    public Class<? extends HttpPartSerializer> getSerializer() {
        return this.serializer;
    }

    public String validateInput(String in) throws SchemaValidationException {
        if (!this.isValidRequired(in)) {
            throw new SchemaValidationException("No value specified.", new Object[0]);
        }
        if (in != null) {
            if (!this.isValidAllowEmpty(in)) {
                throw new SchemaValidationException("Empty value not allowed.", new Object[0]);
            }
            if (!this.isValidPattern(in)) {
                throw new SchemaValidationException("Value does not match expected pattern.  Must match pattern: {0}", this.pattern.pattern());
            }
            if (!this.isValidEnum(in)) {
                throw new SchemaValidationException("Value does not match one of the expected values.  Must be one of the following: {0}", this._enum);
            }
            if (!this.isValidMaxLength(in)) {
                throw new SchemaValidationException("Maximum length of value exceeded.", new Object[0]);
            }
            if (!this.isValidMinLength(in)) {
                throw new SchemaValidationException("Minimum length of value not met.", new Object[0]);
            }
        }
        return in;
    }

    public <T> T validateOutput(T o, BeanContext bc) throws SchemaValidationException {
        if (o == null) {
            if (!this.isValidRequired(o)) {
                throw new SchemaValidationException("Required value not provided.", new Object[0]);
            }
            return o;
        }
        ClassMeta<T> cm = bc.getClassMetaForObject(o);
        switch (this.getType(cm)) {
            case ARRAY: {
                if (cm.isArray()) {
                    if (!this.isValidMinItems(o)) {
                        throw new SchemaValidationException("Minimum number of items not met.", new Object[0]);
                    }
                    if (!this.isValidMaxItems(o)) {
                        throw new SchemaValidationException("Maximum number of items exceeded.", new Object[0]);
                    }
                    if (!this.isValidUniqueItems(o)) {
                        throw new SchemaValidationException("Duplicate items not allowed.", new Object[0]);
                    }
                    HttpPartSchema items = this.getItems();
                    if (items == null) break;
                    for (int i = 0; i < Array.getLength(o); ++i) {
                        items.validateOutput(Array.get(o, i), bc);
                    }
                } else {
                    if (!cm.isCollection()) break;
                    Collection c = (Collection)o;
                    if (!this.isValidMinItems(c)) {
                        throw new SchemaValidationException("Minimum number of items not met.", new Object[0]);
                    }
                    if (!this.isValidMaxItems(c)) {
                        throw new SchemaValidationException("Maximum number of items exceeded.", new Object[0]);
                    }
                    if (!this.isValidUniqueItems(c)) {
                        throw new SchemaValidationException("Duplicate items not allowed.", new Object[0]);
                    }
                    HttpPartSchema items = this.getItems();
                    if (items == null) break;
                    for (Object o2 : c) {
                        items.validateOutput(o2, bc);
                    }
                }
                break;
            }
            case INTEGER: {
                if (!cm.isNumber()) break;
                Number n = (Number)o;
                if (!this.isValidMinimum(n)) {
                    throw new SchemaValidationException("Minimum value not met.", new Object[0]);
                }
                if (!this.isValidMaximum(n)) {
                    throw new SchemaValidationException("Maximum value exceeded.", new Object[0]);
                }
                if (this.isValidMultipleOf(n)) break;
                throw new SchemaValidationException("Multiple-of not met.", new Object[0]);
            }
            case NUMBER: {
                if (!cm.isNumber()) break;
                Number n = (Number)o;
                if (!this.isValidMinimum(n)) {
                    throw new SchemaValidationException("Minimum value not met.", new Object[0]);
                }
                if (!this.isValidMaximum(n)) {
                    throw new SchemaValidationException("Maximum value exceeded.", new Object[0]);
                }
                if (this.isValidMultipleOf(n)) break;
                throw new SchemaValidationException("Multiple-of not met.", new Object[0]);
            }
            case OBJECT: {
                if (cm.isMapOrBean()) {
                    BeanMap<T> m;
                    BeanMap<T> beanMap = m = cm.isMap() ? (BeanMap<T>)o : bc.createSession().toBeanMap(o);
                    if (!this.isValidMinProperties(m)) {
                        throw new SchemaValidationException("Minimum number of properties not met.", new Object[0]);
                    }
                    if (!this.isValidMaxProperties(m)) {
                        throw new SchemaValidationException("Maximum number of properties exceeded.", new Object[0]);
                    }
                    for (Map.Entry e : m.entrySet()) {
                        String key = e.getKey().toString();
                        HttpPartSchema s2 = this.getProperty(key);
                        if (s2 == null) continue;
                        s2.validateOutput(e.getValue(), bc);
                    }
                    break;
                }
                if (!cm.isBean()) break;
                break;
            }
        }
        return o;
    }

    private boolean isValidRequired(Object x) {
        return x != null || !this.required;
    }

    private boolean isValidMinProperties(Map<?, ?> x) {
        return this.minProperties == null || (long)x.size() >= this.minProperties;
    }

    private boolean isValidMaxProperties(Map<?, ?> x) {
        return this.maxProperties == null || (long)x.size() <= this.maxProperties;
    }

    private boolean isValidMinimum(Number x) {
        if (x instanceof Integer || x instanceof AtomicInteger) {
            return this.minimum == null || x.intValue() > this.minimum.intValue() || x.intValue() == this.minimum.intValue() && !this.exclusiveMinimum;
        }
        if (x instanceof Short || x instanceof Byte) {
            return this.minimum == null || x.shortValue() > this.minimum.shortValue() || x.intValue() == this.minimum.shortValue() && !this.exclusiveMinimum;
        }
        if (x instanceof Long || x instanceof AtomicLong || x instanceof BigInteger) {
            return this.minimum == null || x.longValue() > this.minimum.longValue() || (long)x.intValue() == this.minimum.longValue() && !this.exclusiveMinimum;
        }
        if (x instanceof Float) {
            return this.minimum == null || x.floatValue() > this.minimum.floatValue() || x.floatValue() == this.minimum.floatValue() && !this.exclusiveMinimum;
        }
        if (x instanceof Double || x instanceof BigDecimal) {
            return this.minimum == null || x.doubleValue() > this.minimum.doubleValue() || x.doubleValue() == this.minimum.doubleValue() && !this.exclusiveMinimum;
        }
        return true;
    }

    private boolean isValidMaximum(Number x) {
        if (x instanceof Integer || x instanceof AtomicInteger) {
            return this.maximum == null || x.intValue() < this.maximum.intValue() || x.intValue() == this.maximum.intValue() && !this.exclusiveMaximum;
        }
        if (x instanceof Short || x instanceof Byte) {
            return this.maximum == null || x.shortValue() < this.maximum.shortValue() || x.intValue() == this.maximum.shortValue() && !this.exclusiveMaximum;
        }
        if (x instanceof Long || x instanceof AtomicLong || x instanceof BigInteger) {
            return this.maximum == null || x.longValue() < this.maximum.longValue() || (long)x.intValue() == this.maximum.longValue() && !this.exclusiveMaximum;
        }
        if (x instanceof Float) {
            return this.maximum == null || x.floatValue() < this.maximum.floatValue() || x.floatValue() == this.maximum.floatValue() && !this.exclusiveMaximum;
        }
        if (x instanceof Double || x instanceof BigDecimal) {
            return this.maximum == null || x.doubleValue() < this.maximum.doubleValue() || x.doubleValue() == this.maximum.doubleValue() && !this.exclusiveMaximum;
        }
        return true;
    }

    private boolean isValidMultipleOf(Number x) {
        if (x instanceof Integer || x instanceof AtomicInteger) {
            return this.multipleOf == null || x.intValue() % this.multipleOf.intValue() == 0;
        }
        if (x instanceof Short || x instanceof Byte) {
            return this.multipleOf == null || x.shortValue() % this.multipleOf.shortValue() == 0;
        }
        if (x instanceof Long || x instanceof AtomicLong || x instanceof BigInteger) {
            return this.multipleOf == null || x.longValue() % this.multipleOf.longValue() == 0L;
        }
        if (x instanceof Float) {
            return this.multipleOf == null || x.floatValue() % this.multipleOf.floatValue() == 0.0f;
        }
        if (x instanceof Double || x instanceof BigDecimal) {
            return this.multipleOf == null || x.doubleValue() % this.multipleOf.doubleValue() == 0.0;
        }
        return true;
    }

    private boolean isValidAllowEmpty(String x) {
        return this.allowEmptyValue || StringUtils.isNotEmpty(x);
    }

    private boolean isValidPattern(String x) {
        return this.pattern == null || this.pattern.matcher(x).matches();
    }

    private boolean isValidEnum(String x) {
        return this._enum.isEmpty() || this._enum.contains(x);
    }

    private boolean isValidMinLength(String x) {
        return this.minLength == null || (long)x.length() >= this.minLength;
    }

    private boolean isValidMaxLength(String x) {
        return this.maxLength == null || (long)x.length() <= this.maxLength;
    }

    private boolean isValidMinItems(Object x) {
        return this.minItems == null || (long)Array.getLength(x) >= this.minItems;
    }

    private boolean isValidMaxItems(Object x) {
        return this.maxItems == null || (long)Array.getLength(x) <= this.maxItems;
    }

    private boolean isValidUniqueItems(Object x) {
        if (this.uniqueItems) {
            HashSet<Object> s = new HashSet<Object>();
            for (int i = 0; i < Array.getLength(x); ++i) {
                Object o = Array.get(x, i);
                if (s.add(o)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isValidMinItems(Collection<?> x) {
        return this.minItems == null || (long)x.size() >= this.minItems;
    }

    private boolean isValidMaxItems(Collection<?> x) {
        return this.maxItems == null || (long)x.size() <= this.maxItems;
    }

    private boolean isValidUniqueItems(Collection<?> x) {
        if (this.uniqueItems && !(x instanceof Set)) {
            HashSet s = new HashSet();
            for (Object o : x) {
                if (s.add(o)) continue;
                return false;
            }
        }
        return true;
    }

    public HttpPartSchema getProperty(String name) {
        HttpPartSchema schema;
        if (this.properties != null && (schema = this.properties.get(name)) != null) {
            return schema;
        }
        return this.additionalProperties;
    }

    public boolean hasProperties() {
        return this.properties != null || this.additionalProperties != null;
    }

    private static <T> Set<T> copy(Set<T> in) {
        return in == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(new LinkedHashSet<T>(in));
    }

    private static Map<String, HttpPartSchema> build(Map<String, HttpPartSchemaBuilder> in, boolean noValidate) {
        if (in == null) {
            return null;
        }
        LinkedHashMap<String, HttpPartSchema> m = new LinkedHashMap<String, HttpPartSchema>();
        for (Map.Entry<String, HttpPartSchemaBuilder> e : in.entrySet()) {
            m.put(e.getKey(), e.getValue().noValidate(noValidate).build());
        }
        return Collections.unmodifiableMap(m);
    }

    private static HttpPartSchema build(HttpPartSchemaBuilder in, boolean noValidate) {
        return in == null ? null : in.noValidate(noValidate).build();
    }

    private boolean resolve(Boolean b) {
        return b == null ? false : b;
    }

    static final Set<String> toSet(String[] s) {
        return HttpPartSchema.toSet(StringUtils.joinnl(s));
    }

    static final Set<String> toSet(String s) {
        if (StringUtils.isEmpty(s)) {
            return null;
        }
        ASet<String> set = new ASet<String>();
        try {
            for (Object o : StringUtils.parseListOrCdl(s)) {
                set.add(o.toString());
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return set;
    }

    static final Number toNumber(String s) {
        try {
            if (StringUtils.isNotEmpty(s)) {
                return StringUtils.parseNumber(s, Number.class);
            }
            return null;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    static final ObjectMap toObjectMap(String[] ss) {
        String s = StringUtils.joinnl(ss);
        if (s.isEmpty()) {
            return null;
        }
        if (!StringUtils.isObjectMap(s, true)) {
            s = "{" + s + "}";
        }
        try {
            return new ObjectMap(s);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        try {
            ObjectMap m = new ObjectMap().appendSkipEmpty("name", this.name).appendSkipEmpty("type", (Object)this.type).appendSkipEmpty("format", (Object)this.format).appendSkipEmpty("codes", this.codes).appendSkipEmpty("default", this._default).appendSkipEmpty("enum", this._enum).appendSkipEmpty("properties", this.properties).appendSkipFalse("allowEmptyValue", this.allowEmptyValue).appendSkipFalse("exclusiveMaximum", this.exclusiveMaximum).appendSkipFalse("exclusiveMinimum", this.exclusiveMinimum).appendSkipFalse("required", this.required).appendSkipFalse("uniqueItems", this.uniqueItems).appendSkipFalse("skipIfEmpty", this.skipIfEmpty).appendIf(this.collectionFormat != CollectionFormat.NO_COLLECTION_FORMAT, "collectionFormat", (Object)this.collectionFormat).appendSkipEmpty("pattern", this.pattern).appendSkipNull("items", this.items).appendSkipNull("additionalProperties", this.additionalProperties).appendSkipMinusOne("maximum", this.maximum).appendSkipMinusOne("minimum", this.minimum).appendSkipMinusOne("multipleOf", this.multipleOf).appendSkipMinusOne("maxLength", this.maxLength).appendSkipMinusOne("minLength", this.minLength).appendSkipMinusOne("maxItems", this.maxItems).appendSkipMinusOne("minItems", this.minItems).appendSkipMinusOne("maxProperties", this.maxProperties).appendSkipMinusOne("minProperties", this.minProperties).append("parsedType", this.parsedType);
            return m.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static enum Format {
        INT32,
        INT64,
        FLOAT,
        DOUBLE,
        BYTE,
        BINARY,
        BINARY_SPACED,
        DATE,
        DATE_TIME,
        PASSWORD,
        UON,
        NO_FORMAT;


        static Format fromString(String value) {
            value = value.toUpperCase().replace('-', '_');
            return Format.valueOf(value);
        }

        public String toString() {
            String s = this.name().toLowerCase().replace('_', '-');
            return s;
        }

        public boolean isOneOf(Format ... list) {
            for (Format ff : list) {
                if (this != ff) continue;
                return true;
            }
            return false;
        }
    }

    public static enum Type {
        STRING,
        NUMBER,
        INTEGER,
        BOOLEAN,
        ARRAY,
        OBJECT,
        FILE,
        NO_TYPE;


        static Type fromString(String value) {
            return Type.valueOf(value.toUpperCase());
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum CollectionFormat {
        CSV,
        SSV,
        TSV,
        PIPES,
        MULTI,
        UON,
        NO_COLLECTION_FORMAT;


        static CollectionFormat fromString(String value) {
            return CollectionFormat.valueOf(value.toUpperCase());
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

