/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.xml.XmlUtils;

enum HtmlTag {
    TABLE(1, "<table>"),
    TR(2, "<tr>"),
    TH(3, "<th>"),
    TD(4, "<td>"),
    UL(5, "<ul>"),
    LI(6, "<li>"),
    STRING(7, "<string>"),
    NUMBER(8, "<number>"),
    BOOLEAN(9, "<boolean>"),
    NULL(10, "<null>"),
    A(11, "<a>"),
    BR(12, "<br>"),
    FF(13, "<ff>"),
    BS(14, "<bs>"),
    SP(17, "<sp>"),
    P(18, "<p>"),
    HTML(19, "<html>"),
    xTABLE(-1, "</table>"),
    xTR(-2, "</tr>"),
    xTH(-3, "</th>"),
    xTD(-4, "</td>"),
    xUL(-5, "</ul>"),
    xLI(-6, "</li>"),
    xSTRING(-7, "</string>"),
    xNUMBER(-8, "</number>"),
    xBOOLEAN(-9, "</boolean>"),
    xNULL(-10, "</null>"),
    xA(-11, "</a>"),
    xBR(-12, "</br>"),
    xFF(-13, "</ff>"),
    xBS(-14, "</bs>"),
    xSP(-17, "</sp>"),
    xP(-18, "</p>"),
    xHTML(-19, "</html>");

    private Map<Integer, HtmlTag> cache = new HashMap<Integer, HtmlTag>();
    int id;
    String label;

    private HtmlTag(int id, String label) {
        this.id = id;
        this.label = label;
        this.cache.put(id, this);
    }

    static HtmlTag forEvent(ParserSession session, XMLStreamReader r) throws Exception {
        int et = r.getEventType();
        if (et == 1) {
            return HtmlTag.forString(r.getLocalName(), false);
        }
        if (et == 2) {
            return HtmlTag.forString(r.getLocalName(), true);
        }
        throw new ParseException(session, "Invalid call to HtmlTag.forEvent on event of type ''{0}''", XmlUtils.toReadableEvent(r));
    }

    static HtmlTag forString(String tag, boolean end) throws Exception {
        char c = tag.charAt(0);
        HtmlTag t = null;
        if (c == 'u') {
            t = end ? xUL : UL;
        } else if (c == 'l') {
            t = end ? xLI : LI;
        } else if (c == 's') {
            c = tag.charAt(1);
            if (c == 'p') {
                t = end ? xSP : SP;
            } else if (c == 't') {
                t = end ? xSTRING : STRING;
            }
        } else if (c == 'b') {
            c = tag.charAt(1);
            if (c == 'o') {
                t = end ? xBOOLEAN : BOOLEAN;
            } else if (c == 'r') {
                t = end ? xBR : BR;
            } else if (c == 's') {
                t = end ? xBS : BS;
            }
        } else if (c == 'a') {
            t = end ? xA : A;
        } else if (c == 'n') {
            c = tag.charAt(2);
            if (c == 'm') {
                t = end ? xNUMBER : NUMBER;
            } else if (c == 'l') {
                t = end ? xNULL : NULL;
            }
        } else if (c == 't') {
            c = tag.charAt(1);
            if (c == 'a') {
                t = end ? xTABLE : TABLE;
            } else if (c == 'r') {
                t = end ? xTR : TR;
            } else if (c == 'h') {
                t = end ? xTH : TH;
            } else if (c == 'd') {
                t = end ? xTD : TD;
            }
        } else if (c == 'f') {
            t = end ? xFF : FF;
        } else if (c == 'p') {
            t = end ? xP : P;
        } else if (c == 'h') {
            t = end ? xHTML : HTML;
        }
        return t;
    }

    public String toString() {
        return this.label;
    }

    public boolean isOneOf(HtmlTag ... tags) {
        for (HtmlTag tag : tags) {
            if (tag != this) continue;
            return true;
        }
        return false;
    }
}

