/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.html.BasicHtmlDocTemplate;
import org.apache.juneau.html.HtmlDocSerializerSession;
import org.apache.juneau.html.HtmlDocTemplate;
import org.apache.juneau.html.HtmlSchemaDocSerializer;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.html.HtmlStrippedDocSerializer;
import org.apache.juneau.serializer.SerializerSessionArgs;

public class HtmlDocSerializer
extends HtmlStrippedDocSerializer {
    private static final String PREFIX = "HtmlDocSerializer.";
    public static final String HTMLDOC_aside = "HtmlDocSerializer.aside.ls";
    public static final String HTMLDOC_footer = "HtmlDocSerializer.footer.ls";
    public static final String HTMLDOC_head = "HtmlDocSerializer.head.ls";
    public static final String HTMLDOC_header = "HtmlDocSerializer.header.ls";
    public static final String HTMLDOC_nav = "HtmlDocSerializer.nav.ls";
    public static final String HTMLDOC_navlinks = "HtmlDocSerializer.navlinks.ls";
    public static final String HTMLDOC_navlinks_add = "HtmlDocSerializer.navlinks.ls/add";
    public static final String HTMLDOC_noResultsMessage = "HtmlDocSerializer.noResultsMessage.s";
    public static final String HTMLDOC_nowrap = "HtmlDocSerializer.nowrap.b";
    public static final String HTMLDOC_script = "HtmlDocSerializer.script.ls";
    public static final String HTMLDOC_script_add = "HtmlDocSerializer.script.ls/add";
    public static final String HTMLDOC_style = "HtmlDocSerializer.style.ls";
    public static final String HTMLDOC_style_add = "HtmlDocSerializer.style.ls/add";
    public static final String HTMLDOC_stylesheet = "HtmlDocSerializer.stylesheet.ls";
    public static final String HTMLDOC_stylesheet_add = "HtmlDocSerializer.stylesheet.ls/add";
    public static final String HTMLDOC_template = "HtmlDocSerializer.template.c";
    public static final HtmlDocSerializer DEFAULT = new HtmlDocSerializer(PropertyStore.DEFAULT);
    private final String[] style = this.getArrayProperty("HtmlDocSerializer.style.ls", String.class);
    private final String[] stylesheet = this.getArrayProperty("HtmlDocSerializer.stylesheet.ls", String.class);
    private final String[] script = this.getArrayProperty("HtmlDocSerializer.script.ls", String.class);
    private final String[] navlinks;
    private final String[] head = this.getArrayProperty("HtmlDocSerializer.head.ls", String.class);
    private final String[] header = this.getArrayProperty("HtmlDocSerializer.header.ls", String.class);
    private final String[] nav = this.getArrayProperty("HtmlDocSerializer.nav.ls", String.class);
    private final String[] aside = this.getArrayProperty("HtmlDocSerializer.aside.ls", String.class);
    private final String[] footer = this.getArrayProperty("HtmlDocSerializer.footer.ls", String.class);
    private final String noResultsMessage;
    private final boolean nowrap = this.getBooleanProperty("HtmlDocSerializer.nowrap.b", false);
    private final HtmlDocTemplate template;
    private volatile HtmlSchemaDocSerializer schemaSerializer;

    public HtmlDocSerializer(PropertyStore ps) {
        this(ps, "text/html", null);
    }

    public HtmlDocSerializer(PropertyStore ps, String produces, String accept) {
        super(ps, produces, accept);
        this.navlinks = this.getArrayProperty(HTMLDOC_navlinks, String.class);
        this.noResultsMessage = this.getStringProperty(HTMLDOC_noResultsMessage, "<p>no results</p>");
        this.template = this.getInstanceProperty(HTMLDOC_template, HtmlDocTemplate.class, BasicHtmlDocTemplate.class);
    }

    @Override
    public HtmlDocSerializerSession createSession(SerializerSessionArgs args) {
        return new HtmlDocSerializerSession(this, args);
    }

    @Override
    public HtmlSerializer getSchemaSerializer() {
        if (this.schemaSerializer == null) {
            this.schemaSerializer = this.builder().build(HtmlSchemaDocSerializer.class);
        }
        return this.schemaSerializer;
    }

    protected final String[] getStyle() {
        return this.style;
    }

    protected final String[] getStylesheet() {
        return this.stylesheet;
    }

    protected final String[] getScript() {
        return this.script;
    }

    protected final String[] getNavlinks() {
        return this.navlinks;
    }

    protected final String[] getHead() {
        return this.head;
    }

    protected final String[] getHeader() {
        return this.header;
    }

    protected final String[] getNav() {
        return this.nav;
    }

    protected final String[] getAside() {
        return this.aside;
    }

    protected final String[] getFooter() {
        return this.footer;
    }

    protected final String getNoResultsMessage() {
        return this.noResultsMessage;
    }

    protected final boolean isNowrap() {
        return this.nowrap;
    }

    protected final HtmlDocTemplate getTemplate() {
        return this.template;
    }

    @Override
    public ObjectMap asMap() {
        return super.asMap().append("HtmlDocSerializer", new ObjectMap().append("header", this.header).append("nav", this.nav).append("navlinks", this.navlinks).append("aside", this.aside).append("footer", this.footer).append("style", this.style).append("head", this.head).append("stylesheet", this.stylesheet).append("nowrap", this.nowrap).append("template", this.template).append("noResultsMessage", this.noResultsMessage));
    }
}

