/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.encoders;

import java.util.ArrayList;
import java.util.List;
import org.apache.juneau.BeanContext;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderGroup;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.CollectionUtils;

public class EncoderGroupBuilder {
    private final List<Encoder> encoders;
    private BeanContext beanContext = BeanContext.DEFAULT;

    public EncoderGroupBuilder() {
        this.encoders = new ArrayList<Encoder>();
    }

    public EncoderGroupBuilder(EncoderGroup copyFrom) {
        this.encoders = new ArrayList<Encoder>();
        CollectionUtils.addReverse(this.encoders, copyFrom.getEncoders());
    }

    public EncoderGroupBuilder append(Class<?> ... e) {
        for (int i = e.length - 1; i >= 0; --i) {
            this.encoders.add(this.beanContext.newInstance(Encoder.class, e[i]));
        }
        return this;
    }

    public EncoderGroupBuilder append(Encoder ... e) {
        CollectionUtils.addReverse(this.encoders, e);
        return this;
    }

    public EncoderGroupBuilder append(List<Encoder> e) {
        CollectionUtils.addReverse(this.encoders, e);
        return this;
    }

    public EncoderGroupBuilder append(EncoderGroup eg) {
        this.append(eg.getEncoders());
        return this;
    }

    public EncoderGroup build() {
        ArrayList<Encoder> l = new ArrayList<Encoder>();
        for (Encoder e : this.encoders) {
            l.add(this.beanContext.newInstance(Encoder.class, e));
        }
        return new EncoderGroup(ArrayUtils.toReverseArray(Encoder.class, l));
    }
}

