/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.dto.swagger.SwaggerElement;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.BeanPropertyUtils;
import org.apache.juneau.internal.MultiSet;
import org.apache.juneau.utils.ASet;

@Bean(properties="type,description,name,in,flow,authorizationUrl,tokenUrl,scopes,*")
public class SecurityScheme
extends SwaggerElement {
    private static final String[] VALID_TYPES = new String[]{"basic", "apiKey", "oauth2"};
    private String type;
    private String description;
    private String name;
    private String in;
    private String flow;
    private String authorizationUrl;
    private String tokenUrl;
    private Map<String, String> scopes;

    public SecurityScheme() {
    }

    public SecurityScheme(SecurityScheme copyFrom) {
        super(copyFrom);
        this.type = copyFrom.type;
        this.description = copyFrom.description;
        this.name = copyFrom.name;
        this.in = copyFrom.in;
        this.flow = copyFrom.flow;
        this.authorizationUrl = copyFrom.authorizationUrl;
        this.tokenUrl = copyFrom.tokenUrl;
        this.scopes = copyFrom.scopes == null ? null : new LinkedHashMap<String, String>(copyFrom.scopes);
    }

    public SecurityScheme copy() {
        return new SecurityScheme(this);
    }

    @Override
    protected SecurityScheme strict() {
        super.strict();
        return this;
    }

    public String getType() {
        return this.type;
    }

    public SecurityScheme setType(String value) {
        if (this.isStrict() && !ArrayUtils.contains(value, VALID_TYPES)) {
            throw new FormattedRuntimeException("Invalid value passed in to setType(String).  Value=''{0}'', valid values={1}", value, VALID_TYPES);
        }
        this.type = value;
        return this;
    }

    public SecurityScheme type(Object value) {
        return this.setType(BeanPropertyUtils.toStringVal(value));
    }

    public String getDescription() {
        return this.description;
    }

    public SecurityScheme setDescription(String value) {
        this.description = value;
        return this;
    }

    public SecurityScheme description(Object value) {
        return this.setDescription(BeanPropertyUtils.toStringVal(value));
    }

    public String getName() {
        return this.name;
    }

    public SecurityScheme setName(String value) {
        this.name = value;
        return this;
    }

    public SecurityScheme name(Object value) {
        return this.setName(BeanPropertyUtils.toStringVal(value));
    }

    public String getIn() {
        return this.in;
    }

    public SecurityScheme setIn(String value) {
        this.in = value;
        return this;
    }

    public SecurityScheme in(Object value) {
        return this.setIn(BeanPropertyUtils.toStringVal(value));
    }

    public String getFlow() {
        return this.flow;
    }

    public SecurityScheme setFlow(String value) {
        this.flow = value;
        return this;
    }

    public SecurityScheme flow(Object value) {
        return this.setFlow(BeanPropertyUtils.toStringVal(value));
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public SecurityScheme setAuthorizationUrl(String value) {
        this.authorizationUrl = value;
        return this;
    }

    public SecurityScheme authorizationUrl(Object value) {
        return this.setAuthorizationUrl(BeanPropertyUtils.toStringVal(value));
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public SecurityScheme setTokenUrl(String value) {
        this.tokenUrl = value;
        return this;
    }

    public SecurityScheme tokenUrl(Object value) {
        return this.setTokenUrl(BeanPropertyUtils.toStringVal(value));
    }

    public Map<String, String> getScopes() {
        return this.scopes;
    }

    public SecurityScheme setScopes(Map<String, String> value) {
        this.scopes = BeanPropertyUtils.newMap(value);
        return this;
    }

    public SecurityScheme addScopes(Map<String, String> values) {
        this.scopes = BeanPropertyUtils.addToMap(this.scopes, values);
        return this;
    }

    public SecurityScheme scopes(Object ... values) {
        this.scopes = BeanPropertyUtils.addToMap(this.scopes, values, String.class, String.class, new Type[0]);
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "type": {
                return BeanPropertyUtils.toType(this.getType(), type, new Type[0]);
            }
            case "description": {
                return BeanPropertyUtils.toType(this.getDescription(), type, new Type[0]);
            }
            case "name": {
                return BeanPropertyUtils.toType(this.getName(), type, new Type[0]);
            }
            case "in": {
                return BeanPropertyUtils.toType(this.getIn(), type, new Type[0]);
            }
            case "flow": {
                return BeanPropertyUtils.toType(this.getFlow(), type, new Type[0]);
            }
            case "authorizationUrl": {
                return BeanPropertyUtils.toType(this.getAuthorizationUrl(), type, new Type[0]);
            }
            case "tokenUrl": {
                return BeanPropertyUtils.toType(this.getTokenUrl(), type, new Type[0]);
            }
            case "scopes": {
                return BeanPropertyUtils.toType(this.getScopes(), type, new Type[0]);
            }
        }
        return super.get(property, type);
    }

    @Override
    public SecurityScheme set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "type": {
                return this.type(value);
            }
            case "description": {
                return this.description(value);
            }
            case "name": {
                return this.name(value);
            }
            case "in": {
                return this.in(value);
            }
            case "flow": {
                return this.flow(value);
            }
            case "authorizationUrl": {
                return this.authorizationUrl(value);
            }
            case "tokenUrl": {
                return this.tokenUrl(value);
            }
            case "scopes": {
                return this.setScopes(null).scopes(value);
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        ASet<String> s = new ASet<String>().appendIf(this.type != null, "type").appendIf(this.description != null, "description").appendIf(this.name != null, "name").appendIf(this.in != null, "in").appendIf(this.flow != null, "flow").appendIf(this.authorizationUrl != null, "authorizationUrl").appendIf(this.tokenUrl != null, "tokenUrl").appendIf(this.scopes != null, "scopes");
        return new MultiSet<String>(s, super.keySet());
    }
}

