/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.lang.reflect.Type;
import java.util.Set;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.dto.swagger.Contact;
import org.apache.juneau.dto.swagger.License;
import org.apache.juneau.dto.swagger.SwaggerElement;
import org.apache.juneau.internal.BeanPropertyUtils;
import org.apache.juneau.internal.MultiSet;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.utils.ASet;

@Bean(properties="title,description,version,contact,license,termsOfService,*")
public class Info
extends SwaggerElement {
    private String title;
    private String description;
    private String termsOfService;
    private String version;
    private Contact contact;
    private License license;

    public Info() {
    }

    public Info(Info copyFrom) {
        super(copyFrom);
        this.title = copyFrom.title;
        this.description = copyFrom.description;
        this.termsOfService = copyFrom.termsOfService;
        this.version = copyFrom.version;
        this.contact = copyFrom.contact == null ? null : copyFrom.contact.copy();
        this.license = copyFrom.license == null ? null : copyFrom.license.copy();
    }

    public Info copy() {
        return new Info(this);
    }

    public String getTitle() {
        return this.title;
    }

    public Info setTitle(String value) {
        this.title = value;
        return this;
    }

    public Info title(Object value) {
        return this.setTitle(BeanPropertyUtils.toStringVal(value));
    }

    public String getDescription() {
        return this.description;
    }

    public Info setDescription(String value) {
        this.description = value;
        return this;
    }

    public Info description(Object value) {
        return this.setDescription(BeanPropertyUtils.toStringVal(value));
    }

    public String getTermsOfService() {
        return this.termsOfService;
    }

    public Info setTermsOfService(String value) {
        this.termsOfService = value;
        return this;
    }

    public Info termsOfService(Object value) {
        return this.setTermsOfService(BeanPropertyUtils.toStringVal(value));
    }

    public Contact getContact() {
        return this.contact;
    }

    public Info setContact(Contact value) {
        this.contact = value;
        return this;
    }

    public Info contact(Object value) {
        return this.setContact(BeanPropertyUtils.toType(value, Contact.class, new Type[0]));
    }

    public License getLicense() {
        return this.license;
    }

    public Info setLicense(License value) {
        this.license = value;
        return this;
    }

    public Info license(Object value) {
        return this.setLicense(BeanPropertyUtils.toType(value, License.class, new Type[0]));
    }

    public String getVersion() {
        return this.version;
    }

    public Info setVersion(String value) {
        this.version = value;
        return this;
    }

    public Info version(Object value) {
        return this.setVersion(BeanPropertyUtils.toStringVal(value));
    }

    public boolean hasTitle() {
        return StringUtils.isNotEmpty(this.title);
    }

    public boolean hasDescription() {
        return StringUtils.isNotEmpty(this.description);
    }

    public boolean hasVersion() {
        return StringUtils.isNotEmpty(this.version);
    }

    public boolean hasTermsOfService() {
        return StringUtils.isNotEmpty(this.termsOfService);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "title": {
                return BeanPropertyUtils.toType(this.getTitle(), type, new Type[0]);
            }
            case "description": {
                return BeanPropertyUtils.toType(this.getDescription(), type, new Type[0]);
            }
            case "termsOfService": {
                return BeanPropertyUtils.toType(this.getTermsOfService(), type, new Type[0]);
            }
            case "contact": {
                return BeanPropertyUtils.toType(this.getContact(), type, new Type[0]);
            }
            case "license": {
                return BeanPropertyUtils.toType(this.getLicense(), type, new Type[0]);
            }
            case "version": {
                return BeanPropertyUtils.toType(this.getVersion(), type, new Type[0]);
            }
        }
        return super.get(property, type);
    }

    @Override
    public Info set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "title": {
                return this.title(value);
            }
            case "description": {
                return this.description(value);
            }
            case "termsOfService": {
                return this.termsOfService(value);
            }
            case "contact": {
                return this.contact(value);
            }
            case "license": {
                return this.license(value);
            }
            case "version": {
                return this.version(value);
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        ASet<String> s = new ASet<String>().appendIf(this.title != null, "title").appendIf(this.description != null, "description").appendIf(this.termsOfService != null, "termsOfService").appendIf(this.contact != null, "contact").appendIf(this.license != null, "license").appendIf(this.version != null, "version");
        return new MultiSet<String>(s, super.keySet());
    }
}

