/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.cognos;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanSession;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanProperty;
import org.apache.juneau.dto.cognos.Column;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;

@Bean(typeName="dataset", properties="metadata,data")
public class DataSet {
    private Column[] metaData;
    private List<Row> data;

    public DataSet() {
    }

    public DataSet(Column[] columns, Object o, BeanSession session) throws Exception {
        this.metaData = columns;
        this.data = new LinkedList<Row>();
        if (o != null) {
            if (o.getClass().isArray()) {
                o = Arrays.asList((Object[])o);
            }
            if (o instanceof Collection) {
                Collection c = o;
                for (Object o2 : c) {
                    Row r = new Row();
                    BeanMap m = null;
                    m = o2 instanceof Map ? (BeanMap)o2 : session.toBeanMap(o2);
                    for (Column col : columns) {
                        Object v = col.pojoSwap != null ? col.pojoSwap.swap(session, o2) : m.get(col.getName());
                        r.add(v == null ? null : v.toString());
                    }
                    this.data.add(r);
                }
            }
        }
    }

    @BeanProperty(value="metadata")
    public Column[] getMetaData() {
        return this.metaData;
    }

    @BeanProperty(value="metadata")
    public DataSet setMetaData(Column[] metaData) {
        this.metaData = metaData;
        return this;
    }

    @BeanProperty(value="data")
    public List<Row> getData() {
        return this.data;
    }

    @BeanProperty(value="data")
    public DataSet setData(List<Row> data) {
        this.data = data;
        return this;
    }

    @Bean(typeName="row")
    public static final class Row {
        private List<String> values = new LinkedList<String>();

        void add(String value) {
            this.values.add(value);
        }

        @Xml(format=XmlFormat.COLLAPSED, childName="value")
        public List<String> getValues() {
            return this.values;
        }
    }
}

