/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config.internal;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.juneau.ConfigException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.config.event.ConfigEvent;
import org.apache.juneau.config.event.ConfigEventListener;
import org.apache.juneau.config.event.ConfigEventType;
import org.apache.juneau.config.event.ConfigEvents;
import org.apache.juneau.config.internal.ConfigEntry;
import org.apache.juneau.config.store.ConfigStore;
import org.apache.juneau.config.store.ConfigStoreListener;
import org.apache.juneau.internal.AsciiSet;
import org.apache.juneau.internal.StringUtils;

public class ConfigMap
implements ConfigStoreListener {
    private final ConfigStore store;
    private volatile String contents;
    private final String name;
    private static final AsciiSet MOD_CHARS = AsciiSet.create("#$%&*+^@~");
    private final List<ConfigEvent> changes = Collections.synchronizedList(new ConfigEvents());
    private final Set<ConfigEventListener> listeners = Collections.synchronizedSet(new HashSet());
    final Map<String, ConfigSection> entries = Collections.synchronizedMap(new LinkedHashMap());
    final Map<String, ConfigSection> oentries = Collections.synchronizedMap(new LinkedHashMap());
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public ConfigMap(ConfigStore store, String name) throws IOException {
        this.store = store;
        this.name = name;
        this.load(store.read(name));
    }

    ConfigMap(String contents) {
        this.store = null;
        this.name = null;
        this.load(contents);
    }

    private ConfigMap load(String contents) {
        int i;
        if (contents == null) {
            contents = "";
        }
        this.contents = contents;
        this.entries.clear();
        this.oentries.clear();
        AbstractList lines = new LinkedList<String>();
        try (Scanner scanner = new Scanner(contents);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                char c = StringUtils.firstChar(line);
                if (c == '[') {
                    char c2 = StringUtils.lastNonWhitespaceChar(line);
                    String l = line.trim();
                    if (c2 != ']' || !this.isValidNewSectionName(l.substring(1, l.length() - 1))) {
                        throw new ConfigException("Invalid section name found in configuration:  {0}", line);
                    }
                }
                lines.add(line);
            }
        }
        boolean inserted = false;
        boolean foundComment = false;
        ListIterator<String> li = lines.listIterator();
        while (li.hasNext()) {
            String l = (String)li.next();
            char c = StringUtils.firstNonWhitespaceChar(l);
            if (c != '#') {
                if (c != '\u0000' || !foundComment) break;
                li.set("[]");
                inserted = true;
                break;
            }
            foundComment = true;
        }
        if (!inserted) {
            lines.add(0, "[]");
        }
        li = lines.listIterator(lines.size());
        String accumulator = null;
        while (li.hasPrevious()) {
            String l = (String)li.previous();
            char c = StringUtils.firstChar(l);
            if (c == '\t') {
                c = StringUtils.firstNonWhitespaceChar(l);
                if (c == '#') continue;
                accumulator = accumulator == null ? l.substring(1) : l.substring(1) + "\n" + accumulator;
                li.remove();
                continue;
            }
            if (accumulator == null) continue;
            li.set(l + "\n" + accumulator);
            accumulator = null;
        }
        lines = new ArrayList(lines);
        int last = lines.size() - 1;
        int S1 = 1;
        int S2 = 2;
        int state = S1;
        ArrayList<ConfigSection> sections = new ArrayList<ConfigSection>();
        for (i = last; i >= 0; --i) {
            String l = (String)lines.get(i);
            char c = StringUtils.firstChar(l);
            if (state == S1) {
                if (c != '[') continue;
                state = S2;
                continue;
            }
            if (c == '#' || c != '[' && l.indexOf(61) == -1) continue;
            sections.add(new ConfigSection(lines.subList(i + 1, last + 1)));
            last = i + 1;
            state = c == '[' ? S2 : S1;
        }
        sections.add(new ConfigSection(lines.subList(0, last + 1)));
        for (i = sections.size() - 1; i >= 0; --i) {
            ConfigSection cs = (ConfigSection)sections.get(i);
            if (this.entries.containsKey(cs.name)) {
                throw new ConfigException("Duplicate section found in configuration:  [{0}]", cs.name);
            }
            this.entries.put(cs.name, cs);
        }
        this.oentries.putAll(this.entries);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigEntry getEntry(String section, String key) {
        this.checkSectionName(section);
        this.checkKeyName(key);
        this.readLock();
        try {
            ConfigSection cs = this.entries.get(section);
            ConfigEntry configEntry = cs == null ? null : cs.entries.get(key);
            return configEntry;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPreLines(String section) {
        this.checkSectionName(section);
        this.readLock();
        try {
            ConfigSection cs = this.entries.get(section);
            List<String> list = cs == null ? null : cs.preLines;
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    public Set<String> getSections() {
        return Collections.unmodifiableSet(this.entries.keySet());
    }

    public Set<String> getKeys(String section) {
        this.checkSectionName(section);
        ConfigSection cs = this.entries.get(section);
        return cs == null ? Collections.emptySet() : Collections.unmodifiableSet(cs.entries.keySet());
    }

    public boolean hasSection(String section) {
        this.checkSectionName(section);
        return this.entries.get(section) != null;
    }

    public ConfigMap setSection(String section, List<String> preLines) {
        this.checkSectionName(section);
        return this.applyChange(true, ConfigEvent.setSection(section, preLines));
    }

    public ConfigMap setEntry(String section, String key, String value, String modifiers, String comment, List<String> preLines) {
        this.checkSectionName(section);
        this.checkKeyName(key);
        if (modifiers != null && !MOD_CHARS.containsOnly(modifiers)) {
            throw new ConfigException("Invalid modifiers: {0}", modifiers);
        }
        return this.applyChange(true, ConfigEvent.setEntry(section, key, value, modifiers, comment, preLines));
    }

    public ConfigMap removeSection(String section) {
        this.checkSectionName(section);
        return this.applyChange(true, ConfigEvent.removeSection(section));
    }

    public ConfigMap removeEntry(String section, String key) {
        this.checkSectionName(section);
        this.checkKeyName(key);
        return this.applyChange(true, ConfigEvent.removeEntry(section, key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigMap applyChange(boolean addToChangeList, ConfigEvent ce) {
        if (ce == null) {
            return this;
        }
        this.writeLock();
        try {
            String section = ce.getSection();
            ConfigSection cs = this.entries.get(section);
            if (ce.getType() == ConfigEventType.SET_ENTRY) {
                ConfigEntry oe;
                if (cs == null) {
                    cs = new ConfigSection(section);
                    this.entries.put(section, cs);
                }
                if ((oe = cs.entries.get(ce.getKey())) == null) {
                    oe = ConfigEntry.NULL;
                }
                cs.addEntry(ce.getKey(), ce.getValue() == null ? oe.value : ce.getValue(), ce.getModifiers() == null ? oe.modifiers : ce.getModifiers(), ce.getComment() == null ? oe.comment : ce.getComment(), ce.getPreLines() == null ? oe.preLines : ce.getPreLines());
            } else if (ce.getType() == ConfigEventType.SET_SECTION) {
                if (cs == null) {
                    cs = new ConfigSection(section);
                    this.entries.put(section, cs);
                }
                if (ce.getPreLines() != null) {
                    cs.setPreLines(ce.getPreLines());
                }
            } else if (ce.getType() == ConfigEventType.REMOVE_ENTRY) {
                if (cs != null) {
                    cs.entries.remove(ce.getKey());
                }
            } else if (ce.getType() == ConfigEventType.REMOVE_SECTION && cs != null) {
                this.entries.remove(section);
            }
            if (addToChangeList) {
                this.changes.add(ce);
            }
        }
        finally {
            this.writeUnlock();
        }
        return this;
    }

    public ConfigMap load(String contents, boolean synchronous) throws IOException, InterruptedException {
        if (synchronous) {
            final CountDownLatch latch = new CountDownLatch(1);
            ConfigStoreListener l = new ConfigStoreListener(){

                @Override
                public void onChange(String contents) {
                    latch.countDown();
                }
            };
            this.store.register(this.name, l);
            this.store.write(this.name, null, contents);
            latch.await(30L, TimeUnit.SECONDS);
            this.store.unregister(this.name, l);
        } else {
            this.store.write(this.name, null, contents);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigMap commit() throws IOException {
        this.writeLock();
        try {
            String newContents = this.asString();
            for (int i = 0; i <= 10; ++i) {
                if (i == 10) {
                    throw new ConfigException("Unable to store contents of config to store.", new Object[0]);
                }
                String currentContents = this.store.write(this.name, this.contents, newContents);
                if (currentContents == null) break;
                this.onChange(currentContents);
            }
            this.changes.clear();
        }
        finally {
            this.writeUnlock();
        }
        return this;
    }

    public ConfigMap register(ConfigEventListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public ConfigMap unregister(ConfigEventListener listener) {
        this.listeners.remove(listener);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onChange(String newContents) {
        ConfigEvents changes = null;
        this.writeLock();
        try {
            if (!StringUtils.isEquals(this.contents, newContents)) {
                changes = this.findDiffs(newContents);
                this.load(newContents);
                for (ConfigEvent ce : this.changes) {
                    this.applyChange(false, ce);
                }
            }
        }
        finally {
            this.writeUnlock();
        }
        if (changes != null && !changes.isEmpty()) {
            this.signal(changes);
        }
    }

    public String toString() {
        this.readLock();
        try {
            String string = this.asString();
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectMap asMap() {
        ObjectMap m = new ObjectMap();
        this.readLock();
        try {
            for (ConfigSection cs : this.entries.values()) {
                LinkedHashMap<String, String> m2 = new LinkedHashMap<String, String>();
                for (ConfigEntry ce : cs.entries.values()) {
                    m2.put(ce.key, ce.value);
                }
                m.put(cs.name, m2);
            }
        }
        finally {
            this.readUnlock();
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writer writeTo(Writer w) throws IOException {
        this.readLock();
        try {
            for (ConfigSection cs : this.entries.values()) {
                cs.writeTo(w);
            }
        }
        finally {
            this.readUnlock();
        }
        return w;
    }

    public ConfigMap rollback() {
        if (this.changes.size() > 0) {
            this.writeLock();
            try {
                this.changes.clear();
                this.load(this.contents);
            }
            finally {
                this.writeUnlock();
            }
        }
        return this;
    }

    private void readLock() {
        this.lock.readLock().lock();
    }

    private void readUnlock() {
        this.lock.readLock().unlock();
    }

    private void writeLock() {
        this.lock.writeLock().lock();
    }

    private void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    private void checkSectionName(String s) {
        if (!"".equals(s) && !this.isValidNewSectionName(s)) {
            throw new IllegalArgumentException("Invalid section name: '" + s + "'");
        }
    }

    private void checkKeyName(String s) {
        if (!this.isValidKeyName(s)) {
            throw new IllegalArgumentException("Invalid key name: '" + s + "'");
        }
    }

    private boolean isValidKeyName(String s) {
        if (s == null) {
            return false;
        }
        if ((s = s.trim()).isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '/' && c != '\\' && c != '[' && c != ']' && c != '=' && c != '#') continue;
            return false;
        }
        return true;
    }

    private boolean isValidNewSectionName(String s) {
        if (s == null) {
            return false;
        }
        if ((s = s.trim()).isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '/' && c != '\\' && c != '[' && c != ']') continue;
            return false;
        }
        return true;
    }

    private void signal(ConfigEvents changes) {
        for (ConfigEventListener l : this.listeners) {
            l.onConfigChange(changes);
        }
    }

    private ConfigEvents findDiffs(String updatedContents) {
        ConfigEvents changes = new ConfigEvents();
        ConfigMap newMap = new ConfigMap(updatedContents);
        for (ConfigSection ns : newMap.oentries.values()) {
            ConfigSection s = this.oentries.get(ns.name);
            if (s == null) {
                for (ConfigEntry ne : ns.entries.values()) {
                    changes.add(ConfigEvent.setEntry(ns.name, ne.key, ne.value, ne.modifiers, ne.comment, ne.preLines));
                }
                continue;
            }
            for (ConfigEntry ne : ns.oentries.values()) {
                ConfigEntry e = s.oentries.get(ne.key);
                if (e != null && StringUtils.isEquals(e.value, ne.value)) continue;
                changes.add(ConfigEvent.setEntry(s.name, ne.key, ne.value, ne.modifiers, ne.comment, ne.preLines));
            }
            for (ConfigEntry e : s.oentries.values()) {
                ConfigEntry ne = ns.oentries.get(e.key);
                if (ne != null) continue;
                changes.add(ConfigEvent.removeEntry(s.name, e.key));
            }
        }
        for (ConfigSection s : this.oentries.values()) {
            ConfigSection ns = newMap.oentries.get(s.name);
            if (ns != null) continue;
            for (ConfigEntry e : s.oentries.values()) {
                changes.add(ConfigEvent.removeEntry(s.name, e.key));
            }
        }
        return changes;
    }

    private String asString() {
        try {
            StringWriter sw = new StringWriter();
            for (ConfigSection cs : this.entries.values()) {
                cs.writeTo(sw);
            }
            return sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    class ConfigSection {
        final String name;
        final List<String> preLines = Collections.synchronizedList(new ArrayList());
        private final String rawLine;
        final Map<String, ConfigEntry> oentries = Collections.synchronizedMap(new LinkedHashMap());
        final Map<String, ConfigEntry> entries = Collections.synchronizedMap(new LinkedHashMap());

        ConfigSection(String name) {
            this.name = name;
            this.rawLine = "[" + name + "]";
        }

        ConfigSection(List<String> lines) {
            String name = null;
            String rawLine = null;
            int S1 = 1;
            int S2 = 2;
            int state = S1;
            int start = 0;
            for (int i = 0; i < lines.size(); ++i) {
                String l = lines.get(i);
                char c = StringUtils.firstNonWhitespaceChar(l);
                if (state == S1) {
                    if (c == '[') {
                        int i1 = l.indexOf(91);
                        int i2 = l.indexOf(93);
                        name = l.substring(i1 + 1, i2).trim();
                        rawLine = l;
                        state = S2;
                        start = i + 1;
                        continue;
                    }
                    this.preLines.add(l);
                    continue;
                }
                if (c == '#' || l.indexOf(61) == -1) continue;
                ConfigEntry e = new ConfigEntry(l, lines.subList(start, i));
                if (this.entries.containsKey(e.key)) {
                    throw new ConfigException("Duplicate entry found in section [{0}] of configuration:  {1}", name, e.key);
                }
                this.entries.put(e.key, e);
                start = i + 1;
            }
            this.name = name;
            this.rawLine = rawLine;
            this.oentries.putAll(this.entries);
        }

        ConfigSection addEntry(String key, String value, String modifiers, String comment, List<String> preLines) {
            ConfigEntry e = new ConfigEntry(key, value, modifiers, comment, preLines);
            this.entries.put(e.key, e);
            return this;
        }

        ConfigSection setPreLines(List<String> preLines) {
            this.preLines.clear();
            this.preLines.addAll(preLines);
            return this;
        }

        Writer writeTo(Writer w) throws IOException {
            for (String s : this.preLines) {
                w.append(s).append('\n');
            }
            if (!this.name.equals("")) {
                w.append(this.rawLine).append('\n');
            } else if (!this.preLines.isEmpty()) {
                w.append('\n');
            }
            for (ConfigEntry e : this.entries.values()) {
                e.writeTo(w);
            }
            return w;
        }
    }
}

