/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.Map;
import org.apache.juneau.Context;
import org.apache.juneau.ContextCache;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.PropertyStoreBuilder;

public abstract class ContextBuilder {
    protected final PropertyStoreBuilder psb;

    public ContextBuilder() {
        this.psb = PropertyStore.create();
    }

    public ContextBuilder(PropertyStore ps) {
        if (ps == null) {
            ps = PropertyStore.DEFAULT;
        }
        this.psb = ps.builder();
    }

    protected ContextBuilder(PropertyStoreBuilder psb) {
        this.psb = psb;
    }

    protected PropertyStoreBuilder getPropertyStoreBuilder() {
        return this.psb;
    }

    public abstract Context build();

    public ContextBuilder apply(PropertyStore copyFrom) {
        this.psb.apply(copyFrom);
        return this;
    }

    public <T extends Context> T build(Class<T> c) {
        return ContextCache.INSTANCE.create(c, this.getPropertyStore());
    }

    public PropertyStore getPropertyStore() {
        return this.psb.build();
    }

    public ContextBuilder set(String name, Object value) {
        this.psb.set(name, value);
        return this;
    }

    public ContextBuilder set(boolean append, String name, Object value) {
        if (append) {
            this.psb.addTo(name, value);
        } else {
            this.psb.set(name, value);
        }
        return this;
    }

    public ContextBuilder set(Map<String, Object> properties) {
        this.psb.set(properties);
        return this;
    }

    public ContextBuilder add(Map<String, Object> properties) {
        this.psb.add(properties);
        return this;
    }

    public ContextBuilder addTo(String name, Object value) {
        this.psb.addTo(name, value);
        return this;
    }

    public ContextBuilder addTo(String name, String key, Object value) {
        this.psb.addTo(name, key, value);
        return this;
    }

    public ContextBuilder removeFrom(String name, Object value) {
        this.psb.removeFrom(name, value);
        return this;
    }
}

